/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

public abstract class DoubleByteEncoder
extends CharsetEncoder {
    private short[] index1;
    private String[] index2;
    private final Surrogate.Parser sgp = new Surrogate.Parser();

    protected DoubleByteEncoder(Charset cs, short[] index1, String[] index2) {
        super(cs, 2.0f, 2.0f);
        this.index1 = index1;
        this.index2 = index2;
    }

    protected DoubleByteEncoder(Charset cs, short[] index1, String[] index2, float avg, float max) {
        super(cs, avg, max);
        this.index1 = index1;
        this.index2 = index2;
    }

    protected DoubleByteEncoder(Charset cs, short[] index1, String[] index2, byte[] repl) {
        super(cs, 2.0f, 2.0f, repl);
        this.index1 = index1;
        this.index2 = index2;
    }

    protected DoubleByteEncoder(Charset cs, short[] index1, String[] index2, byte[] repl, float avg, float max) {
        super(cs, avg, max, repl);
        this.index1 = index1;
        this.index2 = index2;
    }

    public boolean canEncode(char c) {
        return this.encodeSingle(c) != -1 || this.encodeDouble(c) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeArrayLoop(CharBuffer src, ByteBuffer dst) {
        char[] sa = src.array();
        int sp = src.arrayOffset() + src.position();
        int sl = src.arrayOffset() + src.limit();
        byte[] da = dst.array();
        int dp = dst.arrayOffset() + dst.position();
        int dl = dst.arrayOffset() + dst.limit();
        try {
            while (sp < sl) {
                char c = sa[sp];
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, sa, sp, sl) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    if (sl - sp < 2) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    char c2 = sa[sp + 1];
                    byte[] outputBytes = new byte[2];
                    outputBytes = this.encodeSurrogate(c, c2);
                    if (outputBytes == null) {
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    if (dl - dp < 2) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    da[dp++] = outputBytes[0];
                    da[dp++] = outputBytes[1];
                    sp += 2;
                    continue;
                }
                if (c >= '\ufffe') {
                    CoderResult c2 = CoderResult.unmappableForLength(1);
                    return c2;
                }
                int b = this.encodeSingle(c);
                if (b != -1) {
                    if (dl - dp < 1) {
                        CoderResult outputBytes = CoderResult.OVERFLOW;
                        return outputBytes;
                    }
                    da[dp++] = (byte)b;
                    ++sp;
                    continue;
                }
                int ncode = this.encodeDouble(c);
                if (ncode != 0 && c != '\u0000') {
                    if (dl - dp < 2) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    da[dp++] = (byte)((ncode & 0xFF00) >> 8);
                    da[dp++] = (byte)(ncode & 0xFF);
                    ++sp;
                    continue;
                }
                CoderResult coderResult = CoderResult.unmappableForLength(1);
                return coderResult;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            src.position(sp - src.arrayOffset());
            dst.position(dp - dst.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop(CharBuffer src, ByteBuffer dst) {
        int mark = src.position();
        try {
            while (src.hasRemaining()) {
                CoderResult coderResult;
                char c = src.get();
                if (Surrogate.is(c)) {
                    int surr = this.sgp.parse(c, src);
                    if (surr < 0) {
                        CoderResult coderResult2 = this.sgp.error();
                        return coderResult2;
                    }
                    char c2 = Surrogate.low(surr);
                    byte[] outputBytes = new byte[2];
                    outputBytes = this.encodeSurrogate(c, c2);
                    if (outputBytes == null) {
                        CoderResult coderResult3 = this.sgp.unmappableResult();
                        return coderResult3;
                    }
                    if (dst.remaining() < 2) {
                        CoderResult coderResult4 = CoderResult.OVERFLOW;
                        return coderResult4;
                    }
                    mark += 2;
                    dst.put(outputBytes[0]);
                    dst.put(outputBytes[1]);
                    continue;
                }
                if (c >= '\ufffe') {
                    CoderResult surr = CoderResult.unmappableForLength(1);
                    return surr;
                }
                int b = this.encodeSingle(c);
                if (b != -1) {
                    if (dst.remaining() < 1) {
                        CoderResult c2 = CoderResult.OVERFLOW;
                        return c2;
                    }
                    ++mark;
                    dst.put((byte)b);
                    continue;
                }
                int ncode = this.encodeDouble(c);
                if (ncode != 0 && c != '\u0000') {
                    if (dst.remaining() < 2) {
                        coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    ++mark;
                    dst.put((byte)((ncode & 0xFF00) >> 8));
                    dst.put((byte)ncode);
                    continue;
                }
                coderResult = CoderResult.unmappableForLength(1);
                return coderResult;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            src.position(mark);
        }
    }

    protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
        if (src.hasArray() && dst.hasArray()) {
            return this.encodeArrayLoop(src, dst);
        }
        return this.encodeBufferLoop(src, dst);
    }

    protected int encodeDouble(char ch) {
        int offset = this.index1[(ch & 0xFF00) >> 8] << 8;
        return this.index2[offset >> 12].charAt((offset & 0xFFF) + (ch & 0xFF));
    }

    protected int encodeSingle(char inputChar) {
        if (inputChar < '\u0080') {
            return (byte)inputChar;
        }
        return -1;
    }

    protected byte[] encodeSurrogate(char highSurrogate, char lowSurrogate) {
        return null;
    }
}

