/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.US_ASCII;
import sun.nio.cs.ext.EUC_CN;
import sun.nio.cs.ext.EUC_TW;
import sun.nio.cs.ext.ExtendedCharsets;

public class ISO2022_CN
extends Charset
implements HistoricallyNamedCharset {
    private static final byte ISO_ESC = 27;
    private static final byte ISO_SI = 15;
    private static final byte ISO_SO = 14;
    private static final byte ISO_SS2_7 = 78;
    private static final byte ISO_SS3_7 = 79;
    private static final byte MSB = -128;
    private static final char REPLACE_CHAR = '\ufffd';
    private static final byte SODesigGB = 0;
    private static final byte SODesigCNS = 1;

    public ISO2022_CN() {
        super("ISO-2022-CN", ExtendedCharsets.aliasesFor("ISO-2022-CN"));
    }

    public String historicalName() {
        return "ISO2022CN";
    }

    public boolean contains(Charset cs) {
        return cs instanceof EUC_CN || cs instanceof US_ASCII || cs instanceof EUC_TW || cs instanceof ISO2022_CN;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        throw new UnsupportedOperationException();
    }

    public boolean canEncode() {
        return false;
    }

    static class Decoder
    extends CharsetDecoder {
        private boolean shiftOut = false;
        private byte currentSODesig = 0;
        private static final Charset gb2312 = new EUC_CN();
        private static final Charset cns = new EUC_TW();
        private final EUC_CN.Decoder gb2312Decoder = (EUC_CN.Decoder)gb2312.newDecoder();
        private final EUC_TW.Decoder cnsDecoder = (EUC_TW.Decoder)cns.newDecoder();

        Decoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        protected void implReset() {
            this.shiftOut = false;
            this.currentSODesig = 0;
        }

        private char cnsDecode(byte byte1, byte byte2, byte SS) {
            byte1 = (byte)(byte1 | 0xFFFFFF80);
            byte2 = (byte)(byte2 | 0xFFFFFF80);
            if (SS == 78) {
                return this.cnsDecoder.convToUnicode(byte1, byte2, EUC_TW.Decoder.unicodeCNS2);
            }
            char[] outSurr = this.cnsDecoder.convToSurrogate(byte1, byte2, EUC_TW.Decoder.unicodeCNS3);
            if (outSurr == null || outSurr[0] != '\u0000') {
                return '\ufffd';
            }
            return outSurr[1];
        }

        private char SODecode(byte byte1, byte byte2, byte SOD) {
            byte1 = (byte)(byte1 | 0xFFFFFF80);
            byte2 = (byte)(byte2 | 0xFFFFFF80);
            if (SOD == 0) {
                return this.gb2312Decoder.decodeDouble(byte1 & 0xFF, byte2 & 0xFF);
            }
            return this.cnsDecoder.convToUnicode(byte1, byte2, EUC_TW.Decoder.unicodeCNS1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private CoderResult decodeBufferLoop(ByteBuffer src, CharBuffer dst) {
            mark = src.position();
            b1 = 0;
            b2 = 0;
            b3 = 0;
            b4 = 0;
            inputSize = 0;
            c = '\ufffd';
            try {
                while (src.hasRemaining()) {
                    b1 = src.get();
                    inputSize = 1;
                    while (b1 == 27 || b1 == 14 || b1 == 15) {
                        block55: {
                            block54: {
                                if (b1 != 27) ** GOTO lbl91
                                this.currentSODesig = 0;
                                if (src.remaining() < 1) {
                                    var10_10 = CoderResult.UNDERFLOW;
                                    return var10_10;
                                }
                                b2 = src.get();
                                ++inputSize;
                                if ((b2 & -128) != 0) {
                                    var10_11 = CoderResult.malformedForLength(inputSize);
                                    return var10_11;
                                }
                                if (b2 != 36) ** GOTO lbl72
                                if (src.remaining() < 1) {
                                    var10_12 = CoderResult.UNDERFLOW;
                                    return var10_12;
                                }
                                b3 = src.get();
                                ++inputSize;
                                if ((b3 & -128) != 0) {
                                    var10_13 = CoderResult.malformedForLength(inputSize);
                                    return var10_13;
                                }
                                if (b3 != 65) break block54;
                                this.currentSODesig = 0;
                                break block55;
                            }
                            if (b3 != 41) ** GOTO lbl50
                            if (src.remaining() < 1) {
                                var10_14 = CoderResult.UNDERFLOW;
                                return var10_14;
                            }
                            b4 = src.get();
                            ++inputSize;
                            if (b4 == 65) {
                                this.currentSODesig = 0;
                            } else if (b4 == 71) {
                                this.currentSODesig = 1;
                            } else {
                                var10_15 = CoderResult.malformedForLength(inputSize);
                                return var10_15;
lbl50:
                                // 1 sources

                                if (b3 == 42) {
                                    if (src.remaining() < 1) {
                                        var10_16 = CoderResult.UNDERFLOW;
                                        return var10_16;
                                    }
                                    b4 = src.get();
                                    ++inputSize;
                                    if (b4 != 72) {
                                        var10_17 = CoderResult.malformedForLength(inputSize);
                                        return var10_17;
                                    }
                                } else if (b3 == 43) {
                                    if (src.remaining() < 1) {
                                        var10_18 = CoderResult.UNDERFLOW;
                                        return var10_18;
                                    }
                                    b4 = src.get();
                                    ++inputSize;
                                    if (b4 != 73) {
                                        var10_19 = CoderResult.malformedForLength(inputSize);
                                        return var10_19;
                                    }
                                } else {
                                    var10_20 = CoderResult.malformedForLength(inputSize);
                                    return var10_20;
lbl72:
                                    // 1 sources

                                    if (b2 == 78 || b2 == 79) {
                                        if (src.remaining() < 2) {
                                            var10_21 = CoderResult.UNDERFLOW;
                                            return var10_21;
                                        }
                                        b3 = src.get();
                                        b4 = src.get();
                                        inputSize += 2;
                                        if (dst.remaining() < 1) {
                                            var10_22 = CoderResult.OVERFLOW;
                                            return var10_22;
                                        }
                                        c = this.cnsDecode(b3, b4, b2);
                                        if (c == '\ufffd') {
                                            var10_23 = CoderResult.unmappableForLength(inputSize);
                                            return var10_23;
                                        }
                                        dst.put(c);
                                    } else {
                                        var10_24 = CoderResult.malformedForLength(inputSize);
                                        return var10_24;
lbl91:
                                        // 1 sources

                                        if (b1 == 14) {
                                            this.shiftOut = true;
                                        } else if (b1 == 15) {
                                            this.shiftOut = false;
                                        }
                                    }
                                }
                            }
                        }
                        mark += inputSize;
                        if (src.remaining() < 1) {
                            var10_25 = CoderResult.UNDERFLOW;
                            return var10_25;
                        }
                        b1 = src.get();
                        inputSize = 1;
                    }
                    if (dst.remaining() < 1) {
                        var10_26 = CoderResult.OVERFLOW;
                        return var10_26;
                    }
                    if (!this.shiftOut) {
                        dst.put((char)(b1 & 255));
                        mark += inputSize;
                        continue;
                    }
                    if (src.remaining() < 1) {
                        var10_27 = CoderResult.UNDERFLOW;
                        return var10_27;
                    }
                    b2 = src.get();
                    ++inputSize;
                    c = this.SODecode(b1, b2, this.currentSODesig);
                    if (c == '\ufffd') {
                        var10_28 = CoderResult.unmappableForLength(inputSize);
                        return var10_28;
                    }
                    dst.put(c);
                    mark += inputSize;
                }
                var10_29 = CoderResult.UNDERFLOW;
                return var10_29;
            }
            finally {
                src.position(mark);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private CoderResult decodeArrayLoop(ByteBuffer src, CharBuffer dst) {
            inputSize = 0;
            b1 = 0;
            b2 = 0;
            b3 = 0;
            b4 = 0;
            c = 65533;
            sa = src.array();
            sp = src.arrayOffset() + src.position();
            sl = src.arrayOffset() + src.limit();
            if (!Decoder.$assertionsDisabled && sp > sl) {
                throw new AssertionError();
            }
            da = dst.array();
            dp = dst.arrayOffset() + dst.position();
            dl = dst.arrayOffset() + dst.limit();
            if (!Decoder.$assertionsDisabled && dp > dl) {
                throw new AssertionError();
            }
            dp = dp <= dl ? dp : dl;
            try {
                for (sp = sp <= sl ? sp : sl; sp < sl; sp += inputSize) {
                    b1 = sa[sp];
                    inputSize = 1;
                    while (b1 == 27 || b1 == 14 || b1 == 15) {
                        block57: {
                            block56: {
                                if (b1 != 27) ** GOTO lbl100
                                this.currentSODesig = 0;
                                if (sp + 2 > sl) {
                                    var15_15 = CoderResult.UNDERFLOW;
                                    return var15_15;
                                }
                                b2 = sa[sp + 1];
                                ++inputSize;
                                if ((b2 & -128) != 0) {
                                    var15_16 = CoderResult.malformedForLength(inputSize);
                                    return var15_16;
                                }
                                if (b2 != 36) ** GOTO lbl82
                                if (sp + 3 > sl) {
                                    var15_17 = CoderResult.UNDERFLOW;
                                    return var15_17;
                                }
                                b3 = sa[sp + 2];
                                ++inputSize;
                                if ((b3 & -128) != 0) {
                                    var15_18 = CoderResult.malformedForLength(inputSize);
                                    return var15_18;
                                }
                                if (b3 != 65) break block56;
                                this.currentSODesig = 0;
                                break block57;
                            }
                            if (b3 != 41) ** GOTO lbl60
                            if (sp + 4 > sl) {
                                var15_19 = CoderResult.UNDERFLOW;
                                return var15_19;
                            }
                            b4 = sa[sp + 3];
                            ++inputSize;
                            if (b4 == 65) {
                                this.currentSODesig = 0;
                            } else if (b4 == 71) {
                                this.currentSODesig = 1;
                            } else {
                                var15_20 = CoderResult.malformedForLength(inputSize);
                                return var15_20;
lbl60:
                                // 1 sources

                                if (b3 == 42) {
                                    if (sp + 4 > sl) {
                                        var15_21 = CoderResult.UNDERFLOW;
                                        return var15_21;
                                    }
                                    b4 = sa[sp + 3];
                                    ++inputSize;
                                    if (b4 != 72) {
                                        var15_22 = CoderResult.malformedForLength(inputSize);
                                        return var15_22;
                                    }
                                } else if (b3 == 43) {
                                    if (sp + 4 > sl) {
                                        var15_23 = CoderResult.UNDERFLOW;
                                        return var15_23;
                                    }
                                    b4 = sa[sp + 3];
                                    ++inputSize;
                                    if (b4 != 73) {
                                        var15_24 = CoderResult.malformedForLength(inputSize);
                                        return var15_24;
                                    }
                                } else {
                                    var15_25 = CoderResult.malformedForLength(inputSize);
                                    return var15_25;
lbl82:
                                    // 1 sources

                                    if (b2 == 78 || b2 == 79) {
                                        if (sp + 4 > sl) {
                                            var15_26 = CoderResult.UNDERFLOW;
                                            return var15_26;
                                        }
                                        b3 = sa[sp + 2];
                                        b4 = sa[sp + 3];
                                        if (dl - dp < 1) {
                                            var15_27 = CoderResult.OVERFLOW;
                                            return var15_27;
                                        }
                                        inputSize += 2;
                                        c = this.cnsDecode(b3, b4, b2);
                                        if (c == 65533) {
                                            var15_28 = CoderResult.unmappableForLength(inputSize);
                                            return var15_28;
                                        }
                                        da[dp++] = c;
                                    } else {
                                        var15_29 = CoderResult.malformedForLength(inputSize);
                                        return var15_29;
lbl100:
                                        // 1 sources

                                        if (b1 == 14) {
                                            this.shiftOut = true;
                                        } else if (b1 == 15) {
                                            this.shiftOut = false;
                                        }
                                    }
                                }
                            }
                        }
                        if ((sp += inputSize) + 1 > sl) {
                            var15_30 = CoderResult.UNDERFLOW;
                            return var15_30;
                        }
                        b1 = sa[sp];
                        inputSize = 1;
                    }
                    if (dl - dp < 1) {
                        var15_31 = CoderResult.OVERFLOW;
                        return var15_31;
                    }
                    if (!this.shiftOut) {
                        da[dp++] = (char)(b1 & 255);
                        continue;
                    }
                    if (sp + 2 > sl) {
                        var15_32 = CoderResult.UNDERFLOW;
                        return var15_32;
                    }
                    b2 = sa[sp + 1];
                    ++inputSize;
                    c = this.SODecode(b1, b2, this.currentSODesig);
                    if (c == 65533) {
                        var15_33 = CoderResult.unmappableForLength(inputSize);
                        return var15_33;
                    }
                    da[dp++] = c;
                }
                var15_34 = CoderResult.UNDERFLOW;
                return var15_34;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }

        protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.decodeArrayLoop(src, dst);
            }
            return this.decodeBufferLoop(src, dst);
        }
    }
}

