/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.HmacCore;
import com.sun.crypto.provider.SunJCE;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;

public final class HmacSHA1
extends MacSpi
implements Cloneable {
    private HmacCore hmac = null;
    private static final int SHA1_BLOCK_LENGTH = 64;

    public HmacSHA1() throws NoSuchAlgorithmException {
        if (!SunJCE.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The SunJCE provider may have been tampered.");
        }
        this.hmac = new HmacCore(MessageDigest.getInstance("SHA1"), 64);
    }

    protected int engineGetMacLength() {
        return this.hmac.getDigestLength();
    }

    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.hmac.init(key, params);
    }

    protected void engineUpdate(byte input) {
        this.hmac.update(input);
    }

    protected void engineUpdate(byte[] input, int offset, int len) {
        this.hmac.update(input, offset, len);
    }

    protected void engineUpdate(ByteBuffer input) {
        this.hmac.update(input);
    }

    protected byte[] engineDoFinal() {
        return this.hmac.doFinal();
    }

    protected void engineReset() {
        this.hmac.reset();
    }

    public Object clone() {
        HmacSHA1 that = null;
        try {
            that = (HmacSHA1)super.clone();
            that.hmac = (HmacCore)this.hmac.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return that;
    }
}

