/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NullCipher;

public class CipherInputStream
extends FilterInputStream {
    private Cipher cipher;
    private InputStream input;
    private byte[] ibuffer = new byte[512];
    private boolean done = false;
    private byte[] obuffer;
    private int ostart = 0;
    private int ofinish = 0;

    private int getMoreData() throws IOException {
        if (this.done) {
            return -1;
        }
        int readin = this.input.read(this.ibuffer);
        if (readin == -1) {
            this.done = true;
            try {
                this.obuffer = this.cipher.doFinal();
            }
            catch (IllegalBlockSizeException e) {
                this.obuffer = null;
            }
            catch (BadPaddingException e) {
                this.obuffer = null;
            }
            if (this.obuffer == null) {
                return -1;
            }
            this.ostart = 0;
            this.ofinish = this.obuffer.length;
            return this.ofinish;
        }
        try {
            this.obuffer = this.cipher.update(this.ibuffer, 0, readin);
        }
        catch (IllegalStateException e) {
            this.obuffer = null;
        }
        this.ostart = 0;
        this.ofinish = this.obuffer == null ? 0 : this.obuffer.length;
        return this.ofinish;
    }

    public CipherInputStream(InputStream is, Cipher c) {
        super(is);
        this.input = is;
        this.cipher = c;
    }

    protected CipherInputStream(InputStream is) {
        super(is);
        this.input = is;
        this.cipher = new NullCipher();
    }

    public int read() throws IOException {
        if (this.ostart >= this.ofinish) {
            int i = 0;
            while (i == 0) {
                i = this.getMoreData();
            }
            if (i == -1) {
                return -1;
            }
        }
        return this.obuffer[this.ostart++] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.ostart >= this.ofinish) {
            int i = 0;
            while (i == 0) {
                i = this.getMoreData();
            }
            if (i == -1) {
                return -1;
            }
        }
        if (len <= 0) {
            return 0;
        }
        int available = this.ofinish - this.ostart;
        if (len < available) {
            available = len;
        }
        if (b != null) {
            System.arraycopy(this.obuffer, this.ostart, b, off, available);
        }
        this.ostart += available;
        return available;
    }

    public long skip(long n) throws IOException {
        int available = this.ofinish - this.ostart;
        if (n > (long)available) {
            n = available;
        }
        if (n < 0L) {
            return 0L;
        }
        this.ostart = (int)((long)this.ostart + n);
        return n;
    }

    public int available() throws IOException {
        return this.ofinish - this.ostart;
    }

    public void close() throws IOException {
        this.input.close();
        try {
            this.cipher.doFinal();
        }
        catch (BadPaddingException ex) {
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            // empty catch block
        }
        this.ostart = 0;
        this.ofinish = 0;
    }

    public boolean markSupported() {
        return false;
    }
}

