/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.VariableGridLayout;

public class BorderedComponent
extends JPanel
implements ActionListener {
    JButton moreOrLessButton;
    String valueLabelStr;
    JLabel label;
    JComponent comp;
    boolean collapsed = false;
    private JPopupMenu popupMenu;
    private Icon collapseIcon;
    private Icon expandIcon;

    private static Image getImage(String name) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        name = "resources/" + name + ".png";
        return tk.getImage(BorderedComponent.class.getResource(name));
    }

    public BorderedComponent(String text) {
        this(text, null, false);
    }

    public BorderedComponent(String text, JComponent comp) {
        this(text, comp, false);
    }

    public BorderedComponent(String text, JComponent comp, boolean collapsible) {
        super(null);
        this.comp = comp;
        if (text != null) {
            TitledBorder border;
            if (collapsible) {
                final JLabel textLabel = new JLabel(text);
                JPanel borderLabel = new JPanel(new FlowLayout(0, 2, 0)){

                    public int getBaseline(int w, int h) {
                        Dimension dim = textLabel.getPreferredSize();
                        return textLabel.getBaseline(dim.width, dim.height) + textLabel.getY();
                    }
                };
                borderLabel.add(textLabel);
                border = new LabeledBorder(borderLabel);
                textLabel.setForeground(border.getTitleColor());
                if (JConsole.IS_WIN) {
                    this.collapseIcon = new ImageIcon(BorderedComponent.getImage("collapse-winlf"));
                    this.expandIcon = new ImageIcon(BorderedComponent.getImage("expand-winlf"));
                } else {
                    this.collapseIcon = new ArrowIcon(5, textLabel);
                    this.expandIcon = new ArrowIcon(3, textLabel);
                }
                this.moreOrLessButton = new JButton(this.collapseIcon);
                this.moreOrLessButton.setContentAreaFilled(false);
                this.moreOrLessButton.setBorderPainted(false);
                this.moreOrLessButton.setMargin(new Insets(0, 0, 0, 0));
                this.moreOrLessButton.addActionListener(this);
                String toolTip = Resources.getText("BorderedComponent.moreOrLessButton.toolTip", new Object[0]);
                this.moreOrLessButton.setToolTipText(toolTip);
                borderLabel.add(this.moreOrLessButton);
                borderLabel.setSize(borderLabel.getPreferredSize());
                this.add(borderLabel);
            } else {
                border = new TitledBorder(text);
            }
            this.setBorder(new CompoundBorder(new FocusBorder(this), border));
        } else {
            this.setBorder(new FocusBorder(this));
        }
        if (comp != null) {
            this.add(comp);
        }
    }

    public void setComponent(JComponent comp) {
        if (this.comp != null) {
            this.remove(this.comp);
        }
        this.comp = comp;
        if (!this.collapsed) {
            LayoutManager lm = this.getLayout();
            if (lm instanceof BorderLayout) {
                this.add((Component)comp, "Center");
            } else {
                this.add(comp);
            }
        }
        this.revalidate();
    }

    public void setValueLabel(String str) {
        this.valueLabelStr = str;
        if (this.label != null) {
            this.label.setText(Resources.getText("Current value", this.valueLabelStr));
        }
    }

    public void actionPerformed(ActionEvent ev) {
        if (this.collapsed) {
            if (this.label != null) {
                this.remove(this.label);
            }
            this.add(this.comp);
            this.moreOrLessButton.setIcon(this.collapseIcon);
        } else {
            this.remove(this.comp);
            if (this.valueLabelStr != null) {
                if (this.label == null) {
                    this.label = new JLabel(Resources.getText("Current value", this.valueLabelStr));
                }
                this.add(this.label);
            }
            this.moreOrLessButton.setIcon(this.expandIcon);
        }
        this.collapsed = !this.collapsed;
        JComponent container = (JComponent)this.getParent();
        if (container != null && container.getLayout() instanceof VariableGridLayout) {
            ((VariableGridLayout)container.getLayout()).setFillRow(this, !this.collapsed);
            container.revalidate();
        }
    }

    public Dimension getMinimumSize() {
        if (this.getLayout() != null) {
            return super.getMinimumSize();
        }
        if (this.moreOrLessButton != null) {
            Dimension d = this.moreOrLessButton.getMinimumSize();
            Insets i = this.getInsets();
            d.width += i.left + i.right;
            d.height += i.top + i.bottom;
            return d;
        }
        return super.getMinimumSize();
    }

    public void doLayout() {
        if (this.getLayout() != null) {
            super.doLayout();
            return;
        }
        Dimension d = this.getSize();
        Insets i = this.getInsets();
        if (this.collapsed) {
            if (this.label != null) {
                Dimension p = this.label.getPreferredSize();
                this.label.setBounds(i.left, i.top + (d.height - i.top - i.bottom - p.height) / 2, p.width, p.height);
            }
        } else if (this.comp != null) {
            this.comp.setBounds(i.left, i.top, d.width - i.left - i.right, d.height - i.top - i.bottom);
        }
    }

    protected static class FocusBorder
    extends AbstractBorder
    implements FocusListener {
        private Component comp;
        private Color focusColor;
        private boolean focusLostTemporarily = false;

        public FocusBorder(Component comp) {
            this.comp = comp;
            comp.addFocusListener(this);
            this.focusColor = UIManager.getColor("TabbedPane.focus");
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (this.comp.hasFocus() || this.focusLostTemporarily) {
                Color color = g.getColor();
                g.setColor(this.focusColor);
                BasicGraphicsUtils.drawDashedRect(g, x, y, width, height);
                g.setColor(color);
            }
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.bottom = 2;
            insets.right = 2;
            insets.top = 2;
            insets.left = 2;
            return insets;
        }

        public void focusGained(FocusEvent e) {
            this.comp.repaint();
        }

        public void focusLost(FocusEvent e) {
            this.focusLostTemporarily = e.isTemporary();
            if (!this.focusLostTemporarily) {
                this.comp.repaint();
            }
        }
    }

    protected static class LabeledBorder
    extends TitledBorder {
        protected JComponent label;
        private Point compLoc = new Point();

        public LabeledBorder(JComponent label) {
            this(null, label);
        }

        public LabeledBorder(Border border) {
            this(border, (JComponent)null);
        }

        public LabeledBorder(Border border, JComponent label) {
            super(border);
            this.label = label;
            if (label instanceof JLabel && label.getForeground() instanceof ColorUIResource) {
                label.setForeground(this.getTitleColor());
            }
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Border border = this.getBorder();
            if (this.label == null) {
                if (border != null) {
                    border.paintBorder(c, g, x, y, width, height);
                }
                return;
            }
            Rectangle grooveRect = new Rectangle(x + 2, y + 2, width - 4, height - 4);
            Dimension labelDim = this.label.getPreferredSize();
            int baseline = this.label.getBaseline(labelDim.width, labelDim.height);
            int ascent = Math.max(0, baseline);
            int descent = labelDim.height - ascent;
            Insets insets = border != null ? border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
            int diff = Math.max(0, ascent / 2 + 2 - 2);
            grooveRect.y += diff;
            grooveRect.height -= diff;
            this.compLoc.y = grooveRect.y + insets.top / 2 - (ascent + descent) / 2 - 1;
            int justification = c.getComponentOrientation().isLeftToRight() ? 1 : 3;
            switch (justification) {
                case 1: {
                    this.compLoc.x = grooveRect.x + 5 + insets.left;
                    break;
                }
                case 3: {
                    this.compLoc.x = grooveRect.x + grooveRect.width - (labelDim.width + 5 + insets.right);
                }
            }
            if (border != null) {
                if (grooveRect.y > this.compLoc.y - ascent) {
                    Rectangle clipRect = new Rectangle();
                    Rectangle saveClip = g.getClipBounds();
                    clipRect.setBounds(saveClip);
                    if (LabeledBorder.computeIntersection(clipRect, x, y, this.compLoc.x - 1 - x, height)) {
                        g.setClip(clipRect);
                        border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                    }
                    clipRect.setBounds(saveClip);
                    if (LabeledBorder.computeIntersection(clipRect, this.compLoc.x + labelDim.width + 1, y, x + width - (this.compLoc.x + labelDim.width + 1), height)) {
                        g.setClip(clipRect);
                        border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                    }
                    clipRect.setBounds(saveClip);
                    if (LabeledBorder.computeIntersection(clipRect, this.compLoc.x - 1, this.compLoc.y + ascent + descent, labelDim.width + 2, y + height - this.compLoc.y - ascent - descent)) {
                        g.setClip(clipRect);
                        border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                    }
                    g.setClip(saveClip);
                } else {
                    border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                }
                this.label.setLocation(this.compLoc);
                this.label.setSize(labelDim);
            }
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            int height = 16;
            Border border = this.getBorder();
            if (border != null) {
                if (border instanceof AbstractBorder) {
                    ((AbstractBorder)border).getBorderInsets(c, insets);
                } else {
                    Insets i = border.getBorderInsets(c);
                    insets.top = i.top;
                    insets.right = i.right;
                    insets.bottom = i.bottom;
                    insets.left = i.left;
                }
            } else {
                insets.bottom = 0;
                insets.right = 0;
                insets.top = 0;
                insets.left = 0;
            }
            insets.left += 4;
            insets.right += 4;
            insets.top += 4;
            insets.bottom += 4;
            if (c == null || this.label == null) {
                return insets;
            }
            insets.top += this.label.getHeight();
            return insets;
        }

        public JComponent getLabel() {
            return this.label;
        }

        public void setLabel(JComponent label) {
            this.label = label;
        }

        public Dimension getMinimumSize(Component c) {
            Insets insets = this.getBorderInsets(c);
            Dimension minSize = new Dimension(insets.right + insets.left, insets.top + insets.bottom);
            minSize.width += this.label.getWidth();
            return minSize;
        }

        private static boolean computeIntersection(Rectangle dest, int rx, int ry, int rw, int rh) {
            int x1 = Math.max(rx, dest.x);
            int x2 = Math.min(rx + rw, dest.x + dest.width);
            int y1 = Math.max(ry, dest.y);
            int y2 = Math.min(ry + rh, dest.y + dest.height);
            dest.x = x1;
            dest.y = y1;
            dest.width = x2 - x1;
            dest.height = y2 - y1;
            return dest.width > 0 && dest.height > 0;
        }
    }

    private static class ArrowIcon
    implements Icon {
        private int direction;
        private JLabel textLabel;

        public ArrowIcon(int direction, JLabel textLabel) {
            this.direction = direction;
            this.textLabel = textLabel;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            int w;
            int h = w = this.getIconWidth();
            Polygon p = new Polygon();
            switch (this.direction) {
                case 3: {
                    p.addPoint(x + 2, y);
                    p.addPoint(x + w - 2, y + h / 2);
                    p.addPoint(x + 2, y + h - 1);
                    break;
                }
                case 5: {
                    p.addPoint(x, y + 2);
                    p.addPoint(x + w / 2, y + h - 2);
                    p.addPoint(x + w - 1, y + 2);
                }
            }
            g.fillPolygon(p);
        }

        public int getIconWidth() {
            return this.getIconHeight();
        }

        public int getIconHeight() {
            Graphics g = this.textLabel.getGraphics();
            if (g != null) {
                int h = g.getFontMetrics(this.textLabel.getFont()).getAscent() * 6 / 10;
                if (h % 2 == 0) {
                    ++h;
                }
                return h;
            }
            return 7;
        }
    }
}

