/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import com.sun.management.GarbageCollectorMXBean;
import com.sun.management.GcInfo;
import java.io.IOException;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import sun.tools.jconsole.MemoryPoolStat;
import sun.tools.jconsole.ProxyClient;

public class MemoryPoolProxy {
    private String poolName;
    private ProxyClient client;
    private ObjectName objName;
    private MemoryPoolMXBean pool;
    private Map<ObjectName, Long> gcMBeans;
    private GcInfo lastGcInfo;

    public MemoryPoolProxy(ProxyClient client, ObjectName poolName) throws IOException {
        String[] mgrNames;
        this.client = client;
        this.objName = this.objName;
        this.pool = client.getMXBean(poolName, MemoryPoolMXBean.class);
        this.poolName = this.pool.getName();
        this.gcMBeans = new HashMap<ObjectName, Long>();
        this.lastGcInfo = null;
        for (String name : mgrNames = this.pool.getMemoryManagerNames()) {
            try {
                ObjectName mbeanName = new ObjectName("java.lang:type=GarbageCollector,name=" + name);
                if (!client.isRegistered(mbeanName)) continue;
                this.gcMBeans.put(mbeanName, new Long(0L));
            }
            catch (Exception e) {
                assert (false);
            }
        }
    }

    public boolean isCollectedMemoryPool() {
        return this.gcMBeans.size() != 0;
    }

    public ObjectName getObjectName() {
        return this.objName;
    }

    public MemoryPoolStat getStat() throws IOException {
        long usageThreshold = this.pool.isUsageThresholdSupported() ? this.pool.getUsageThreshold() : -1L;
        long collectThreshold = this.pool.isCollectionUsageThresholdSupported() ? this.pool.getCollectionUsageThreshold() : -1L;
        long lastGcStartTime = 0L;
        long lastGcEndTime = 0L;
        MemoryUsage beforeGcUsage = null;
        MemoryUsage afterGcUsage = null;
        long gcId = 0L;
        if (this.lastGcInfo != null) {
            gcId = this.lastGcInfo.getId();
            lastGcStartTime = this.lastGcInfo.getStartTime();
            lastGcEndTime = this.lastGcInfo.getEndTime();
            beforeGcUsage = this.lastGcInfo.getMemoryUsageBeforeGc().get(this.poolName);
            afterGcUsage = this.lastGcInfo.getMemoryUsageAfterGc().get(this.poolName);
        }
        Set<Map.Entry<ObjectName, Long>> set = this.gcMBeans.entrySet();
        for (Map.Entry<ObjectName, Long> e : set) {
            GarbageCollectorMXBean gc = this.client.getMXBean(e.getKey(), GarbageCollectorMXBean.class);
            Long gcCount = e.getValue();
            Long newCount = gc.getCollectionCount();
            if (newCount <= gcCount) continue;
            this.gcMBeans.put(e.getKey(), new Long(newCount));
            this.lastGcInfo = gc.getLastGcInfo();
            if (this.lastGcInfo.getEndTime() <= lastGcEndTime) continue;
            gcId = this.lastGcInfo.getId();
            lastGcStartTime = this.lastGcInfo.getStartTime();
            lastGcEndTime = this.lastGcInfo.getEndTime();
            beforeGcUsage = this.lastGcInfo.getMemoryUsageBeforeGc().get(this.poolName);
            afterGcUsage = this.lastGcInfo.getMemoryUsageAfterGc().get(this.poolName);
            assert (beforeGcUsage != null);
            assert (afterGcUsage != null);
        }
        MemoryUsage usage = this.pool.getUsage();
        return new MemoryPoolStat(this.poolName, usageThreshold, usage, gcId, lastGcStartTime, lastGcEndTime, collectThreshold, beforeGcUsage, afterGcUsage);
    }
}

