/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.AESConstants;
import com.sun.crypto.provider.DESKey;
import com.sun.crypto.provider.DESedeKey;
import com.sun.crypto.provider.DHPublicKey;
import com.sun.crypto.provider.SunJCE;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class DHKeyAgreement
extends KeyAgreementSpi {
    private boolean generateSecret = false;
    private BigInteger init_p = null;
    private BigInteger init_g = null;
    private BigInteger x = BigInteger.ZERO;
    private BigInteger y = BigInteger.ZERO;

    public DHKeyAgreement() {
        if (!SunJCE.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The SunJCE provider may have been tampered.");
        }
    }

    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(key, null, random);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.generateSecret = false;
        this.init_p = null;
        this.init_g = null;
        if (params != null && !(params instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Diffie-Hellman parameters expected");
        }
        if (!(key instanceof DHPrivateKey)) {
            throw new InvalidKeyException("Diffie-Hellman private key expected");
        }
        DHPrivateKey dhPrivKey = (DHPrivateKey)key;
        if (params != null) {
            this.init_p = ((DHParameterSpec)params).getP();
            this.init_g = ((DHParameterSpec)params).getG();
        }
        BigInteger priv_p = dhPrivKey.getParams().getP();
        BigInteger priv_g = dhPrivKey.getParams().getG();
        if (this.init_p != null && priv_p != null && !this.init_p.equals(priv_p)) {
            throw new InvalidKeyException("Incompatible parameters");
        }
        if (this.init_g != null && priv_g != null && !this.init_g.equals(priv_g)) {
            throw new InvalidKeyException("Incompatible parameters");
        }
        if (this.init_p == null && priv_p == null || this.init_g == null && priv_g == null) {
            throw new InvalidKeyException("Missing parameters");
        }
        this.init_p = priv_p;
        this.init_g = priv_g;
        this.x = dhPrivKey.getX();
    }

    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (!(key instanceof javax.crypto.interfaces.DHPublicKey)) {
            throw new InvalidKeyException("Diffie-Hellman public key expected");
        }
        javax.crypto.interfaces.DHPublicKey dhPubKey = (javax.crypto.interfaces.DHPublicKey)key;
        if (this.init_p == null || this.init_g == null) {
            throw new IllegalStateException("Not initialized");
        }
        BigInteger pub_p = dhPubKey.getParams().getP();
        BigInteger pub_g = dhPubKey.getParams().getG();
        if (pub_p != null && !this.init_p.equals(pub_p)) {
            throw new InvalidKeyException("Incompatible parameters");
        }
        if (pub_g != null && !this.init_g.equals(pub_g)) {
            throw new InvalidKeyException("Incompatible parameters");
        }
        this.y = dhPubKey.getY();
        this.generateSecret = true;
        if (!lastPhase) {
            byte[] intermediate = this.engineGenerateSecret();
            return new DHPublicKey(new BigInteger(1, intermediate), this.init_p, this.init_g);
        }
        return null;
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (!this.generateSecret) {
            throw new IllegalStateException("Key agreement has not been completed yet");
        }
        this.generateSecret = false;
        BigInteger modulus = this.init_p;
        BigInteger tmpResult = this.y.modPow(this.x, modulus);
        byte[] secret = tmpResult.toByteArray();
        if (tmpResult.bitLength() % 8 == 0) {
            byte[] retval = new byte[secret.length - 1];
            System.arraycopy(secret, 1, retval, 0, retval.length);
            return retval;
        }
        return secret;
    }

    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        if (!this.generateSecret) {
            throw new IllegalStateException("Key agreement has not been completed yet");
        }
        if (sharedSecret == null) {
            throw new ShortBufferException("No buffer provided for shared secret");
        }
        BigInteger modulus = this.init_p;
        byte[] secret = this.y.modPow(this.x, modulus).toByteArray();
        if (secret.length << 3 != modulus.bitLength()) {
            if (sharedSecret.length - offset < secret.length - 1) {
                throw new ShortBufferException("Buffer too short for shared secret");
            }
            System.arraycopy(secret, 1, sharedSecret, offset, secret.length - 1);
            this.generateSecret = false;
            return secret.length - 1;
        }
        if (sharedSecret.length - offset < secret.length) {
            throw new ShortBufferException("Buffer too short to hold shared secret");
        }
        System.arraycopy(secret, 0, sharedSecret, offset, secret.length);
        this.generateSecret = false;
        return secret.length;
    }

    protected SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (algorithm == null) {
            throw new NoSuchAlgorithmException("null algorithm");
        }
        byte[] secret = this.engineGenerateSecret();
        if (algorithm.equalsIgnoreCase("DES")) {
            return new DESKey(secret);
        }
        if (algorithm.equalsIgnoreCase("DESede") || algorithm.equalsIgnoreCase("TripleDES")) {
            return new DESedeKey(secret);
        }
        if (algorithm.equalsIgnoreCase("Blowfish")) {
            int keysize = secret.length;
            if (keysize >= 56) {
                keysize = 56;
            }
            SecretKeySpec skey = new SecretKeySpec(secret, 0, keysize, "Blowfish");
            return skey;
        }
        if (algorithm.equalsIgnoreCase("AES")) {
            int keysize = secret.length;
            SecretKeySpec skey = null;
            for (int idx = AESConstants.AES_KEYSIZES.length - 1; skey == null && idx >= 0; --idx) {
                if (keysize < AESConstants.AES_KEYSIZES[idx]) continue;
                keysize = AESConstants.AES_KEYSIZES[idx];
                skey = new SecretKeySpec(secret, 0, keysize, "AES");
            }
            if (skey == null) {
                throw new InvalidKeyException("Key material is too short");
            }
            return skey;
        }
        if (algorithm.equals("TlsPremasterSecret")) {
            return new SecretKeySpec(secret, "TlsPremasterSecret");
        }
        throw new NoSuchAlgorithmException("Unsupported secret key algorithm: " + algorithm);
    }
}

