/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.protocol;

import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.logging.POASystemException;
import com.sun.corba.se.impl.protocol.LocalClientRequestDispatcherBase;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.oa.OADestroyed;
import com.sun.corba.se.spi.oa.OAInvocationInfo;
import com.sun.corba.se.spi.oa.ObjectAdapter;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.protocol.ForwardException;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ServantObject;

public class POALocalCRDImpl
extends LocalClientRequestDispatcherBase {
    private ORBUtilSystemException wrapper;
    private POASystemException poaWrapper;

    public POALocalCRDImpl(ORB orb, int scid, IOR ior) {
        super(orb, scid, ior);
        this.wrapper = ORBUtilSystemException.get(orb, "rpc.protocol");
        this.poaWrapper = POASystemException.get(orb, "rpc.protocol");
    }

    private OAInvocationInfo servantEnter(ObjectAdapter oa) throws OADestroyed {
        oa.enter();
        OAInvocationInfo info = oa.makeInvocationInfo(this.objectId);
        this.orb.pushInvocationInfo(info);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void servantExit(ObjectAdapter oa) {
        try {
            oa.returnServant();
        }
        finally {
            oa.exit();
            this.orb.popInvocationInfo();
        }
    }

    public ServantObject servant_preinvoke(Object self, String operation, Class expectedType) {
        ObjectAdapter oa = this.oaf.find(this.oaid);
        OAInvocationInfo info = null;
        try {
            info = this.servantEnter(oa);
            info.setOperation(operation);
        }
        catch (OADestroyed ex) {
            return this.servant_preinvoke(self, operation, expectedType);
        }
        try {
            try {
                oa.getInvocationServant(info);
                if (!this.checkForCompatibleServant(info, expectedType)) {
                    return null;
                }
            }
            catch (Throwable thr) {
                this.servantExit(oa);
                throw thr;
            }
        }
        catch (ForwardException ex) {
            RuntimeException runexc = new RuntimeException("deal with this.");
            runexc.initCause(ex);
            throw runexc;
        }
        catch (ThreadDeath ex) {
            throw this.wrapper.runtimeexception(ex);
        }
        catch (Throwable t) {
            if (t instanceof SystemException) {
                throw (SystemException)t;
            }
            throw this.poaWrapper.localServantLookup(t);
        }
        if (!this.checkForCompatibleServant(info, expectedType)) {
            this.servantExit(oa);
            return null;
        }
        return info;
    }

    public void servant_postinvoke(Object self, ServantObject servantobj) {
        ObjectAdapter oa = this.orb.peekInvocationInfo().oa();
        this.servantExit(oa);
    }
}

