/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import java.io.IOException;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.Node;

class DRIMarkerSegment
extends MarkerSegment {
    int restartInterval = 0;

    DRIMarkerSegment(JPEGBuffer buffer) throws IOException {
        super(buffer);
        this.restartInterval = (buffer.buf[buffer.bufPtr++] & 0xFF) << 8;
        this.restartInterval |= buffer.buf[buffer.bufPtr++] & 0xFF;
        buffer.bufAvail -= this.length;
    }

    DRIMarkerSegment(Node node) throws IIOInvalidTreeException {
        super(221);
        this.updateFromNativeNode(node, true);
    }

    IIOMetadataNode getNativeNode() {
        IIOMetadataNode node = new IIOMetadataNode("dri");
        node.setAttribute("interval", Integer.toString(this.restartInterval));
        return node;
    }

    void updateFromNativeNode(Node node, boolean fromScratch) throws IIOInvalidTreeException {
        this.restartInterval = DRIMarkerSegment.getAttributeValue(node, null, "interval", 0, 65535, true);
    }

    void write(ImageOutputStream ios) throws IOException {
    }

    void print() {
        this.printTag("DRI");
        System.out.println("Interval: " + Integer.toString(this.restartInterval));
    }
}

