/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import java.util.ArrayList;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadataFormatImpl;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.plugins.jpeg.JPEGQTable;

abstract class JPEGMetadataFormat
extends IIOMetadataFormatImpl {
    private static final int MAX_JPEG_DATA_SIZE = 65533;
    String resourceBaseName = this.getClass().getName() + "Resources";

    JPEGMetadataFormat(String formatName, int childPolicy) {
        super(formatName, childPolicy);
        this.setResourceBaseName(this.resourceBaseName);
    }

    void addStreamElements(String parentName) {
        this.addElement("dqt", parentName, 1, 4);
        this.addElement("dqtable", "dqt", 0);
        this.addAttribute("dqtable", "elementPrecision", 2, false, "0");
        ArrayList<String> tabids = new ArrayList<String>();
        tabids.add("0");
        tabids.add("1");
        tabids.add("2");
        tabids.add("3");
        this.addAttribute("dqtable", "qtableId", 2, true, null, tabids);
        this.addObjectValue("dqtable", JPEGQTable.class, true, null);
        this.addElement("dht", parentName, 1, 4);
        this.addElement("dhtable", "dht", 0);
        ArrayList<String> classes = new ArrayList<String>();
        classes.add("0");
        classes.add("1");
        this.addAttribute("dhtable", "class", 2, true, null, classes);
        this.addAttribute("dhtable", "htableId", 2, true, null, tabids);
        this.addObjectValue("dhtable", JPEGHuffmanTable.class, true, null);
        this.addElement("dri", parentName, 0);
        this.addAttribute("dri", "interval", 2, true, null, "0", "65535", true, true);
        this.addElement("com", parentName, 0);
        this.addAttribute("com", "comment", 0, false, null);
        this.addObjectValue("com", byte[].class, 1, 65533);
        this.addElement("unknown", parentName, 0);
        this.addAttribute("unknown", "MarkerTag", 2, true, null, "0", "255", true, true);
        this.addObjectValue("unknown", byte[].class, 1, 65533);
    }

    public boolean canNodeAppear(String elementName, ImageTypeSpecifier imageType) {
        return this.isInSubtree(elementName, this.getRootName());
    }

    protected boolean isInSubtree(String elementName, String subtreeName) {
        if (elementName.equals(subtreeName)) {
            return true;
        }
        String[] children = this.getChildNames(elementName);
        for (int i = 0; i < children.length; ++i) {
            if (!this.isInSubtree(elementName, children[i])) continue;
            return true;
        }
        return false;
    }
}

