/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKConstants;
import com.sun.java.swing.plaf.gtk.GTKEngine;
import com.sun.java.swing.plaf.gtk.GTKLookAndFeel;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import com.sun.java.swing.plaf.gtk.Metacity;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;
import sun.awt.UNIXToolkit;
import sun.swing.plaf.synth.SynthUI;

class GTKPainter
extends SynthPainter {
    private static final GTKConstants.PositionType[] POSITIONS = new GTKConstants.PositionType[]{GTKConstants.PositionType.BOTTOM, GTKConstants.PositionType.RIGHT, GTKConstants.PositionType.TOP, GTKConstants.PositionType.LEFT};
    private static final GTKConstants.ShadowType[] SHADOWS = new GTKConstants.ShadowType[]{GTKConstants.ShadowType.NONE, GTKConstants.ShadowType.IN, GTKConstants.ShadowType.OUT, GTKConstants.ShadowType.ETCHED_IN, GTKConstants.ShadowType.OUT};
    private static final GTKEngine ENGINE = GTKEngine.INSTANCE;
    static final GTKPainter INSTANCE = new GTKPainter();

    private GTKPainter() {
    }

    private String getName(SynthContext context) {
        return context.getRegion().isSubregion() ? null : context.getComponent().getName();
    }

    @Override
    public void paintCheckBoxBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paintRadioButtonBackground(context, g, x, y, w, h);
    }

    @Override
    public void paintCheckBoxMenuItemBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paintRadioButtonMenuItemBackground(context, g, x, y, w, h);
    }

    @Override
    public void paintFormattedTextFieldBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paintTextBackground(context, g, x, y, w, h);
    }

    @Override
    public void paintToolBarDragWindowBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paintToolBarBackground(context, g, x, y, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintToolBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Region id = context.getRegion();
        int state = context.getComponentState();
        int gtkState = GTKLookAndFeel.synthStateToGTKState(id, state);
        int orientation = ((JToolBar)context.getComponent()).getOrientation();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(g, x, y, w, h, id, state, orientation)) {
                ENGINE.startPainting(g, x, y, w, h, id, state, orientation);
                ENGINE.paintBox(g, context, id, gtkState, GTKConstants.ShadowType.OUT, "handlebox_bin", x, y, w, h);
                ENGINE.finishPainting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintToolBarContentBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Region id = context.getRegion();
        int orientation = ((JToolBar)context.getComponent()).getOrientation();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(g, x, y, w, h, id, orientation)) {
                ENGINE.startPainting(g, x, y, w, h, id, orientation);
                ENGINE.paintBox(g, context, id, 1, GTKConstants.ShadowType.OUT, "toolbar", x, y, w, h);
                ENGINE.finishPainting();
            }
        }
    }

    @Override
    public void paintPasswordFieldBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paintTextBackground(context, g, x, y, w, h);
    }

    @Override
    public void paintTextFieldBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        if (this.getName(context) == "Tree.cellEditor") {
            this.paintTreeCellEditorBackground(context, g, x, y, w, h);
        } else {
            this.paintTextBackground(context, g, x, y, w, h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintRadioButtonBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Region id = context.getRegion();
        int gtkState = GTKLookAndFeel.synthStateToGTKState(id, context.getComponentState());
        if (gtkState == 2) {
            Object object = UNIXToolkit.GTK_LOCK;
            synchronized (object) {
                if (!ENGINE.paintCachedImage(g, x, y, w, h, id)) {
                    ENGINE.startPainting(g, x, y, w, h, id);
                    ENGINE.paintFlatBox(g, context, id, 2, GTKConstants.ShadowType.ETCHED_OUT, "checkbutton", x, y, w, h, ColorType.BACKGROUND);
                    ENGINE.finishPainting();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintRadioButtonMenuItemBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Region id = context.getRegion();
        int gtkState = GTKLookAndFeel.synthStateToGTKState(id, context.getComponentState());
        if (gtkState == 2) {
            Object object = UNIXToolkit.GTK_LOCK;
            synchronized (object) {
                if (!ENGINE.paintCachedImage(g, x, y, w, h, id)) {
                    GTKConstants.ShadowType shadow = GTKLookAndFeel.is2_2() ? GTKConstants.ShadowType.NONE : GTKConstants.ShadowType.OUT;
                    ENGINE.startPainting(g, x, y, w, h, id);
                    ENGINE.paintBox(g, context, id, gtkState, shadow, "menuitem", x, y, w, h);
                    ENGINE.finishPainting();
                }
            }
        }
    }

    @Override
    public void paintLabelBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        String name = this.getName(context);
        JComponent c = context.getComponent();
        Container container = c.getParent();
        if (name == "TableHeader.renderer" || name == "GTKFileChooser.directoryListLabel" || name == "GTKFileChooser.fileListLabel") {
            this.paintButtonBackgroundImpl(context, g, Region.BUTTON, "button", x, y, w, h, true, false, false, false);
        } else if (c instanceof ListCellRenderer && container != null && container.getParent() instanceof JComboBox) {
            this.paintTextBackground(context, g, x, y, w, h);
        }
    }

    @Override
    public void paintInternalFrameBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Metacity.INSTANCE.paintFrameBorder(context, g, x, y, w, h);
    }

    @Override
    public void paintDesktopPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.fillArea(context, g, x, y, w, h, ColorType.BACKGROUND);
    }

    @Override
    public void paintDesktopIconBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Metacity.INSTANCE.paintFrameBorder(context, g, x, y, w, h);
    }

    @Override
    public void paintButtonBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        String name = this.getName(context);
        if (name != null && name.startsWith("InternalFrameTitlePane.")) {
            Metacity.INSTANCE.paintButtonBackground(context, g, x, y, w, h);
        } else {
            AbstractButton button = (AbstractButton)context.getComponent();
            boolean paintBG = button.isContentAreaFilled() && button.isBorderPainted();
            boolean paintFocus = button.isFocusPainted();
            boolean defaultCapable = button instanceof JButton && ((JButton)button).isDefaultCapable();
            boolean toolButton = button.getParent() instanceof JToolBar;
            this.paintButtonBackgroundImpl(context, g, Region.BUTTON, "button", x, y, w, h, paintBG, paintFocus, defaultCapable, toolButton);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintButtonBackgroundImpl(SynthContext context, Graphics g, Region id, String detail, int x, int y, int w, int h, boolean paintBackground, boolean paintFocus, boolean defaultCapable, boolean toolButton) {
        int state = context.getComponentState();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            boolean paintBg;
            if (ENGINE.paintCachedImage(g, x, y, w, h, id, state, detail, paintBackground, paintFocus, defaultCapable, toolButton)) {
                return;
            }
            ENGINE.startPainting(g, x, y, w, h, id, state, detail, paintBackground, paintFocus, defaultCapable, toolButton);
            GTKStyle style = (GTKStyle)context.getStyle();
            if (defaultCapable && !toolButton) {
                Insets defaultInsets = style.getClassSpecificInsetsValue(context, "default-border", GTKStyle.BUTTON_DEFAULT_BORDER_INSETS);
                if (paintBackground && (state & 0x400) != 0) {
                    ENGINE.paintBox(g, context, id, 1, GTKConstants.ShadowType.IN, "buttondefault", x, y, w, h);
                }
                x += defaultInsets.left;
                y += defaultInsets.top;
                w -= defaultInsets.left + defaultInsets.right;
                h -= defaultInsets.top + defaultInsets.bottom;
            }
            boolean interiorFocus = style.getClassSpecificBoolValue(context, "interior-focus", true);
            int focusSize = style.getClassSpecificIntValue(context, "focus-line-width", 1);
            int focusPad = style.getClassSpecificIntValue(context, "focus-padding", 1);
            int totalFocusSize = focusSize + focusPad;
            int xThickness = style.getXThickness();
            int yThickness = style.getYThickness();
            if (!interiorFocus && (state & 0x100) == 256) {
                x += totalFocusSize;
                y += totalFocusSize;
                w -= 2 * totalFocusSize;
                h -= 2 * totalFocusSize;
            }
            int gtkState = GTKLookAndFeel.synthStateToGTKState(id, state);
            if (toolButton) {
                paintBg = gtkState != 1 && gtkState != 8;
            } else {
                boolean bl = paintBg = paintBackground || gtkState != 1;
            }
            if (paintBg) {
                GTKConstants.ShadowType shadowType = GTKConstants.ShadowType.OUT;
                if ((state & 0x204) != 0) {
                    shadowType = GTKConstants.ShadowType.IN;
                }
                ENGINE.paintBox(g, context, id, gtkState, shadowType, detail, x, y, w, h);
            }
            if (paintFocus && (state & 0x100) != 0) {
                if (interiorFocus) {
                    x += xThickness + focusPad;
                    y += yThickness + focusPad;
                    w -= 2 * (xThickness + focusPad);
                    h -= 2 * (yThickness + focusPad);
                } else {
                    x -= totalFocusSize;
                    y -= totalFocusSize;
                    w += 2 * totalFocusSize;
                    h += 2 * totalFocusSize;
                }
                ENGINE.paintFocus(g, context, id, gtkState, detail, x, y, w, h);
            }
            ENGINE.finishPainting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintArrowButtonForeground(SynthContext context, Graphics g, int x, int y, int w, int h, int direction) {
        Region id = context.getRegion();
        JComponent c = context.getComponent();
        String name = c.getName();
        GTKConstants.ArrowType arrowType = null;
        switch (direction) {
            case 1: {
                arrowType = GTKConstants.ArrowType.UP;
                break;
            }
            case 5: {
                arrowType = GTKConstants.ArrowType.DOWN;
                break;
            }
            case 3: {
                arrowType = GTKConstants.ArrowType.RIGHT;
                break;
            }
            case 7: {
                arrowType = GTKConstants.ArrowType.LEFT;
            }
        }
        String detail = "arrow";
        if (name == "ScrollBar.button") {
            detail = arrowType == GTKConstants.ArrowType.UP || arrowType == GTKConstants.ArrowType.DOWN ? "vscrollbar" : "hscrollbar";
        } else if (name == "Spinner.nextButton" || name == "Spinner.previousButton") {
            detail = "spinbutton";
        } else if (name != "ComboBox.arrowButton") assert (false);
        int gtkState = GTKLookAndFeel.synthStateToGTKState(id, context.getComponentState());
        GTKConstants.ShadowType shadowType = gtkState == 4 ? GTKConstants.ShadowType.IN : GTKConstants.ShadowType.OUT;
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (ENGINE.paintCachedImage(g, x, y, w, h, gtkState, name, direction)) {
                return;
            }
            ENGINE.startPainting(g, x, y, w, h, gtkState, name, direction);
            ENGINE.paintArrow(g, context, id, gtkState, shadowType, arrowType, detail, x, y, w, h);
            ENGINE.finishPainting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintArrowButtonBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Region id = context.getRegion();
        AbstractButton button = (AbstractButton)context.getComponent();
        String name = button.getName();
        String detail = "button";
        int direction = 0;
        if (name == "ScrollBar.button") {
            Integer prop = (Integer)button.getClientProperty("__arrow_direction__");
            direction = prop != null ? prop : 7;
            switch (direction) {
                default: {
                    detail = "hscrollbar";
                    break;
                }
                case 1: 
                case 5: {
                    detail = "vscrollbar";
                    break;
                }
            }
        } else if (name == "Spinner.previousButton") {
            detail = "spinbutton_down";
        } else if (name == "Spinner.nextButton") {
            detail = "spinbutton_up";
        } else if (name != "ComboBox.arrowButton") assert (false);
        int state = context.getComponentState();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (ENGINE.paintCachedImage(g, x, y, w, h, id, state, detail, direction)) {
                return;
            }
            ENGINE.startPainting(g, x, y, w, h, id, state, detail, direction);
            if (detail.startsWith("spin")) {
                int spinState = button.getParent().isEnabled() ? 1 : 8;
                int mody = detail == "spinbutton_up" ? y : y - h;
                int modh = h * 2;
                ENGINE.paintBox(g, context, id, spinState, GTKConstants.ShadowType.IN, "spinbutton", x, mody, w, modh);
            }
            int gtkState = GTKLookAndFeel.synthStateToGTKState(id, state);
            GTKConstants.ShadowType shadowType = GTKConstants.ShadowType.OUT;
            if ((gtkState & 0x204) != 0) {
                shadowType = GTKConstants.ShadowType.IN;
            }
            ENGINE.paintBox(g, context, id, gtkState, shadowType, detail, x, y, w, h);
            ENGINE.finishPainting();
        }
    }

    @Override
    public void paintListBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.fillArea(context, g, x, y, w, h, GTKColorType.TEXT_BACKGROUND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintMenuBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Region id = context.getRegion();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (ENGINE.paintCachedImage(g, x, y, w, h, id)) {
                return;
            }
            GTKStyle style = (GTKStyle)context.getStyle();
            int shadow = style.getClassSpecificIntValue(context, "shadow-type", 2);
            GTKConstants.ShadowType shadowType = SHADOWS[shadow];
            int gtkState = GTKLookAndFeel.synthStateToGTKState(id, context.getComponentState());
            ENGINE.startPainting(g, x, y, w, h, id);
            ENGINE.paintBox(g, context, id, gtkState, shadowType, "menubar", x, y, w, h);
            ENGINE.finishPainting();
        }
    }

    @Override
    public void paintMenuBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paintMenuItemBackground(context, g, x, y, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintMenuItemBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        int gtkState = GTKLookAndFeel.synthStateToGTKState(context.getRegion(), context.getComponentState());
        if (gtkState == 2) {
            Region id = Region.MENU_ITEM;
            Object object = UNIXToolkit.GTK_LOCK;
            synchronized (object) {
                if (!ENGINE.paintCachedImage(g, x, y, w, h, id)) {
                    GTKConstants.ShadowType shadow = GTKLookAndFeel.is2_2() ? GTKConstants.ShadowType.NONE : GTKConstants.ShadowType.OUT;
                    ENGINE.startPainting(g, x, y, w, h, id);
                    ENGINE.paintBox(g, context, id, gtkState, shadow, "menuitem", x, y, w, h);
                    ENGINE.finishPainting();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintPopupMenuBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Region id = context.getRegion();
        int gtkState = GTKLookAndFeel.synthStateToGTKState(id, context.getComponentState());
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (ENGINE.paintCachedImage(g, x, y, w, h, id, gtkState)) {
                return;
            }
            ENGINE.startPainting(g, x, y, w, h, id, gtkState);
            ENGINE.paintBox(g, context, id, gtkState, GTKConstants.ShadowType.OUT, "menu", x, y, w, h);
            GTKStyle style = (GTKStyle)context.getStyle();
            int xThickness = style.getXThickness();
            int yThickness = style.getYThickness();
            ENGINE.paintBackground(g, context, id, gtkState, style.getGTKColor(context, gtkState, GTKColorType.BACKGROUND), x + xThickness, y + yThickness, w - xThickness - xThickness, h - yThickness - yThickness);
            ENGINE.finishPainting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintProgressBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Region id = context.getRegion();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(g, x, y, w, h, id)) {
                ENGINE.startPainting(g, x, y, w, h, id);
                ENGINE.paintBox(g, context, id, 1, GTKConstants.ShadowType.IN, "trough", x, y, w, h);
                ENGINE.finishPainting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintProgressBarForeground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        Region id = context.getRegion();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (w <= 0 || h <= 0) {
                return;
            }
            ENGINE.startPainting(g, x, y, w, h, id, "fg");
            ENGINE.paintBox(g, context, id, 2, GTKConstants.ShadowType.OUT, "bar", x, y, w, h);
            ENGINE.finishPainting(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintViewportBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Region id = context.getRegion();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(g, x, y, w, h, id)) {
                ENGINE.startPainting(g, x, y, w, h, id);
                ENGINE.paintShadow(g, context, id, 1, GTKConstants.ShadowType.IN, "scrolled_window", x, y, w, h);
                ENGINE.finishPainting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintSeparatorBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        String detail;
        Region id = context.getRegion();
        int state = context.getComponentState();
        JComponent c = context.getComponent();
        if (c instanceof JToolBar.Separator) {
            detail = "toolbar";
            float pct = 0.2f;
            JToolBar.Separator sep = (JToolBar.Separator)c;
            Dimension size = sep.getSeparatorSize();
            GTKStyle style = (GTKStyle)context.getStyle();
            if (orientation == 0) {
                x += (int)((float)w * pct);
                w -= (int)((float)w * pct * 2.0f);
                y += (size.height - style.getYThickness()) / 2;
            } else {
                y += (int)((float)h * pct);
                h -= (int)((float)h * pct * 2.0f);
                x += (size.width - style.getXThickness()) / 2;
            }
        } else {
            detail = "separator";
            Insets insets = c.getInsets();
            x += insets.left;
            y += insets.top;
            if (orientation == 0) {
                w -= insets.left + insets.right;
            } else {
                h -= insets.top + insets.bottom;
            }
        }
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(g, x, y, w, h, id, state, detail, orientation)) {
                ENGINE.startPainting(g, x, y, w, h, id, state, detail, orientation);
                if (orientation == 0) {
                    ENGINE.paintHline(g, context, id, state, detail, x, y, w, h);
                } else {
                    ENGINE.paintVline(g, context, id, state, detail, x, y, w, h);
                }
                ENGINE.finishPainting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintSliderTrackBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Region id = context.getRegion();
        int state = context.getComponentState();
        boolean focused = (state & 0x100) != 0;
        int focusSize = 0;
        if (focused) {
            GTKStyle style = (GTKStyle)context.getStyle();
            focusSize = style.getClassSpecificIntValue(context, "focus-line-width", 1) + style.getClassSpecificIntValue(context, "focus-padding", 1);
            x -= focusSize;
            y -= focusSize;
            w += focusSize * 2;
            h += focusSize * 2;
        }
        JSlider slider = (JSlider)context.getComponent();
        double value = slider.getValue();
        double min = slider.getMinimum();
        double max = slider.getMaximum();
        double visible = 20.0;
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (w <= 0 || h <= 0) {
                return;
            }
            ENGINE.startPainting(g, x, y, w, h, id, state, value);
            int gtkState = GTKLookAndFeel.synthStateToGTKState(id, state);
            ENGINE.setRangeValue(context, id, value, min, max, visible);
            ENGINE.paintBox(g, context, id, gtkState, GTKConstants.ShadowType.IN, "trough", x + focusSize, y + focusSize, w - 2 * focusSize, h - 2 * focusSize);
            if (focused) {
                ENGINE.paintFocus(g, context, id, 1, "trough", x, y, w, h);
            }
            ENGINE.finishPainting(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintSliderThumbBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int dir) {
        Region id = context.getRegion();
        int gtkState = GTKLookAndFeel.synthStateToGTKState(id, context.getComponentState());
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(g, x, y, w, h, id, gtkState, dir)) {
                GTKConstants.Orientation orientation = dir == 0 ? GTKConstants.Orientation.HORIZONTAL : GTKConstants.Orientation.VERTICAL;
                String detail = dir == 0 ? "hscale" : "vscale";
                ENGINE.startPainting(g, x, y, w, h, id, gtkState, dir);
                ENGINE.paintSlider(g, context, id, gtkState, GTKConstants.ShadowType.OUT, detail, x, y, w, h, orientation);
                ENGINE.finishPainting();
            }
        }
    }

    @Override
    public void paintSpinnerBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintSplitPaneDividerBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Region id = context.getRegion();
        int gtkState = GTKLookAndFeel.synthStateToGTKState(id, context.getComponentState());
        JSplitPane splitPane = (JSplitPane)context.getComponent();
        GTKConstants.Orientation orientation = splitPane.getOrientation() == 1 ? GTKConstants.Orientation.VERTICAL : GTKConstants.Orientation.HORIZONTAL;
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(g, x, y, w, h, new Object[]{id, gtkState, orientation})) {
                ENGINE.startPainting(g, x, y, w, h, new Object[]{id, gtkState, orientation});
                ENGINE.paintHandle(g, context, id, gtkState, GTKConstants.ShadowType.OUT, "paned", x, y, w, h, orientation);
                ENGINE.finishPainting();
            }
        }
    }

    @Override
    public void paintSplitPaneDragDivider(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paintSplitPaneDividerForeground(context, g, x, y, w, h, orientation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTabbedPaneContentBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        JTabbedPane pane = (JTabbedPane)context.getComponent();
        int selectedIndex = pane.getSelectedIndex();
        GTKConstants.PositionType placement = GTKLookAndFeel.SwingOrientationConstantToGTK(pane.getTabPlacement());
        int gapStart = 0;
        int gapSize = 0;
        if (selectedIndex != -1) {
            Rectangle tabBounds = pane.getBoundsAt(selectedIndex);
            if (placement == GTKConstants.PositionType.TOP || placement == GTKConstants.PositionType.BOTTOM) {
                gapStart = tabBounds.x - x;
                gapSize = tabBounds.width;
            } else {
                gapStart = tabBounds.y - y;
                gapSize = tabBounds.height;
            }
        }
        Region id = context.getRegion();
        int gtkState = GTKLookAndFeel.synthStateToGTKState(id, context.getComponentState());
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(g, x, y, w, h, new Object[]{id, gtkState, placement, gapStart, gapSize})) {
                ENGINE.startPainting(g, x, y, w, h, new Object[]{id, gtkState, placement, gapStart, gapSize});
                ENGINE.paintBoxGap(g, context, id, gtkState, GTKConstants.ShadowType.OUT, "notebook", x, y, w, h, placement, gapStart, gapSize);
                ENGINE.finishPainting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTabbedPaneTabBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int tabIndex) {
        Region id = context.getRegion();
        int state = context.getComponentState();
        int gtkState = (state & 0x200) != 0 ? 1 : 4;
        JTabbedPane pane = (JTabbedPane)context.getComponent();
        int placement = pane.getTabPlacement();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(g, x, y, w, h, id, gtkState, placement, tabIndex)) {
                GTKConstants.PositionType side = POSITIONS[placement - 1];
                ENGINE.startPainting(g, x, y, w, h, id, gtkState, placement, tabIndex);
                ENGINE.paintExtension(g, context, id, gtkState, GTKConstants.ShadowType.OUT, "tab", x, y, w, h, side, tabIndex);
                ENGINE.finishPainting();
            }
        }
    }

    @Override
    public void paintTextPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paintTextAreaBackground(context, g, x, y, w, h);
    }

    @Override
    public void paintEditorPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paintTextAreaBackground(context, g, x, y, w, h);
    }

    @Override
    public void paintTextAreaBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.fillArea(context, g, x, y, w, h, GTKColorType.TEXT_BACKGROUND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintTextBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        JComponent c = context.getComponent();
        GTKStyle style = (GTKStyle)context.getStyle();
        Region id = context.getRegion();
        int state = context.getComponentState();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (ENGINE.paintCachedImage(g, x, y, w, h, id, state)) {
                return;
            }
            int gtkState = GTKLookAndFeel.synthStateToGTKState(id, state);
            int focusSize = 0;
            boolean interiorFocus = style.getClassSpecificBoolValue(context, "interior-focus", true);
            if (!interiorFocus && (state & 0x100) != 0) {
                focusSize = style.getClassSpecificIntValue(context, "focus-line-width", 1);
                x += focusSize;
                y += focusSize;
                w -= 2 * focusSize;
                h -= 2 * focusSize;
            }
            int xThickness = style.getXThickness();
            int yThickness = style.getYThickness();
            ENGINE.startPainting(g, x, y, w, h, id, state);
            ENGINE.paintShadow(g, context, id, gtkState, GTKConstants.ShadowType.IN, "entry", x, y, w, h);
            ENGINE.paintFlatBox(g, context, id, gtkState, GTKConstants.ShadowType.NONE, "entry_bg", x + xThickness, y + yThickness, w - 2 * xThickness, h - 2 * yThickness, ColorType.TEXT_BACKGROUND);
            if (focusSize > 0) {
                ENGINE.paintFocus(g, context, id, gtkState, "entry", x -= focusSize, y -= focusSize, w += 2 * focusSize, h += 2 * focusSize);
            }
            ENGINE.finishPainting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintTreeCellEditorBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Region id = context.getRegion();
        int gtkState = GTKLookAndFeel.synthStateToGTKState(id, context.getComponentState());
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(g, x, y, w, h, id, gtkState)) {
                ENGINE.startPainting(g, x, y, w, h, id, gtkState);
                ENGINE.paintFlatBox(g, context, id, gtkState, GTKConstants.ShadowType.NONE, "entry_bg", x, y, w, h, ColorType.TEXT_BACKGROUND);
                ENGINE.finishPainting();
            }
        }
    }

    @Override
    public void paintRootPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.fillArea(context, g, x, y, w, h, GTKColorType.BACKGROUND);
    }

    @Override
    public void paintToggleButtonBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Region id = context.getRegion();
        JToggleButton toggleButton = (JToggleButton)context.getComponent();
        boolean paintBG = toggleButton.isContentAreaFilled() && toggleButton.isBorderPainted();
        boolean paintFocus = toggleButton.isFocusPainted();
        boolean toolButton = toggleButton.getParent() instanceof JToolBar;
        this.paintButtonBackgroundImpl(context, g, id, "button", x, y, w, h, paintBG, paintFocus, false, toolButton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintScrollBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Region id = context.getRegion();
        boolean focused = (context.getComponentState() & 0x100) != 0;
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (ENGINE.paintCachedImage(g, x, y, w, h, id, focused)) {
                return;
            }
            ENGINE.startPainting(g, x, y, w, h, id, focused);
            Insets insets = context.getComponent().getInsets();
            GTKStyle style = (GTKStyle)context.getStyle();
            int troughBorder = style.getClassSpecificIntValue(context, "trough-border", 1);
            insets.left -= troughBorder;
            insets.right -= troughBorder;
            insets.top -= troughBorder;
            insets.bottom -= troughBorder;
            ENGINE.paintBox(g, context, id, 4, GTKConstants.ShadowType.IN, "trough", x + insets.left, y + insets.top, w - insets.left - insets.right, h - insets.top - insets.bottom);
            if (focused) {
                ENGINE.paintFocus(g, context, id, 1, "trough", x, y, w, h);
            }
            ENGINE.finishPainting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintScrollBarThumbBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int dir) {
        double value;
        Region id = context.getRegion();
        int gtkState = GTKLookAndFeel.synthStateToGTKState(id, context.getComponentState());
        JScrollBar sb = (JScrollBar)context.getComponent();
        boolean rtl = sb.getOrientation() == 0 && !sb.getComponentOrientation().isLeftToRight();
        double min = 0.0;
        double max = 100.0;
        double visible = 20.0;
        if (sb.getMaximum() - sb.getMinimum() == sb.getVisibleAmount()) {
            value = 0.0;
            visible = 100.0;
        } else {
            value = sb.getValue() == sb.getMinimum() ? (rtl ? 100.0 : 0.0) : (sb.getValue() >= sb.getMaximum() - sb.getVisibleAmount() ? (rtl ? 0.0 : 100.0) : 50.0);
        }
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(g, x, y, w, h, id, gtkState, dir, value, visible, rtl)) {
                ENGINE.startPainting(g, x, y, w, h, id, gtkState, dir, value, visible, rtl);
                GTKConstants.Orientation orientation = dir == 0 ? GTKConstants.Orientation.HORIZONTAL : GTKConstants.Orientation.VERTICAL;
                ENGINE.setRangeValue(context, id, value, min, max, visible);
                ENGINE.paintSlider(g, context, id, gtkState, GTKConstants.ShadowType.OUT, "slider", x, y, w, h, orientation);
                ENGINE.finishPainting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintToolTipBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Region id = context.getRegion();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(g, x, y, w, h, id)) {
                ENGINE.startPainting(g, x, y, w, h, id);
                ENGINE.paintFlatBox(g, context, id, 1, GTKConstants.ShadowType.OUT, "tooltip", x, y, w, h, ColorType.BACKGROUND);
                ENGINE.finishPainting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTreeCellBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Region id = context.getRegion();
        int state = context.getComponentState();
        int gtkState = GTKLookAndFeel.synthStateToGTKState(id, state);
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(g, x, y, w, h, id, state)) {
                ENGINE.startPainting(g, x, y, w, h, id, state);
                ENGINE.paintFlatBox(g, context, id, gtkState, GTKConstants.ShadowType.NONE, "cell_odd", x, y, w, h, ColorType.TEXT_BACKGROUND);
                ENGINE.finishPainting();
            }
        }
    }

    @Override
    public void paintTreeCellFocus(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Region id = Region.TREE_CELL;
        int state = context.getComponentState();
        this.paintFocus(context, g, id, state, "treeview", x, y, w, h);
    }

    @Override
    public void paintTreeBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.fillArea(context, g, x, y, w, h, GTKColorType.TEXT_BACKGROUND);
    }

    @Override
    public void paintViewportBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.fillArea(context, g, x, y, w, h, GTKColorType.TEXT_BACKGROUND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintFocus(SynthContext context, Graphics g, Region id, int state, String detail, int x, int y, int w, int h) {
        int gtkState = GTKLookAndFeel.synthStateToGTKState(id, state);
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(g, x, y, w, h, id, gtkState, "focus")) {
                ENGINE.startPainting(g, x, y, w, h, id, gtkState, "focus");
                ENGINE.paintFocus(g, context, id, gtkState, detail, x, y, w, h);
                ENGINE.finishPainting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintMetacityElement(SynthContext context, Graphics g, int gtkState, String detail, int x, int y, int w, int h, GTKConstants.ShadowType shadow, GTKConstants.ArrowType direction) {
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(g, x, y, w, h, new Object[]{gtkState, detail, shadow, direction})) {
                ENGINE.startPainting(g, x, y, w, h, new Object[]{gtkState, detail, shadow, direction});
                if (detail == "metacity-arrow") {
                    ENGINE.paintArrow(g, context, Region.INTERNAL_FRAME_TITLE_PANE, gtkState, shadow, direction, "", x, y, w, h);
                } else if (detail == "metacity-box") {
                    ENGINE.paintBox(g, context, Region.INTERNAL_FRAME_TITLE_PANE, gtkState, shadow, "", x, y, w, h);
                } else if (detail == "metacity-vline") {
                    ENGINE.paintVline(g, context, Region.INTERNAL_FRAME_TITLE_PANE, gtkState, "", x, y, w, h);
                }
                ENGINE.finishPainting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintIcon(SynthContext context, Graphics g, Method paintMethod, int x, int y, int w, int h) {
        int state = context.getComponentState();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(g, x, y, w, h, state, paintMethod)) {
                block8: {
                    ENGINE.startPainting(g, x, y, w, h, state, paintMethod);
                    try {
                        paintMethod.invoke(this, context, g, state, x, y, w, h);
                    }
                    catch (IllegalAccessException iae) {
                        assert (false);
                    }
                    catch (InvocationTargetException ite) {
                        if ($assertionsDisabled) break block8;
                        throw new AssertionError();
                    }
                }
                ENGINE.finishPainting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintIcon(SynthContext context, Graphics g, Method paintMethod, int x, int y, int w, int h, Object direction) {
        int state = context.getComponentState();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(g, x, y, w, h, state, paintMethod, direction)) {
                block8: {
                    ENGINE.startPainting(g, x, y, w, h, state, paintMethod, direction);
                    try {
                        paintMethod.invoke(this, context, g, state, x, y, w, h, direction);
                    }
                    catch (IllegalAccessException iae) {
                        assert (false);
                    }
                    catch (InvocationTargetException ite) {
                        if ($assertionsDisabled) break block8;
                        throw new AssertionError();
                    }
                }
                ENGINE.finishPainting();
            }
        }
    }

    public void paintTreeExpandedIcon(SynthContext context, Graphics g, int state, int x, int y, int w, int h) {
        ENGINE.paintExpander(g, context, Region.TREE, GTKLookAndFeel.synthStateToGTKState(context.getRegion(), state), GTKConstants.ExpanderStyle.EXPANDED, "treeview", x, y, w, h);
    }

    public void paintTreeCollapsedIcon(SynthContext context, Graphics g, int state, int x, int y, int w, int h) {
        ENGINE.paintExpander(g, context, Region.TREE, GTKLookAndFeel.synthStateToGTKState(context.getRegion(), state), GTKConstants.ExpanderStyle.COLLAPSED, "treeview", x, y, w, h);
    }

    public void paintCheckBoxIcon(SynthContext context, Graphics g, int state, int x, int y, int w, int h) {
        GTKStyle style = (GTKStyle)context.getStyle();
        int size = style.getClassSpecificIntValue(context, "indicator-size", 13);
        int offset = style.getClassSpecificIntValue(context, "indicator-spacing", 2);
        ENGINE.paintCheck(g, context, Region.CHECK_BOX, "checkbutton", x + offset, y + offset, size, size);
    }

    public void paintRadioButtonIcon(SynthContext context, Graphics g, int state, int x, int y, int w, int h) {
        GTKStyle style = (GTKStyle)context.getStyle();
        int size = style.getClassSpecificIntValue(context, "indicator-size", 13);
        int offset = style.getClassSpecificIntValue(context, "indicator-spacing", 2);
        ENGINE.paintOption(g, context, Region.RADIO_BUTTON, "radiobutton", x + offset, y + offset, size, size);
    }

    public void paintMenuArrowIcon(SynthContext context, Graphics g, int state, int x, int y, int w, int h, GTKConstants.ArrowType dir) {
        int gtkState = GTKLookAndFeel.synthStateToGTKState(context.getRegion(), state);
        GTKConstants.ShadowType shadow = GTKConstants.ShadowType.OUT;
        if (gtkState == 2) {
            shadow = GTKConstants.ShadowType.IN;
        }
        ENGINE.paintArrow(g, context, Region.MENU_ITEM, gtkState, shadow, dir, "menuitem", x + 3, y + 3, 7, 7);
    }

    public void paintCheckBoxMenuItemCheckIcon(SynthContext context, Graphics g, int state, int x, int y, int w, int h) {
        GTKStyle style = (GTKStyle)context.getStyle();
        int size = style.getClassSpecificIntValue(context, "indicator-size", 12);
        ENGINE.paintCheck(g, context, Region.CHECK_BOX_MENU_ITEM, "check", x + 1, y + 1, size, size);
    }

    public void paintRadioButtonMenuItemCheckIcon(SynthContext context, Graphics g, int state, int x, int y, int w, int h) {
        GTKStyle style = (GTKStyle)context.getStyle();
        int size = style.getClassSpecificIntValue(context, "indicator-size", 12);
        ENGINE.paintOption(g, context, Region.RADIO_BUTTON_MENU_ITEM, "option", x + 1, y + 1, size, size);
    }

    public void paintToolBarHandleIcon(SynthContext context, Graphics g, int state, int x, int y, int w, int h, GTKConstants.Orientation orientation) {
        int gtkState = GTKLookAndFeel.synthStateToGTKState(context.getRegion(), state);
        orientation = orientation == GTKConstants.Orientation.HORIZONTAL ? GTKConstants.Orientation.VERTICAL : GTKConstants.Orientation.HORIZONTAL;
        ENGINE.paintHandle(g, context, Region.TOOL_BAR, gtkState, GTKConstants.ShadowType.OUT, "handlebox", x, y, w, h, orientation);
    }

    public void paintAscendingSortIcon(SynthContext context, Graphics g, int state, int x, int y, int w, int h) {
        ENGINE.paintArrow(g, context, Region.TABLE, 1, GTKConstants.ShadowType.IN, GTKConstants.ArrowType.UP, "arrow", x, y, w, h);
    }

    public void paintDescendingSortIcon(SynthContext context, Graphics g, int state, int x, int y, int w, int h) {
        ENGINE.paintArrow(g, context, Region.TABLE, 1, GTKConstants.ShadowType.IN, GTKConstants.ArrowType.DOWN, "arrow", x, y, w, h);
    }

    private void fillArea(SynthContext context, Graphics g, int x, int y, int w, int h, ColorType colorType) {
        if (context.getComponent().isOpaque()) {
            Region id = context.getRegion();
            int gtkState = GTKLookAndFeel.synthStateToGTKState(id, context.getComponentState());
            GTKStyle style = (GTKStyle)context.getStyle();
            g.setColor(style.getGTKColor(context, gtkState, colorType));
            g.fillRect(x, y, w, h);
        }
    }

    static class TitledBorder
    extends AbstractBorder
    implements UIResource {
        TitledBorder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            SynthContext context = this.getContext((JComponent)c);
            Region id = context.getRegion();
            int state = context.getComponentState();
            int gtkState = GTKLookAndFeel.synthStateToGTKState(id, state);
            Object object = UNIXToolkit.GTK_LOCK;
            synchronized (object) {
                if (!ENGINE.paintCachedImage(g, x, y, w, h, id)) {
                    ENGINE.startPainting(g, x, y, w, h, id);
                    ENGINE.paintShadow(g, context, id, gtkState, GTKConstants.ShadowType.ETCHED_IN, "frame", x, y, w, h);
                    ENGINE.finishPainting();
                }
            }
        }

        @Override
        public Insets getBorderInsets(Component c, Insets i) {
            SynthContext context = this.getContext((JComponent)c);
            return context.getStyle().getInsets(context, i);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        private SynthStyle getStyle(JComponent c) {
            return SynthLookAndFeel.getStyle(c, GTKEngine.CustomRegion.TITLED_BORDER);
        }

        private SynthContext getContext(JComponent c) {
            int state = 1024;
            return new SynthContext(c, GTKEngine.CustomRegion.TITLED_BORDER, this.getStyle(c), state);
        }
    }

    static class ListTableFocusBorder
    extends AbstractBorder
    implements UIResource {
        private boolean selectedCell;
        private boolean focusedCell;

        public static ListTableFocusBorder getSelectedCellBorder() {
            return new ListTableFocusBorder(true, true);
        }

        public static ListTableFocusBorder getUnselectedCellBorder() {
            return new ListTableFocusBorder(false, true);
        }

        public static ListTableFocusBorder getNoFocusCellBorder() {
            return new ListTableFocusBorder(false, false);
        }

        public ListTableFocusBorder(boolean selectedCell, boolean focusedCell) {
            this.selectedCell = selectedCell;
            this.focusedCell = focusedCell;
        }

        private SynthContext getContext(Component c) {
            SynthContext context = null;
            LabelUI ui = null;
            if (c instanceof JLabel) {
                ui = ((JLabel)c).getUI();
            }
            if (ui instanceof SynthUI) {
                context = ((SynthUI)((Object)ui)).getContext((JComponent)c);
            }
            return context;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (this.focusedCell) {
                int state;
                SynthContext context = this.getContext(c);
                int n = state = this.selectedCell ? 512 : 257;
                if (context != null) {
                    INSTANCE.paintFocus(context, g, Region.TABLE, state, "", x, y, w, h);
                }
            }
        }

        @Override
        public Insets getBorderInsets(Component c, Insets i) {
            SynthContext context = this.getContext(c);
            if (context != null) {
                i = context.getStyle().getInsets(context, i);
            }
            return i;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

