/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.interceptor;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.interceptor.MBeanServerInterceptor;
import com.sun.jmx.mbeanserver.DynamicMBean2;
import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.MBeanInstantiator;
import com.sun.jmx.mbeanserver.ModifiableClassLoaderRepository;
import com.sun.jmx.mbeanserver.NamedObject;
import com.sun.jmx.mbeanserver.Repository;
import com.sun.jmx.remote.util.EnvHelp;
import java.lang.ref.WeakReference;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanPermission;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.MBeanTrustPermission;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMBeanServerInterceptor
implements MBeanServerInterceptor {
    private final transient MBeanInstantiator instantiator;
    private transient MBeanServer server = null;
    private final transient MBeanServerDelegate delegate;
    private final transient Repository repository;
    private final transient WeakHashMap<ListenerWrapper, WeakReference<ListenerWrapper>> listenerWrappers = new WeakHashMap();
    private final String domain;
    private boolean queryByRepo;
    private final Set<ObjectName> beingUnregistered = new HashSet<ObjectName>();

    public DefaultMBeanServerInterceptor(MBeanServer outer, MBeanServerDelegate delegate, MBeanInstantiator instantiator, Repository repository) {
        if (outer == null) {
            throw new IllegalArgumentException("outer MBeanServer cannot be null");
        }
        if (delegate == null) {
            throw new IllegalArgumentException("MBeanServerDelegate cannot be null");
        }
        if (instantiator == null) {
            throw new IllegalArgumentException("MBeanInstantiator cannot be null");
        }
        if (repository == null) {
            throw new IllegalArgumentException("Repository cannot be null");
        }
        this.server = outer;
        this.delegate = delegate;
        this.instantiator = instantiator;
        this.repository = repository;
        this.domain = repository.getDefaultDomain();
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.createMBean(className, name, null, null);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.createMBean(className, name, loaderName, null, null);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            return this.createMBean(className, name, null, true, params, signature);
        }
        catch (InstanceNotFoundException e) {
            throw EnvHelp.initCause(new IllegalArgumentException("Unexpected exception: " + e), e);
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.createMBean(className, name, loaderName, false, params, signature);
    }

    private ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, boolean withDefaultLoaderRepository, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        Class theClass;
        ObjectName logicalName = name;
        if (className == null) {
            IllegalArgumentException wrapped = new IllegalArgumentException("The class name cannot be null");
            throw new RuntimeOperationsException(wrapped, "Exception occurred during MBean creation");
        }
        if (name != null) {
            if (name.isPattern()) {
                IllegalArgumentException wrapped = new IllegalArgumentException("Invalid name->" + name.toString());
                String msg = "Exception occurred during MBean creation";
                throw new RuntimeOperationsException(wrapped, "Exception occurred during MBean creation");
            }
            name = this.nonDefaultDomain(name);
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(className, null, null, "instantiate");
        DefaultMBeanServerInterceptor.checkMBeanPermission(className, null, name, "registerMBean");
        if (withDefaultLoaderRepository) {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "createMBean", "ClassName = " + className + ", ObjectName = " + name);
            }
            theClass = this.instantiator.findClassWithDefaultLoaderRepository(className);
        } else if (loaderName == null) {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "createMBean", "ClassName = " + className + ", ObjectName = " + name + ", Loader name = null");
            }
            theClass = this.instantiator.findClass(className, this.server.getClass().getClassLoader());
        } else {
            loaderName = this.nonDefaultDomain(loaderName);
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "createMBean", "ClassName = " + className + ", ObjectName = " + name + ", Loader name = " + loaderName);
            }
            theClass = this.instantiator.findClass(className, loaderName);
        }
        DefaultMBeanServerInterceptor.checkMBeanTrustPermission(theClass);
        Introspector.testCreation(theClass);
        Introspector.checkCompliance(theClass);
        Object moi = this.instantiator.instantiate(theClass, params, signature, this.server.getClass().getClassLoader());
        String infoClassName = DefaultMBeanServerInterceptor.getNewMBeanClassName(moi);
        return this.registerObject(infoClassName, moi, name);
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        Class<?> theClass = object.getClass();
        Introspector.checkCompliance(theClass);
        String infoClassName = DefaultMBeanServerInterceptor.getNewMBeanClassName(object);
        DefaultMBeanServerInterceptor.checkMBeanPermission(infoClassName, null, name, "registerMBean");
        DefaultMBeanServerInterceptor.checkMBeanTrustPermission(theClass);
        return this.registerObject(infoClassName, object, name);
    }

    private static String getNewMBeanClassName(Object mbeanToRegister) throws NotCompliantMBeanException {
        if (mbeanToRegister instanceof DynamicMBean) {
            String name;
            DynamicMBean mbean = (DynamicMBean)mbeanToRegister;
            try {
                name = mbean.getMBeanInfo().getClassName();
            }
            catch (Exception e) {
                NotCompliantMBeanException ncmbe = new NotCompliantMBeanException("Bad getMBeanInfo()");
                ncmbe.initCause(e);
                throw ncmbe;
            }
            if (name == null) {
                String msg = "MBeanInfo has null class name";
                throw new NotCompliantMBeanException("MBeanInfo has null class name");
            }
            return name;
        }
        return mbeanToRegister.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        if (name == null) {
            IllegalArgumentException wrapped = new IllegalArgumentException("Object name cannot be null");
            throw new RuntimeOperationsException(wrapped, "Exception occurred trying to unregister the MBean");
        }
        name = this.nonDefaultDomain(name);
        Set<ObjectName> set = this.beingUnregistered;
        synchronized (set) {
            while (this.beingUnregistered.contains(name)) {
                try {
                    this.beingUnregistered.wait();
                }
                catch (InterruptedException e) {
                    throw new MBeanRegistrationException(e, e.toString());
                }
            }
            this.beingUnregistered.add(name);
        }
        try {
            this.exclusiveUnregisterMBean(name);
        }
        finally {
            set = this.beingUnregistered;
            synchronized (set) {
                this.beingUnregistered.remove(name);
                this.beingUnregistered.notifyAll();
            }
        }
    }

    private void exclusiveUnregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        ModifiableClassLoaderRepository clr;
        DynamicMBean instance = this.getMBean(name);
        DefaultMBeanServerInterceptor.checkMBeanPermission(instance, null, name, "unregisterMBean");
        if (instance instanceof MBeanRegistration) {
            DefaultMBeanServerInterceptor.preDeregisterInvoke((MBeanRegistration)((Object)instance));
        }
        this.repository.remove(name);
        Object resource = DefaultMBeanServerInterceptor.getResource(instance);
        if (resource instanceof ClassLoader && resource != this.server.getClass().getClassLoader() && (clr = this.instantiator.getClassLoaderRepository()) != null) {
            clr.removeClassLoader(name);
        }
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "unregisterMBean", "Send delete notification of object " + name.getCanonicalName());
        }
        this.sendNotification("JMX.mbean.unregistered", name);
        if (instance instanceof MBeanRegistration) {
            DefaultMBeanServerInterceptor.postDeregisterInvoke((MBeanRegistration)((Object)instance));
        }
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        name = this.nonDefaultDomain(name);
        DynamicMBean instance = this.getMBean(name);
        DefaultMBeanServerInterceptor.checkMBeanPermission(instance, null, name, "getObjectInstance");
        String className = DefaultMBeanServerInterceptor.getClassName(instance);
        return new ObjectInstance(name, className);
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            DefaultMBeanServerInterceptor.checkMBeanPermission((String)null, null, null, "queryMBeans");
            Set<ObjectInstance> list = this.queryMBeansImpl(name, null);
            HashSet<ObjectInstance> allowedList = new HashSet<ObjectInstance>(list.size());
            for (ObjectInstance oi : list) {
                try {
                    DefaultMBeanServerInterceptor.checkMBeanPermission(oi.getClassName(), null, oi.getObjectName(), "queryMBeans");
                    allowedList.add(oi);
                }
                catch (SecurityException e) {}
            }
            return this.filterListOfObjectInstances(allowedList, query);
        }
        return this.queryMBeansImpl(name, query);
    }

    private Set<ObjectInstance> queryMBeansImpl(ObjectName name, QueryExp query) {
        Set<NamedObject> list = null;
        list = this.repository.query(name, query);
        if (this.queryByRepo) {
            query = null;
        }
        return this.objectInstancesFromFilteredNamedObjects(list, query);
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        Set<ObjectName> queryList;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            DefaultMBeanServerInterceptor.checkMBeanPermission((String)null, null, null, "queryNames");
            Set<ObjectInstance> list = this.queryMBeansImpl(name, null);
            HashSet<ObjectInstance> allowedList = new HashSet<ObjectInstance>(list.size());
            for (ObjectInstance oi : list) {
                try {
                    DefaultMBeanServerInterceptor.checkMBeanPermission(oi.getClassName(), null, oi.getObjectName(), "queryNames");
                    allowedList.add(oi);
                }
                catch (SecurityException e) {}
            }
            Set<ObjectInstance> queryObjectInstanceList = this.filterListOfObjectInstances(allowedList, query);
            queryList = new HashSet<ObjectName>(queryObjectInstanceList.size());
            for (ObjectInstance oi : queryObjectInstanceList) {
                queryList.add(oi.getObjectName());
            }
        } else {
            queryList = this.queryNamesImpl(name, query);
        }
        return queryList;
    }

    private Set<ObjectName> queryNamesImpl(ObjectName name, QueryExp query) {
        Set<NamedObject> list = null;
        list = this.repository.query(name, query);
        if (this.queryByRepo) {
            query = null;
        }
        return this.objectNamesFromFilteredNamedObjects(list, query);
    }

    @Override
    public boolean isRegistered(ObjectName name) {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name cannot be null"), "Object name cannot be null");
        }
        name = this.nonDefaultDomain(name);
        return this.repository.contains(name);
    }

    @Override
    public String[] getDomains() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            DefaultMBeanServerInterceptor.checkMBeanPermission((String)null, null, null, "getDomains");
            String[] domains = this.repository.getDomains();
            ArrayList<String> result = new ArrayList<String>(domains.length);
            for (int i = 0; i < domains.length; ++i) {
                try {
                    ObjectName domain = new ObjectName(domains[i] + ":x=x");
                    DefaultMBeanServerInterceptor.checkMBeanPermission((String)null, null, domain, "getDomains");
                    result.add(domains[i]);
                    continue;
                }
                catch (MalformedObjectNameException e) {
                    if (!JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.SEVERE)) continue;
                    JmxProperties.MBEANSERVER_LOGGER.logp(Level.SEVERE, DefaultMBeanServerInterceptor.class.getName(), "getDomains", "Failed to check permission for domain = " + domains[i], e);
                    continue;
                }
                catch (SecurityException e) {
                    // empty catch block
                }
            }
            return result.toArray(new String[result.size()]);
        }
        return this.repository.getDomains();
    }

    @Override
    public Integer getMBeanCount() {
        return this.repository.getCount();
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name cannot be null"), "Exception occurred trying to invoke the getter on the MBean");
        }
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Exception occurred trying to invoke the getter on the MBean");
        }
        name = this.nonDefaultDomain(name);
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "getAttribute", "Attribute = " + attribute + ", ObjectName = " + name);
        }
        DynamicMBean instance = this.getMBean(name);
        DefaultMBeanServerInterceptor.checkMBeanPermission(instance, attribute, name, "getAttribute");
        try {
            return instance.getAttribute(attribute);
        }
        catch (AttributeNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            DefaultMBeanServerInterceptor.rethrowMaybeMBeanException(t);
            throw new AssertionError();
        }
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        String[] allowedAttributes;
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName name cannot be null"), "Exception occurred trying to invoke the getter on the MBean");
        }
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attributes cannot be null"), "Exception occurred trying to invoke the getter on the MBean");
        }
        name = this.nonDefaultDomain(name);
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "getAttributes", "ObjectName = " + name);
        }
        DynamicMBean instance = this.getMBean(name);
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            allowedAttributes = attributes;
        } else {
            String classname = DefaultMBeanServerInterceptor.getClassName(instance);
            DefaultMBeanServerInterceptor.checkMBeanPermission(classname, null, name, "getAttribute");
            ArrayList<String> allowedList = new ArrayList<String>(attributes.length);
            for (String attr : attributes) {
                try {
                    DefaultMBeanServerInterceptor.checkMBeanPermission(classname, attr, name, "getAttribute");
                    allowedList.add(attr);
                }
                catch (SecurityException e) {
                    // empty catch block
                }
            }
            allowedAttributes = allowedList.toArray(new String[0]);
        }
        try {
            return instance.getAttributes(allowedAttributes);
        }
        catch (Throwable t) {
            DefaultMBeanServerInterceptor.rethrow(t);
            throw new AssertionError();
        }
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName name cannot be null"), "Exception occurred trying to invoke the setter on the MBean");
        }
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Exception occurred trying to invoke the setter on the MBean");
        }
        name = this.nonDefaultDomain(name);
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "setAttribute", "ObjectName = " + name + ", Attribute = " + attribute.getName());
        }
        DynamicMBean instance = this.getMBean(name);
        DefaultMBeanServerInterceptor.checkMBeanPermission(instance, attribute.getName(), name, "setAttribute");
        try {
            instance.setAttribute(attribute);
        }
        catch (AttributeNotFoundException e) {
            throw e;
        }
        catch (InvalidAttributeValueException e) {
            throw e;
        }
        catch (Throwable t) {
            DefaultMBeanServerInterceptor.rethrowMaybeMBeanException(t);
            throw new AssertionError();
        }
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        AttributeList allowedAttributes;
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName name cannot be null"), "Exception occurred trying to invoke the setter on the MBean");
        }
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("AttributeList  cannot be null"), "Exception occurred trying to invoke the setter on the MBean");
        }
        name = this.nonDefaultDomain(name);
        DynamicMBean instance = this.getMBean(name);
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            allowedAttributes = attributes;
        } else {
            String classname = DefaultMBeanServerInterceptor.getClassName(instance);
            DefaultMBeanServerInterceptor.checkMBeanPermission(classname, null, name, "setAttribute");
            allowedAttributes = new AttributeList(attributes.size());
            Iterator i = attributes.iterator();
            while (i.hasNext()) {
                try {
                    Attribute attribute = (Attribute)i.next();
                    DefaultMBeanServerInterceptor.checkMBeanPermission(classname, attribute.getName(), name, "setAttribute");
                    allowedAttributes.add(attribute);
                }
                catch (SecurityException e) {}
            }
        }
        try {
            return instance.setAttributes(allowedAttributes);
        }
        catch (Throwable t) {
            DefaultMBeanServerInterceptor.rethrow(t);
            throw new AssertionError();
        }
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        name = this.nonDefaultDomain(name);
        DynamicMBean instance = this.getMBean(name);
        DefaultMBeanServerInterceptor.checkMBeanPermission(instance, operationName, name, "invoke");
        try {
            return instance.invoke(operationName, params, signature);
        }
        catch (Throwable t) {
            DefaultMBeanServerInterceptor.rethrowMaybeMBeanException(t);
            throw new AssertionError();
        }
    }

    private static void rethrow(Throwable t) throws ReflectionException {
        try {
            throw t;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (RuntimeOperationsException e) {
            throw e;
        }
        catch (RuntimeErrorException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeMBeanException(e, e.toString());
        }
        catch (Error e) {
            throw new RuntimeErrorException(e, e.toString());
        }
        catch (Throwable t2) {
            throw new RuntimeException("Unexpected exception", t2);
        }
    }

    private static void rethrowMaybeMBeanException(Throwable t) throws ReflectionException, MBeanException {
        if (t instanceof MBeanException) {
            throw (MBeanException)t;
        }
        DefaultMBeanServerInterceptor.rethrow(t);
    }

    private ObjectInstance registerObject(String classname, Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (object == null) {
            IllegalArgumentException wrapped = new IllegalArgumentException("Cannot add null object");
            throw new RuntimeOperationsException(wrapped, "Exception occurred trying to register the MBean");
        }
        DynamicMBean mbean = Introspector.makeDynamicMBean(object);
        return this.registerDynamicMBean(classname, mbean, name);
    }

    private ObjectInstance registerDynamicMBean(String classname, DynamicMBean mbean, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        Object resource;
        name = this.nonDefaultDomain(name);
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "registerMBean", "ObjectName = " + name);
        }
        ObjectName logicalName = name;
        if (mbean instanceof MBeanRegistration) {
            MBeanRegistration reg = (MBeanRegistration)((Object)mbean);
            logicalName = DefaultMBeanServerInterceptor.preRegisterInvoke(reg, name, this.server);
            if (mbean instanceof DynamicMBean2) {
                try {
                    ((DynamicMBean2)mbean).preRegister2(this.server, logicalName);
                }
                catch (Exception e) {
                    DefaultMBeanServerInterceptor.postRegisterInvoke(reg, false, false);
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e instanceof InstanceAlreadyExistsException) {
                        throw (InstanceAlreadyExistsException)e;
                    }
                    throw new RuntimeException(e);
                }
            }
            if (logicalName != name && logicalName != null) {
                logicalName = ObjectName.getInstance(this.nonDefaultDomain(logicalName));
            }
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(classname, null, logicalName, "registerMBean");
        if (logicalName == null) {
            if (mbean instanceof MBeanRegistration) {
                DefaultMBeanServerInterceptor.postRegisterInvoke((MBeanRegistration)((Object)mbean), false, true);
            }
            IllegalArgumentException wrapped = new IllegalArgumentException("No object name specified");
            throw new RuntimeOperationsException(wrapped, "Exception occurred trying to register the MBean");
        }
        ObjectInstance result = new ObjectInstance(logicalName, classname);
        this.internal_addObject(mbean, logicalName);
        if (mbean instanceof MBeanRegistration) {
            DefaultMBeanServerInterceptor.postRegisterInvoke((MBeanRegistration)((Object)mbean), true, false);
        }
        if ((resource = DefaultMBeanServerInterceptor.getResource(mbean)) instanceof ClassLoader) {
            ModifiableClassLoaderRepository clr = this.instantiator.getClassLoaderRepository();
            if (clr == null) {
                IllegalArgumentException wrapped = new IllegalArgumentException("Dynamic addition of class loaders is not supported");
                throw new RuntimeOperationsException(wrapped, "Exception occurred trying to register the MBean as a class loader");
            }
            clr.addClassLoader(logicalName, (ClassLoader)resource);
        }
        return result;
    }

    private static ObjectName preRegisterInvoke(MBeanRegistration moi, ObjectName name, MBeanServer mbs) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        ObjectName newName;
        try {
            newName = moi.preRegister(mbs, name);
        }
        catch (RuntimeException e) {
            throw new RuntimeMBeanException(e, "RuntimeException thrown in preRegister method");
        }
        catch (Error er) {
            throw new RuntimeErrorException(er, "Error thrown in preRegister method");
        }
        catch (MBeanRegistrationException r) {
            throw r;
        }
        catch (Exception ex) {
            throw new MBeanRegistrationException(ex, "Exception thrown in preRegister method");
        }
        if (newName != null) {
            return newName;
        }
        return name;
    }

    private static void postRegisterInvoke(MBeanRegistration moi, boolean registrationDone, boolean registerFailed) {
        if (registerFailed && moi instanceof DynamicMBean2) {
            ((DynamicMBean2)((Object)moi)).registerFailed();
        }
        try {
            moi.postRegister(new Boolean(registrationDone));
        }
        catch (RuntimeException e) {
            throw new RuntimeMBeanException(e, "RuntimeException thrown in postRegister method");
        }
        catch (Error er) {
            throw new RuntimeErrorException(er, "Error thrown in postRegister method");
        }
    }

    private static void preDeregisterInvoke(MBeanRegistration moi) throws MBeanRegistrationException {
        try {
            moi.preDeregister();
        }
        catch (RuntimeException e) {
            throw new RuntimeMBeanException(e, "RuntimeException thrown in preDeregister method");
        }
        catch (Error er) {
            throw new RuntimeErrorException(er, "Error thrown in preDeregister method");
        }
        catch (MBeanRegistrationException t) {
            throw t;
        }
        catch (Exception ex) {
            throw new MBeanRegistrationException(ex, "Exception thrown in preDeregister method");
        }
    }

    private static void postDeregisterInvoke(MBeanRegistration moi) {
        try {
            moi.postDeregister();
        }
        catch (RuntimeException e) {
            throw new RuntimeMBeanException(e, "RuntimeException thrown in postDeregister method");
        }
        catch (Error er) {
            throw new RuntimeErrorException(er, "Error thrown in postDeregister method");
        }
    }

    private DynamicMBean getMBean(ObjectName name) throws InstanceNotFoundException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name cannot be null"), "Exception occurred trying to get an MBean");
        }
        DynamicMBean obj = null;
        obj = this.repository.retrieve(name);
        if (obj == null) {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "getMBean", name + " : Found no object");
            }
            throw new InstanceNotFoundException(name.toString());
        }
        return obj;
    }

    private static Object getResource(DynamicMBean mbean) {
        if (mbean instanceof DynamicMBean2) {
            return ((DynamicMBean2)mbean).getResource();
        }
        return mbean;
    }

    private ObjectName nonDefaultDomain(ObjectName name) {
        if (name == null || name.getDomain().length() > 0) {
            return name;
        }
        String completeName = this.domain + name;
        try {
            return new ObjectName(completeName);
        }
        catch (MalformedObjectNameException e) {
            String msg = "Unexpected default domain problem: " + completeName + ": " + e;
            throw EnvHelp.initCause(new IllegalArgumentException(msg), e);
        }
    }

    @Override
    public String getDefaultDomain() {
        return this.domain;
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "addNotificationListener", "ObjectName = " + name);
        }
        DynamicMBean instance = this.getMBean(name);
        DefaultMBeanServerInterceptor.checkMBeanPermission(instance, null, name, "addNotificationListener");
        NotificationBroadcaster broadcaster = DefaultMBeanServerInterceptor.getNotificationBroadcaster(name, instance, NotificationBroadcaster.class);
        if (listener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null listener"), "Null listener");
        }
        NotificationListener listenerWrapper = this.getListenerWrapper(listener, name, broadcaster, true);
        broadcaster.addNotificationListener(listenerWrapper, filter, handback);
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        DynamicMBean instance = this.getMBean(listener);
        Object resource = DefaultMBeanServerInterceptor.getResource(instance);
        if (!(resource instanceof NotificationListener)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(listener.getCanonicalName()), "The MBean " + listener.getCanonicalName() + "does not implement the NotificationListener interface");
        }
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "addNotificationListener", "ObjectName = " + name + ", Listener = " + listener);
        }
        this.server.addNotificationListener(name, (NotificationListener)resource, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.removeNotificationListener(name, listener, null, null, true);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.removeNotificationListener(name, listener, filter, handback, false);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        NotificationListener instance = this.getListener(listener);
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "removeNotificationListener", "ObjectName = " + name + ", Listener = " + listener);
        }
        this.server.removeNotificationListener(name, instance);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        NotificationListener instance = this.getListener(listener);
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "removeNotificationListener", "ObjectName = " + name + ", Listener = " + listener);
        }
        this.server.removeNotificationListener(name, instance, filter, handback);
    }

    private NotificationListener getListener(ObjectName listener) throws ListenerNotFoundException {
        DynamicMBean instance;
        try {
            instance = this.getMBean(listener);
        }
        catch (InstanceNotFoundException e) {
            throw EnvHelp.initCause(new ListenerNotFoundException(e.getMessage()), e);
        }
        Object resource = DefaultMBeanServerInterceptor.getResource(instance);
        if (!(resource instanceof NotificationListener)) {
            IllegalArgumentException exc = new IllegalArgumentException(listener.getCanonicalName());
            String msg = "MBean " + listener.getCanonicalName() + " does not " + "implement " + NotificationListener.class.getName();
            throw new RuntimeOperationsException(exc, msg);
        }
        return (NotificationListener)resource;
    }

    private void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback, boolean removeAll) throws InstanceNotFoundException, ListenerNotFoundException {
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "removeNotificationListener", "ObjectName = " + name);
        }
        DynamicMBean instance = this.getMBean(name);
        DefaultMBeanServerInterceptor.checkMBeanPermission(instance, null, name, "removeNotificationListener");
        Object resource = DefaultMBeanServerInterceptor.getResource(instance);
        Class reqClass = removeAll ? NotificationBroadcaster.class : NotificationEmitter.class;
        NotificationBroadcaster broadcaster = DefaultMBeanServerInterceptor.getNotificationBroadcaster(name, instance, reqClass);
        NotificationListener listenerWrapper = this.getListenerWrapper(listener, name, resource, false);
        if (listenerWrapper == null) {
            throw new ListenerNotFoundException("Unknown listener");
        }
        if (removeAll) {
            broadcaster.removeNotificationListener(listenerWrapper);
        } else {
            NotificationEmitter emitter = (NotificationEmitter)broadcaster;
            emitter.removeNotificationListener(listenerWrapper, filter, handback);
        }
    }

    private static <T extends NotificationBroadcaster> T getNotificationBroadcaster(ObjectName name, Object instance, Class<T> reqClass) {
        if (instance instanceof DynamicMBean2) {
            instance = ((DynamicMBean2)instance).getResource();
        }
        if (reqClass.isInstance(instance)) {
            return (T)((NotificationBroadcaster)reqClass.cast(instance));
        }
        IllegalArgumentException exc = new IllegalArgumentException(name.getCanonicalName());
        String msg = "MBean " + name.getCanonicalName() + " does not " + "implement " + reqClass.getName();
        throw new RuntimeOperationsException(exc, msg);
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        MBeanInfo mbi;
        DynamicMBean moi = this.getMBean(name);
        try {
            mbi = moi.getMBeanInfo();
        }
        catch (RuntimeMBeanException e) {
            throw e;
        }
        catch (RuntimeErrorException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeMBeanException(e, "getMBeanInfo threw RuntimeException");
        }
        catch (Error e) {
            throw new RuntimeErrorException(e, "getMBeanInfo threw Error");
        }
        if (mbi == null) {
            throw new JMRuntimeException("MBean " + name + "has no MBeanInfo");
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(mbi.getClassName(), null, name, "getMBeanInfo");
        return mbi;
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        DynamicMBean instance = this.getMBean(name);
        DefaultMBeanServerInterceptor.checkMBeanPermission(instance, null, name, "isInstanceOf");
        try {
            if (instance instanceof DynamicMBean2) {
                Object resource = ((DynamicMBean2)instance).getResource();
                ClassLoader loader = resource.getClass().getClassLoader();
                Class<?> c = Class.forName(className, false, loader);
                return c.isInstance(resource);
            }
            String cn = DefaultMBeanServerInterceptor.getClassName(instance);
            if (cn.equals(className)) {
                return true;
            }
            ClassLoader cl = instance.getClass().getClassLoader();
            Class<?> classNameClass = Class.forName(className, false, cl);
            if (classNameClass.isInstance(instance)) {
                return true;
            }
            Class<?> instanceClass = Class.forName(cn, false, cl);
            return classNameClass.isAssignableFrom(instanceClass);
        }
        catch (Exception x) {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINEST, DefaultMBeanServerInterceptor.class.getName(), "isInstanceOf", "Exception calling isInstanceOf", x);
            }
            return false;
        }
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        DynamicMBean instance = this.getMBean(mbeanName);
        DefaultMBeanServerInterceptor.checkMBeanPermission(instance, null, mbeanName, "getClassLoaderFor");
        return DefaultMBeanServerInterceptor.getResource(instance).getClass().getClassLoader();
    }

    @Override
    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        if (loaderName == null) {
            DefaultMBeanServerInterceptor.checkMBeanPermission((String)null, null, null, "getClassLoader");
            return this.server.getClass().getClassLoader();
        }
        DynamicMBean instance = this.getMBean(loaderName);
        DefaultMBeanServerInterceptor.checkMBeanPermission(instance, null, loaderName, "getClassLoader");
        Object resource = DefaultMBeanServerInterceptor.getResource(instance);
        if (!(resource instanceof ClassLoader)) {
            throw new InstanceNotFoundException(loaderName.toString() + " is not a classloader");
        }
        return (ClassLoader)resource;
    }

    private void internal_addObject(DynamicMBean object, ObjectName logicalName) throws InstanceAlreadyExistsException {
        try {
            this.repository.addMBean(object, logicalName);
        }
        catch (InstanceAlreadyExistsException e) {
            if (object instanceof MBeanRegistration) {
                DefaultMBeanServerInterceptor.postRegisterInvoke((MBeanRegistration)((Object)object), false, true);
            }
            throw e;
        }
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "addObject", "Send create notification of object " + logicalName.getCanonicalName());
        }
        this.sendNotification("JMX.mbean.registered", logicalName);
    }

    private void sendNotification(String NotifType, ObjectName name) {
        MBeanServerNotification notif = new MBeanServerNotification(NotifType, (Object)MBeanServerDelegate.DELEGATE_NAME, 0L, name);
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "sendNotification", NotifType + " " + name);
        }
        this.delegate.sendNotification(notif);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ObjectName> objectNamesFromFilteredNamedObjects(Set<NamedObject> list, QueryExp query) {
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        if (query == null) {
            for (NamedObject no : list) {
                result.add(no.getName());
            }
        } else {
            MBeanServer oldServer = QueryEval.getMBeanServer();
            query.setMBeanServer(this.server);
            try {
                for (NamedObject no : list) {
                    boolean res;
                    DynamicMBean obj = no.getObject();
                    try {
                        res = query.apply(no.getName());
                    }
                    catch (Exception e) {
                        res = false;
                    }
                    if (!res) continue;
                    result.add(no.getName());
                }
            }
            finally {
                query.setMBeanServer(oldServer);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ObjectInstance> objectInstancesFromFilteredNamedObjects(Set<NamedObject> list, QueryExp query) {
        HashSet<ObjectInstance> result = new HashSet<ObjectInstance>();
        if (query == null) {
            for (NamedObject no : list) {
                DynamicMBean obj = no.getObject();
                String className = DefaultMBeanServerInterceptor.safeGetClassName(obj);
                result.add(new ObjectInstance(no.getName(), className));
            }
        } else {
            MBeanServer oldServer = QueryEval.getMBeanServer();
            query.setMBeanServer(this.server);
            try {
                for (NamedObject no : list) {
                    boolean res;
                    DynamicMBean obj = no.getObject();
                    try {
                        res = query.apply(no.getName());
                    }
                    catch (Exception e) {
                        res = false;
                    }
                    if (!res) continue;
                    String className = DefaultMBeanServerInterceptor.safeGetClassName(obj);
                    result.add(new ObjectInstance(no.getName(), className));
                }
            }
            finally {
                query.setMBeanServer(oldServer);
            }
        }
        return result;
    }

    private static String safeGetClassName(DynamicMBean mbean) {
        try {
            return DefaultMBeanServerInterceptor.getClassName(mbean);
        }
        catch (Exception e) {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINEST, DefaultMBeanServerInterceptor.class.getName(), "safeGetClassName", "Exception getting MBean class name", e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ObjectInstance> filterListOfObjectInstances(Set<ObjectInstance> list, QueryExp query) {
        if (query == null) {
            return list;
        }
        HashSet<ObjectInstance> result = new HashSet<ObjectInstance>();
        for (ObjectInstance oi : list) {
            boolean res = false;
            MBeanServer oldServer = QueryEval.getMBeanServer();
            query.setMBeanServer(this.server);
            try {
                res = query.apply(oi.getObjectName());
            }
            catch (Exception e) {
                res = false;
            }
            finally {
                query.setMBeanServer(oldServer);
            }
            if (!res) continue;
            result.add(oi);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotificationListener getListenerWrapper(NotificationListener l, ObjectName name, Object mbean, boolean create) {
        ListenerWrapper wrapper = new ListenerWrapper(l, name, mbean);
        WeakHashMap<ListenerWrapper, WeakReference<ListenerWrapper>> weakHashMap = this.listenerWrappers;
        synchronized (weakHashMap) {
            NotificationListener existing;
            WeakReference<ListenerWrapper> ref = this.listenerWrappers.get(wrapper);
            if (ref != null && (existing = (NotificationListener)ref.get()) != null) {
                return existing;
            }
            if (create) {
                ref = new WeakReference<ListenerWrapper>(wrapper);
                this.listenerWrappers.put(wrapper, ref);
                return wrapper;
            }
            return null;
        }
    }

    private static String getClassName(DynamicMBean mbean) {
        if (mbean instanceof DynamicMBean2) {
            return ((DynamicMBean2)mbean).getClassName();
        }
        return mbean.getMBeanInfo().getClassName();
    }

    private static void checkMBeanPermission(DynamicMBean mbean, String member, ObjectName objectName, String actions2) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            DefaultMBeanServerInterceptor.checkMBeanPermission(DefaultMBeanServerInterceptor.safeGetClassName(mbean), member, objectName, actions2);
        }
    }

    private static void checkMBeanPermission(String classname, String member, ObjectName objectName, String actions2) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            MBeanPermission perm = new MBeanPermission(classname, member, objectName, actions2);
            sm.checkPermission(perm);
        }
    }

    private static void checkMBeanTrustPermission(final Class theClass) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            MBeanTrustPermission perm = new MBeanTrustPermission("register");
            PrivilegedAction<ProtectionDomain> act = new PrivilegedAction<ProtectionDomain>(){

                @Override
                public ProtectionDomain run() {
                    return theClass.getProtectionDomain();
                }
            };
            ProtectionDomain pd = AccessController.doPrivileged(act);
            AccessControlContext acc = new AccessControlContext(new ProtectionDomain[]{pd});
            sm.checkPermission(perm, acc);
        }
    }

    private static class ListenerWrapper
    implements NotificationListener {
        private NotificationListener listener;
        private ObjectName name;
        private Object mbean;

        ListenerWrapper(NotificationListener l, ObjectName name, Object mbean) {
            this.listener = l;
            this.name = name;
            this.mbean = mbean;
        }

        public void handleNotification(Notification notification, Object handback) {
            if (notification != null && notification.getSource() == this.mbean) {
                notification.setSource(this.name);
            }
            this.listener.handleNotification(notification, handback);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ListenerWrapper)) {
                return false;
            }
            ListenerWrapper w = (ListenerWrapper)o;
            return w.listener == this.listener && w.mbean == this.mbean && w.name.equals(this.name);
        }

        public int hashCode() {
            return System.identityHashCode(this.listener) ^ System.identityHashCode(this.mbean);
        }
    }
}

