/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.DynamicMBean2;
import com.sun.jmx.mbeanserver.MBeanIntrospector;
import com.sun.jmx.mbeanserver.PerInterface;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MBeanSupport<M>
implements DynamicMBean2,
MBeanRegistration {
    private final MBeanInfo mbeanInfo;
    private final Object resource;
    private final PerInterface<M> perInterface;

    <T> MBeanSupport(T resource, Class<T> mbeanInterface) throws NotCompliantMBeanException {
        if (mbeanInterface == null) {
            throw new NotCompliantMBeanException("Null MBean interface");
        }
        if (!mbeanInterface.isInstance(resource)) {
            String msg = "Resource class " + resource.getClass().getName() + " is not an instance of " + mbeanInterface.getName();
            throw new NotCompliantMBeanException(msg);
        }
        this.resource = resource;
        MBeanIntrospector<M> introspector = this.getMBeanIntrospector();
        this.perInterface = introspector.getPerInterface(mbeanInterface);
        this.mbeanInfo = introspector.getMBeanInfo(resource, this.perInterface);
    }

    abstract MBeanIntrospector<M> getMBeanIntrospector();

    abstract Object getCookie();

    public final boolean isMXBean() {
        return this.perInterface.isMXBean();
    }

    public abstract void register(MBeanServer var1, ObjectName var2) throws Exception;

    public abstract void unregister();

    @Override
    public final ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (this.resource instanceof MBeanRegistration) {
            return ((MBeanRegistration)this.resource).preRegister(server, name);
        }
        return name;
    }

    @Override
    public final void preRegister2(MBeanServer server, ObjectName name) throws Exception {
        this.register(server, name);
    }

    @Override
    public final void registerFailed() {
        this.unregister();
    }

    @Override
    public final void postRegister(Boolean registrationDone) {
        if (this.resource instanceof MBeanRegistration) {
            ((MBeanRegistration)this.resource).postRegister(registrationDone);
        }
    }

    @Override
    public final void preDeregister() throws Exception {
        if (this.resource instanceof MBeanRegistration) {
            ((MBeanRegistration)this.resource).preDeregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void postDeregister() {
        try {
            this.unregister();
        }
        finally {
            if (this.resource instanceof MBeanRegistration) {
                ((MBeanRegistration)this.resource).postDeregister();
            }
        }
    }

    @Override
    public final Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.perInterface.getAttribute(this.resource, attribute, this.getCookie());
    }

    @Override
    public final AttributeList getAttributes(String[] attributes) {
        AttributeList result = new AttributeList(attributes.length);
        for (String attrName : attributes) {
            try {
                Object attrValue = this.getAttribute(attrName);
                result.add(new Attribute(attrName, attrValue));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public final void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String name = attribute.getName();
        Object value = attribute.getValue();
        this.perInterface.setAttribute(this.resource, name, value, this.getCookie());
    }

    @Override
    public final AttributeList setAttributes(AttributeList attributes) {
        AttributeList result = new AttributeList(attributes.size());
        for (Object attrObj : attributes) {
            Attribute attr = (Attribute)attrObj;
            try {
                this.setAttribute(attr);
                result.add(new Attribute(attr.getName(), attr.getValue()));
            }
            catch (Exception e) {}
        }
        return result;
    }

    @Override
    public final Object invoke(String operation, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return this.perInterface.invoke(this.resource, operation, params, signature, this.getCookie());
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    @Override
    public final String getClassName() {
        return this.resource.getClass().getName();
    }

    @Override
    public final Object getResource() {
        return this.resource;
    }

    public final Class<?> getMBeanInterface() {
        return this.perInterface.getMBeanInterface();
    }
}

