/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.ConvertingMethod;
import com.sun.jmx.mbeanserver.MBeanAnalyzer;
import com.sun.jmx.mbeanserver.MXBeanIntrospector;
import com.sun.jmx.mbeanserver.MXBeanLookup;
import com.sun.jmx.mbeanserver.Util;
import java.lang.reflect.Method;
import java.util.Map;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MXBeanProxy {
    private final Map<Method, Handler> handlerMap = Util.newMap();

    public MXBeanProxy(Class<?> mxbeanInterface) throws IllegalArgumentException {
        MBeanAnalyzer<ConvertingMethod> analyzer;
        if (mxbeanInterface == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        try {
            analyzer = MXBeanIntrospector.getInstance().getAnalyzer(mxbeanInterface);
        }
        catch (NotCompliantMBeanException e) {
            throw new IllegalArgumentException(e);
        }
        analyzer.visit(new Visitor());
    }

    public Object invoke(MBeanServerConnection mbsc, ObjectName name, Method method, Object[] args) throws Throwable {
        Handler handler = this.handlerMap.get(method);
        ConvertingMethod cm = handler.getConvertingMethod();
        MXBeanLookup lookup = MXBeanLookup.lookupFor(mbsc);
        Object[] openArgs = cm.toOpenParameters(lookup, args);
        Object result = handler.invoke(mbsc, name, openArgs);
        return cm.fromOpenReturnValue(lookup, result);
    }

    private static class InvokeHandler
    extends Handler {
        private final String[] signature;

        InvokeHandler(String operationName, String[] signature, ConvertingMethod cm) {
            super(operationName, cm);
            this.signature = signature;
        }

        Object invoke(MBeanServerConnection mbsc, ObjectName name, Object[] args) throws Exception {
            return mbsc.invoke(name, this.getName(), args, this.signature);
        }
    }

    private static class SetHandler
    extends Handler {
        SetHandler(String attributeName, ConvertingMethod cm) {
            super(attributeName, cm);
        }

        Object invoke(MBeanServerConnection mbsc, ObjectName name, Object[] args) throws Exception {
            assert (args.length == 1);
            Attribute attr = new Attribute(this.getName(), args[0]);
            mbsc.setAttribute(name, attr);
            return null;
        }
    }

    private static class GetHandler
    extends Handler {
        GetHandler(String attributeName, ConvertingMethod cm) {
            super(attributeName, cm);
        }

        Object invoke(MBeanServerConnection mbsc, ObjectName name, Object[] args) throws Exception {
            assert (args == null || args.length == 0);
            return mbsc.getAttribute(name, this.getName());
        }
    }

    private static abstract class Handler {
        private final String name;
        private final ConvertingMethod convertingMethod;

        Handler(String name, ConvertingMethod cm) {
            this.name = name;
            this.convertingMethod = cm;
        }

        String getName() {
            return this.name;
        }

        ConvertingMethod getConvertingMethod() {
            return this.convertingMethod;
        }

        abstract Object invoke(MBeanServerConnection var1, ObjectName var2, Object[] var3) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Visitor
    implements MBeanAnalyzer.MBeanVisitor<ConvertingMethod> {
        private Visitor() {
        }

        @Override
        public void visitAttribute(String attributeName, ConvertingMethod getter, ConvertingMethod setter) {
            if (getter != null) {
                getter.checkCallToOpen();
                Method getterMethod = getter.getMethod();
                MXBeanProxy.this.handlerMap.put(getterMethod, new GetHandler(attributeName, getter));
            }
            if (setter != null) {
                Method setterMethod = setter.getMethod();
                MXBeanProxy.this.handlerMap.put(setterMethod, new SetHandler(attributeName, setter));
            }
        }

        @Override
        public void visitOperation(String operationName, ConvertingMethod operation) {
            operation.checkCallToOpen();
            Method operationMethod = operation.getMethod();
            String[] sig = operation.getOpenSignature();
            MXBeanProxy.this.handlerMap.put(operationMethod, new InvokeHandler(operationName, sig, operation));
        }
    }
}

