/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.MBeanAnalyzer;
import com.sun.jmx.mbeanserver.MXBeanLookup;
import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.remote.util.EnvHelp;
import java.beans.ConstructorProperties;
import java.io.InvalidObjectException;
import java.lang.annotation.ElementType;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.management.JMX;
import javax.management.ObjectName;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataInvocationHandler;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeDataView;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OpenConverter {
    private final Type targetType;
    private final OpenType openType;
    private final Class openClass;
    private static final ConverterMap converterMap = new ConverterMap();
    private static final List<OpenConverter> permanentConverters = Util.newList();
    private static final String[] keyArray;
    private static final String[] keyValueArray;
    private static final Map<Type, Type> inProgress;

    private OpenConverter(Type targetType, OpenType openType, Class openClass) {
        this.targetType = targetType;
        this.openType = openType;
        this.openClass = openClass;
    }

    public final Object fromOpenValue(MXBeanLookup lookup, Object value) throws InvalidObjectException {
        if (value == null) {
            return null;
        }
        return this.fromNonNullOpenValue(lookup, value);
    }

    abstract Object fromNonNullOpenValue(MXBeanLookup var1, Object var2) throws InvalidObjectException;

    void checkReconstructible() throws InvalidObjectException {
    }

    final Object toOpenValue(MXBeanLookup lookup, Object value) throws OpenDataException {
        if (value == null) {
            return null;
        }
        return this.toNonNullOpenValue(lookup, value);
    }

    abstract Object toNonNullOpenValue(MXBeanLookup var1, Object var2) throws OpenDataException;

    boolean isIdentity() {
        return false;
    }

    final Type getTargetType() {
        return this.targetType;
    }

    final OpenType getOpenType() {
        return this.openType;
    }

    final Class getOpenClass() {
        return this.openClass;
    }

    private static synchronized OpenConverter getConverter(Type type) {
        WeakReference wr = (WeakReference)converterMap.get(type);
        return wr == null ? null : (OpenConverter)wr.get();
    }

    private static synchronized void putConverter(Type type, OpenConverter conv) {
        WeakReference<OpenConverter> wr = new WeakReference<OpenConverter>(conv);
        converterMap.put(type, wr);
    }

    private static synchronized void putPermanentConverter(Type type, OpenConverter conv) {
        OpenConverter.putConverter(type, conv);
        permanentConverters.add(conv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized OpenConverter toConverter(Type objType) throws OpenDataException {
        if (inProgress.containsKey(objType)) {
            throw new OpenDataException("Recursive data structure");
        }
        OpenConverter conv = OpenConverter.getConverter(objType);
        if (conv != null) {
            return conv;
        }
        inProgress.put(objType, objType);
        try {
            conv = OpenConverter.makeConverter(objType);
        }
        finally {
            inProgress.remove(objType);
        }
        OpenConverter.putConverter(objType, conv);
        return conv;
    }

    private static OpenConverter makeConverter(Type objType) throws OpenDataException {
        if (objType instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)objType).getGenericComponentType();
            return OpenConverter.makeArrayOrCollectionConverter(objType, componentType);
        }
        if (objType instanceof Class) {
            Class objClass = (Class)objType;
            if (objClass.isEnum()) {
                return OpenConverter.makeEnumConverter(objClass, ElementType.class);
            }
            if (objClass.isArray()) {
                Class<?> componentType = objClass.getComponentType();
                return OpenConverter.makeArrayOrCollectionConverter(objClass, componentType);
            }
            if (JMX.isMXBeanInterface(objClass)) {
                return OpenConverter.makeMXBeanConverter(objClass);
            }
            return OpenConverter.makeCompositeConverter(objClass);
        }
        if (objType instanceof ParameterizedType) {
            return OpenConverter.makeParameterizedConverter((ParameterizedType)objType);
        }
        throw new OpenDataException("Cannot map type: " + objType);
    }

    private static <T extends Enum<T>> OpenConverter makeEnumConverter(Class<?> enumClass, Class<T> fake) {
        Class enumClassT = (Class)Util.cast(enumClass);
        return new EnumConverter(enumClassT);
    }

    private static OpenConverter makeArrayOrCollectionConverter(Type collectionType, Type elementType) throws OpenDataException {
        Class<?> openArrayClass;
        OpenConverter elementConverter = OpenConverter.toConverter(elementType);
        OpenType elementOpenType = elementConverter.getOpenType();
        ArrayType<E[]> openType = ArrayType.getArrayType(elementOpenType);
        Class elementOpenClass = elementConverter.getOpenClass();
        String openArrayClassName = elementOpenClass.isArray() ? "[" + elementOpenClass.getName() : "[L" + elementOpenClass.getName() + ";";
        try {
            openArrayClass = Class.forName(openArrayClassName);
        }
        catch (ClassNotFoundException e) {
            throw OpenConverter.openDataException("Cannot obtain array class", e);
        }
        if (collectionType instanceof ParameterizedType) {
            return new CollectionConverter(collectionType, openType, openArrayClass, elementConverter);
        }
        if (elementConverter.isIdentity()) {
            return new IdentityConverter(collectionType, openType, openArrayClass);
        }
        return new ArrayConverter(collectionType, openType, openArrayClass, elementConverter);
    }

    private static OpenConverter makeTabularConverter(Type objType, boolean sortedMap, Type keyType, Type valueType) throws OpenDataException {
        String objTypeName = objType.toString();
        OpenConverter keyConverter = OpenConverter.toConverter(keyType);
        OpenConverter valueConverter = OpenConverter.toConverter(valueType);
        OpenType keyOpenType = keyConverter.getOpenType();
        OpenType valueOpenType = valueConverter.getOpenType();
        CompositeType rowType = new CompositeType(objTypeName, objTypeName, keyValueArray, keyValueArray, new OpenType[]{keyOpenType, valueOpenType});
        TabularType tabularType = new TabularType(objTypeName, objTypeName, rowType, keyArray);
        return new TabularConverter(objType, sortedMap, tabularType, keyConverter, valueConverter);
    }

    private static OpenConverter makeParameterizedConverter(ParameterizedType objType) throws OpenDataException {
        Type rawType = objType.getRawType();
        if (rawType instanceof Class) {
            boolean sortedMap;
            Class c = (Class)rawType;
            if (c == List.class || c == Set.class || c == SortedSet.class) {
                Type[] actuals = objType.getActualTypeArguments();
                assert (actuals.length == 1);
                if (c == SortedSet.class) {
                    OpenConverter.mustBeComparable(c, actuals[0]);
                }
                return OpenConverter.makeArrayOrCollectionConverter(objType, actuals[0]);
            }
            boolean bl = sortedMap = c == SortedMap.class;
            if (c == Map.class || sortedMap) {
                Type[] actuals = objType.getActualTypeArguments();
                assert (actuals.length == 2);
                if (sortedMap) {
                    OpenConverter.mustBeComparable(c, actuals[0]);
                }
                return OpenConverter.makeTabularConverter(objType, sortedMap, actuals[0], actuals[1]);
            }
        }
        throw new OpenDataException("Cannot convert type: " + objType);
    }

    private static OpenConverter makeMXBeanConverter(Type t) throws OpenDataException {
        return new MXBeanConverter(t);
    }

    private static OpenConverter makeCompositeConverter(Class c) throws OpenDataException {
        boolean gcInfoHack = c.getName().equals("com.sun.management.GcInfo") && c.getClassLoader() == null;
        List<Method> methods = MBeanAnalyzer.eliminateCovariantMethods(c.getMethods());
        SortedMap<String, Method> getterMap = Util.newSortedMap();
        for (Method method : methods) {
            Method old;
            String propertyName = OpenConverter.propertyName(method);
            if (propertyName == null || gcInfoHack && propertyName.equals("CompositeType") || (old = getterMap.put(OpenConverter.decapitalize(propertyName), method)) == null) continue;
            String msg = "Class " + c.getName() + " has method name clash: " + old.getName() + ", " + method.getName();
            throw new OpenDataException(msg);
        }
        int nitems = getterMap.size();
        if (nitems == 0) {
            throw new OpenDataException("Can't map " + c.getName() + " to an open data type");
        }
        Method[] getters = new Method[nitems];
        String[] itemNames = new String[nitems];
        OpenType[] openTypes = new OpenType[nitems];
        int i = 0;
        for (Map.Entry entry : getterMap.entrySet()) {
            Method getter;
            itemNames[i] = (String)entry.getKey();
            getters[i] = getter = (Method)entry.getValue();
            Type retType = getter.getGenericReturnType();
            openTypes[i] = OpenConverter.toConverter(retType).getOpenType();
            ++i;
        }
        CompositeType compositeType = new CompositeType(c.getName(), c.getName(), itemNames, itemNames, openTypes);
        return new CompositeConverter(c, compositeType, itemNames, getters);
    }

    static InvalidObjectException invalidObjectException(String msg, Throwable cause) {
        return EnvHelp.initCause(new InvalidObjectException(msg), cause);
    }

    static InvalidObjectException invalidObjectException(Throwable cause) {
        return OpenConverter.invalidObjectException(cause.getMessage(), cause);
    }

    static OpenDataException openDataException(String msg, Throwable cause) {
        return EnvHelp.initCause(new OpenDataException(msg), cause);
    }

    static OpenDataException openDataException(Throwable cause) {
        return OpenConverter.openDataException(cause.getMessage(), cause);
    }

    static void mustBeComparable(Class collection, Type element) throws OpenDataException {
        if (!(element instanceof Class) || !Comparable.class.isAssignableFrom((Class)element)) {
            String msg = "Parameter class " + element + " of " + collection.getName() + " does not implement " + Comparable.class.getName();
            throw new OpenDataException(msg);
        }
    }

    public static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        int offset1 = Character.offsetByCodePoints(name, 0, 1);
        if (offset1 < name.length() && Character.isUpperCase(name.codePointAt(offset1))) {
            return name;
        }
        return name.substring(0, offset1).toLowerCase() + name.substring(offset1);
    }

    static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        int offset1 = name.offsetByCodePoints(0, 1);
        return name.substring(0, offset1).toUpperCase() + name.substring(offset1);
    }

    public static String propertyName(Method m) {
        String rest = null;
        String name = m.getName();
        if (name.startsWith("get")) {
            rest = name.substring(3);
        } else if (name.startsWith("is") && m.getReturnType() == Boolean.TYPE) {
            rest = name.substring(2);
        }
        if (rest == null || rest.length() == 0 || m.getParameterTypes().length > 0 || m.getReturnType() == Void.TYPE || name.equals("getClass")) {
            return null;
        }
        return rest;
    }

    static {
        OpenType[] simpleTypes = new OpenType[]{SimpleType.BIGDECIMAL, SimpleType.BIGINTEGER, SimpleType.BOOLEAN, SimpleType.BYTE, SimpleType.CHARACTER, SimpleType.DATE, SimpleType.DOUBLE, SimpleType.FLOAT, SimpleType.INTEGER, SimpleType.LONG, SimpleType.OBJECTNAME, SimpleType.SHORT, SimpleType.STRING, SimpleType.VOID};
        for (int i = 0; i < simpleTypes.length; ++i) {
            Class<?> c;
            OpenType t = simpleTypes[i];
            try {
                c = Class.forName(t.getClassName(), false, ObjectName.class.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new Error(e);
            }
            IdentityConverter conv = new IdentityConverter(c, t, c);
            OpenConverter.putPermanentConverter(c, conv);
            if (!c.getName().startsWith("java.lang.")) continue;
            try {
                Field typeField = c.getField("TYPE");
                Class primitiveType = (Class)typeField.get(null);
                IdentityConverter primitiveConv = new IdentityConverter(primitiveType, t, primitiveType);
                OpenConverter.putPermanentConverter(primitiveType, primitiveConv);
                if (primitiveType == Void.TYPE) continue;
                Class<?> primitiveArrayType = Array.newInstance(primitiveType, 0).getClass();
                ArrayType<?> primitiveArrayOpenType = ArrayType.getPrimitiveArrayType(primitiveArrayType);
                IdentityConverter primitiveArrayConv = new IdentityConverter(primitiveArrayType, primitiveArrayOpenType, primitiveArrayType);
                OpenConverter.putPermanentConverter(primitiveArrayType, primitiveArrayConv);
                continue;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                assert (false);
                continue;
            }
        }
        keyArray = new String[]{"key"};
        keyValueArray = new String[]{"key", "value"};
        inProgress = Util.newIdentityHashMap();
    }

    private static final class CompositeBuilderViaProxy
    extends CompositeBuilder {
        CompositeBuilderViaProxy(Class targetClass, String[] itemNames) {
            super(targetClass, itemNames);
        }

        String applicable(Method[] getters) {
            Class<?> targetClass = this.getTargetClass();
            if (!targetClass.isInterface()) {
                return "not an interface";
            }
            Set<Method> methods = Util.newSet(Arrays.asList(targetClass.getMethods()));
            methods.removeAll(Arrays.asList(getters));
            String bad = null;
            for (Method m : methods) {
                String mname = m.getName();
                Class<?>[] mparams = m.getParameterTypes();
                try {
                    Method om = Object.class.getMethod(mname, mparams);
                    if (Modifier.isPublic(om.getModifiers())) continue;
                    bad = mname;
                }
                catch (NoSuchMethodException e) {
                    bad = mname;
                }
            }
            if (bad != null) {
                return "contains methods other than getters (" + bad + ")";
            }
            return null;
        }

        final Object fromCompositeData(MXBeanLookup lookup, CompositeData cd, String[] itemNames, OpenConverter[] converters) {
            Class<?> targetClass = this.getTargetClass();
            return Proxy.newProxyInstance(targetClass.getClassLoader(), new Class[]{targetClass}, new CompositeDataInvocationHandler(cd));
        }
    }

    private static final class CompositeBuilderViaConstructor
    extends CompositeBuilder {
        private List<Constr> annotatedConstructors;

        CompositeBuilderViaConstructor(Class targetClass, String[] itemNames) {
            super(targetClass, itemNames);
        }

        String applicable(Method[] getters) throws InvalidObjectException {
            Class<ConstructorProperties> propertyNamesClass = ConstructorProperties.class;
            Class<?> targetClass = this.getTargetClass();
            Constructor<?>[] constrs = targetClass.getConstructors();
            List<Constructor<?>> annotatedConstrList = Util.newList();
            for (Constructor<?> constr : constrs) {
                if (!Modifier.isPublic(constr.getModifiers()) || constr.getAnnotation(propertyNamesClass) == null) continue;
                annotatedConstrList.add(constr);
            }
            if (annotatedConstrList.isEmpty()) {
                return "no constructor has @ConstructorProperties annotation";
            }
            this.annotatedConstructors = Util.newList();
            Map<String, Integer> getterMap = Util.newMap();
            String[] itemNames = this.getItemNames();
            for (int i = 0; i < itemNames.length; ++i) {
                getterMap.put(itemNames[i], i);
            }
            Set<BitSet> getterIndexSets = Util.newSet();
            for (Constructor constructor : annotatedConstrList) {
                Object[] propertyNames = constructor.getAnnotation(propertyNamesClass).value();
                Type[] paramTypes = constructor.getGenericParameterTypes();
                if (paramTypes.length != propertyNames.length) {
                    String msg = "Number of constructor params does not match @ConstructorProperties annotation: " + constructor;
                    throw new InvalidObjectException(msg);
                }
                int[] paramIndexes = new int[getters.length];
                for (int i = 0; i < getters.length; ++i) {
                    paramIndexes[i] = -1;
                }
                BitSet present = new BitSet();
                for (int i = 0; i < propertyNames.length; ++i) {
                    String propertyName = propertyNames[i];
                    if (!getterMap.containsKey(propertyName)) {
                        String msg = "@ConstructorProperties includes name " + propertyName + " which does not correspond to a property: " + constructor;
                        throw new InvalidObjectException(msg);
                    }
                    int getterIndex = (Integer)getterMap.get(propertyName);
                    paramIndexes[getterIndex] = i;
                    if (present.get(getterIndex)) {
                        String msg = "@ConstructorProperties contains property " + propertyName + " more than once: " + constructor;
                        throw new InvalidObjectException(msg);
                    }
                    present.set(getterIndex);
                    Method getter = getters[getterIndex];
                    Type propertyType = getter.getGenericReturnType();
                    if (propertyType.equals(paramTypes[i])) continue;
                    String msg = "@ConstructorProperties gives property " + propertyName + " of type " + propertyType + " for parameter " + " of type " + paramTypes[i] + ": " + constructor;
                    throw new InvalidObjectException(msg);
                }
                if (!getterIndexSets.add(present)) {
                    String msg = "More than one constructor has a @ConstructorProperties annotation with this set of names: " + Arrays.toString(propertyNames);
                    throw new InvalidObjectException(msg);
                }
                Constr c = new Constr(constructor, paramIndexes, present);
                this.annotatedConstructors.add(c);
            }
            for (BitSet bitSet : getterIndexSets) {
                boolean seen = false;
                for (BitSet b : getterIndexSets) {
                    if (bitSet == b) {
                        seen = true;
                        continue;
                    }
                    if (!seen) continue;
                    BitSet u = new BitSet();
                    u.or(bitSet);
                    u.or(b);
                    if (getterIndexSets.contains(u)) continue;
                    TreeSet<String> names = new TreeSet<String>();
                    int i = u.nextSetBit(0);
                    while (i >= 0) {
                        names.add(itemNames[i]);
                        i = u.nextSetBit(i + 1);
                    }
                    String msg = "Constructors with @ConstructorProperties annotation  would be ambiguous for these items: " + names;
                    throw new InvalidObjectException(msg);
                }
            }
            return null;
        }

        Object fromCompositeData(MXBeanLookup lookup, CompositeData cd, String[] itemNames, OpenConverter[] converters) throws InvalidObjectException {
            CompositeType ct = cd.getCompositeType();
            BitSet present = new BitSet();
            for (int i = 0; i < itemNames.length; ++i) {
                if (ct.getType(itemNames[i]) == null) continue;
                present.set(i);
            }
            Constr max = null;
            for (Constr constr : this.annotatedConstructors) {
                if (!CompositeBuilderViaConstructor.subset(constr.presentParams, present) || max != null && !CompositeBuilderViaConstructor.subset(max.presentParams, constr.presentParams)) continue;
                max = constr;
            }
            if (max == null) {
                String msg = "No constructor has a @ConstructorProperties for this set of items: " + ct.keySet();
                throw new InvalidObjectException(msg);
            }
            Object[] params = new Object[max.presentParams.cardinality()];
            for (int i = 0; i < itemNames.length; ++i) {
                if (!max.presentParams.get(i)) continue;
                Object openItem = cd.get(itemNames[i]);
                Object javaItem = converters[i].fromOpenValue(lookup, openItem);
                int index = max.paramIndexes[i];
                if (index < 0) continue;
                params[index] = javaItem;
            }
            try {
                return max.constructor.newInstance(params);
            }
            catch (Exception e) {
                String msg = "Exception constructing " + this.getTargetClass().getName();
                throw OpenConverter.invalidObjectException(msg, e);
            }
        }

        private static boolean subset(BitSet sub, BitSet sup) {
            BitSet subcopy = (BitSet)sub.clone();
            subcopy.andNot(sup);
            return subcopy.isEmpty();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Constr {
            final Constructor<?> constructor;
            final int[] paramIndexes;
            final BitSet presentParams;

            Constr(Constructor<?> constructor, int[] paramIndexes, BitSet presentParams) {
                this.constructor = constructor;
                this.paramIndexes = paramIndexes;
                this.presentParams = presentParams;
            }
        }
    }

    private static class CompositeBuilderViaSetters
    extends CompositeBuilder {
        private Method[] setters;

        CompositeBuilderViaSetters(Class targetClass, String[] itemNames) {
            super(targetClass, itemNames);
        }

        String applicable(Method[] getters) {
            try {
                Constructor<?> c = this.getTargetClass().getConstructor(null);
            }
            catch (Exception e) {
                return "does not have a public no-arg constructor";
            }
            Method[] setters = new Method[getters.length];
            for (int i = 0; i < getters.length; ++i) {
                Method setter;
                Method getter = getters[i];
                Class<?> returnType = getter.getReturnType();
                String name = OpenConverter.propertyName(getter);
                String setterName = "set" + name;
                try {
                    setter = this.getTargetClass().getMethod(setterName, returnType);
                    if (setter.getReturnType() != Void.TYPE) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    return "not all getters have corresponding setters (" + getter + ")";
                }
                setters[i] = setter;
            }
            this.setters = setters;
            return null;
        }

        Object fromCompositeData(MXBeanLookup lookup, CompositeData cd, String[] itemNames, OpenConverter[] converters) throws InvalidObjectException {
            Object o;
            try {
                o = this.getTargetClass().newInstance();
                for (int i = 0; i < itemNames.length; ++i) {
                    if (!cd.containsKey(itemNames[i])) continue;
                    Object openItem = cd.get(itemNames[i]);
                    Object javaItem = converters[i].fromOpenValue(lookup, openItem);
                    this.setters[i].invoke(o, javaItem);
                }
            }
            catch (Exception e) {
                throw OpenConverter.invalidObjectException(e);
            }
            return o;
        }
    }

    private static class CompositeBuilderCheckGetters
    extends CompositeBuilder {
        private final OpenConverter[] getterConverters;

        CompositeBuilderCheckGetters(Class targetClass, String[] itemNames, OpenConverter[] getterConverters) {
            super(targetClass, itemNames);
            this.getterConverters = getterConverters;
        }

        String applicable(Method[] getters) {
            for (int i = 0; i < getters.length; ++i) {
                try {
                    this.getterConverters[i].checkReconstructible();
                    continue;
                }
                catch (InvalidObjectException e) {
                    return "method " + getters[i].getName() + " returns type " + "that cannot be mapped back from OpenData";
                }
            }
            return "";
        }

        final Object fromCompositeData(MXBeanLookup lookup, CompositeData cd, String[] itemNames, OpenConverter[] converters) {
            throw new Error();
        }
    }

    private static final class CompositeBuilderViaFrom
    extends CompositeBuilder {
        private Method fromMethod;

        CompositeBuilderViaFrom(Class targetClass, String[] itemNames) {
            super(targetClass, itemNames);
        }

        String applicable(Method[] getters) throws InvalidObjectException {
            Class<?> targetClass = this.getTargetClass();
            try {
                Method fromMethod = targetClass.getMethod("from", CompositeData.class);
                if (!Modifier.isStatic(fromMethod.getModifiers())) {
                    String msg = "Method from(CompositeData) is not static";
                    throw new InvalidObjectException("Method from(CompositeData) is not static");
                }
                if (fromMethod.getReturnType() != this.getTargetClass()) {
                    String msg = "Method from(CompositeData) returns " + fromMethod.getReturnType().getName() + " not " + targetClass.getName();
                    throw new InvalidObjectException(msg);
                }
                this.fromMethod = fromMethod;
                return null;
            }
            catch (InvalidObjectException e) {
                throw e;
            }
            catch (Exception e) {
                return "no method from(CompositeData)";
            }
        }

        final Object fromCompositeData(MXBeanLookup lookup, CompositeData cd, String[] itemNames, OpenConverter[] converters) throws InvalidObjectException {
            try {
                return this.fromMethod.invoke(null, cd);
            }
            catch (Exception e) {
                String msg = "Failed to invoke from(CompositeData)";
                throw OpenConverter.invalidObjectException("Failed to invoke from(CompositeData)", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class CompositeBuilder {
        private final Class<?> targetClass;
        private final String[] itemNames;

        CompositeBuilder(Class targetClass, String[] itemNames) {
            this.targetClass = targetClass;
            this.itemNames = itemNames;
        }

        Class<?> getTargetClass() {
            return this.targetClass;
        }

        String[] getItemNames() {
            return this.itemNames;
        }

        abstract String applicable(Method[] var1) throws InvalidObjectException;

        abstract Object fromCompositeData(MXBeanLookup var1, CompositeData var2, String[] var3, OpenConverter[] var4) throws InvalidObjectException;
    }

    private static final class CompositeConverter
    extends OpenConverter {
        private final String[] itemNames;
        private final Method[] getters;
        private final OpenConverter[] getterConverters;
        private CompositeBuilder compositeBuilder;

        CompositeConverter(Class targetClass, CompositeType compositeType, String[] itemNames, Method[] getters) throws OpenDataException {
            super(targetClass, compositeType, CompositeData.class);
            assert (itemNames.length == getters.length);
            this.itemNames = itemNames;
            this.getters = getters;
            this.getterConverters = new OpenConverter[getters.length];
            for (int i = 0; i < getters.length; ++i) {
                Type retType = getters[i].getGenericReturnType();
                this.getterConverters[i] = OpenConverter.toConverter(retType);
            }
        }

        final Object toNonNullOpenValue(MXBeanLookup lookup, Object value) throws OpenDataException {
            CompositeType ct = (CompositeType)this.getOpenType();
            if (value instanceof CompositeDataView) {
                return ((CompositeDataView)value).toCompositeData(ct);
            }
            if (value == null) {
                return null;
            }
            Object[] values = new Object[this.getters.length];
            for (int i = 0; i < this.getters.length; ++i) {
                try {
                    Object got = this.getters[i].invoke(value, null);
                    values[i] = this.getterConverters[i].toOpenValue(lookup, got);
                    continue;
                }
                catch (Exception e) {
                    throw CompositeConverter.openDataException("Error calling getter for " + this.itemNames[i] + ": " + e, e);
                }
            }
            return new CompositeDataSupport(ct, this.itemNames, values);
        }

        private synchronized void makeCompositeBuilder() throws InvalidObjectException {
            if (this.compositeBuilder != null) {
                return;
            }
            Class targetClass = (Class)this.getTargetType();
            CompositeBuilder[][] builders = new CompositeBuilder[][]{{new CompositeBuilderViaFrom(targetClass, this.itemNames)}, {new CompositeBuilderViaConstructor(targetClass, this.itemNames)}, {new CompositeBuilderCheckGetters(targetClass, this.itemNames, this.getterConverters), new CompositeBuilderViaSetters(targetClass, this.itemNames), new CompositeBuilderViaProxy(targetClass, this.itemNames)}};
            CompositeBuilder foundBuilder = null;
            StringBuilder whyNots = new StringBuilder();
            block0: for (CompositeBuilder[] relatedBuilders : builders) {
                for (int i = 0; i < relatedBuilders.length; ++i) {
                    CompositeBuilder builder = relatedBuilders[i];
                    String whyNot = builder.applicable(this.getters);
                    if (whyNot == null) {
                        foundBuilder = builder;
                        break block0;
                    }
                    if (whyNot.length() <= 0) continue;
                    if (whyNots.length() > 0) {
                        whyNots.append("; ");
                    }
                    whyNots.append(whyNot);
                    if (i == 0) continue block0;
                }
            }
            if (foundBuilder == null) {
                String msg = "Do not know how to make a " + targetClass.getName() + " from a CompositeData: " + whyNots;
                throw new InvalidObjectException(msg);
            }
            this.compositeBuilder = foundBuilder;
        }

        void checkReconstructible() throws InvalidObjectException {
            this.makeCompositeBuilder();
        }

        public final Object fromNonNullOpenValue(MXBeanLookup lookup, Object value) throws InvalidObjectException {
            this.makeCompositeBuilder();
            return this.compositeBuilder.fromCompositeData(lookup, (CompositeData)value, this.itemNames, this.getterConverters);
        }
    }

    private static final class TabularConverter
    extends OpenConverter {
        private final boolean sortedMap;
        private final OpenConverter keyConverter;
        private final OpenConverter valueConverter;

        TabularConverter(Type targetType, boolean sortedMap, TabularType tabularType, OpenConverter keyConverter, OpenConverter valueConverter) {
            super(targetType, tabularType, TabularData.class);
            this.sortedMap = sortedMap;
            this.keyConverter = keyConverter;
            this.valueConverter = valueConverter;
        }

        final Object toNonNullOpenValue(MXBeanLookup lookup, Object value) throws OpenDataException {
            Comparator comparator;
            Map valueMap = (Map)Util.cast(value);
            if (valueMap instanceof SortedMap && (comparator = ((SortedMap)valueMap).comparator()) != null) {
                String msg = "Cannot convert SortedMap with non-null comparator: " + comparator;
                throw new OpenDataException(msg);
            }
            TabularType tabularType = (TabularType)this.getOpenType();
            TabularDataSupport table = new TabularDataSupport(tabularType);
            CompositeType rowType = tabularType.getRowType();
            for (Map.Entry entry : valueMap.entrySet()) {
                Object openKey = this.keyConverter.toOpenValue(lookup, entry.getKey());
                Object openValue = this.valueConverter.toOpenValue(lookup, entry.getValue());
                CompositeDataSupport row = new CompositeDataSupport(rowType, keyValueArray, new Object[]{openKey, openValue});
                table.put(row);
            }
            return table;
        }

        public final Object fromNonNullOpenValue(MXBeanLookup lookup, Object openValue) throws InvalidObjectException {
            TabularData table = (TabularData)openValue;
            Collection rows = (Collection)Util.cast(table.values());
            Map<Object, Object> valueMap = this.sortedMap ? Util.newSortedMap() : Util.newMap();
            for (CompositeData row : rows) {
                Object value;
                Object key = this.keyConverter.fromOpenValue(lookup, row.get("key"));
                if (valueMap.put(key, value = this.valueConverter.fromOpenValue(lookup, row.get("value"))) == null) continue;
                String msg = "Duplicate entry in TabularData: key=" + key;
                throw new InvalidObjectException(msg);
            }
            return valueMap;
        }

        void checkReconstructible() throws InvalidObjectException {
            this.keyConverter.checkReconstructible();
            this.valueConverter.checkReconstructible();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MXBeanConverter
    extends OpenConverter {
        MXBeanConverter(Type intf) {
            super(intf, SimpleType.OBJECTNAME, ObjectName.class);
        }

        @Override
        final Object toNonNullOpenValue(MXBeanLookup lookup, Object value) throws OpenDataException {
            this.lookupNotNull(lookup, OpenDataException.class);
            ObjectName name = lookup.mxbeanToObjectName(value);
            if (name == null) {
                throw new OpenDataException("No name for object: " + value);
            }
            return name;
        }

        @Override
        public final Object fromNonNullOpenValue(MXBeanLookup lookup, Object value) throws InvalidObjectException {
            this.lookupNotNull(lookup, InvalidObjectException.class);
            ObjectName name = (ObjectName)value;
            Object mxbean = lookup.objectNameToMXBean(name, (Class)this.getTargetType());
            if (mxbean == null) {
                String msg = "No MXBean for name: " + name;
                throw new InvalidObjectException(msg);
            }
            return mxbean;
        }

        private <T extends Exception> void lookupNotNull(MXBeanLookup lookup, Class<T> excClass) throws T {
            if (lookup == null) {
                Exception exc;
                String msg = "Cannot convert MXBean interface in this context";
                try {
                    Constructor<T> con = excClass.getConstructor(String.class);
                    exc = (Exception)con.newInstance("Cannot convert MXBean interface in this context");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                throw exc;
            }
        }
    }

    private static final class CollectionConverter
    extends OpenConverter {
        private final Class<? extends Collection> collectionClass;
        private final OpenConverter elementConverter;

        CollectionConverter(Type targetType, ArrayType openArrayType, Class openArrayClass, OpenConverter elementConverter) {
            super(targetType, openArrayType, openArrayClass);
            this.elementConverter = elementConverter;
            Type raw = ((ParameterizedType)targetType).getRawType();
            Class c = (Class)raw;
            if (c == List.class) {
                this.collectionClass = ArrayList.class;
            } else if (c == Set.class) {
                this.collectionClass = HashSet.class;
            } else if (c == SortedSet.class) {
                this.collectionClass = TreeSet.class;
            } else {
                assert (false);
                this.collectionClass = null;
            }
        }

        final Object toNonNullOpenValue(MXBeanLookup lookup, Object value) throws OpenDataException {
            Comparator comparator;
            Collection valueCollection = (Collection)value;
            if (valueCollection instanceof SortedSet && (comparator = ((SortedSet)valueCollection).comparator()) != null) {
                String msg = "Cannot convert SortedSet with non-null comparator: " + comparator;
                throw new OpenDataException(msg);
            }
            Object[] openArray = (Object[])Array.newInstance(this.getOpenClass().getComponentType(), valueCollection.size());
            int i = 0;
            for (Object o : valueCollection) {
                openArray[i++] = this.elementConverter.toOpenValue(lookup, o);
            }
            return openArray;
        }

        public final Object fromNonNullOpenValue(MXBeanLookup lookup, Object openValue) throws InvalidObjectException {
            Collection valueCollection;
            Object[] openArray = (Object[])openValue;
            try {
                valueCollection = (Collection)Util.cast(this.collectionClass.newInstance());
            }
            catch (Exception e) {
                throw CollectionConverter.invalidObjectException("Cannot create collection", e);
            }
            for (Object o : openArray) {
                Object value = this.elementConverter.fromOpenValue(lookup, o);
                if (valueCollection.add(value)) continue;
                String msg = "Could not add " + o + " to " + this.collectionClass.getName() + " (duplicate set element?)";
                throw new InvalidObjectException(msg);
            }
            return valueCollection;
        }

        void checkReconstructible() throws InvalidObjectException {
            this.elementConverter.checkReconstructible();
        }
    }

    private static final class ArrayConverter
    extends OpenConverter {
        private final OpenConverter elementConverter;

        ArrayConverter(Type targetType, ArrayType openArrayType, Class openArrayClass, OpenConverter elementConverter) {
            super(targetType, openArrayType, openArrayClass);
            this.elementConverter = elementConverter;
        }

        final Object toNonNullOpenValue(MXBeanLookup lookup, Object value) throws OpenDataException {
            Object[] valueArray = (Object[])value;
            int len = valueArray.length;
            Object[] openArray = (Object[])Array.newInstance(this.getOpenClass().getComponentType(), len);
            for (int i = 0; i < len; ++i) {
                openArray[i] = this.elementConverter.toOpenValue(lookup, valueArray[i]);
            }
            return openArray;
        }

        public final Object fromNonNullOpenValue(MXBeanLookup lookup, Object openValue) throws InvalidObjectException {
            Class<?> componentType;
            Object[] openArray = (Object[])openValue;
            Type targetType = this.getTargetType();
            if (targetType instanceof GenericArrayType) {
                componentType = ((GenericArrayType)targetType).getGenericComponentType();
            } else if (targetType instanceof Class && ((Class)targetType).isArray()) {
                componentType = ((Class)targetType).getComponentType();
            } else {
                throw new IllegalArgumentException("Not an array: " + targetType);
            }
            Object[] valueArray = (Object[])Array.newInstance(componentType, openArray.length);
            for (int i = 0; i < openArray.length; ++i) {
                valueArray[i] = this.elementConverter.fromOpenValue(lookup, openArray[i]);
            }
            return valueArray;
        }

        void checkReconstructible() throws InvalidObjectException {
            this.elementConverter.checkReconstructible();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EnumConverter<T extends Enum<T>>
    extends OpenConverter {
        private final Class<T> enumClass;

        EnumConverter(Class<T> enumClass) {
            super(enumClass, SimpleType.STRING, String.class);
            this.enumClass = enumClass;
        }

        @Override
        final Object toNonNullOpenValue(MXBeanLookup lookup, Object value) {
            return ((Enum)value).name();
        }

        @Override
        public final Object fromNonNullOpenValue(MXBeanLookup lookup, Object value) throws InvalidObjectException {
            try {
                return Enum.valueOf(this.enumClass, (String)value);
            }
            catch (Exception e) {
                throw EnumConverter.invalidObjectException("Cannot convert to enum: " + value, e);
            }
        }
    }

    private static final class IdentityConverter
    extends OpenConverter {
        IdentityConverter(Type targetType, OpenType openType, Class openClass) {
            super(targetType, openType, openClass);
        }

        boolean isIdentity() {
            return true;
        }

        final Object toNonNullOpenValue(MXBeanLookup lookup, Object value) {
            return value;
        }

        public final Object fromNonNullOpenValue(MXBeanLookup lookup, Object value) {
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConverterMap
    extends WeakHashMap<Type, WeakReference<OpenConverter>> {
        private ConverterMap() {
        }
    }
}

