/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.cosnaming;

import com.sun.jndi.cosnaming.CNBindingEnumeration;
import com.sun.jndi.cosnaming.CNNameParser;
import com.sun.jndi.cosnaming.CorbanameUrl;
import com.sun.jndi.cosnaming.ExceptionMapper;
import com.sun.jndi.cosnaming.IiopUrl;
import com.sun.jndi.cosnaming.OrbReuseTracker;
import com.sun.jndi.toolkit.corba.CorbaUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.CannotProceedException;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ResolveResult;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class CNCtx
implements Context {
    private static final boolean debug = false;
    ORB _orb;
    public NamingContext _nc;
    private NameComponent[] _name = null;
    Hashtable _env;
    static final CNNameParser parser = new CNNameParser();
    private static final String FED_PROP = "com.sun.jndi.cosnaming.federation";
    boolean federation = false;
    OrbReuseTracker orbTracker = null;
    int enumCount;
    boolean isCloseCalled = false;

    CNCtx(Hashtable env) throws NamingException {
        if (env != null) {
            env = (Hashtable)env.clone();
        }
        this._env = env;
        this.federation = "true".equals(env != null ? env.get(FED_PROP) : null);
        this.initOrbAndRootContext(env);
    }

    private CNCtx() {
    }

    public static ResolveResult createUsingURL(String url, Hashtable env) throws NamingException {
        CNCtx ctx = new CNCtx();
        if (env != null) {
            env = (Hashtable)env.clone();
        }
        ctx._env = env;
        String rest = ctx.initUsingUrl(env != null ? (ORB)env.get("java.naming.corba.orb") : null, url, env);
        return new ResolveResult((java.lang.Object)ctx, parser.parse(rest));
    }

    CNCtx(ORB orb, OrbReuseTracker tracker, NamingContext nctx, Hashtable env, NameComponent[] name) throws NamingException {
        if (orb == null || nctx == null) {
            throw new ConfigurationException("Must supply ORB or NamingContext");
        }
        this._orb = orb;
        this.orbTracker = tracker;
        if (this.orbTracker != null) {
            this.orbTracker.incRefCount();
        }
        this._nc = nctx;
        this._env = env;
        this._name = name;
        this.federation = "true".equals(env != null ? env.get(FED_PROP) : null);
    }

    NameComponent[] makeFullName(NameComponent[] child) {
        if (this._name == null || this._name.length == 0) {
            return child;
        }
        NameComponent[] answer = new NameComponent[this._name.length + child.length];
        System.arraycopy(this._name, 0, answer, 0, this._name.length);
        System.arraycopy(child, 0, answer, this._name.length, child.length);
        return answer;
    }

    public String getNameInNamespace() throws NamingException {
        if (this._name == null || this._name.length == 0) {
            return "";
        }
        return CNNameParser.cosNameToInsString(this._name);
    }

    private static boolean isCorbaUrl(String url) {
        return url.startsWith("iiop://") || url.startsWith("iiopname://") || url.startsWith("corbaname:");
    }

    private void initOrbAndRootContext(Hashtable env) throws NamingException {
        ORB inOrb = null;
        String ncIor = null;
        if (env != null) {
            inOrb = (ORB)env.get("java.naming.corba.orb");
        }
        String provUrl = null;
        if (env != null) {
            provUrl = (String)env.get("java.naming.provider.url");
        }
        if (provUrl != null && !CNCtx.isCorbaUrl(provUrl)) {
            ncIor = this.getStringifiedIor(provUrl);
            if (inOrb == null) {
                inOrb = CorbaUtils.getOrb(null, -1, env);
                this.orbTracker = new OrbReuseTracker(inOrb);
            }
            this.setOrbAndRootContext(inOrb, ncIor);
        } else if (provUrl != null) {
            String insName = this.initUsingUrl(inOrb, provUrl, env);
            if (insName.length() > 0) {
                this._name = CNNameParser.nameToCosName(parser.parse(insName));
                try {
                    Object obj = this._nc.resolve(this._name);
                    this._nc = NamingContextHelper.narrow(obj);
                    if (this._nc == null) {
                        throw new ConfigurationException(insName + " does not name a NamingContext");
                    }
                }
                catch (BAD_PARAM e) {
                    throw new ConfigurationException(insName + " does not name a NamingContext");
                }
                catch (Exception e) {
                    throw ExceptionMapper.mapException(e, this, this._name);
                }
            }
        } else {
            if (inOrb == null) {
                inOrb = CorbaUtils.getOrb(null, -1, env);
                this.orbTracker = new OrbReuseTracker(inOrb);
            }
            this.setOrbAndRootContext(inOrb, (String)null);
        }
    }

    private String initUsingUrl(ORB orb, String url, Hashtable env) throws NamingException {
        if (url.startsWith("iiop://") || url.startsWith("iiopname://")) {
            return this.initUsingIiopUrl(orb, url, env);
        }
        return this.initUsingCorbanameUrl(orb, url, env);
    }

    private String initUsingIiopUrl(ORB defOrb, String url, Hashtable env) throws NamingException {
        try {
            IiopUrl parsedUrl = new IiopUrl(url);
            Vector addrs = parsedUrl.getAddresses();
            NamingException savedException = null;
            for (int i = 0; i < addrs.size(); ++i) {
                IiopUrl.Address addr = (IiopUrl.Address)addrs.elementAt(i);
                try {
                    if (defOrb != null) {
                        try {
                            String tmpUrl = "corbaloc:iiop:" + addr.host + ":" + addr.port + "/NameService";
                            Object rootCtx = defOrb.string_to_object(tmpUrl);
                            this.setOrbAndRootContext(defOrb, rootCtx);
                            return parsedUrl.getStringName();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    ORB orb = CorbaUtils.getOrb(addr.host, addr.port, env);
                    this.orbTracker = new OrbReuseTracker(orb);
                    this.setOrbAndRootContext(orb, (String)null);
                    return parsedUrl.getStringName();
                }
                catch (NamingException ne) {
                    savedException = ne;
                    continue;
                }
            }
            if (savedException != null) {
                throw savedException;
            }
            throw new ConfigurationException("Problem with URL: " + url);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    private String initUsingCorbanameUrl(ORB orb, String url, Hashtable env) throws NamingException {
        try {
            CorbanameUrl parsedUrl = new CorbanameUrl(url);
            String corbaloc = parsedUrl.getLocation();
            String cosName = parsedUrl.getStringName();
            if (orb == null) {
                orb = CorbaUtils.getOrb(null, -1, env);
                this.orbTracker = new OrbReuseTracker(orb);
            }
            this.setOrbAndRootContext(orb, corbaloc);
            return parsedUrl.getStringName();
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    private void setOrbAndRootContext(ORB orb, String ncIor) throws NamingException {
        this._orb = orb;
        try {
            Object ncRef = ncIor != null ? this._orb.string_to_object(ncIor) : this._orb.resolve_initial_references("NameService");
            this._nc = NamingContextHelper.narrow(ncRef);
            if (this._nc == null) {
                if (ncIor != null) {
                    throw new ConfigurationException("Cannot convert IOR to a NamingContext: " + ncIor);
                }
                throw new ConfigurationException("ORB.resolve_initial_references(\"NameService\") does not return a NamingContext");
            }
        }
        catch (InvalidName in) {
            ConfigurationException ne = new ConfigurationException("COS Name Service not registered with ORB under the name 'NameService'");
            ne.setRootCause(in);
            throw ne;
        }
        catch (COMM_FAILURE e) {
            CommunicationException ne = new CommunicationException("Cannot connect to ORB");
            ne.setRootCause(e);
            throw ne;
        }
        catch (BAD_PARAM e) {
            ConfigurationException ne = new ConfigurationException("Invalid URL or IOR: " + ncIor);
            ne.setRootCause(e);
            throw ne;
        }
        catch (INV_OBJREF e) {
            ConfigurationException ne = new ConfigurationException("Invalid object reference: " + ncIor);
            ne.setRootCause(e);
            throw ne;
        }
    }

    private void setOrbAndRootContext(ORB orb, Object ncRef) throws NamingException {
        this._orb = orb;
        try {
            this._nc = NamingContextHelper.narrow(ncRef);
            if (this._nc == null) {
                throw new ConfigurationException("Cannot convert object reference to NamingContext: " + ncRef);
            }
        }
        catch (COMM_FAILURE e) {
            CommunicationException ne = new CommunicationException("Cannot connect to ORB");
            ne.setRootCause(e);
            throw ne;
        }
    }

    private String getStringifiedIor(String url) throws NamingException {
        if (url.startsWith("IOR:") || url.startsWith("corbaloc:")) {
            return url;
        }
        InputStream in = null;
        try {
            URL u = new URL(url);
            in = u.openStream();
            if (in != null) {
                String str;
                BufferedReader bufin = new BufferedReader(new InputStreamReader(in, "8859_1"));
                while ((str = bufin.readLine()) != null) {
                    if (!str.startsWith("IOR:")) continue;
                    String string = str;
                    return string;
                }
            }
        }
        catch (IOException e) {
            ConfigurationException ne = new ConfigurationException("Invalid URL: " + url);
            ne.setRootCause(e);
            throw ne;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                ConfigurationException ne = new ConfigurationException("Invalid URL: " + url);
                ne.setRootCause(e);
                throw ne;
            }
        }
        throw new ConfigurationException(url + " does not contain an IOR");
    }

    java.lang.Object callResolve(NameComponent[] path) throws NamingException {
        try {
            Object obj = this._nc.resolve(path);
            try {
                NamingContext nc = NamingContextHelper.narrow(obj);
                if (nc != null) {
                    return new CNCtx(this._orb, this.orbTracker, nc, this._env, this.makeFullName(path));
                }
                return obj;
            }
            catch (SystemException e) {
                return obj;
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.mapException(e, this, path);
        }
    }

    public java.lang.Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    public java.lang.Object lookup(Name name) throws NamingException {
        if (this._nc == null) {
            throw new ConfigurationException("Context does not have a corresponding NamingContext");
        }
        if (name.size() == 0) {
            return this;
        }
        NameComponent[] path = CNNameParser.nameToCosName(name);
        try {
            java.lang.Object answer = this.callResolve(path);
            try {
                return NamingManager.getObjectInstance(answer, name, this, this._env);
            }
            catch (NamingException e) {
                throw e;
            }
            catch (Exception e) {
                NamingException ne = new NamingException("problem generating object using object factory");
                ne.setRootCause(e);
                throw ne;
            }
        }
        catch (CannotProceedException cpe) {
            Context cctx = CNCtx.getContinuationContext(cpe);
            return cctx.lookup(cpe.getRemainingName());
        }
    }

    private void callBindOrRebind(NameComponent[] pth, Name name, java.lang.Object obj, boolean rebind) throws NamingException {
        block11: {
            if (this._nc == null) {
                throw new ConfigurationException("Context does not have a corresponding NamingContext");
            }
            try {
                obj = NamingManager.getStateToBind(obj, name, this, this._env);
                if (obj instanceof CNCtx) {
                    obj = ((CNCtx)obj)._nc;
                }
                if (obj instanceof NamingContext) {
                    NamingContext nobj = NamingContextHelper.narrow((Object)obj);
                    if (rebind) {
                        this._nc.rebind_context(pth, nobj);
                    } else {
                        this._nc.bind_context(pth, nobj);
                    }
                    break block11;
                }
                if (obj instanceof Object) {
                    if (rebind) {
                        this._nc.rebind(pth, (Object)obj);
                    } else {
                        this._nc.bind(pth, (Object)obj);
                    }
                    break block11;
                }
                throw new IllegalArgumentException("Only instances of org.omg.CORBA.Object can be bound");
            }
            catch (BAD_PARAM e) {
                NotContextException ne = new NotContextException(name.toString());
                ne.setRootCause(e);
                throw ne;
            }
            catch (Exception e) {
                throw ExceptionMapper.mapException(e, this, pth);
            }
        }
    }

    public void bind(Name name, java.lang.Object obj) throws NamingException {
        if (name.size() == 0) {
            throw new InvalidNameException("Name is empty");
        }
        NameComponent[] path = CNNameParser.nameToCosName(name);
        try {
            this.callBindOrRebind(path, name, obj, false);
        }
        catch (CannotProceedException e) {
            Context cctx = CNCtx.getContinuationContext(e);
            cctx.bind(e.getRemainingName(), obj);
        }
    }

    private static Context getContinuationContext(CannotProceedException cpe) throws NamingException {
        try {
            return NamingManager.getContinuationContext(cpe);
        }
        catch (CannotProceedException e) {
            Reference ref;
            RefAddr addr;
            java.lang.Object resObj = e.getResolvedObj();
            if (resObj instanceof Reference && (addr = (ref = (Reference)resObj).get("nns")).getContent() instanceof Context) {
                NameNotFoundException ne = new NameNotFoundException("No object reference bound for specified name");
                ne.setRootCause(cpe.getRootCause());
                ne.setRemainingName(cpe.getRemainingName());
                throw ne;
            }
            throw e;
        }
    }

    public void bind(String name, java.lang.Object obj) throws NamingException {
        this.bind(new CompositeName(name), obj);
    }

    public void rebind(Name name, java.lang.Object obj) throws NamingException {
        if (name.size() == 0) {
            throw new InvalidNameException("Name is empty");
        }
        NameComponent[] path = CNNameParser.nameToCosName(name);
        try {
            this.callBindOrRebind(path, name, obj, true);
        }
        catch (CannotProceedException e) {
            Context cctx = CNCtx.getContinuationContext(e);
            cctx.rebind(e.getRemainingName(), obj);
        }
    }

    public void rebind(String name, java.lang.Object obj) throws NamingException {
        this.rebind(new CompositeName(name), obj);
    }

    private void callUnbind(NameComponent[] path) throws NamingException {
        if (this._nc == null) {
            throw new ConfigurationException("Context does not have a corresponding NamingContext");
        }
        try {
            this._nc.unbind(path);
        }
        catch (NotFound e) {
            if (!this.leafNotFound(e, path[path.length - 1])) {
                throw ExceptionMapper.mapException(e, this, path);
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.mapException(e, this, path);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean leafNotFound(NotFound e, NameComponent leaf) {
        if (e.why.value() != 0) return false;
        if (e.rest_of_name.length != 1) return false;
        NameComponent rest = e.rest_of_name[0];
        if (!rest.id.equals(leaf.id)) return false;
        if (rest.kind == leaf.kind) return true;
        if (rest.kind == null) return false;
        if (!rest.kind.equals(leaf.kind)) return false;
        return true;
    }

    public void unbind(String name) throws NamingException {
        this.unbind(new CompositeName(name));
    }

    public void unbind(Name name) throws NamingException {
        if (name.size() == 0) {
            throw new InvalidNameException("Name is empty");
        }
        NameComponent[] path = CNNameParser.nameToCosName(name);
        try {
            this.callUnbind(path);
        }
        catch (CannotProceedException e) {
            Context cctx = CNCtx.getContinuationContext(e);
            cctx.unbind(e.getRemainingName());
        }
    }

    public void rename(String oldName, String newName) throws NamingException {
        this.rename(new CompositeName(oldName), new CompositeName(newName));
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        if (this._nc == null) {
            throw new ConfigurationException("Context does not have a corresponding NamingContext");
        }
        if (oldName.size() == 0 || newName.size() == 0) {
            throw new InvalidNameException("One or both names empty");
        }
        java.lang.Object obj = this.lookup(oldName);
        this.bind(newName, obj);
        this.unbind(oldName);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.listBindings(name);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(new CompositeName(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (this._nc == null) {
            throw new ConfigurationException("Context does not have a corresponding NamingContext");
        }
        if (name.size() > 0) {
            try {
                java.lang.Object obj = this.lookup(name);
                if (obj instanceof CNCtx) {
                    return new CNBindingEnumeration((CNCtx)obj, true, this._env);
                }
                throw new NotContextException(name.toString());
            }
            catch (NamingException ne) {
                throw ne;
            }
            catch (BAD_PARAM e) {
                NotContextException ne = new NotContextException(name.toString());
                ne.setRootCause(e);
                throw ne;
            }
        }
        return new CNBindingEnumeration(this, false, this._env);
    }

    private void callDestroy(NamingContext nc) throws NamingException {
        if (this._nc == null) {
            throw new ConfigurationException("Context does not have a corresponding NamingContext");
        }
        try {
            nc.destroy();
        }
        catch (Exception e) {
            throw ExceptionMapper.mapException(e, this, null);
        }
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(new CompositeName(name));
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (this._nc == null) {
            throw new ConfigurationException("Context does not have a corresponding NamingContext");
        }
        NamingContext the_nc = this._nc;
        NameComponent[] path = CNNameParser.nameToCosName(name);
        if (name.size() > 0) {
            try {
                Context ctx = (Context)this.callResolve(path);
                CNCtx cnc = (CNCtx)ctx;
                the_nc = cnc._nc;
                cnc.close();
            }
            catch (ClassCastException e) {
                throw new NotContextException(name.toString());
            }
            catch (CannotProceedException e) {
                Context cctx = CNCtx.getContinuationContext(e);
                cctx.destroySubcontext(e.getRemainingName());
                return;
            }
            catch (NameNotFoundException e) {
                if (e.getRootCause() instanceof NotFound && this.leafNotFound((NotFound)e.getRootCause(), path[path.length - 1])) {
                    return;
                }
                throw e;
            }
            catch (NamingException e) {
                throw e;
            }
        }
        this.callDestroy(the_nc);
        this.callUnbind(path);
    }

    private Context callBindNewContext(NameComponent[] path) throws NamingException {
        if (this._nc == null) {
            throw new ConfigurationException("Context does not have a corresponding NamingContext");
        }
        try {
            NamingContext nctx = this._nc.bind_new_context(path);
            return new CNCtx(this._orb, this.orbTracker, nctx, this._env, this.makeFullName(path));
        }
        catch (Exception e) {
            throw ExceptionMapper.mapException(e, this, path);
        }
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(new CompositeName(name));
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (name.size() == 0) {
            throw new InvalidNameException("Name is empty");
        }
        NameComponent[] path = CNNameParser.nameToCosName(name);
        try {
            return this.callBindNewContext(path);
        }
        catch (CannotProceedException e) {
            Context cctx = CNCtx.getContinuationContext(e);
            return cctx.createSubcontext(e.getRemainingName());
        }
    }

    public java.lang.Object lookupLink(String name) throws NamingException {
        return this.lookupLink(new CompositeName(name));
    }

    public java.lang.Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public NameParser getNameParser(String name) throws NamingException {
        return parser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return parser;
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this._env == null) {
            return new Hashtable(5, 0.75f);
        }
        return (Hashtable)this._env.clone();
    }

    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(new CompositeName(name), new CompositeName(prefix)).toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        return result.addAll(name);
    }

    public java.lang.Object addToEnvironment(String propName, java.lang.Object propValue) throws NamingException {
        this._env = this._env == null ? new Hashtable(7, 0.75f) : (Hashtable)this._env.clone();
        return this._env.put(propName, propValue);
    }

    public java.lang.Object removeFromEnvironment(String propName) throws NamingException {
        if (this._env != null && this._env.get(propName) != null) {
            this._env = (Hashtable)this._env.clone();
            return this._env.remove(propName);
        }
        return null;
    }

    public synchronized void incEnumCount() {
        if (this.orbTracker == null) {
            return;
        }
        ++this.enumCount;
    }

    public synchronized void decEnumCount() throws NamingException {
        if (this.orbTracker == null) {
            return;
        }
        --this.enumCount;
        if (this.enumCount == 0 && this.isCloseCalled) {
            this.close();
        }
    }

    public synchronized void close() throws NamingException {
        if (this.orbTracker == null) {
            return;
        }
        if (this.enumCount > 0) {
            this.isCloseCalled = true;
            return;
        }
        this.orbTracker.decRefCount();
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }
}

