/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapReferralContext;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.ReferralException;
import javax.naming.ldap.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LdapReferralException
extends javax.naming.ldap.LdapReferralException {
    private int handleReferrals;
    private Hashtable envprops;
    private String nextName;
    private Control[] reqCtls;
    private Vector referrals = null;
    private int referralIndex = 0;
    private int referralCount = 0;
    private boolean foundEntry = false;
    private boolean skipThisReferral = false;
    private int hopCount = 1;
    private NamingException errorEx = null;
    private String newRdn = null;
    private boolean debug = false;
    LdapReferralException nextReferralEx = null;

    LdapReferralException(Name resolvedName, Object resolvedObj, Name remainingName, String explanation, Hashtable envprops, String nextName, int handleReferrals, Control[] reqCtls) {
        super(explanation);
        if (this.debug) {
            System.out.println("LdapReferralException constructor");
        }
        this.setResolvedName(resolvedName);
        this.setResolvedObj(resolvedObj);
        this.setRemainingName(remainingName);
        this.envprops = envprops;
        this.nextName = nextName;
        this.handleReferrals = handleReferrals;
        this.reqCtls = handleReferrals == 1 ? reqCtls : null;
    }

    @Override
    public Context getReferralContext() throws NamingException {
        return this.getReferralContext(this.envprops, null);
    }

    @Override
    public Context getReferralContext(Hashtable<?, ?> newProps) throws NamingException {
        return this.getReferralContext(newProps, null);
    }

    @Override
    public Context getReferralContext(Hashtable<?, ?> newProps, Control[] connCtls) throws NamingException {
        if (this.debug) {
            System.out.println("LdapReferralException.getReferralContext");
        }
        LdapReferralContext refCtx = new LdapReferralContext(this, newProps, connCtls, this.reqCtls, this.nextName, this.skipThisReferral, this.handleReferrals);
        refCtx.setHopCount(this.hopCount + 1);
        if (this.skipThisReferral) {
            this.skipThisReferral = false;
        }
        return refCtx;
    }

    @Override
    public Object getReferralInfo() {
        if (this.debug) {
            System.out.println("LdapReferralException.getReferralInfo");
            System.out.println("  referralIndex=" + this.referralIndex);
        }
        if (this.hasMoreReferrals()) {
            return this.referrals.elementAt(this.referralIndex);
        }
        return null;
    }

    @Override
    public void retryReferral() {
        if (this.debug) {
            System.out.println("LdapReferralException.retryReferral");
        }
        if (this.referralIndex > 0) {
            --this.referralIndex;
        }
    }

    @Override
    public boolean skipReferral() {
        if (this.debug) {
            System.out.println("LdapReferralException.skipReferral");
        }
        this.skipThisReferral = true;
        try {
            this.getNextReferral();
        }
        catch (ReferralException referralException) {
            // empty catch block
        }
        return this.hasMoreReferrals() || this.hasMoreReferralExceptions();
    }

    void setReferralInfo(Vector referrals, boolean continuationRef) {
        if (this.debug) {
            System.out.println("LdapReferralException.setReferralInfo");
        }
        this.referrals = referrals;
        if (referrals != null) {
            this.referralCount = referrals.size();
        }
        if (this.debug) {
            for (int i = 0; i < this.referralCount; ++i) {
                System.out.println("  [" + i + "] " + referrals.elementAt(i));
            }
        }
    }

    String getNextReferral() throws ReferralException {
        if (this.debug) {
            System.out.println("LdapReferralException.getNextReferral");
        }
        if (this.hasMoreReferrals()) {
            return (String)this.referrals.elementAt(this.referralIndex++);
        }
        if (this.hasMoreReferralExceptions()) {
            throw this.nextReferralEx;
        }
        return null;
    }

    LdapReferralException appendUnprocessedReferrals(LdapReferralException back) {
        LdapReferralException front;
        if (this.debug) {
            System.out.println("LdapReferralException.appendUnprocessedReferrals");
            this.dump();
            if (back != null) {
                back.dump();
            }
        }
        if (!(front = this).hasMoreReferrals()) {
            front = this.nextReferralEx;
            if (this.errorEx != null && front != null) {
                front.setNamingException(this.errorEx);
            }
        }
        if (this == back) {
            return front;
        }
        if (back != null && !back.hasMoreReferrals()) {
            back = back.nextReferralEx;
        }
        if (back == null) {
            return front;
        }
        LdapReferralException ptr = front;
        while (ptr.nextReferralEx != null) {
            ptr = ptr.nextReferralEx;
        }
        ptr.nextReferralEx = back;
        return front;
    }

    boolean hasMoreReferrals() {
        if (this.debug) {
            System.out.println("LdapReferralException.hasMoreReferrals");
        }
        return !this.foundEntry && this.referralIndex < this.referralCount;
    }

    boolean hasMoreReferralExceptions() {
        if (this.debug) {
            System.out.println("LdapReferralException.hasMoreReferralExceptions");
        }
        return this.nextReferralEx != null;
    }

    void setHopCount(int hopCount) {
        if (this.debug) {
            System.out.println("LdapReferralException.setHopCount");
        }
        this.hopCount = hopCount;
    }

    void setNameResolved(boolean resolved) {
        if (this.debug) {
            System.out.println("LdapReferralException.setNameResolved");
        }
        this.foundEntry = resolved;
    }

    void setNamingException(NamingException e) {
        if (this.debug) {
            System.out.println("LdapReferralException.setNamingException");
        }
        if (this.errorEx == null) {
            e.setRootCause(this);
            this.errorEx = e;
        }
    }

    String getNewRdn() {
        if (this.debug) {
            System.out.println("LdapReferralException.getNewRdn");
        }
        return this.newRdn;
    }

    void setNewRdn(String newRdn) {
        if (this.debug) {
            System.out.println("LdapReferralException.setNewRdn");
        }
        this.newRdn = newRdn;
    }

    NamingException getNamingException() {
        if (this.debug) {
            System.out.println("LdapReferralException.getNamingException");
        }
        return this.errorEx;
    }

    void dump() {
        System.out.println();
        System.out.println("LdapReferralException.dump");
        LdapReferralException ptr = this;
        while (ptr != null) {
            ptr.dumpState();
            ptr = ptr.nextReferralEx;
        }
    }

    private void dumpState() {
        System.out.println("LdapReferralException.dumpState");
        System.out.println("  hashCode=" + this.hashCode());
        System.out.println("  foundEntry=" + this.foundEntry);
        System.out.println("  skipThisReferral=" + this.skipThisReferral);
        System.out.println("  referralIndex=" + this.referralIndex);
        if (this.referrals != null) {
            System.out.println("  referrals:");
            for (int i = 0; i < this.referralCount; ++i) {
                System.out.println("    [" + i + "] " + this.referrals.elementAt(i));
            }
        } else {
            System.out.println("  referrals=null");
        }
        System.out.println("  errorEx=" + this.errorEx);
        if (this.nextReferralEx == null) {
            System.out.println("  nextRefEx=null");
        } else {
            System.out.println("  nextRefEx=" + this.nextReferralEx.hashCode());
        }
        System.out.println();
    }
}

