/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.sasl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class SaslInputStream
extends InputStream {
    private static final boolean debug = false;
    private byte[] saslBuffer;
    private byte[] lenBuf = new byte[4];
    private byte[] buf = new byte[0];
    private int bufPos = 0;
    private InputStream in;
    private SaslClient sc;
    private int recvMaxBufSize = 65536;

    SaslInputStream(SaslClient sc, InputStream in) throws SaslException {
        this.in = in;
        this.sc = sc;
        String str = (String)sc.getNegotiatedProperty("javax.security.sasl.maxbuffer");
        if (str != null) {
            try {
                this.recvMaxBufSize = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                throw new SaslException("javax.security.sasl.maxbuffer property must be numeric string: " + str);
            }
        }
        this.saslBuffer = new byte[this.recvMaxBufSize];
    }

    public int read() throws IOException {
        byte[] inBuf = new byte[1];
        int count = this.read(inBuf, 0, 1);
        if (count > 0) {
            return inBuf[0];
        }
        return -1;
    }

    public int read(byte[] inBuf, int start, int count) throws IOException {
        int avail;
        if (this.bufPos >= this.buf.length) {
            int actual = this.fill();
            while (actual == 0) {
                actual = this.fill();
            }
            if (actual == -1) {
                return -1;
            }
        }
        if (count > (avail = this.buf.length - this.bufPos)) {
            System.arraycopy(this.buf, this.bufPos, inBuf, start, avail);
            this.bufPos = this.buf.length;
            return avail;
        }
        System.arraycopy(this.buf, this.bufPos, inBuf, start, count);
        this.bufPos += count;
        return count;
    }

    private int fill() throws IOException {
        int actual = this.readFully(this.lenBuf, 4);
        if (actual != 4) {
            return -1;
        }
        int len = SaslInputStream.networkByteOrderToInt(this.lenBuf, 0, 4);
        if (len > this.recvMaxBufSize) {
            throw new IOException(len + "exceeds the negotiated receive buffer size limit:" + this.recvMaxBufSize);
        }
        actual = this.readFully(this.saslBuffer, len);
        if (actual != len) {
            throw new EOFException("Expecting to read " + len + " bytes but got " + actual + " bytes before EOF");
        }
        this.buf = this.sc.unwrap(this.saslBuffer, 0, len);
        this.bufPos = 0;
        return this.buf.length;
    }

    private int readFully(byte[] inBuf, int total) throws IOException {
        int pos = 0;
        while (total > 0) {
            int count = this.in.read(inBuf, pos, total);
            if (count == -1) {
                return pos == 0 ? -1 : pos;
            }
            pos += count;
            total -= count;
        }
        return pos;
    }

    public int available() throws IOException {
        return this.buf.length - this.bufPos;
    }

    public void close() throws IOException {
        SaslException save = null;
        try {
            this.sc.dispose();
        }
        catch (SaslException e) {
            save = e;
        }
        this.in.close();
        if (save != null) {
            throw save;
        }
    }

    private static int networkByteOrderToInt(byte[] buf, int start, int count) {
        if (count > 4) {
            throw new IllegalArgumentException("Cannot handle more than 4 bytes");
        }
        int answer = 0;
        for (int i = 0; i < count; ++i) {
            answer <<= 8;
            answer |= buf[start + i] & 0xFF;
        }
        return answer;
    }
}

