/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.corba;

import java.applet.Applet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.ConfigurationException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class CorbaUtils {
    private static Method toStubMethod = null;
    private static Method connectMethod = null;
    private static Class corbaStubClass = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object remoteToCorba(Remote remoteObj, ORB orb) throws ClassNotFoundException, ConfigurationException {
        Class<CorbaUtils> clazz = CorbaUtils.class;
        synchronized (CorbaUtils.class) {
            java.lang.Object stub;
            if (toStubMethod == null) {
                CorbaUtils.initMethodHandles();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                stub = toStubMethod.invoke(null, remoteObj);
            }
            catch (InvocationTargetException e) {
                Throwable realException = e.getTargetException();
                ConfigurationException ce = new ConfigurationException("Problem with PortableRemoteObject.toStub(); object not exported or stub not found");
                ce.setRootCause(realException);
                throw ce;
            }
            catch (IllegalAccessException e) {
                ConfigurationException ce = new ConfigurationException("Cannot invoke javax.rmi.PortableRemoteObject.toStub(java.rmi.Remote)");
                ce.setRootCause(e);
                throw ce;
            }
            if (!corbaStubClass.isInstance(stub)) {
                return null;
            }
            try {
                connectMethod.invoke(stub, orb);
            }
            catch (InvocationTargetException e) {
                Throwable realException = e.getTargetException();
                if (!(realException instanceof RemoteException)) {
                    ConfigurationException ce = new ConfigurationException("Problem invoking javax.rmi.CORBA.Stub.connect()");
                    ce.setRootCause(realException);
                    throw ce;
                }
            }
            catch (IllegalAccessException e) {
                ConfigurationException ce = new ConfigurationException("Cannot invoke javax.rmi.CORBA.Stub.connect()");
                ce.setRootCause(e);
                throw ce;
            }
            return (Object)stub;
        }
    }

    public static ORB getOrb(String server, int port, Hashtable env) {
        Properties orbProp;
        if (env != null) {
            if (env instanceof Properties) {
                orbProp = (Properties)env.clone();
            } else {
                orbProp = new Properties();
                Enumeration envProp = env.keys();
                while (envProp.hasMoreElements()) {
                    String key = (String)envProp.nextElement();
                    java.lang.Object val = env.get(key);
                    if (!(val instanceof String)) continue;
                    orbProp.put(key, val);
                }
            }
        } else {
            orbProp = new Properties();
        }
        if (server != null) {
            orbProp.put("org.omg.CORBA.ORBInitialHost", server);
        }
        if (port >= 0) {
            orbProp.put("org.omg.CORBA.ORBInitialPort", "" + port);
        }
        Applet applet = null;
        if (env != null) {
            applet = (Applet)env.get("java.naming.applet");
        }
        if (applet != null) {
            return ORB.init(applet, orbProp);
        }
        return ORB.init(new String[0], orbProp);
    }

    private static void initMethodHandles() throws ClassNotFoundException {
        corbaStubClass = Class.forName("javax.rmi.CORBA.Stub");
        try {
            connectMethod = corbaStubClass.getMethod("connect", ORB.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No method definition for javax.rmi.CORBA.Stub.connect(org.omg.CORBA.ORB)");
        }
        Class<?> proClass = Class.forName("javax.rmi.PortableRemoteObject");
        try {
            toStubMethod = proClass.getMethod("toStub", Remote.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No method definition for javax.rmi.PortableRemoteObject.toStub(java.rmi.Remote)");
        }
    }
}

