/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.RSAKeyValue;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class RSAKeyValueResolver
extends KeyResolverSpi {
    static Logger log = Logger.getLogger(RSAKeyValueResolver.class.getName());
    private Element _rsaKeyElement = null;

    public boolean engineCanResolve(Element element, String BaseURI, StorageResolver storage) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Can I resolve " + element.getTagName());
        }
        if (element == null) {
            return false;
        }
        boolean isKeyValue = XMLUtils.elementIsInSignatureSpace(element, "KeyValue");
        boolean isRSAKeyValue = XMLUtils.elementIsInSignatureSpace(element, "RSAKeyValue");
        if (isKeyValue) {
            this._rsaKeyElement = XMLUtils.selectDsNode(element.getFirstChild(), "RSAKeyValue", 0);
            if (this._rsaKeyElement != null) {
                return true;
            }
        } else if (isRSAKeyValue) {
            this._rsaKeyElement = element;
            return true;
        }
        return false;
    }

    public PublicKey engineResolvePublicKey(Element element, String BaseURI, StorageResolver storage) {
        boolean weCanResolve;
        if (!(this._rsaKeyElement != null || (weCanResolve = this.engineCanResolve(element, BaseURI, storage)) && this._rsaKeyElement != null)) {
            return null;
        }
        try {
            RSAKeyValue rsaKeyValue = new RSAKeyValue(this._rsaKeyElement, BaseURI);
            return rsaKeyValue.getPublicKey();
        }
        catch (XMLSecurityException ex) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "XMLSecurityException", ex);
            }
            return null;
        }
    }

    public X509Certificate engineResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }

    public SecretKey engineResolveSecretKey(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }
}

