/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.RetrievalMethod;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.Transforms;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RetrievalMethodResolver
extends KeyResolverSpi {
    static Logger log = Logger.getLogger(RetrievalMethodResolver.class.getName());

    public boolean engineCanResolve(Element element, String BaseURI, StorageResolver storage) {
        return XMLUtils.elementIsInSignatureSpace(element, "RetrievalMethod");
    }

    public PublicKey engineResolvePublicKey(Element element, String BaseURI, StorageResolver storage) {
        block18: {
            try {
                RetrievalMethod rm = new RetrievalMethod(element, BaseURI);
                Attr uri = rm.getURIAttr();
                String type = rm.getType();
                Transforms transforms = rm.getTransforms();
                ResourceResolver resRes = ResourceResolver.getInstance(uri, BaseURI);
                if (resRes != null) {
                    XMLSignatureInput resource = resRes.resolve(uri, BaseURI);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Before applying Transforms, resource has " + resource.getBytes().length + "bytes");
                    }
                    if (transforms != null) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "We have Transforms");
                        }
                        resource = transforms.performTransforms(resource);
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "After applying Transforms, resource has " + resource.getBytes().length + "bytes");
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Resolved to resource " + resource.getSourceURI());
                    }
                    byte[] inputBytes = resource.getBytes();
                    if (type != null && type.equals("http://www.w3.org/2000/09/xmldsig#rawX509Certificate")) {
                        CertificateFactory certFact = CertificateFactory.getInstance("X.509");
                        X509Certificate cert = (X509Certificate)certFact.generateCertificate(new ByteArrayInputStream(inputBytes));
                        if (cert != null) {
                            return cert.getPublicKey();
                        }
                    } else {
                        KeyResolver newKeyResolver;
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "we have to parse " + inputBytes.length + " bytes");
                        }
                        Element e = this.getDocFromBytes(inputBytes);
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "Now we have a {" + e.getNamespaceURI() + "}" + e.getLocalName() + " Element");
                        }
                        if (e != null && (newKeyResolver = KeyResolver.getInstance(RetrievalMethodResolver.getFirstElementChild(e), BaseURI, storage)) != null) {
                            return newKeyResolver.resolvePublicKey(RetrievalMethodResolver.getFirstElementChild(e), BaseURI, storage);
                        }
                    }
                }
            }
            catch (XMLSecurityException ex) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "XMLSecurityException", ex);
                }
            }
            catch (CertificateException ex) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "CertificateException", ex);
                }
            }
            catch (IOException ex) {
                if (!log.isLoggable(Level.FINE)) break block18;
                log.log(Level.FINE, "IOException", ex);
            }
        }
        return null;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) {
        block19: {
            try {
                ResourceResolver resRes;
                RetrievalMethod rm = new RetrievalMethod(element, BaseURI);
                Attr uri = rm.getURIAttr();
                Transforms transforms = rm.getTransforms();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Asked to resolve URI " + uri);
                }
                if ((resRes = ResourceResolver.getInstance(uri, BaseURI)) != null) {
                    XMLSignatureInput resource = resRes.resolve(uri, BaseURI);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Before applying Transforms, resource has " + resource.getBytes().length + "bytes");
                    }
                    if (transforms != null) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "We have Transforms");
                        }
                        resource = transforms.performTransforms(resource);
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "After applying Transforms, resource has " + resource.getBytes().length + "bytes");
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Resolved to resource " + resource.getSourceURI());
                    }
                    byte[] inputBytes = resource.getBytes();
                    if (rm.getType() != null && rm.getType().equals("http://www.w3.org/2000/09/xmldsig#rawX509Certificate")) {
                        CertificateFactory certFact = CertificateFactory.getInstance("X.509");
                        X509Certificate cert = (X509Certificate)certFact.generateCertificate(new ByteArrayInputStream(inputBytes));
                        if (cert != null) {
                            return cert;
                        }
                    } else {
                        KeyResolver newKeyResolver;
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "we have to parse " + inputBytes.length + " bytes");
                        }
                        Element e = this.getDocFromBytes(inputBytes);
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "Now we have a {" + e.getNamespaceURI() + "}" + e.getLocalName() + " Element");
                        }
                        if (e != null && (newKeyResolver = KeyResolver.getInstance(RetrievalMethodResolver.getFirstElementChild(e), BaseURI, storage)) != null) {
                            return newKeyResolver.resolveX509Certificate(RetrievalMethodResolver.getFirstElementChild(e), BaseURI, storage);
                        }
                    }
                }
            }
            catch (XMLSecurityException ex) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "XMLSecurityException", ex);
                }
            }
            catch (CertificateException ex) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "CertificateException", ex);
                }
            }
            catch (IOException ex) {
                if (!log.isLoggable(Level.FINE)) break block19;
                log.log(Level.FINE, "IOException", ex);
            }
        }
        return null;
    }

    Element getDocFromBytes(byte[] bytes) throws KeyResolverException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(bytes));
            return doc.getDocumentElement();
        }
        catch (SAXException ex) {
            throw new KeyResolverException("empty", ex);
        }
        catch (IOException ex) {
            throw new KeyResolverException("empty", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new KeyResolverException("empty", ex);
        }
    }

    public SecretKey engineResolveSecretKey(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }

    static Element getFirstElementChild(Element e) {
        Node n;
        for (n = e.getFirstChild(); n != null && n.getNodeType() != 1; n = n.getNextSibling()) {
        }
        return (Element)n;
    }
}

