/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils.resolver.implementations;

import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.IdResolver;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ResolverFragment
extends ResourceResolverSpi {
    static Logger log = Logger.getLogger(ResolverFragment.class.getName());

    public XMLSignatureInput engineResolve(Attr uri, String BaseURI) throws ResourceResolverException {
        String uriNodeValue = uri.getNodeValue();
        Document doc = uri.getOwnerElement().getOwnerDocument();
        Node selectedElem = null;
        if (uriNodeValue.equals("")) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "ResolverFragment with empty URI (means complete document)");
            }
            selectedElem = doc;
        } else {
            String id = uriNodeValue.substring(1);
            selectedElem = IdResolver.getElementById(doc, id);
            if (selectedElem == null) {
                Object[] exArgs = new Object[]{id};
                throw new ResourceResolverException("signature.Verification.MissingID", exArgs, uri, BaseURI);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Try to catch an Element with ID " + id + " and Element was " + selectedElem);
            }
        }
        XMLSignatureInput result = new XMLSignatureInput(selectedElem);
        result.setExcludeComments(true);
        result.setMIMEType("text/xml");
        result.setSourceURI(BaseURI != null ? BaseURI.concat(uri.getNodeValue()) : uri.getNodeValue());
        return result;
    }

    public boolean engineCanResolve(Attr uri, String BaseURI) {
        if (uri == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Quick fail for null uri");
            }
            return false;
        }
        String uriNodeValue = uri.getNodeValue();
        if (uriNodeValue.equals("") || uriNodeValue.charAt(0) == '#' && !uriNodeValue.startsWith("#xpointer(")) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "State I can resolve reference: \"" + uriNodeValue + "\"");
            }
            return true;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Do not seem to be able to resolve reference: \"" + uriNodeValue + "\"");
        }
        return false;
    }
}

