/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventDispatchThread;
import java.awt.EventQueueItem;
import java.awt.MenuComponent;
import java.awt.Queue;
import java.awt.Rectangle;
import java.awt.SentEvent;
import java.awt.SequencedEvent;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.PaintEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.ComponentPeer;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EmptyStackException;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.AWTAutoShutdown;
import sun.awt.AppContext;
import sun.awt.PeerEvent;
import sun.awt.SunToolkit;
import sun.misc.JavaSecurityAccess;
import sun.misc.SharedSecrets;

public class EventQueue {
    private static int threadInitNumber;
    private static final int LOW_PRIORITY = 0;
    private static final int NORM_PRIORITY = 1;
    private static final int HIGH_PRIORITY = 2;
    private static final int ULTIMATE_PRIORITY = 3;
    private static final int NUM_PRIORITIES = 4;
    private Queue[] queues = new Queue[4];
    private EventQueue nextQueue;
    private EventQueue previousQueue;
    private EventDispatchThread dispatchThread;
    private final ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
    private final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private long mostRecentEventTime = System.currentTimeMillis();
    private WeakReference currentEvent;
    private int waitForID;
    private final String name = "AWT-EventQueue-" + EventQueue.nextThreadNum();
    private static final Logger eventLog;
    private static final int PAINT = 0;
    private static final int UPDATE = 1;
    private static final int MOVE = 2;
    private static final int DRAG = 3;
    private static final int PEER = 4;
    private static final int CACHE_LENGTH = 5;
    private static final JavaSecurityAccess javaSecurityAccess;

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    public EventQueue() {
        for (int i = 0; i < 4; ++i) {
            this.queues[i] = new Queue();
        }
    }

    public void postEvent(AWTEvent theEvent) {
        SunToolkit.flushPendingEvents();
        this.postEventPrivate(theEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void postEventPrivate(AWTEvent theEvent) {
        theEvent.isPosted = true;
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            if (this.dispatchThread == null && this.nextQueue == null) {
                if (theEvent.getSource() == AWTAutoShutdown.getInstance()) {
                    return;
                }
                this.initDispatchThread();
            }
            if (this.nextQueue != null) {
                this.nextQueue.postEventPrivate(theEvent);
                return;
            }
            this.postEvent(theEvent, EventQueue.getPriority(theEvent));
        }
    }

    private static int getPriority(AWTEvent theEvent) {
        if (theEvent instanceof PeerEvent && (((PeerEvent)theEvent).getFlags() & 2L) != 0L) {
            return 3;
        }
        if (theEvent instanceof PeerEvent && (((PeerEvent)theEvent).getFlags() & 1L) != 0L) {
            return 2;
        }
        if (theEvent instanceof PeerEvent && (((PeerEvent)theEvent).getFlags() & 4L) != 0L) {
            return 0;
        }
        int id = theEvent.getID();
        if (id == 800 || id == 801) {
            return 0;
        }
        return 1;
    }

    private void postEvent(AWTEvent theEvent, int priority) {
        boolean notifyID;
        if (this.coalesceEvent(theEvent, priority)) {
            return;
        }
        EventQueueItem newItem = new EventQueueItem(theEvent);
        this.cacheEQItem(newItem);
        boolean bl = notifyID = theEvent.getID() == this.waitForID;
        if (this.queues[priority].head == null) {
            boolean shouldNotify = this.noEvents();
            this.queues[priority].head = this.queues[priority].tail = newItem;
            if (shouldNotify) {
                if (theEvent.getSource() != AWTAutoShutdown.getInstance()) {
                    AWTAutoShutdown.getInstance().notifyThreadBusy(this.dispatchThread);
                }
                this.notifyAll();
            } else if (notifyID) {
                this.notifyAll();
            }
        } else {
            this.queues[priority].tail.next = newItem;
            this.queues[priority].tail = newItem;
            if (notifyID) {
                this.notifyAll();
            }
        }
    }

    private boolean coalescePaintEvent(PaintEvent e) {
        PaintEvent merged;
        EventQueueItem[] cache;
        ComponentPeer sourcePeer = ((Component)e.getSource()).peer;
        if (sourcePeer != null) {
            sourcePeer.coalescePaintEvent(e);
        }
        if ((cache = ((Component)e.getSource()).eventCache) == null) {
            return false;
        }
        int index = EventQueue.eventToCacheIndex(e);
        if (index != -1 && cache[index] != null && (merged = this.mergePaintEvents(e, (PaintEvent)cache[index].event)) != null) {
            cache[index].event = merged;
            return true;
        }
        return false;
    }

    private PaintEvent mergePaintEvents(PaintEvent a, PaintEvent b) {
        Rectangle aRect = a.getUpdateRect();
        Rectangle bRect = b.getUpdateRect();
        if (bRect.contains(aRect)) {
            return b;
        }
        if (aRect.contains(bRect)) {
            return a;
        }
        return null;
    }

    private boolean coalesceMouseEvent(MouseEvent e) {
        EventQueueItem[] cache = ((Component)e.getSource()).eventCache;
        if (cache == null) {
            return false;
        }
        int index = EventQueue.eventToCacheIndex(e);
        if (index != -1 && cache[index] != null) {
            cache[index].event = e;
            return true;
        }
        return false;
    }

    private boolean coalescePeerEvent(PeerEvent e) {
        EventQueueItem[] cache = ((Component)e.getSource()).eventCache;
        if (cache == null) {
            return false;
        }
        int index = EventQueue.eventToCacheIndex(e);
        if (index != -1 && cache[index] != null) {
            if ((e = e.coalesceEvents((PeerEvent)cache[index].event)) != null) {
                cache[index].event = e;
                return true;
            }
            cache[index] = null;
        }
        return false;
    }

    private boolean coalesceOtherEvent(AWTEvent e, int priority) {
        int id = e.getID();
        Component source = (Component)e.getSource();
        EventQueueItem entry = this.queues[priority].head;
        while (entry != null) {
            AWTEvent coalescedEvent;
            if (entry.event.getSource() == source && entry.id == id && (coalescedEvent = source.coalesceEvents(entry.event, e)) != null) {
                entry.event = coalescedEvent;
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    private boolean coalesceEvent(AWTEvent e, int priority) {
        if (!(e.getSource() instanceof Component)) {
            return false;
        }
        if (e instanceof PeerEvent) {
            return this.coalescePeerEvent((PeerEvent)e);
        }
        if (((Component)e.getSource()).isCoalescingEnabled() && this.coalesceOtherEvent(e, priority)) {
            return true;
        }
        if (e instanceof PaintEvent) {
            return this.coalescePaintEvent((PaintEvent)e);
        }
        if (e instanceof MouseEvent) {
            return this.coalesceMouseEvent((MouseEvent)e);
        }
        return false;
    }

    private void cacheEQItem(EventQueueItem entry) {
        int index = EventQueue.eventToCacheIndex(entry.event);
        if (index != -1 && entry.event.getSource() instanceof Component) {
            Component source = (Component)entry.event.getSource();
            if (source.eventCache == null) {
                source.eventCache = new EventQueueItem[5];
            }
            source.eventCache[index] = entry;
        }
    }

    private void uncacheEQItem(EventQueueItem entry) {
        int index = EventQueue.eventToCacheIndex(entry.event);
        if (index != -1 && entry.event.getSource() instanceof Component) {
            Component source = (Component)entry.event.getSource();
            if (source.eventCache == null) {
                return;
            }
            source.eventCache[index] = null;
        }
    }

    private static int eventToCacheIndex(AWTEvent e) {
        switch (e.getID()) {
            case 800: {
                return 0;
            }
            case 801: {
                return 1;
            }
            case 503: {
                return 2;
            }
            case 506: {
                return 3;
            }
        }
        return e instanceof PeerEvent ? 4 : -1;
    }

    private boolean noEvents() {
        for (int i = 0; i < 4; ++i) {
            if (this.queues[i].head == null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AWTEvent getNextEvent() throws InterruptedException {
        while (true) {
            SunToolkit.flushPendingEvents();
            EventQueue eventQueue = this;
            synchronized (eventQueue) {
                for (int i = 3; i >= 0; --i) {
                    if (this.queues[i].head == null) continue;
                    EventQueueItem entry = this.queues[i].head;
                    this.queues[i].head = entry.next;
                    if (entry.next == null) {
                        this.queues[i].tail = null;
                    }
                    this.uncacheEQItem(entry);
                    return entry.event;
                }
                AWTAutoShutdown.getInstance().notifyThreadFree(this.dispatchThread);
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AWTEvent getNextEvent(int id) throws InterruptedException {
        while (true) {
            SunToolkit.flushPendingEvents();
            EventQueue eventQueue = this;
            synchronized (eventQueue) {
                for (int i = 0; i < 4; ++i) {
                    EventQueueItem entry = this.queues[i].head;
                    EventQueueItem prev = null;
                    while (entry != null) {
                        if (entry.id == id) {
                            if (prev == null) {
                                this.queues[i].head = entry.next;
                            } else {
                                prev.next = entry.next;
                            }
                            if (this.queues[i].tail == entry) {
                                this.queues[i].tail = prev;
                            }
                            this.uncacheEQItem(entry);
                            return entry.event;
                        }
                        prev = entry;
                        entry = entry.next;
                    }
                }
                this.waitForID = id;
                this.wait();
                this.waitForID = 0;
            }
        }
    }

    public synchronized AWTEvent peekEvent() {
        for (int i = 3; i >= 0; --i) {
            if (this.queues[i].head == null) continue;
            return this.queues[i].head.event;
        }
        return null;
    }

    public synchronized AWTEvent peekEvent(int id) {
        for (int i = 3; i >= 0; --i) {
            EventQueueItem q = this.queues[i].head;
            while (q != null) {
                if (q.id == id) {
                    return q.event;
                }
                q = q.next;
            }
        }
        return null;
    }

    protected void dispatchEvent(final AWTEvent event) {
        final Object src = event.getSource();
        final PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                EventQueue.this.dispatchEventImpl(event, src);
                return null;
            }
        };
        AccessControlContext stack = AccessController.getContext();
        AccessControlContext srcAcc = EventQueue.getAccessControlContextFrom(src);
        final AccessControlContext eventAcc = event.getAccessControlContext();
        if (srcAcc == null) {
            javaSecurityAccess.doIntersectionPrivilege(action, stack, eventAcc);
        } else {
            javaSecurityAccess.doIntersectionPrivilege(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    javaSecurityAccess.doIntersectionPrivilege(action, eventAcc);
                    return null;
                }
            }, stack, srcAcc);
        }
    }

    private static AccessControlContext getAccessControlContextFrom(Object src) {
        return src instanceof Component ? ((Component)src).getAccessControlContext() : (src instanceof MenuComponent ? ((MenuComponent)src).getAccessControlContext() : (src instanceof TrayIcon ? ((TrayIcon)src).getAccessControlContext() : null));
    }

    private void dispatchEventImpl(AWTEvent event, Object src) {
        event.isPosted = true;
        if (event instanceof ActiveEvent) {
            this.setCurrentEventAndMostRecentTimeImpl(event);
            ((ActiveEvent)((Object)event)).dispatch();
        } else if (src instanceof Component) {
            ((Component)src).dispatchEvent(event);
            event.dispatched();
        } else if (src instanceof MenuComponent) {
            ((MenuComponent)src).dispatchEvent(event);
        } else if (src instanceof TrayIcon) {
            ((TrayIcon)src).dispatchEvent(event);
        } else if (src instanceof AWTAutoShutdown) {
            if (this.noEvents()) {
                this.dispatchThread.stopDispatching();
            }
        } else {
            System.err.println("unable to dispatch event: " + event);
        }
    }

    public static long getMostRecentEventTime() {
        return Toolkit.getEventQueue().getMostRecentEventTimeImpl();
    }

    private synchronized long getMostRecentEventTimeImpl() {
        return Thread.currentThread() == this.dispatchThread ? this.mostRecentEventTime : System.currentTimeMillis();
    }

    synchronized long getMostRecentEventTimeEx() {
        return this.mostRecentEventTime;
    }

    public static AWTEvent getCurrentEvent() {
        return Toolkit.getEventQueue().getCurrentEventImpl();
    }

    private synchronized AWTEvent getCurrentEventImpl() {
        return Thread.currentThread() == this.dispatchThread ? (AWTEvent)this.currentEvent.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void push(EventQueue newEventQueue) {
        if (eventLog.isLoggable(Level.FINE)) {
            eventLog.log(Level.FINE, "EventQueue.push(" + newEventQueue + ")");
        }
        if (this.nextQueue != null) {
            this.nextQueue.push(newEventQueue);
            return;
        }
        EventQueue eventQueue = newEventQueue;
        synchronized (eventQueue) {
            while (this.peekEvent() != null) {
                try {
                    newEventQueue.postEventPrivate(this.getNextEvent());
                }
                catch (InterruptedException ie) {
                    if (!eventLog.isLoggable(Level.FINE)) continue;
                    eventLog.log(Level.FINE, "Interrupted push", ie);
                }
            }
            newEventQueue.previousQueue = this;
        }
        if (this.dispatchThread != null) {
            this.dispatchThread.stopDispatchingLater();
        }
        this.nextQueue = newEventQueue;
        AppContext appContext = AppContext.getAppContext();
        if (appContext.get(AppContext.EVENT_QUEUE_KEY) == this) {
            appContext.put(AppContext.EVENT_QUEUE_KEY, newEventQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pop() throws EmptyStackException {
        EventQueue prev;
        if (eventLog.isLoggable(Level.FINE)) {
            eventLog.log(Level.FINE, "EventQueue.pop(" + this + ")");
        }
        EventQueue eventQueue = (prev = this.previousQueue) != null ? prev : this;
        synchronized (eventQueue) {
            EventQueue eventQueue2 = this;
            synchronized (eventQueue2) {
                if (this.nextQueue != null) {
                    this.nextQueue.pop();
                    return;
                }
                if (this.previousQueue == null) {
                    throw new EmptyStackException();
                }
                this.previousQueue.nextQueue = null;
                while (this.peekEvent() != null) {
                    try {
                        this.previousQueue.postEventPrivate(this.getNextEvent());
                    }
                    catch (InterruptedException ie) {
                        if (!eventLog.isLoggable(Level.FINE)) continue;
                        eventLog.log(Level.FINE, "Interrupted pop", ie);
                    }
                }
                AppContext appContext = AppContext.getAppContext();
                if (appContext.get(AppContext.EVENT_QUEUE_KEY) == this) {
                    appContext.put(AppContext.EVENT_QUEUE_KEY, this.previousQueue);
                }
                this.previousQueue = null;
            }
        }
        EventDispatchThread dt = this.dispatchThread;
        if (dt != null) {
            dt.stopDispatching();
        }
    }

    public static boolean isDispatchThread() {
        EventQueue eq = Toolkit.getEventQueue();
        EventQueue next = eq.nextQueue;
        while (next != null) {
            eq = next;
            next = eq.nextQueue;
        }
        return Thread.currentThread() == eq.dispatchThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void initDispatchThread() {
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            if (this.dispatchThread == null && !this.threadGroup.isDestroyed()) {
                this.dispatchThread = (EventDispatchThread)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        EventDispatchThread t = new EventDispatchThread(EventQueue.this.threadGroup, EventQueue.this.name, EventQueue.this);
                        t.setContextClassLoader(EventQueue.this.classLoader);
                        t.setPriority(6);
                        t.setDaemon(false);
                        return t;
                    }
                });
                AWTAutoShutdown.getInstance().notifyThreadBusy(this.dispatchThread);
                this.dispatchThread.start();
            }
        }
    }

    final void detachDispatchThread() {
        this.dispatchThread = null;
    }

    final EventDispatchThread getDispatchThread() {
        return this.dispatchThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeSourceEvents(Object source, boolean removeAllEvents) {
        SunToolkit.flushPendingEvents();
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            for (int i = 0; i < 4; ++i) {
                EventQueueItem entry = this.queues[i].head;
                EventQueueItem prev = null;
                while (entry != null) {
                    if (!(entry.event.getSource() != source || !removeAllEvents && (entry.event instanceof SequencedEvent || entry.event instanceof SentEvent || entry.event instanceof FocusEvent || entry.event instanceof WindowEvent || entry.event instanceof KeyEvent || entry.event instanceof InputMethodEvent))) {
                        if (entry.event instanceof SequencedEvent) {
                            ((SequencedEvent)entry.event).dispose();
                        }
                        if (entry.event instanceof SentEvent) {
                            ((SentEvent)entry.event).dispose();
                        }
                        if (prev == null) {
                            this.queues[i].head = entry.next;
                        } else {
                            prev.next = entry.next;
                        }
                        this.uncacheEQItem(entry);
                    } else {
                        prev = entry;
                    }
                    entry = entry.next;
                }
                this.queues[i].tail = prev;
            }
        }
    }

    static void setCurrentEventAndMostRecentTime(AWTEvent e) {
        Toolkit.getEventQueue().setCurrentEventAndMostRecentTimeImpl(e);
    }

    private synchronized void setCurrentEventAndMostRecentTimeImpl(AWTEvent e) {
        if (Thread.currentThread() != this.dispatchThread) {
            return;
        }
        this.currentEvent = new WeakReference<AWTEvent>(e);
        long mostRecentEventTime2 = Long.MIN_VALUE;
        if (e instanceof InputEvent) {
            InputEvent ie = (InputEvent)e;
            mostRecentEventTime2 = ie.getWhen();
        } else if (e instanceof InputMethodEvent) {
            InputMethodEvent ime = (InputMethodEvent)e;
            mostRecentEventTime2 = ime.getWhen();
        } else if (e instanceof ActionEvent) {
            ActionEvent ae = (ActionEvent)e;
            mostRecentEventTime2 = ae.getWhen();
        } else if (e instanceof InvocationEvent) {
            InvocationEvent ie = (InvocationEvent)e;
            mostRecentEventTime2 = ie.getWhen();
        }
        this.mostRecentEventTime = Math.max(this.mostRecentEventTime, mostRecentEventTime2);
    }

    public static void invokeLater(Runnable runnable) {
        Toolkit.getEventQueue().postEvent(new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            throw new Error("Cannot call invokeAndWait from the event dispatcher thread");
        }
        class AWTInvocationLock {
            AWTInvocationLock() {
            }
        }
        AWTInvocationLock lock = new AWTInvocationLock();
        InvocationEvent event = new InvocationEvent(Toolkit.getDefaultToolkit(), runnable, lock, true);
        AWTInvocationLock aWTInvocationLock = lock;
        synchronized (aWTInvocationLock) {
            Toolkit.getEventQueue().postEvent(event);
            lock.wait();
        }
        Throwable eventThrowable = event.getThrowable();
        if (eventThrowable != null) {
            throw new InvocationTargetException(eventThrowable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeup(boolean isShutdown) {
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            if (this.nextQueue != null) {
                this.nextQueue.wakeup(isShutdown);
            } else if (this.dispatchThread != null) {
                this.notifyAll();
            } else if (!isShutdown) {
                this.initDispatchThread();
            }
        }
    }

    static {
        eventLog = Logger.getLogger("java.awt.event.EventQueue");
        javaSecurityAccess = SharedSecrets.getJavaSecurityAccess();
    }
}

