/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.peer.FileDialogPeer;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;

public class FileDialog
extends Dialog {
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    int mode;
    String dir;
    String file;
    FilenameFilter filter;
    private static final String base = "filedlg";
    private static int nameCounter = 0;
    private static final long serialVersionUID = 5035145889651310422L;

    private static native void initIDs();

    public FileDialog(Frame parent) {
        this(parent, "", 0);
    }

    public FileDialog(Frame parent, String title) {
        this(parent, title, 0);
    }

    public FileDialog(Frame parent, String title, int mode) {
        super(parent, title, true);
        this.setMode(mode);
        this.setLayout(null);
    }

    public FileDialog(Dialog parent) {
        this(parent, "", 0);
    }

    public FileDialog(Dialog parent, String title) {
        this(parent, title, 0);
    }

    public FileDialog(Dialog parent, String title, int mode) {
        super(parent, title, true);
        this.setMode(mode);
        this.setLayout(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String constructComponentName() {
        Class<FileDialog> clazz = FileDialog.class;
        synchronized (FileDialog.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.parent != null && this.parent.getPeer() == null) {
                this.parent.addNotify();
            }
            if (this.peer == null) {
                this.peer = this.getToolkit().createFileDialog(this);
            }
            super.addNotify();
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        switch (mode) {
            case 0: 
            case 1: {
                this.mode = mode;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal file dialog mode");
            }
        }
    }

    public String getDirectory() {
        return this.dir;
    }

    public void setDirectory(String dir) {
        this.dir = dir != null && dir.equals("") ? null : dir;
        FileDialogPeer peer = (FileDialogPeer)this.peer;
        if (peer != null) {
            peer.setDirectory(this.dir);
        }
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file != null && file.equals("") ? null : file;
        FileDialogPeer peer = (FileDialogPeer)this.peer;
        if (peer != null) {
            peer.setFile(this.file);
        }
    }

    public FilenameFilter getFilenameFilter() {
        return this.filter;
    }

    public synchronized void setFilenameFilter(FilenameFilter filter) {
        this.filter = filter;
        FileDialogPeer peer = (FileDialogPeer)this.peer;
        if (peer != null) {
            peer.setFilenameFilter(filter);
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.dir != null && this.dir.equals("")) {
            this.dir = null;
        }
        if (this.file != null && this.file.equals("")) {
            this.file = null;
        }
    }

    protected String paramString() {
        String str = super.paramString();
        str = str + ",dir= " + this.dir;
        str = str + ",file= " + this.file;
        return str + (this.mode == 0 ? ",load" : ",save");
    }

    boolean postsOldMouseEvents() {
        return false;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            FileDialog.initIDs();
        }
    }
}

