/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.peer.LabelPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class Label
extends Component
implements Accessible {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    String text;
    int alignment = 0;
    private static final String base = "label";
    private static int nameCounter;
    private static final long serialVersionUID = 3094126758329070636L;

    public Label() throws HeadlessException {
        this("", 0);
    }

    public Label(String text) throws HeadlessException {
        this(text, 0);
    }

    public Label(String text, int alignment) throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.text = text;
        this.setAlignment(alignment);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException, HeadlessException {
        GraphicsEnvironment.checkHeadless();
        s.defaultReadObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String constructComponentName() {
        Class<Label> clazz = Label.class;
        synchronized (Label.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createLabel(this);
            }
            super.addNotify();
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    public synchronized void setAlignment(int alignment) {
        switch (alignment) {
            case 0: 
            case 1: 
            case 2: {
                this.alignment = alignment;
                LabelPeer peer = (LabelPeer)this.peer;
                if (peer != null) {
                    peer.setAlignment(alignment);
                }
                return;
            }
        }
        throw new IllegalArgumentException("improper alignment: " + alignment);
    }

    public String getText() {
        return this.text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String text) {
        boolean testvalid = false;
        Label label = this;
        synchronized (label) {
            if (!(text == this.text || this.text != null && this.text.equals(text))) {
                this.text = text;
                LabelPeer peer = (LabelPeer)this.peer;
                if (peer != null) {
                    peer.setText(text);
                }
                testvalid = true;
            }
        }
        if (testvalid) {
            this.invalidateIfValid();
        }
    }

    protected String paramString() {
        String str = ",align=";
        switch (this.alignment) {
            case 0: {
                str = str + "left";
                break;
            }
            case 1: {
                str = str + "center";
                break;
            }
            case 2: {
                str = str + "right";
            }
        }
        return super.paramString() + str + ",text=" + this.text;
    }

    private static native void initIDs();

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTLabel();
        }
        return this.accessibleContext;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Label.initIDs();
        }
        nameCounter = 0;
    }

    protected class AccessibleAWTLabel
    extends Component.AccessibleAWTComponent {
        private static final long serialVersionUID = -3568967560160480438L;

        public AccessibleAWTLabel() {
            super(Label.this);
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (Label.this.getText() == null) {
                return super.getAccessibleName();
            }
            return Label.this.getText();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }
    }
}

