/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;
import sun.java2d.StateTrackable;

public final class DataBufferUShort
extends DataBuffer {
    short[] data;
    short[][] bankdata;

    public DataBufferUShort(int size) {
        super(StateTrackable.State.STABLE, 1, size);
        this.data = new short[size];
        this.bankdata = new short[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferUShort(int size, int numBanks) {
        super(StateTrackable.State.STABLE, 1, size, numBanks);
        this.bankdata = new short[numBanks][];
        for (int i = 0; i < numBanks; ++i) {
            this.bankdata[i] = new short[size];
        }
        this.data = this.bankdata[0];
    }

    public DataBufferUShort(short[] dataArray, int size) {
        super(StateTrackable.State.UNTRACKABLE, 1, size);
        if (dataArray == null) {
            throw new NullPointerException("dataArray is null");
        }
        this.data = dataArray;
        this.bankdata = new short[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferUShort(short[] dataArray, int size, int offset) {
        super(StateTrackable.State.UNTRACKABLE, 1, size, 1, offset);
        if (dataArray == null) {
            throw new NullPointerException("dataArray is null");
        }
        if (size + offset > dataArray.length) {
            throw new IllegalArgumentException("Length of dataArray is less  than size+offset.");
        }
        this.data = dataArray;
        this.bankdata = new short[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferUShort(short[][] dataArray, int size) {
        super(StateTrackable.State.UNTRACKABLE, 1, size, dataArray.length);
        if (dataArray == null) {
            throw new NullPointerException("dataArray is null");
        }
        for (int i = 0; i < dataArray.length; ++i) {
            if (dataArray[i] != null) continue;
            throw new NullPointerException("dataArray[" + i + "] is null");
        }
        this.bankdata = (short[][])dataArray.clone();
        this.data = this.bankdata[0];
    }

    public DataBufferUShort(short[][] dataArray, int size, int[] offsets) {
        super(StateTrackable.State.UNTRACKABLE, 1, size, dataArray.length, offsets);
        if (dataArray == null) {
            throw new NullPointerException("dataArray is null");
        }
        for (int i = 0; i < dataArray.length; ++i) {
            if (dataArray[i] == null) {
                throw new NullPointerException("dataArray[" + i + "] is null");
            }
            if (size + offsets[i] <= dataArray[i].length) continue;
            throw new IllegalArgumentException("Length of dataArray[" + i + "] is less than size+" + "offsets[" + i + "].");
        }
        this.bankdata = (short[][])dataArray.clone();
        this.data = this.bankdata[0];
    }

    public short[] getData() {
        this.theTrackable.setUntrackable();
        return this.data;
    }

    public short[] getData(int bank) {
        this.theTrackable.setUntrackable();
        return this.bankdata[bank];
    }

    public short[][] getBankData() {
        this.theTrackable.setUntrackable();
        return (short[][])this.bankdata.clone();
    }

    public int getElem(int i) {
        return this.data[i + this.offset] & 0xFFFF;
    }

    public int getElem(int bank, int i) {
        return this.bankdata[bank][i + this.offsets[bank]] & 0xFFFF;
    }

    public void setElem(int i, int val) {
        this.data[i + this.offset] = (short)(val & 0xFFFF);
        this.theTrackable.markDirty();
    }

    public void setElem(int bank, int i, int val) {
        this.bankdata[bank][i + this.offsets[bank]] = (short)(val & 0xFFFF);
        this.theTrackable.markDirty();
    }
}

