/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import sun.net.www.ParseUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Package
implements AnnotatedElement {
    private static Map pkgs = new HashMap(31);
    private static Map urls = new HashMap(10);
    private static Map mans = new HashMap(10);
    private final String pkgName;
    private final String specTitle;
    private final String specVersion;
    private final String specVendor;
    private final String implTitle;
    private final String implVersion;
    private final String implVendor;
    private final URL sealBase;
    private final transient ClassLoader loader;
    private transient Class packageInfo;

    public String getName() {
        return this.pkgName;
    }

    public String getSpecificationTitle() {
        return this.specTitle;
    }

    public String getSpecificationVersion() {
        return this.specVersion;
    }

    public String getSpecificationVendor() {
        return this.specVendor;
    }

    public String getImplementationTitle() {
        return this.implTitle;
    }

    public String getImplementationVersion() {
        return this.implVersion;
    }

    public String getImplementationVendor() {
        return this.implVendor;
    }

    public boolean isSealed() {
        return this.sealBase != null;
    }

    public boolean isSealed(URL url) {
        return url.equals(this.sealBase);
    }

    public boolean isCompatibleWith(String desired) throws NumberFormatException {
        if (this.specVersion == null || this.specVersion.length() < 1) {
            throw new NumberFormatException("Empty version string");
        }
        String[] sa = this.specVersion.split("\\.", -1);
        int[] si = new int[sa.length];
        for (int i = 0; i < sa.length; ++i) {
            si[i] = Integer.parseInt(sa[i]);
            if (si[i] >= 0) continue;
            throw NumberFormatException.forInputString("" + si[i]);
        }
        String[] da = desired.split("\\.", -1);
        int[] di = new int[da.length];
        for (int i = 0; i < da.length; ++i) {
            di[i] = Integer.parseInt(da[i]);
            if (di[i] >= 0) continue;
            throw NumberFormatException.forInputString("" + di[i]);
        }
        int len = Math.max(di.length, si.length);
        for (int i = 0; i < len; ++i) {
            int s;
            int d = i < di.length ? di[i] : 0;
            int n = s = i < si.length ? si[i] : 0;
            if (s < d) {
                return false;
            }
            if (s <= d) continue;
            return true;
        }
        return true;
    }

    public static Package getPackage(String name) {
        ClassLoader l = ClassLoader.getCallerClassLoader();
        if (l != null) {
            return l.getPackage(name);
        }
        return Package.getSystemPackage(name);
    }

    public static Package[] getPackages() {
        ClassLoader l = ClassLoader.getCallerClassLoader();
        if (l != null) {
            return l.getPackages();
        }
        return Package.getSystemPackages();
    }

    static Package getPackage(Class c) {
        String name = c.getName();
        int i = name.lastIndexOf(46);
        if (i != -1) {
            name = name.substring(0, i);
            ClassLoader cl = c.getClassLoader();
            if (cl != null) {
                return cl.getPackage(name);
            }
            return Package.getSystemPackage(name);
        }
        return null;
    }

    public int hashCode() {
        return this.pkgName.hashCode();
    }

    public String toString() {
        String spec = this.specTitle;
        String ver = this.specVersion;
        spec = spec != null && spec.length() > 0 ? ", " + spec : "";
        ver = ver != null && ver.length() > 0 ? ", version " + ver : "";
        return "package " + this.pkgName + spec + ver;
    }

    private Class<?> getPackageInfo() {
        if (this.packageInfo == null) {
            try {
                this.packageInfo = Class.forName(this.pkgName + ".package-info", false, this.loader);
            }
            catch (ClassNotFoundException ex) {
                class PackageInfoProxy {
                    PackageInfoProxy() {
                    }
                }
                this.packageInfo = PackageInfoProxy.class;
            }
        }
        return this.packageInfo;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return this.getPackageInfo().getAnnotation(annotationClass);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getPackageInfo().isAnnotationPresent(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getPackageInfo().getAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getPackageInfo().getDeclaredAnnotations();
    }

    Package(String name, String spectitle, String specversion, String specvendor, String impltitle, String implversion, String implvendor, URL sealbase, ClassLoader loader) {
        this.pkgName = name;
        this.implTitle = impltitle;
        this.implVersion = implversion;
        this.implVendor = implvendor;
        this.specTitle = spectitle;
        this.specVersion = specversion;
        this.specVendor = specvendor;
        this.sealBase = sealbase;
        this.loader = loader;
    }

    private Package(String name, Manifest man, URL url, ClassLoader loader) {
        String path = name.replace('.', '/').concat("/");
        String sealed = null;
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        URL sealBase = null;
        Attributes attr = man.getAttributes(path);
        if (attr != null) {
            specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if ((attr = man.getMainAttributes()) != null) {
            if (specTitle == null) {
                specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (specVersion == null) {
                specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (specVendor == null) {
                specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (implTitle == null) {
                implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (implVersion == null) {
                implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (implVendor == null) {
                implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (sealed == null) {
                sealed = attr.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(sealed)) {
            sealBase = url;
        }
        this.pkgName = name;
        this.specTitle = specTitle;
        this.specVersion = specVersion;
        this.specVendor = specVendor;
        this.implTitle = implTitle;
        this.implVersion = implVersion;
        this.implVendor = implVendor;
        this.sealBase = sealBase;
        this.loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Package getSystemPackage(String name) {
        Map map = pkgs;
        synchronized (map) {
            String fn;
            Package pkg = (Package)pkgs.get(name);
            if (pkg == null && (fn = Package.getSystemPackage0(name = name.replace('.', '/').concat("/"))) != null) {
                pkg = Package.defineSystemPackage(name, fn);
            }
            return pkg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Package[] getSystemPackages() {
        String[] names = Package.getSystemPackages0();
        Map map = pkgs;
        synchronized (map) {
            for (int i = 0; i < names.length; ++i) {
                Package.defineSystemPackage(names[i], Package.getSystemPackage0(names[i]));
            }
            return pkgs.values().toArray(new Package[pkgs.size()]);
        }
    }

    private static Package defineSystemPackage(final String iname, final String fn) {
        return (Package)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String name = iname;
                URL url = (URL)urls.get(fn);
                if (url == null) {
                    File file = new File(fn);
                    try {
                        url = ParseUtil.fileToEncodedURL(file);
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                    if (url != null) {
                        urls.put(fn, url);
                        if (file.isFile()) {
                            mans.put(fn, Package.loadManifest(fn));
                        }
                    }
                }
                name = name.substring(0, name.length() - 1).replace('/', '.');
                Manifest man = (Manifest)mans.get(fn);
                Package pkg = man != null ? new Package(name, man, url, null) : new Package(name, null, null, null, null, null, null, null, null);
                pkgs.put(name, pkg);
                return pkg;
            }
        });
    }

    private static Manifest loadManifest(String fn) {
        try {
            FileInputStream fis = new FileInputStream(fn);
            JarInputStream jis = new JarInputStream((InputStream)fis, false);
            Manifest man = jis.getManifest();
            jis.close();
            return man;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static native String getSystemPackage0(String var0);

    private static native String[] getSystemPackages0();
}

