/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class StackTraceElement
implements Serializable {
    private String declaringClass;
    private String methodName;
    private String fileName;
    private int lineNumber;
    private static final long serialVersionUID = 6992337162326171013L;

    public StackTraceElement(String declaringClass, String methodName, String fileName, int lineNumber) {
        if (declaringClass == null) {
            throw new NullPointerException("Declaring class is null");
        }
        if (methodName == null) {
            throw new NullPointerException("Method name is null");
        }
        this.declaringClass = declaringClass;
        this.methodName = methodName;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getClassName() {
        return this.declaringClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isNativeMethod() {
        return this.lineNumber == -2;
    }

    public String toString() {
        return this.getClassName() + "." + this.methodName + (this.isNativeMethod() ? "(Native Method)" : (this.fileName != null && this.lineNumber >= 0 ? "(" + this.fileName + ":" + this.lineNumber + ")" : (this.fileName != null ? "(" + this.fileName + ")" : "(Unknown Source)")));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StackTraceElement)) {
            return false;
        }
        StackTraceElement e = (StackTraceElement)obj;
        return e.declaringClass.equals(this.declaringClass) && e.lineNumber == this.lineNumber && StackTraceElement.eq(this.methodName, e.methodName) && StackTraceElement.eq(this.fileName, e.fileName);
    }

    private static boolean eq(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public int hashCode() {
        int result = 31 * this.declaringClass.hashCode() + this.methodName.hashCode();
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        result = 31 * result + this.lineNumber;
        return result;
    }
}

