/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Console;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.channels.Channel;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;
import sun.misc.VM;
import sun.misc.Version;
import sun.net.InetAddressCachePolicy;
import sun.nio.ch.Interruptible;
import sun.reflect.ConstantPool;
import sun.reflect.Reflection;
import sun.reflect.annotation.AnnotationType;
import sun.security.util.SecurityConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class System {
    public static final InputStream in;
    public static final PrintStream out;
    public static final PrintStream err;
    private static volatile SecurityManager security;
    private static volatile Console cons;
    private static Properties props;

    private static native void registerNatives();

    private System() {
    }

    public static void setIn(InputStream in) {
        System.checkIO();
        System.setIn0(in);
    }

    public static void setOut(PrintStream out) {
        System.checkIO();
        System.setOut0(out);
    }

    public static void setErr(PrintStream err) {
        System.checkIO();
        System.setErr0(err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Console console() {
        if (cons != null) return cons;
        Class<System> clazz = System.class;
        synchronized (System.class) {
            cons = SharedSecrets.getJavaIOAccess().console();
            // ** MonitorExit[var0] (shouldn't be in output)
            return cons;
        }
    }

    public static Channel inheritedChannel() throws IOException {
        return SelectorProvider.provider().inheritedChannel();
    }

    private static void checkIO() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setIO"));
        }
    }

    private static native void setIn0(InputStream var0);

    private static native void setOut0(PrintStream var0);

    private static native void setErr0(PrintStream var0);

    public static void setSecurityManager(SecurityManager s) {
        try {
            s.checkPackageAccess("java.lang");
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.setSecurityManager0(s);
    }

    private static synchronized void setSecurityManager0(final SecurityManager s) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setSecurityManager"));
        }
        if (s != null && s.getClass().getClassLoader() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    s.getClass().getProtectionDomain().implies(SecurityConstants.ALL_PERMISSION);
                    return null;
                }
            });
        }
        security = s;
        InetAddressCachePolicy.setIfNotSet(-1);
    }

    public static SecurityManager getSecurityManager() {
        return security;
    }

    public static native long currentTimeMillis();

    public static native long nanoTime();

    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    public static native int identityHashCode(Object var0);

    private static native Properties initProperties(Properties var0);

    public static Properties getProperties() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertiesAccess();
        }
        return props;
    }

    public static void setProperties(Properties props) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertiesAccess();
        }
        if (props == null) {
            props = new Properties();
            System.initProperties(props);
        }
        System.props = props;
    }

    public static String getProperty(String key) {
        System.checkKey(key);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertyAccess(key);
        }
        return props.getProperty(key);
    }

    public static String getProperty(String key, String def) {
        System.checkKey(key);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertyAccess(key);
        }
        return props.getProperty(key, def);
    }

    public static String setProperty(String key, String value) {
        System.checkKey(key);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission(key, "write"));
        }
        return (String)props.setProperty(key, value);
    }

    public static String clearProperty(String key) {
        System.checkKey(key);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission(key, "write"));
        }
        return (String)props.remove(key);
    }

    private static void checkKey(String key) {
        if (key == null) {
            throw new NullPointerException("key can't be null");
        }
        if (key.equals("")) {
            throw new IllegalArgumentException("key can't be empty");
        }
    }

    public static String getenv(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getenv." + name));
        }
        return ProcessEnvironment.getenv(name);
    }

    public static Map<String, String> getenv() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getenv.*"));
        }
        return ProcessEnvironment.getenv();
    }

    public static void exit(int status) {
        Runtime.getRuntime().exit(status);
    }

    public static void gc() {
        Runtime.getRuntime().gc();
    }

    public static void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }

    @Deprecated
    public static void runFinalizersOnExit(boolean value) {
        Runtime.getRuntime();
        Runtime.runFinalizersOnExit(value);
    }

    public static void load(String filename) {
        Runtime.getRuntime().load0(System.getCallerClass(), filename);
    }

    public static void loadLibrary(String libname) {
        Runtime.getRuntime().loadLibrary0(System.getCallerClass(), libname);
    }

    public static native String mapLibraryName(String var0);

    private static void initializeSystemClass() {
        props = new Properties();
        System.initProperties(props);
        Version.init();
        FileInputStream fdIn = new FileInputStream(FileDescriptor.in);
        FileOutputStream fdOut = new FileOutputStream(FileDescriptor.out);
        FileOutputStream fdErr = new FileOutputStream(FileDescriptor.err);
        System.setIn0(new BufferedInputStream(fdIn));
        System.setOut0(new PrintStream(new BufferedOutputStream(fdOut, 128), true));
        System.setErr0(new PrintStream(new BufferedOutputStream(fdErr, 128), true));
        System.loadLibrary("zip");
        Terminator.setup();
        Shutdown.add(SharedSecrets.getJavaIOAccess().consoleRestoreHook());
        Shutdown.add(ApplicationShutdownHooks.hook());
        Shutdown.add(SharedSecrets.getJavaIODeleteOnExitAccess());
        VM.initializeOSEnvironment();
        VM.maxDirectMemory();
        VM.allowArraySyntax();
        VM.booted();
        Thread current = Thread.currentThread();
        current.getThreadGroup().add(current);
        SharedSecrets.setJavaLangAccess(new JavaLangAccess(){

            @Override
            public ConstantPool getConstantPool(Class klass) {
                return klass.getConstantPool();
            }

            @Override
            public void setAnnotationType(Class klass, AnnotationType type) {
                klass.setAnnotationType(type);
            }

            @Override
            public AnnotationType getAnnotationType(Class klass) {
                return klass.getAnnotationType();
            }

            @Override
            public <E extends Enum<E>> E[] getEnumConstantsShared(Class<E> klass) {
                return (Enum[])klass.getEnumConstantsShared();
            }

            @Override
            public void blockedOn(Thread t, Interruptible b) {
                t.blockedOn(b);
            }
        });
    }

    static Class getCallerClass() {
        return Reflection.getCallerClass(3);
    }

    static {
        System.registerNatives();
        in = null;
        out = null;
        err = null;
        security = null;
        cons = null;
    }
}

