/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.SocketException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import sun.security.action.LoadLibraryAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NetworkInterface {
    private String name;
    private String displayName;
    private int index;
    private InetAddress[] addrs;
    private InterfaceAddress[] bindings;
    private NetworkInterface[] childs;
    private NetworkInterface parent = null;
    private boolean virtual = false;

    NetworkInterface() {
    }

    NetworkInterface(String name, int index, InetAddress[] addrs) {
        this.name = name;
        this.index = index;
        this.addrs = addrs;
    }

    public String getName() {
        return this.name;
    }

    public Enumeration<InetAddress> getInetAddresses() {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class CheckedAddresses
        implements Enumeration<InetAddress> {
            private int i = 0;
            private int count = 0;
            private InetAddress[] local_addrs;

            CheckedAddresses() {
                this.local_addrs = new InetAddress[NetworkInterface.this.addrs.length];
                SecurityManager sec = System.getSecurityManager();
                for (int j = 0; j < NetworkInterface.this.addrs.length; ++j) {
                    try {
                        if (sec != null) {
                            sec.checkConnect(NetworkInterface.this.addrs[j].getHostAddress(), -1);
                        }
                        this.local_addrs[this.count++] = NetworkInterface.this.addrs[j];
                        continue;
                    }
                    catch (SecurityException e) {
                        // empty catch block
                    }
                }
            }

            @Override
            public InetAddress nextElement() {
                if (this.i < this.count) {
                    return this.local_addrs[this.i++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasMoreElements() {
                return this.i < this.count;
            }
        }
        return new CheckedAddresses();
    }

    public List<InterfaceAddress> getInterfaceAddresses() {
        ArrayList<InterfaceAddress> lst = new ArrayList<InterfaceAddress>(1);
        SecurityManager sec = System.getSecurityManager();
        for (int j = 0; j < this.bindings.length; ++j) {
            try {
                if (sec != null) {
                    sec.checkConnect(this.bindings[j].getAddress().getHostAddress(), -1);
                }
                lst.add(this.bindings[j]);
                continue;
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        return lst;
    }

    public Enumeration<NetworkInterface> getSubInterfaces() {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class SubIFs
        implements Enumeration<NetworkInterface> {
            private int i = 0;

            SubIFs() {
            }

            @Override
            public NetworkInterface nextElement() {
                if (this.i < NetworkInterface.this.childs.length) {
                    return NetworkInterface.this.childs[this.i++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasMoreElements() {
                return this.i < NetworkInterface.this.childs.length;
            }
        }
        return new SubIFs();
    }

    public NetworkInterface getParent() {
        return this.parent;
    }

    int getIndex() {
        return this.index;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static NetworkInterface getByName(String name) throws SocketException {
        if (name == null) {
            throw new NullPointerException();
        }
        return NetworkInterface.getByName0(name);
    }

    static native NetworkInterface getByIndex(int var0) throws SocketException;

    public static NetworkInterface getByInetAddress(InetAddress addr) throws SocketException {
        if (addr == null) {
            throw new NullPointerException();
        }
        if (!(addr instanceof Inet4Address) && !(addr instanceof Inet6Address)) {
            throw new IllegalArgumentException("invalid address type");
        }
        return NetworkInterface.getByInetAddress0(addr);
    }

    public static Enumeration<NetworkInterface> getNetworkInterfaces() throws SocketException {
        final NetworkInterface[] netifs = NetworkInterface.getAll();
        if (netifs == null) {
            return null;
        }
        return new Enumeration<NetworkInterface>(){
            private int i = 0;

            @Override
            public NetworkInterface nextElement() {
                if (netifs != null && this.i < netifs.length) {
                    NetworkInterface netif = netifs[this.i++];
                    return netif;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasMoreElements() {
                return netifs != null && this.i < netifs.length;
            }
        };
    }

    private static native NetworkInterface[] getAll() throws SocketException;

    private static native NetworkInterface getByName0(String var0) throws SocketException;

    private static native NetworkInterface getByInetAddress0(InetAddress var0) throws SocketException;

    public boolean isUp() throws SocketException {
        return NetworkInterface.isUp0(this.name, this.index);
    }

    public boolean isLoopback() throws SocketException {
        return NetworkInterface.isLoopback0(this.name, this.index);
    }

    public boolean isPointToPoint() throws SocketException {
        return NetworkInterface.isP2P0(this.name, this.index);
    }

    public boolean supportsMulticast() throws SocketException {
        return NetworkInterface.supportsMulticast0(this.name, this.index);
    }

    public byte[] getHardwareAddress() throws SocketException {
        if (!this.getInetAddresses().hasMoreElements()) {
            return null;
        }
        for (InetAddress addr : this.addrs) {
            if (!(addr instanceof Inet4Address)) continue;
            return NetworkInterface.getMacAddr0(((Inet4Address)addr).getAddress(), this.name, this.index);
        }
        return NetworkInterface.getMacAddr0(null, this.name, this.index);
    }

    public int getMTU() throws SocketException {
        return NetworkInterface.getMTU0(this.name, this.index);
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    private static native long getSubnet0(String var0, int var1) throws SocketException;

    private static native Inet4Address getBroadcast0(String var0, int var1) throws SocketException;

    private static native boolean isUp0(String var0, int var1) throws SocketException;

    private static native boolean isLoopback0(String var0, int var1) throws SocketException;

    private static native boolean supportsMulticast0(String var0, int var1) throws SocketException;

    private static native boolean isP2P0(String var0, int var1) throws SocketException;

    private static native byte[] getMacAddr0(byte[] var0, String var1, int var2) throws SocketException;

    private static native int getMTU0(String var0, int var1) throws SocketException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface netIF = (NetworkInterface)obj;
        if (this.name != null) {
            if (netIF.getName() == null) return false;
            if (!this.name.equals(netIF.getName())) {
                return false;
            }
        } else if (netIF.getName() != null) {
            return false;
        }
        Enumeration<InetAddress> newAddrs = netIF.getInetAddresses();
        int i = 0;
        i = 0;
        while (newAddrs.hasMoreElements()) {
            newAddrs.nextElement();
            ++i;
        }
        if (this.addrs == null) {
            if (i != 0) {
                return false;
            }
        } else {
            int count = 0;
            Enumeration<InetAddress> e = this.getInetAddresses();
            while (e.hasMoreElements()) {
                e.nextElement();
                ++count;
            }
            if (i != count) {
                return false;
            }
        }
        newAddrs = netIF.getInetAddresses();
        while (newAddrs.hasMoreElements()) {
            boolean equal = false;
            Enumeration<InetAddress> thisAddrs = this.getInetAddresses();
            InetAddress newAddr = newAddrs.nextElement();
            while (thisAddrs.hasMoreElements()) {
                InetAddress thisAddr = thisAddrs.nextElement();
                if (!thisAddr.equals(newAddr)) continue;
                equal = true;
            }
            if (equal) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int count = this.name == null ? 0 : this.name.hashCode();
        Enumeration<InetAddress> addrs = this.getInetAddresses();
        while (addrs.hasMoreElements()) {
            count += addrs.nextElement().hashCode();
        }
        return count;
    }

    public String toString() {
        String result = "name:";
        result = result + (this.name == null ? "null" : this.name);
        if (this.displayName != null) {
            result = result + " (" + this.displayName + ")";
        }
        return result;
    }

    private static native void init();

    static {
        AccessController.doPrivileged(new LoadLibraryAction("javanet"));
        NetworkInterface.init();
    }
}

