/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.net.SocketPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

final class SocketPermissionCollection
extends PermissionCollection
implements Serializable {
    private transient List perms = new ArrayList();
    private static final long serialVersionUID = 2787186408602843674L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", Vector.class)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Permission permission) {
        if (!(permission instanceof SocketPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        SocketPermissionCollection socketPermissionCollection = this;
        synchronized (socketPermissionCollection) {
            this.perms.add(0, permission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(Permission permission) {
        if (!(permission instanceof SocketPermission)) {
            return false;
        }
        SocketPermission np = (SocketPermission)permission;
        int desired = np.getMask();
        int effective = 0;
        int needed = desired;
        SocketPermissionCollection socketPermissionCollection = this;
        synchronized (socketPermissionCollection) {
            int len = this.perms.size();
            for (int i = 0; i < len; ++i) {
                SocketPermission x = (SocketPermission)this.perms.get(i);
                if ((needed & x.getMask()) == 0 || !x.impliesIgnoreMask(np)) continue;
                if (((effective |= x.getMask()) & desired) == desired) {
                    return true;
                }
                needed = desired ^ effective;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration elements() {
        SocketPermissionCollection socketPermissionCollection = this;
        synchronized (socketPermissionCollection) {
            return Collections.enumeration(this.perms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        Vector permissions = new Vector(this.perms.size());
        SocketPermissionCollection socketPermissionCollection = this;
        synchronized (socketPermissionCollection) {
            permissions.addAll(this.perms);
        }
        ObjectOutputStream.PutField pfields = out.putFields();
        pfields.put("permissions", permissions);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gfields = in.readFields();
        Vector permissions = (Vector)gfields.get("permissions", null);
        this.perms = new ArrayList(permissions.size());
        this.perms.addAll(permissions);
    }
}

