/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteBufferAsLongBufferL;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;

class ByteBufferAsLongBufferRL
extends ByteBufferAsLongBufferL {
    ByteBufferAsLongBufferRL(ByteBuffer bb) {
        super(bb);
    }

    ByteBufferAsLongBufferRL(ByteBuffer bb, int mark, int pos, int lim, int cap, int off) {
        super(bb, mark, pos, lim, cap, off);
    }

    public LongBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = (pos << 3) + this.offset;
        assert (off >= 0);
        return new ByteBufferAsLongBufferRL(this.bb, -1, 0, rem, rem, off);
    }

    public LongBuffer duplicate() {
        return new ByteBufferAsLongBufferRL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    public LongBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    public LongBuffer put(long x) {
        throw new ReadOnlyBufferException();
    }

    public LongBuffer put(int i, long x) {
        throw new ReadOnlyBufferException();
    }

    public LongBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    public boolean isDirect() {
        return this.bb.isDirect();
    }

    public boolean isReadOnly() {
        return true;
    }

    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

