/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapShortBufferR;
import java.nio.ShortBuffer;

class HeapShortBuffer
extends ShortBuffer {
    HeapShortBuffer(int cap, int lim) {
        super(-1, 0, lim, cap, new short[cap], 0);
    }

    HeapShortBuffer(short[] buf, int off, int len) {
        super(-1, off, off + len, buf.length, buf, 0);
    }

    protected HeapShortBuffer(short[] buf, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap, buf, off);
    }

    public ShortBuffer slice() {
        return new HeapShortBuffer(this.hb, -1, 0, this.remaining(), this.remaining(), this.position() + this.offset);
    }

    public ShortBuffer duplicate() {
        return new HeapShortBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    public ShortBuffer asReadOnlyBuffer() {
        return new HeapShortBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int i) {
        return i + this.offset;
    }

    public short get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    public short get(int i) {
        return this.hb[this.ix(this.checkIndex(i))];
    }

    public ShortBuffer get(short[] dst, int offset, int length) {
        HeapShortBuffer.checkBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(this.position()), dst, offset, length);
        this.position(this.position() + length);
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public ShortBuffer put(short x) {
        this.hb[this.ix((int)this.nextPutIndex())] = x;
        return this;
    }

    public ShortBuffer put(int i, short x) {
        this.hb[this.ix((int)this.checkIndex((int)i))] = x;
        return this;
    }

    public ShortBuffer put(short[] src, int offset, int length) {
        HeapShortBuffer.checkBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, offset, this.hb, this.ix(this.position()), length);
        this.position(this.position() + length);
        return this;
    }

    public ShortBuffer put(ShortBuffer src) {
        if (src instanceof HeapShortBuffer) {
            if (src == this) {
                throw new IllegalArgumentException();
            }
            HeapShortBuffer sb = (HeapShortBuffer)src;
            int n = sb.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            System.arraycopy(sb.hb, sb.ix(sb.position()), this.hb, this.ix(this.position()), n);
            sb.position(sb.position() + n);
            this.position(this.position() + n);
        } else if (src.isDirect()) {
            int n = src.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            src.get(this.hb, this.ix(this.position()), n);
            this.position(this.position() + n);
        } else {
            super.put(src);
        }
        return this;
    }

    public ShortBuffer compact() {
        System.arraycopy(this.hb, this.ix(this.position()), this.hb, this.ix(0), this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

