/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.text.BreakDictionary;
import java.text.CharacterIterator;
import java.text.RuleBasedBreakIterator;
import java.util.Stack;
import java.util.Vector;

class DictionaryBasedBreakIterator
extends RuleBasedBreakIterator {
    private BreakDictionary dictionary;
    private boolean[] categoryFlags;
    private int dictionaryCharCount;
    private int[] cachedBreakPositions;
    private int positionInCache;

    public DictionaryBasedBreakIterator(String dataFile, String dictionaryFile) throws IOException {
        super(dataFile);
        byte[] tmp = super.getAdditionalData();
        if (tmp != null) {
            this.prepareCategoryFlags(tmp);
            super.setAdditionalData(null);
        }
        this.dictionary = new BreakDictionary(dictionaryFile);
    }

    private void prepareCategoryFlags(byte[] data) {
        this.categoryFlags = new boolean[data.length];
        for (int i = 0; i < data.length; ++i) {
            this.categoryFlags[i] = data[i] == 1;
        }
    }

    public void setText(CharacterIterator newText) {
        super.setText(newText);
        this.cachedBreakPositions = null;
        this.dictionaryCharCount = 0;
        this.positionInCache = 0;
    }

    public int first() {
        this.cachedBreakPositions = null;
        this.dictionaryCharCount = 0;
        this.positionInCache = 0;
        return super.first();
    }

    public int last() {
        this.cachedBreakPositions = null;
        this.dictionaryCharCount = 0;
        this.positionInCache = 0;
        return super.last();
    }

    public int previous() {
        CharacterIterator text = this.getText();
        if (this.cachedBreakPositions != null && this.positionInCache > 0) {
            --this.positionInCache;
            text.setIndex(this.cachedBreakPositions[this.positionInCache]);
            return this.cachedBreakPositions[this.positionInCache];
        }
        this.cachedBreakPositions = null;
        int result = super.previous();
        if (this.cachedBreakPositions != null) {
            this.positionInCache = this.cachedBreakPositions.length - 2;
        }
        return result;
    }

    public int preceding(int offset) {
        CharacterIterator text = this.getText();
        DictionaryBasedBreakIterator.checkOffset(offset, text);
        if (this.cachedBreakPositions == null || offset <= this.cachedBreakPositions[0] || offset > this.cachedBreakPositions[this.cachedBreakPositions.length - 1]) {
            this.cachedBreakPositions = null;
            return super.preceding(offset);
        }
        this.positionInCache = 0;
        while (this.positionInCache < this.cachedBreakPositions.length && offset > this.cachedBreakPositions[this.positionInCache]) {
            ++this.positionInCache;
        }
        --this.positionInCache;
        text.setIndex(this.cachedBreakPositions[this.positionInCache]);
        return text.getIndex();
    }

    public int following(int offset) {
        CharacterIterator text = this.getText();
        DictionaryBasedBreakIterator.checkOffset(offset, text);
        if (this.cachedBreakPositions == null || offset < this.cachedBreakPositions[0] || offset >= this.cachedBreakPositions[this.cachedBreakPositions.length - 1]) {
            this.cachedBreakPositions = null;
            return super.following(offset);
        }
        this.positionInCache = 0;
        while (this.positionInCache < this.cachedBreakPositions.length && offset >= this.cachedBreakPositions[this.positionInCache]) {
            ++this.positionInCache;
        }
        text.setIndex(this.cachedBreakPositions[this.positionInCache]);
        return text.getIndex();
    }

    protected int handleNext() {
        CharacterIterator text = this.getText();
        if (this.cachedBreakPositions == null || this.positionInCache == this.cachedBreakPositions.length - 1) {
            int startPos = text.getIndex();
            this.dictionaryCharCount = 0;
            int result = super.handleNext();
            if (this.dictionaryCharCount > 1 && result - startPos > 1) {
                this.divideUpDictionaryRange(startPos, result);
            } else {
                this.cachedBreakPositions = null;
                return result;
            }
        }
        if (this.cachedBreakPositions != null) {
            ++this.positionInCache;
            text.setIndex(this.cachedBreakPositions[this.positionInCache]);
            return this.cachedBreakPositions[this.positionInCache];
        }
        return -9999;
    }

    protected int lookupCategory(int c) {
        int result = super.lookupCategory(c);
        if (result != -1 && this.categoryFlags[result]) {
            ++this.dictionaryCharCount;
        }
        return result;
    }

    private void divideUpDictionaryRange(int startPos, int endPos) {
        CharacterIterator text = this.getText();
        text.setIndex(startPos);
        int c = this.getCurrent();
        int category = this.lookupCategory(c);
        while (category == -1 || !this.categoryFlags[category]) {
            c = this.getNext();
            category = this.lookupCategory(c);
        }
        Stack currentBreakPositions = new Stack();
        Stack<Integer> possibleBreakPositions = new Stack<Integer>();
        Vector wrongBreakPositions = new Vector();
        int state = 0;
        int farthestEndPoint = text.getIndex();
        Stack bestBreakPositions = null;
        c = this.getCurrent();
        while (true) {
            if (this.dictionary.getNextState(state, 0) == -1) {
                possibleBreakPositions.push(new Integer(text.getIndex()));
            }
            if ((state = (int)this.dictionary.getNextStateFromCharacter(state, c)) == -1) {
                currentBreakPositions.push(new Integer(text.getIndex()));
                break;
            }
            if (state == 0 || text.getIndex() >= endPos) {
                if (text.getIndex() > farthestEndPoint) {
                    farthestEndPoint = text.getIndex();
                    bestBreakPositions = (Stack)currentBreakPositions.clone();
                }
                Object newStartingSpot = null;
                while (!possibleBreakPositions.isEmpty() && wrongBreakPositions.contains(possibleBreakPositions.peek())) {
                    possibleBreakPositions.pop();
                }
                if (possibleBreakPositions.isEmpty()) {
                    if (bestBreakPositions != null) {
                        currentBreakPositions = bestBreakPositions;
                        if (farthestEndPoint >= endPos) break;
                        text.setIndex(farthestEndPoint + 1);
                    } else {
                        if ((currentBreakPositions.size() == 0 || ((Integer)currentBreakPositions.peek()).intValue() != text.getIndex()) && text.getIndex() != startPos) {
                            currentBreakPositions.push(new Integer(text.getIndex()));
                        }
                        this.getNext();
                        currentBreakPositions.push(new Integer(text.getIndex()));
                    }
                } else {
                    Integer temp = (Integer)possibleBreakPositions.pop();
                    Object temp2 = null;
                    while (!currentBreakPositions.isEmpty() && temp < (Integer)currentBreakPositions.peek()) {
                        temp2 = currentBreakPositions.pop();
                        wrongBreakPositions.addElement(temp2);
                    }
                    currentBreakPositions.push(temp);
                    text.setIndex((Integer)currentBreakPositions.peek());
                }
                c = this.getCurrent();
                if (text.getIndex() < endPos) continue;
                break;
            }
            c = this.getNext();
        }
        if (!currentBreakPositions.isEmpty()) {
            currentBreakPositions.pop();
        }
        currentBreakPositions.push(new Integer(endPos));
        this.cachedBreakPositions = new int[currentBreakPositions.size() + 1];
        this.cachedBreakPositions[0] = startPos;
        for (int i = 0; i < currentBreakPositions.size(); ++i) {
            this.cachedBreakPositions[i + 1] = (Integer)currentBreakPositions.elementAt(i);
        }
        this.positionInCache = 0;
    }
}

