/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExecutorService
implements ExecutorService {
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new FutureTask<T>(runnable, value);
    }

    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new FutureTask<T>(callable);
    }

    @Override
    public Future<?> submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture<Object> ftask = this.newTaskFor(task, null);
        this.execute(ftask);
        return ftask;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture<T> ftask = this.newTaskFor(task, result);
        this.execute(ftask);
        return ftask;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture<T> ftask = this.newTaskFor(task);
        this.execute(ftask);
        return ftask;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T doInvokeAny(Collection<? extends Callable<T>> tasks, boolean timed, long nanos) throws InterruptedException, ExecutionException, TimeoutException {
        if (tasks == null) {
            throw new NullPointerException();
        }
        int ntasks = tasks.size();
        if (ntasks == 0) {
            throw new IllegalArgumentException();
        }
        ArrayList futures = new ArrayList(ntasks);
        ExecutorCompletionService<T> ecs = new ExecutorCompletionService<T>(this);
        try {
            ExecutionException ee = null;
            long lastTime = timed ? System.nanoTime() : 0L;
            Iterator<Callable<T>> it = tasks.iterator();
            futures.add(ecs.submit(it.next()));
            --ntasks;
            int active = 1;
            while (true) {
                Object now2;
                Future f;
                if ((f = ecs.poll()) == null) {
                    if (ntasks > 0) {
                        --ntasks;
                        futures.add(ecs.submit(it.next()));
                        ++active;
                    } else {
                        if (active == 0) {
                            if (ee != null) throw ee;
                            break;
                        }
                        if (timed) {
                            f = ecs.poll(nanos, TimeUnit.NANOSECONDS);
                            if (f == null) {
                                throw new TimeoutException();
                            }
                            long now2 = System.nanoTime();
                            nanos -= now2 - lastTime;
                            lastTime = now2;
                        } else {
                            f = ecs.take();
                        }
                    }
                }
                if (f == null) continue;
                --active;
                try {
                    now2 = f.get();
                }
                catch (InterruptedException ie) {
                    throw ie;
                }
                catch (ExecutionException eex) {
                    ee = eex;
                    continue;
                }
                catch (RuntimeException rex) {
                    ee = new ExecutionException(rex);
                    continue;
                }
                Object var17_17 = null;
                for (Future future : futures) {
                    future.cancel(true);
                }
                return (T)now2;
                break;
            }
            ee = new ExecutionException();
            throw ee;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            Iterator i$ = futures.iterator();
            while (true) {
                if (!i$.hasNext()) {
                    throw throwable;
                }
                Future future = (Future)i$.next();
                future.cancel(true);
            }
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        try {
            return this.doInvokeAny(tasks, false, 0L);
        }
        catch (TimeoutException cannotHappen) {
            assert (false);
            return null;
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doInvokeAny(tasks, true, unit.toNanos(timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        ArrayList<Future<T>> arrayList;
        block11: {
            if (tasks == null) {
                throw new NullPointerException();
            }
            ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
            boolean done = false;
            try {
                for (Callable<T> callable : tasks) {
                    RunnableFuture<T> f = this.newTaskFor(callable);
                    futures.add(f);
                    this.execute(f);
                }
                for (Future future : futures) {
                    if (future.isDone()) continue;
                    try {
                        future.get();
                    }
                    catch (CancellationException ignore) {
                    }
                    catch (ExecutionException ignore) {}
                }
                done = true;
                arrayList = futures;
                Object var8_11 = null;
                if (done) break block11;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                if (!done) {
                    for (Future future : futures) {
                        future.cancel(true);
                    }
                }
                throw throwable;
            }
            for (Future future : futures) {
                future.cancel(true);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        ArrayList<Future<T>> arrayList;
        boolean done;
        ArrayList<Future<T>> futures;
        block21: {
            ArrayList<Future<T>> arrayList2;
            block20: {
                Iterator i$2;
                ArrayList<Future<T>> arrayList3;
                block19: {
                    if (tasks == null || unit == null) {
                        throw new NullPointerException();
                    }
                    long nanos = unit.toNanos(timeout);
                    futures = new ArrayList<Future<T>>(tasks.size());
                    done = false;
                    try {
                        for (Callable<T> t : tasks) {
                            futures.add(this.newTaskFor(t));
                        }
                        long lastTime = System.nanoTime();
                        Iterator it = futures.iterator();
                        while (it.hasNext()) {
                            this.execute((Runnable)it.next());
                            long now = System.nanoTime();
                            if ((nanos -= now - (lastTime = now)) > 0L) continue;
                            arrayList3 = futures;
                            Object var17_19 = null;
                            if (done) return arrayList3;
                            i$2 = futures.iterator();
                            break block19;
                        }
                        for (Future future : futures) {
                            if (future.isDone()) continue;
                            if (nanos <= 0L) {
                                arrayList2 = futures;
                                break block20;
                            }
                            try {
                                future.get(nanos, TimeUnit.NANOSECONDS);
                            }
                            catch (CancellationException ignore) {
                            }
                            catch (ExecutionException ignore) {
                            }
                            catch (TimeoutException toe) {
                                ArrayList<Future<T>> arrayList4 = futures;
                                Object var17_21 = null;
                                if (done) return arrayList4;
                                Iterator i$2 = futures.iterator();
                                while (true) {
                                    if (!i$2.hasNext()) {
                                        return arrayList4;
                                    }
                                    Future future2 = (Future)i$2.next();
                                    future2.cancel(true);
                                }
                            }
                            long now = System.nanoTime();
                            nanos -= now - lastTime;
                            lastTime = now;
                        }
                        done = true;
                        arrayList = futures;
                        break block21;
                    }
                    catch (Throwable throwable) {
                        Object var17_23 = null;
                        if (!done) {
                            for (Future future : futures) {
                                future.cancel(true);
                            }
                        }
                        throw throwable;
                    }
                }
                while (i$2.hasNext()) {
                    Future future = (Future)i$2.next();
                    future.cancel(true);
                }
                return arrayList3;
            }
            Object var17_20 = null;
            if (done) return arrayList2;
            for (Future future : futures) {
                future.cancel(true);
            }
            return arrayList2;
        }
        Object var17_22 = null;
        if (done) return arrayList;
        Iterator i$2 = futures.iterator();
        while (i$2.hasNext()) {
            Future future = (Future)i$2.next();
            future.cancel(true);
        }
        return arrayList;
    }
}

