/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = -6903933977591709194L;
    private final int capacity;
    private final AtomicInteger count = new AtomicInteger(0);
    private transient Node<E> head;
    private transient Node<E> last;
    private final ReentrantLock takeLock = new ReentrantLock();
    private final Condition notEmpty = this.takeLock.newCondition();
    private final ReentrantLock putLock = new ReentrantLock();
    private final Condition notFull = this.putLock.newCondition();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalNotEmpty() {
        ReentrantLock takeLock = this.takeLock;
        takeLock.lock();
        try {
            this.notEmpty.signal();
            Object var3_2 = null;
            takeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            takeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalNotFull() {
        ReentrantLock putLock = this.putLock;
        putLock.lock();
        try {
            this.notFull.signal();
            Object var3_2 = null;
            putLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            putLock.unlock();
            throw throwable;
        }
    }

    private void insert(E x) {
        this.last.next = new Node<E>(x);
        this.last = this.last.next;
    }

    private E extract() {
        Node first = this.head.next;
        this.head = first;
        Object x = first.item;
        first.item = null;
        return x;
    }

    private void fullyLock() {
        this.putLock.lock();
        this.takeLock.lock();
    }

    private void fullyUnlock() {
        this.takeLock.unlock();
        this.putLock.unlock();
    }

    public LinkedBlockingQueue() {
        this(Integer.MAX_VALUE);
    }

    public LinkedBlockingQueue(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
        this.head = new Node<Object>(null);
        this.last = this.head;
    }

    public LinkedBlockingQueue(Collection<? extends E> c) {
        this(Integer.MAX_VALUE);
        for (E e : c) {
            this.add(e);
        }
    }

    @Override
    public int size() {
        return this.count.get();
    }

    @Override
    public int remainingCapacity() {
        return this.capacity - this.count.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        int c = -1;
        ReentrantLock putLock = this.putLock;
        AtomicInteger count = this.count;
        putLock.lockInterruptibly();
        try {
            try {
                while (count.get() == this.capacity) {
                    this.notFull.await();
                }
            }
            catch (InterruptedException ie) {
                this.notFull.signal();
                throw ie;
            }
            this.insert(e);
            c = count.getAndIncrement();
            if (c + 1 < this.capacity) {
                this.notFull.signal();
            }
            Object var7_6 = null;
            putLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            putLock.unlock();
            throw throwable;
        }
        if (c == 0) {
            this.signalNotEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        long nanos = unit.toNanos(timeout);
        int c = -1;
        ReentrantLock putLock = this.putLock;
        AtomicInteger count = this.count;
        putLock.lockInterruptibly();
        try {
            while (true) {
                if (count.get() < this.capacity) {
                    this.insert(e);
                    c = count.getAndIncrement();
                    if (c + 1 >= this.capacity) break;
                    this.notFull.signal();
                    break;
                }
                if (nanos <= 0L) {
                    boolean bl = false;
                    Object var12_10 = null;
                    putLock.unlock();
                    return bl;
                }
                try {
                    nanos = this.notFull.awaitNanos(nanos);
                }
                catch (InterruptedException ie) {
                    this.notFull.signal();
                    throw ie;
                }
            }
            Object var12_11 = null;
            putLock.unlock();
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            putLock.unlock();
            throw throwable;
        }
        if (c == 0) {
            this.signalNotEmpty();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        AtomicInteger count = this.count;
        if (count.get() == this.capacity) {
            return false;
        }
        int c = -1;
        ReentrantLock putLock = this.putLock;
        putLock.lock();
        try {
            if (count.get() < this.capacity) {
                this.insert(e);
                c = count.getAndIncrement();
                if (c + 1 < this.capacity) {
                    this.notFull.signal();
                }
            }
            Object var6_5 = null;
            putLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            putLock.unlock();
            throw throwable;
        }
        if (c == 0) {
            this.signalNotEmpty();
        }
        return c >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        E x;
        int c = -1;
        AtomicInteger count = this.count;
        ReentrantLock takeLock = this.takeLock;
        takeLock.lockInterruptibly();
        try {
            try {
                while (count.get() == 0) {
                    this.notEmpty.await();
                }
            }
            catch (InterruptedException ie) {
                this.notEmpty.signal();
                throw ie;
            }
            x = this.extract();
            c = count.getAndDecrement();
            if (c > 1) {
                this.notEmpty.signal();
            }
            Object var7_6 = null;
            takeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            takeLock.unlock();
            throw throwable;
        }
        if (c == this.capacity) {
            this.signalNotFull();
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        E x = null;
        int c = -1;
        long nanos = unit.toNanos(timeout);
        AtomicInteger count = this.count;
        ReentrantLock takeLock = this.takeLock;
        takeLock.lockInterruptibly();
        try {
            while (true) {
                if (count.get() > 0) {
                    x = this.extract();
                    c = count.getAndDecrement();
                    if (c <= 1) break;
                    this.notEmpty.signal();
                    break;
                }
                if (nanos <= 0L) {
                    E e = null;
                    Object var12_10 = null;
                    takeLock.unlock();
                    return e;
                }
                try {
                    nanos = this.notEmpty.awaitNanos(nanos);
                }
                catch (InterruptedException ie) {
                    this.notEmpty.signal();
                    throw ie;
                }
            }
            Object var12_11 = null;
            takeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            takeLock.unlock();
            throw throwable;
        }
        if (c == this.capacity) {
            this.signalNotFull();
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        AtomicInteger count = this.count;
        if (count.get() == 0) {
            return null;
        }
        E x = null;
        int c = -1;
        ReentrantLock takeLock = this.takeLock;
        takeLock.lock();
        try {
            if (count.get() > 0) {
                x = this.extract();
                c = count.getAndDecrement();
                if (c > 1) {
                    this.notEmpty.signal();
                }
            }
            Object var6_5 = null;
            takeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            takeLock.unlock();
            throw throwable;
        }
        if (c == this.capacity) {
            this.signalNotFull();
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        Node first;
        ReentrantLock takeLock;
        block4: {
            E e;
            if (this.count.get() == 0) {
                return null;
            }
            takeLock = this.takeLock;
            takeLock.lock();
            try {
                first = this.head.next;
                if (first != null) break block4;
                e = null;
                Object var5_5 = null;
                takeLock.unlock();
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                takeLock.unlock();
                throw throwable;
            }
            return e;
        }
        Object e = first.item;
        Object var5_6 = null;
        takeLock.unlock();
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        boolean removed = false;
        this.fullyLock();
        try {
            Node<E> trail = this.head;
            Node p = this.head.next;
            while (p != null) {
                if (o.equals(p.item)) {
                    removed = true;
                    break;
                }
                trail = p;
                p = p.next;
            }
            if (removed) {
                p.item = null;
                trail.next = p.next;
                if (this.last == p) {
                    this.last = trail;
                }
                if (this.count.getAndDecrement() == this.capacity) {
                    this.notFull.signalAll();
                }
            }
            Object var6_5 = null;
            this.fullyUnlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.fullyUnlock();
            throw throwable;
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        this.fullyLock();
        try {
            int size = this.count.get();
            Object[] a = new Object[size];
            int k = 0;
            Node p = this.head.next;
            while (p != null) {
                a[k++] = p.item;
                p = p.next;
            }
            Object[] objectArray = a;
            Object var6_5 = null;
            this.fullyUnlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.fullyUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        this.fullyLock();
        try {
            int size = this.count.get();
            if (a.length < size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            int k = 0;
            Node p = this.head.next;
            while (p != null) {
                a[k++] = p.item;
                p = p.next;
            }
            if (a.length > k) {
                a[k] = null;
            }
            Object[] objectArray = a;
            Object var6_5 = null;
            this.fullyUnlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.fullyUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        this.fullyLock();
        try {
            String string = super.toString();
            Object var3_2 = null;
            this.fullyUnlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.fullyUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.fullyLock();
        try {
            this.head.next = null;
            assert (this.head.item == null);
            this.last = this.head;
            if (this.count.getAndSet(0) == this.capacity) {
                this.notFull.signalAll();
            }
            Object var2_1 = null;
            this.fullyUnlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.fullyUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c) {
        Node first;
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        this.fullyLock();
        try {
            first = this.head.next;
            this.head.next = null;
            assert (this.head.item == null);
            this.last = this.head;
            if (this.count.getAndSet(0) == this.capacity) {
                this.notFull.signalAll();
            }
            Object var4_3 = null;
            this.fullyUnlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.fullyUnlock();
            throw throwable;
        }
        int n = 0;
        Node p = first;
        while (p != null) {
            c.add(p.item);
            p.item = null;
            ++n;
            p = p.next;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        this.fullyLock();
        try {
            int n;
            Node p = this.head.next;
            for (n = 0; p != null && n < maxElements; ++n) {
                c.add(p.item);
                p.item = null;
                p = p.next;
            }
            if (n != 0) {
                this.head.next = p;
                assert (this.head.item == null);
                if (p == null) {
                    this.last = this.head;
                }
                if (this.count.getAndAdd(-n) == this.capacity) {
                    this.notFull.signalAll();
                }
            }
            int n2 = n;
            Object var7_6 = null;
            this.fullyUnlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.fullyUnlock();
            throw throwable;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        this.fullyLock();
        try {
            s.defaultWriteObject();
            Node p = this.head.next;
            while (p != null) {
                s.writeObject(p.item);
                p = p.next;
            }
            s.writeObject(null);
            Object var4_3 = null;
            this.fullyUnlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.fullyUnlock();
            throw throwable;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object item;
        s.defaultReadObject();
        this.count.set(0);
        this.head = new Node<Object>(null);
        this.last = this.head;
        while ((item = s.readObject()) != null) {
            this.add(item);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<E> {
        private Node<E> current;
        private Node<E> lastRet;
        private E currentElement;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Itr() {
            ReentrantLock putLock = LinkedBlockingQueue.this.putLock;
            ReentrantLock takeLock = LinkedBlockingQueue.this.takeLock;
            putLock.lock();
            takeLock.lock();
            try {
                this.current = ((LinkedBlockingQueue)LinkedBlockingQueue.this).head.next;
                if (this.current != null) {
                    this.currentElement = this.current.item;
                }
                Object var5_4 = null;
                takeLock.unlock();
                putLock.unlock();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                takeLock.unlock();
                putLock.unlock();
                throw throwable;
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            Object e;
            ReentrantLock putLock = LinkedBlockingQueue.this.putLock;
            ReentrantLock takeLock = LinkedBlockingQueue.this.takeLock;
            putLock.lock();
            takeLock.lock();
            try {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                Object x = this.currentElement;
                this.lastRet = this.current;
                this.current = this.current.next;
                if (this.current != null) {
                    this.currentElement = this.current.item;
                }
                e = x;
                Object var6_5 = null;
                takeLock.unlock();
                putLock.unlock();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                takeLock.unlock();
                putLock.unlock();
                throw throwable;
            }
            return e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            ReentrantLock putLock = LinkedBlockingQueue.this.putLock;
            ReentrantLock takeLock = LinkedBlockingQueue.this.takeLock;
            putLock.lock();
            takeLock.lock();
            try {
                Node node = this.lastRet;
                this.lastRet = null;
                Node trail = LinkedBlockingQueue.this.head;
                Node p = ((LinkedBlockingQueue)LinkedBlockingQueue.this).head.next;
                while (p != null && p != node) {
                    trail = p;
                    p = p.next;
                }
                if (p == node) {
                    int c;
                    p.item = null;
                    trail.next = p.next;
                    if (LinkedBlockingQueue.this.last == p) {
                        LinkedBlockingQueue.this.last = trail;
                    }
                    if ((c = LinkedBlockingQueue.this.count.getAndDecrement()) == LinkedBlockingQueue.this.capacity) {
                        LinkedBlockingQueue.this.notFull.signalAll();
                    }
                }
                Object var8_7 = null;
                takeLock.unlock();
                putLock.unlock();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                takeLock.unlock();
                putLock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Node<E> {
        volatile E item;
        Node<E> next;

        Node(E x) {
            this.item = x;
        }
    }
}

