/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.CodeSigner;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import sun.security.util.Debug;
import sun.security.util.ManifestDigester;
import sun.security.util.ManifestEntryVerifier;
import sun.security.util.SignatureFileVerifier;

class JarVerifier {
    static final Debug debug = Debug.getInstance("jar");
    private Hashtable verifiedSigners;
    private Hashtable sigFileSigners;
    private Hashtable sigFileData;
    private ArrayList pendingBlocks;
    private ArrayList signerCache;
    private boolean parsingBlockOrSF = false;
    private boolean parsingMeta = true;
    private boolean anyToVerify = true;
    private ByteArrayOutputStream baos;
    private volatile ManifestDigester manDig;
    byte[] manifestRawBytes = null;

    public JarVerifier(byte[] rawBytes) {
        this.manifestRawBytes = rawBytes;
        this.sigFileSigners = new Hashtable();
        this.verifiedSigners = new Hashtable();
        this.sigFileData = new Hashtable(11);
        this.pendingBlocks = new ArrayList();
        this.baos = new ByteArrayOutputStream();
    }

    public void beginEntry(JarEntry je, ManifestEntryVerifier mev) throws IOException {
        String uname;
        if (je == null) {
            return;
        }
        if (debug != null) {
            debug.println("beginEntry " + je.getName());
        }
        String name = je.getName();
        if (this.parsingMeta && ((uname = name.toUpperCase(Locale.ENGLISH)).startsWith("META-INF/") || uname.startsWith("/META-INF/"))) {
            if (je.isDirectory()) {
                mev.setEntry(null, je);
                return;
            }
            if (SignatureFileVerifier.isBlockOrSF(uname)) {
                this.parsingBlockOrSF = true;
                this.baos.reset();
                mev.setEntry(null, je);
            }
            return;
        }
        if (this.parsingMeta) {
            this.doneWithMeta();
        }
        if (je.isDirectory()) {
            mev.setEntry(null, je);
            return;
        }
        if (name.startsWith("./")) {
            name = name.substring(2);
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (this.sigFileSigners.get(name) != null) {
            mev.setEntry(name, je);
            return;
        }
        mev.setEntry(null, je);
    }

    public void update(int b, ManifestEntryVerifier mev) throws IOException {
        if (b != -1) {
            if (this.parsingBlockOrSF) {
                this.baos.write(b);
            } else {
                mev.update((byte)b);
            }
        } else {
            this.processEntry(mev);
        }
    }

    public void update(int n, byte[] b, int off, int len, ManifestEntryVerifier mev) throws IOException {
        if (n != -1) {
            if (this.parsingBlockOrSF) {
                this.baos.write(b, off, n);
            } else {
                mev.update(b, off, n);
            }
        } else {
            this.processEntry(mev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void processEntry(ManifestEntryVerifier mev) throws IOException {
        if (!this.parsingBlockOrSF) {
            JarEntry je = mev.getEntry();
            if (je == null) return;
            if (je.signers != null) return;
            je.signers = mev.verify(this.verifiedSigners, this.sigFileSigners);
            je.certs = JarVerifier.mapSignersToCertArray(je.signers);
            return;
        }
        try {
            SignatureFileVerifier sfv;
            String uname;
            this.parsingBlockOrSF = false;
            if (debug != null) {
                debug.println("processEntry: processing block");
            }
            if ((uname = mev.getEntry().getName().toUpperCase(Locale.ENGLISH)).endsWith(".SF")) {
                String key = uname.substring(0, uname.length() - 3);
                byte[] bytes = this.baos.toByteArray();
                this.sigFileData.put(key, bytes);
                Iterator it = this.pendingBlocks.iterator();
                while (it.hasNext()) {
                    SignatureFileVerifier sfv2 = (SignatureFileVerifier)it.next();
                    if (!sfv2.needSignatureFile(key)) continue;
                    if (debug != null) {
                        debug.println("processEntry: processing pending block");
                    }
                    sfv2.setSignatureFile(bytes);
                    sfv2.process(this.sigFileSigners);
                }
                return;
            }
            String key = uname.substring(0, uname.lastIndexOf("."));
            if (this.signerCache == null) {
                this.signerCache = new ArrayList();
            }
            if (this.manDig == null) {
                byte[] bytes = this.manifestRawBytes;
                // MONITORENTER : this.manifestRawBytes
                if (this.manDig == null) {
                    this.manDig = new ManifestDigester(this.manifestRawBytes);
                    this.manifestRawBytes = null;
                }
                // MONITOREXIT : bytes
            }
            if ((sfv = new SignatureFileVerifier(this.signerCache, this.manDig, uname, this.baos.toByteArray())).needSignatureFileBytes()) {
                byte[] bytes = (byte[])this.sigFileData.get(key);
                if (bytes == null) {
                    if (debug != null) {
                        debug.println("adding pending block");
                    }
                    this.pendingBlocks.add(sfv);
                    return;
                }
                sfv.setSignatureFile(bytes);
            }
            sfv.process(this.sigFileSigners);
            return;
        }
        catch (IOException ioe) {
            if (debug == null) return;
            debug.println("processEntry caught: " + ioe);
            return;
        }
        catch (SignatureException se) {
            if (debug == null) return;
            debug.println("processEntry caught: " + se);
            return;
        }
        catch (NoSuchAlgorithmException nsae) {
            if (debug == null) return;
            debug.println("processEntry caught: " + nsae);
            return;
        }
        catch (CertificateException ce) {
            if (debug == null) return;
            debug.println("processEntry caught: " + ce);
        }
    }

    public Certificate[] getCerts(String name) {
        return JarVerifier.mapSignersToCertArray(this.getCodeSigners(name));
    }

    public CodeSigner[] getCodeSigners(String name) {
        return (CodeSigner[])this.verifiedSigners.get(name);
    }

    private static Certificate[] mapSignersToCertArray(CodeSigner[] signers) {
        if (signers != null) {
            ArrayList<? extends Certificate> certChains = new ArrayList<Certificate>();
            for (int i = 0; i < signers.length; ++i) {
                certChains.addAll(signers[i].getSignerCertPath().getCertificates());
            }
            return certChains.toArray(new Certificate[certChains.size()]);
        }
        return null;
    }

    boolean nothingToVerify() {
        return !this.anyToVerify;
    }

    void doneWithMeta() {
        this.parsingMeta = false;
        this.anyToVerify = !this.sigFileSigners.isEmpty();
        this.baos = null;
        this.sigFileData = null;
        this.pendingBlocks = null;
        this.signerCache = null;
        this.manDig = null;
    }

    static class VerifierStream
    extends InputStream {
        private InputStream is;
        private JarVerifier jv;
        private ManifestEntryVerifier mev;
        private long numLeft;

        VerifierStream(Manifest man, JarEntry je, InputStream is, JarVerifier jv) throws IOException {
            this.is = is;
            this.jv = jv;
            this.mev = new ManifestEntryVerifier(man);
            this.jv.beginEntry(je, this.mev);
            this.numLeft = je.getSize();
            if (this.numLeft == 0L) {
                this.jv.update(-1, this.mev);
            }
        }

        public int read() throws IOException {
            if (this.numLeft > 0L) {
                int b = this.is.read();
                this.jv.update(b, this.mev);
                --this.numLeft;
                if (this.numLeft == 0L) {
                    this.jv.update(-1, this.mev);
                }
                return b;
            }
            return -1;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.numLeft > 0L && this.numLeft < (long)len) {
                len = (int)this.numLeft;
            }
            if (this.numLeft > 0L) {
                int n = this.is.read(b, off, len);
                this.jv.update(n, b, off, len, this.mev);
                this.numLeft -= (long)n;
                if (this.numLeft == 0L) {
                    this.jv.update(-1, b, off, len, this.mev);
                }
                return n;
            }
            return -1;
        }

        public void close() throws IOException {
            if (this.is != null) {
                this.is.close();
            }
            this.is = null;
            this.mev = null;
            this.jv = null;
        }

        public int available() throws IOException {
            return this.is.available();
        }
    }
}

