/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipError;
import java.util.zip.ZipException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFile
implements ZipConstants {
    private long jzfile;
    private String name;
    private int total;
    private boolean closeRequested;
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private Vector inflaters = new Vector();

    private static native void initIDs();

    public ZipFile(String name) throws IOException {
        this(new File(name), 1);
    }

    public ZipFile(File file, int mode) throws IOException {
        if ((mode & 1) == 0 || (mode & 0xFFFFFFFA) != 0) {
            throw new IllegalArgumentException("Illegal mode: 0x" + Integer.toHexString(mode));
        }
        String name = file.getPath();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkRead(name);
            if ((mode & 4) != 0) {
                sm.checkDelete(name);
            }
        }
        this.jzfile = ZipFile.open(name, mode, file.lastModified());
        this.name = name;
        this.total = ZipFile.getTotal(this.jzfile);
    }

    private static native long open(String var0, int var1, long var2);

    private static native int getTotal(long var0);

    public ZipFile(File file) throws ZipException, IOException {
        this(file, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipEntry getEntry(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        long jzentry = 0L;
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            jzentry = ZipFile.getEntry(this.jzfile, name, true);
            if (jzentry != 0L) {
                ZipEntry ze = new ZipEntry(name, jzentry);
                ZipFile.freeEntry(this.jzfile, jzentry);
                return ze;
            }
        }
        return null;
    }

    private static native long getEntry(long var0, String var2, boolean var3);

    private static native void freeEntry(long var0, long var2);

    public InputStream getInputStream(ZipEntry entry) throws IOException {
        return this.getInputStream(entry.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getInputStream(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        long jzentry = 0L;
        ZipFileInputStream in = null;
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            jzentry = ZipFile.getEntry(this.jzfile, name, false);
            if (jzentry == 0L) {
                return null;
            }
            in = new ZipFileInputStream(jzentry);
        }
        final ZipFileInputStream zfin = in;
        switch (ZipFile.getMethod(jzentry)) {
            case 0: {
                return zfin;
            }
            case 8: {
                long size = ZipFile.getSize(jzentry) + 2L;
                if (size > 65536L) {
                    size = 8192L;
                }
                if (size <= 0L) {
                    size = 4096L;
                }
                return new InflaterInputStream(zfin, this.getInflater(), (int)size){
                    private boolean isClosed;
                    private boolean eof;
                    {
                        super(x0, x1, x2);
                        this.isClosed = false;
                    }

                    public void close() throws IOException {
                        if (!this.isClosed) {
                            ZipFile.this.releaseInflater(this.inf);
                            this.in.close();
                            this.isClosed = true;
                        }
                    }

                    protected void fill() throws IOException {
                        if (this.eof) {
                            throw new EOFException("Unexpected end of ZLIB input stream");
                        }
                        this.len = this.in.read(this.buf, 0, this.buf.length);
                        if (this.len == -1) {
                            this.buf[0] = 0;
                            this.len = 1;
                            this.eof = true;
                        }
                        this.inf.setInput(this.buf, 0, this.len);
                    }

                    public int available() throws IOException {
                        if (this.isClosed) {
                            return 0;
                        }
                        long avail = zfin.size() - this.inf.getBytesWritten();
                        return avail > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)avail;
                    }
                };
            }
        }
        throw new ZipException("invalid compression method");
    }

    private static native int getMethod(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Inflater getInflater() {
        Vector vector = this.inflaters;
        synchronized (vector) {
            int size = this.inflaters.size();
            if (size > 0) {
                Inflater inf = (Inflater)this.inflaters.remove(size - 1);
                inf.reset();
                return inf;
            }
            return new Inflater(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInflater(Inflater inf) {
        Vector vector = this.inflaters;
        synchronized (vector) {
            this.inflaters.add(inf);
        }
    }

    public String getName() {
        return this.name;
    }

    public Enumeration<? extends ZipEntry> entries() {
        this.ensureOpen();
        return new Enumeration<ZipEntry>(){
            private int i = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasMoreElements() {
                ZipFile zipFile = ZipFile.this;
                synchronized (zipFile) {
                    ZipFile.this.ensureOpen();
                    return this.i < ZipFile.this.total;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ZipEntry nextElement() throws NoSuchElementException {
                ZipFile zipFile = ZipFile.this;
                synchronized (zipFile) {
                    ZipFile.this.ensureOpen();
                    if (this.i >= ZipFile.this.total) {
                        throw new NoSuchElementException();
                    }
                    long jzentry = ZipFile.getNextEntry(ZipFile.this.jzfile, this.i++);
                    if (jzentry == 0L) {
                        String message = ZipFile.this.closeRequested ? "ZipFile concurrently closed" : ZipFile.getZipMessage(ZipFile.this.jzfile);
                        throw new ZipError("jzentry == 0,\n jzfile = " + ZipFile.this.jzfile + ",\n total = " + ZipFile.this.total + ",\n name = " + ZipFile.this.name + ",\n i = " + this.i + ",\n message = " + message);
                    }
                    ZipEntry ze = new ZipEntry(jzentry);
                    ZipFile.freeEntry(ZipFile.this.jzfile, jzentry);
                    return ze;
                }
            }
        };
    }

    private static native long getNextEntry(long var0, int var2);

    public int size() {
        this.ensureOpen();
        return this.total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.closeRequested = true;
            if (this.jzfile != 0L) {
                long zf = this.jzfile;
                this.jzfile = 0L;
                ZipFile.close(zf);
                Vector vector = this.inflaters;
                synchronized (vector) {
                    int size = this.inflaters.size();
                    for (int i = 0; i < size; ++i) {
                        Inflater inf = (Inflater)this.inflaters.get(i);
                        inf.end();
                    }
                }
            }
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private static native void close(long var0);

    private void ensureOpen() {
        if (this.closeRequested) {
            throw new IllegalStateException("zip file closed");
        }
        if (this.jzfile == 0L) {
            throw new IllegalStateException("The object is not initialized.");
        }
    }

    private void ensureOpenOrZipException() throws IOException {
        if (this.closeRequested) {
            throw new ZipException("ZipFile closed");
        }
    }

    private static native int read(long var0, long var2, long var4, byte[] var6, int var7, int var8);

    private static native long getCSize(long var0);

    private static native long getSize(long var0);

    private static native String getZipMessage(long var0);

    static {
        ZipFile.initIDs();
    }

    private class ZipFileInputStream
    extends InputStream {
        protected long jzentry;
        private long pos = 0L;
        protected long rem;
        protected long size;

        ZipFileInputStream(long jzentry) {
            this.rem = ZipFile.getCSize(jzentry);
            this.size = ZipFile.getSize(jzentry);
            this.jzentry = jzentry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.rem == 0L) {
                return -1;
            }
            if (len <= 0) {
                return 0;
            }
            if ((long)len > this.rem) {
                len = (int)this.rem;
            }
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                ZipFile.this.ensureOpenOrZipException();
                len = ZipFile.read(ZipFile.this.jzfile, this.jzentry, this.pos, b, off, len);
            }
            if (len > 0) {
                this.pos += (long)len;
                this.rem -= (long)len;
            }
            if (this.rem == 0L) {
                this.close();
            }
            return len;
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            if (this.read(b, 0, 1) == 1) {
                return b[0] & 0xFF;
            }
            return -1;
        }

        public long skip(long n) {
            if (n > this.rem) {
                n = this.rem;
            }
            this.pos += n;
            this.rem -= n;
            if (this.rem == 0L) {
                this.close();
            }
            return n;
        }

        public int available() {
            return this.rem > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.rem;
        }

        public long size() {
            return this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.rem = 0L;
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                if (this.jzentry != 0L && ZipFile.this.jzfile != 0L) {
                    ZipFile.freeEntry(ZipFile.this.jzfile, this.jzentry);
                    this.jzentry = 0L;
                }
            }
        }
    }
}

