/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Stack;
import javax.imageio.IIOException;
import javax.imageio.stream.IIOByteBuffer;
import javax.imageio.stream.ImageInputStream;

public abstract class ImageInputStreamImpl
implements ImageInputStream {
    private Stack markByteStack = new Stack();
    private Stack markBitStack = new Stack();
    private boolean isClosed = false;
    private static final int BYTE_BUF_LENGTH = 8192;
    byte[] byteBuf = new byte[8192];
    protected ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    protected long streamPos;
    protected int bitOffset;
    protected long flushedPos = 0L;

    protected final void checkClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("closed");
        }
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public abstract int read() throws IOException;

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public void readBytes(IIOByteBuffer buf, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException("len < 0!");
        }
        if (buf == null) {
            throw new NullPointerException("buf == null!");
        }
        byte[] data = new byte[len];
        len = this.read(data, 0, len);
        buf.setData(data);
        buf.setOffset(0);
        buf.setLength(len);
    }

    public boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    public byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    public int readUnsignedByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    public short readShort() throws IOException {
        if (this.read(this.byteBuf, 0, 2) < 0) {
            throw new EOFException();
        }
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            return (short)((this.byteBuf[0] & 0xFF) << 8 | (this.byteBuf[1] & 0xFF) << 0);
        }
        return (short)((this.byteBuf[1] & 0xFF) << 8 | (this.byteBuf[0] & 0xFF) << 0);
    }

    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public char readChar() throws IOException {
        return (char)this.readShort();
    }

    public int readInt() throws IOException {
        if (this.read(this.byteBuf, 0, 4) < 0) {
            throw new EOFException();
        }
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            return (this.byteBuf[0] & 0xFF) << 24 | (this.byteBuf[1] & 0xFF) << 16 | (this.byteBuf[2] & 0xFF) << 8 | (this.byteBuf[3] & 0xFF) << 0;
        }
        return (this.byteBuf[3] & 0xFF) << 24 | (this.byteBuf[2] & 0xFF) << 16 | (this.byteBuf[1] & 0xFF) << 8 | (this.byteBuf[0] & 0xFF) << 0;
    }

    public long readUnsignedInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readLong() throws IOException {
        int i1 = this.readInt();
        int i2 = this.readInt();
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            return ((long)i1 << 32) + ((long)i2 & 0xFFFFFFFFL);
        }
        return ((long)i2 << 32) + ((long)i1 & 0xFFFFFFFFL);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        StringBuffer input = new StringBuffer();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = this.read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    continue block4;
                }
                case 13: {
                    eol = true;
                    long cur = this.getStreamPosition();
                    if (this.read() == 10) continue block4;
                    this.seek(cur);
                    continue block4;
                }
            }
            input.append((char)c);
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    public String readUTF() throws IOException {
        String ret;
        this.bitOffset = 0;
        ByteOrder oldByteOrder = this.getByteOrder();
        this.setByteOrder(ByteOrder.BIG_ENDIAN);
        try {
            ret = DataInputStream.readUTF(this);
        }
        catch (IOException e) {
            this.setByteOrder(oldByteOrder);
            throw e;
        }
        this.setByteOrder(oldByteOrder);
        return ret;
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > b.length!");
        }
        while (len > 0) {
            int nbytes = this.read(b, off, len);
            if (nbytes == -1) {
                throw new EOFException();
            }
            off += nbytes;
            len -= nbytes;
        }
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(short[] s, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > s.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > s.length!");
        }
        while (len > 0) {
            int nelts = Math.min(len, this.byteBuf.length / 2);
            this.readFully(this.byteBuf, 0, nelts * 2);
            this.toShorts(this.byteBuf, s, off, nelts);
            off += nelts;
            len -= nelts;
        }
    }

    public void readFully(char[] c, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > c.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length!");
        }
        while (len > 0) {
            int nelts = Math.min(len, this.byteBuf.length / 2);
            this.readFully(this.byteBuf, 0, nelts * 2);
            this.toChars(this.byteBuf, c, off, nelts);
            off += nelts;
            len -= nelts;
        }
    }

    public void readFully(int[] i, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > i.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length!");
        }
        while (len > 0) {
            int nelts = Math.min(len, this.byteBuf.length / 4);
            this.readFully(this.byteBuf, 0, nelts * 4);
            this.toInts(this.byteBuf, i, off, nelts);
            off += nelts;
            len -= nelts;
        }
    }

    public void readFully(long[] l, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > l.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > l.length!");
        }
        while (len > 0) {
            int nelts = Math.min(len, this.byteBuf.length / 8);
            this.readFully(this.byteBuf, 0, nelts * 8);
            this.toLongs(this.byteBuf, l, off, nelts);
            off += nelts;
            len -= nelts;
        }
    }

    public void readFully(float[] f, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > f.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > f.length!");
        }
        while (len > 0) {
            int nelts = Math.min(len, this.byteBuf.length / 4);
            this.readFully(this.byteBuf, 0, nelts * 4);
            this.toFloats(this.byteBuf, f, off, nelts);
            off += nelts;
            len -= nelts;
        }
    }

    public void readFully(double[] d, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > d.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > d.length!");
        }
        while (len > 0) {
            int nelts = Math.min(len, this.byteBuf.length / 8);
            this.readFully(this.byteBuf, 0, nelts * 8);
            this.toDoubles(this.byteBuf, d, off, nelts);
            off += nelts;
            len -= nelts;
        }
    }

    private void toShorts(byte[] b, short[] s, int off, int len) {
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff];
                int b1 = b[boff + 1] & 0xFF;
                s[off + j] = (short)(b0 << 8 | b1);
                boff += 2;
            }
        } else {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff + 1];
                int b1 = b[boff] & 0xFF;
                s[off + j] = (short)(b0 << 8 | b1);
                boff += 2;
            }
        }
    }

    private void toChars(byte[] b, char[] c, int off, int len) {
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff];
                int b1 = b[boff + 1] & 0xFF;
                c[off + j] = (char)(b0 << 8 | b1);
                boff += 2;
            }
        } else {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff + 1];
                int b1 = b[boff] & 0xFF;
                c[off + j] = (char)(b0 << 8 | b1);
                boff += 2;
            }
        }
    }

    private void toInts(byte[] b, int[] i, int off, int len) {
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff];
                int b1 = b[boff + 1] & 0xFF;
                int b2 = b[boff + 2] & 0xFF;
                int b3 = b[boff + 3] & 0xFF;
                i[off + j] = b0 << 24 | b1 << 16 | b2 << 8 | b3;
                boff += 4;
            }
        } else {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff + 3];
                int b1 = b[boff + 2] & 0xFF;
                int b2 = b[boff + 1] & 0xFF;
                int b3 = b[boff] & 0xFF;
                i[off + j] = b0 << 24 | b1 << 16 | b2 << 8 | b3;
                boff += 4;
            }
        }
    }

    private void toLongs(byte[] b, long[] l, int off, int len) {
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff];
                int b1 = b[boff + 1] & 0xFF;
                int b2 = b[boff + 2] & 0xFF;
                int b3 = b[boff + 3] & 0xFF;
                byte b4 = b[boff + 4];
                int b5 = b[boff + 5] & 0xFF;
                int b6 = b[boff + 6] & 0xFF;
                int b7 = b[boff + 7] & 0xFF;
                int i0 = b0 << 24 | b1 << 16 | b2 << 8 | b3;
                int i1 = b4 << 24 | b5 << 16 | b6 << 8 | b7;
                l[off + j] = (long)i0 << 32 | (long)i1 & 0xFFFFFFFFL;
                boff += 8;
            }
        } else {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff + 7];
                int b1 = b[boff + 6] & 0xFF;
                int b2 = b[boff + 5] & 0xFF;
                int b3 = b[boff + 4] & 0xFF;
                byte b4 = b[boff + 3];
                int b5 = b[boff + 2] & 0xFF;
                int b6 = b[boff + 1] & 0xFF;
                int b7 = b[boff] & 0xFF;
                int i0 = b0 << 24 | b1 << 16 | b2 << 8 | b3;
                int i1 = b4 << 24 | b5 << 16 | b6 << 8 | b7;
                l[off + j] = (long)i0 << 32 | (long)i1 & 0xFFFFFFFFL;
                boff += 8;
            }
        }
    }

    private void toFloats(byte[] b, float[] f, int off, int len) {
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff];
                int b1 = b[boff + 1] & 0xFF;
                int b2 = b[boff + 2] & 0xFF;
                int b3 = b[boff + 3] & 0xFF;
                int i = b0 << 24 | b1 << 16 | b2 << 8 | b3;
                f[off + j] = Float.intBitsToFloat(i);
                boff += 4;
            }
        } else {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff + 3];
                int b1 = b[boff + 2] & 0xFF;
                int b2 = b[boff + 1] & 0xFF;
                int b3 = b[boff + 0] & 0xFF;
                int i = b0 << 24 | b1 << 16 | b2 << 8 | b3;
                f[off + j] = Float.intBitsToFloat(i);
                boff += 4;
            }
        }
    }

    private void toDoubles(byte[] b, double[] d, int off, int len) {
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff];
                int b1 = b[boff + 1] & 0xFF;
                int b2 = b[boff + 2] & 0xFF;
                int b3 = b[boff + 3] & 0xFF;
                byte b4 = b[boff + 4];
                int b5 = b[boff + 5] & 0xFF;
                int b6 = b[boff + 6] & 0xFF;
                int b7 = b[boff + 7] & 0xFF;
                int i0 = b0 << 24 | b1 << 16 | b2 << 8 | b3;
                int i1 = b4 << 24 | b5 << 16 | b6 << 8 | b7;
                long l = (long)i0 << 32 | (long)i1 & 0xFFFFFFFFL;
                d[off + j] = Double.longBitsToDouble(l);
                boff += 8;
            }
        } else {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff + 7];
                int b1 = b[boff + 6] & 0xFF;
                int b2 = b[boff + 5] & 0xFF;
                int b3 = b[boff + 4] & 0xFF;
                byte b4 = b[boff + 3];
                int b5 = b[boff + 2] & 0xFF;
                int b6 = b[boff + 1] & 0xFF;
                int b7 = b[boff] & 0xFF;
                int i0 = b0 << 24 | b1 << 16 | b2 << 8 | b3;
                int i1 = b4 << 24 | b5 << 16 | b6 << 8 | b7;
                long l = (long)i0 << 32 | (long)i1 & 0xFFFFFFFFL;
                d[off + j] = Double.longBitsToDouble(l);
                boff += 8;
            }
        }
    }

    public long getStreamPosition() throws IOException {
        this.checkClosed();
        return this.streamPos;
    }

    public int getBitOffset() throws IOException {
        this.checkClosed();
        return this.bitOffset;
    }

    public void setBitOffset(int bitOffset) throws IOException {
        this.checkClosed();
        if (bitOffset < 0 || bitOffset > 7) {
            throw new IllegalArgumentException("bitOffset must be betwwen 0 and 7!");
        }
        this.bitOffset = bitOffset;
    }

    public int readBit() throws IOException {
        this.checkClosed();
        int newBitOffset = this.bitOffset + 1 & 7;
        int val = this.read();
        if (val == -1) {
            throw new EOFException();
        }
        if (newBitOffset != 0) {
            this.seek(this.getStreamPosition() - 1L);
            val >>= 8 - newBitOffset;
        }
        this.bitOffset = newBitOffset;
        return val & 1;
    }

    public long readBits(int numBits) throws IOException {
        int bitsToRead;
        this.checkClosed();
        if (numBits < 0 || numBits > 64) {
            throw new IllegalArgumentException();
        }
        if (numBits == 0) {
            return 0L;
        }
        int newBitOffset = this.bitOffset + numBits & 7;
        long accum = 0L;
        for (bitsToRead = numBits + this.bitOffset; bitsToRead > 0; bitsToRead -= 8) {
            int val = this.read();
            if (val == -1) {
                throw new EOFException();
            }
            accum <<= 8;
            accum |= (long)val;
        }
        if (newBitOffset != 0) {
            this.seek(this.getStreamPosition() - 1L);
        }
        this.bitOffset = newBitOffset;
        accum >>>= -bitsToRead;
        return accum &= -1L >>> 64 - numBits;
    }

    public long length() {
        return -1L;
    }

    public int skipBytes(int n) throws IOException {
        long pos = this.getStreamPosition();
        this.seek(pos + (long)n);
        return (int)(this.getStreamPosition() - pos);
    }

    public long skipBytes(long n) throws IOException {
        long pos = this.getStreamPosition();
        this.seek(pos + n);
        return this.getStreamPosition() - pos;
    }

    public void seek(long pos) throws IOException {
        this.checkClosed();
        if (pos < this.flushedPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos!");
        }
        this.streamPos = pos;
        this.bitOffset = 0;
    }

    public void mark() {
        try {
            this.markByteStack.push(new Long(this.getStreamPosition()));
            this.markBitStack.push(new Integer(this.getBitOffset()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void reset() throws IOException {
        if (this.markByteStack.empty()) {
            return;
        }
        long pos = (Long)this.markByteStack.pop();
        if (pos < this.flushedPos) {
            throw new IIOException("Previous marked position has been discarded!");
        }
        this.seek(pos);
        int offset = (Integer)this.markBitStack.pop();
        this.setBitOffset(offset);
    }

    public void flushBefore(long pos) throws IOException {
        this.checkClosed();
        if (pos < this.flushedPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos!");
        }
        if (pos > this.getStreamPosition()) {
            throw new IndexOutOfBoundsException("pos > getStreamPosition()!");
        }
        this.flushedPos = pos;
    }

    public void flush() throws IOException {
        this.flushBefore(this.getStreamPosition());
    }

    public long getFlushedPosition() {
        return this.flushedPos;
    }

    public boolean isCached() {
        return false;
    }

    public boolean isCachedMemory() {
        return false;
    }

    public boolean isCachedFile() {
        return false;
    }

    public void close() throws IOException {
        this.checkClosed();
        this.isClosed = true;
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.finalize();
    }
}

