/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import com.sun.imageio.stream.StreamFinalizer;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.imageio.stream.MemoryCache;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;

public class MemoryCacheImageInputStream
extends ImageInputStreamImpl {
    private InputStream stream;
    private MemoryCache cache = new MemoryCache();
    private final Object disposerReferent;
    private final DisposerRecord disposerRecord;

    public MemoryCacheImageInputStream(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("stream == null!");
        }
        this.stream = stream;
        this.disposerRecord = new StreamDisposerRecord(this.cache);
        if (this.getClass() == MemoryCacheImageInputStream.class) {
            this.disposerReferent = new Object();
            Disposer.addRecord(this.disposerReferent, this.disposerRecord);
        } else {
            this.disposerReferent = new StreamFinalizer(this);
        }
    }

    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        long pos = this.cache.loadFromStream(this.stream, this.streamPos + 1L);
        if (pos >= this.streamPos + 1L) {
            return this.cache.read(this.streamPos++);
        }
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        if (b == null) {
            throw new NullPointerException("b == null!");
        }
        if (off < 0 || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off+len > b.length || off+len < 0!");
        }
        this.bitOffset = 0;
        if (len == 0) {
            return 0;
        }
        long pos = this.cache.loadFromStream(this.stream, this.streamPos + (long)len);
        if ((len = (int)(pos - this.streamPos)) > 0) {
            this.cache.read(b, off, len, this.streamPos);
            this.streamPos += (long)len;
            return len;
        }
        return -1;
    }

    public void flushBefore(long pos) throws IOException {
        super.flushBefore(pos);
        this.cache.disposeBefore(pos);
    }

    public boolean isCached() {
        return true;
    }

    public boolean isCachedFile() {
        return false;
    }

    public boolean isCachedMemory() {
        return true;
    }

    public void close() throws IOException {
        super.close();
        this.disposerRecord.dispose();
        this.stream = null;
        this.cache = null;
    }

    protected void finalize() throws Throwable {
    }

    private static class StreamDisposerRecord
    implements DisposerRecord {
        private MemoryCache cache;

        public StreamDisposerRecord(MemoryCache cache) {
            this.cache = cache;
        }

        public synchronized void dispose() {
            if (this.cache != null) {
                this.cache.reset();
                this.cache = null;
            }
        }
    }
}

