/*
 * Decompiled with CFR 0.152.
 */
package javax.print;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.print.DocFlavor;
import javax.print.MultiDocPrintService;
import javax.print.PrintService;
import javax.print.StreamPrintService;
import javax.print.attribute.AttributeSet;
import sun.awt.AppContext;

public abstract class PrintServiceLookup {
    private static Services getServicesForContext() {
        Services services = (Services)AppContext.getAppContext().get(Services.class);
        if (services == null) {
            services = new Services();
            AppContext.getAppContext().put(Services.class, services);
        }
        return services;
    }

    private static ArrayList getListOfLookupServices() {
        return PrintServiceLookup.getServicesForContext().listOfLookupServices;
    }

    private static ArrayList initListOfLookupServices() {
        ArrayList listOfLookupServices = new ArrayList();
        PrintServiceLookup.getServicesForContext().listOfLookupServices = listOfLookupServices;
        return listOfLookupServices;
    }

    private static ArrayList getRegisteredServices() {
        return PrintServiceLookup.getServicesForContext().registeredServices;
    }

    private static ArrayList initRegisteredServices() {
        ArrayList registeredServices = new ArrayList();
        PrintServiceLookup.getServicesForContext().registeredServices = registeredServices;
        return registeredServices;
    }

    public static final PrintService[] lookupPrintServices(DocFlavor flavor, AttributeSet attributes) {
        ArrayList list = PrintServiceLookup.getServices(flavor, attributes);
        return list.toArray(new PrintService[list.size()]);
    }

    public static final MultiDocPrintService[] lookupMultiDocPrintServices(DocFlavor[] flavors, AttributeSet attributes) {
        ArrayList list = PrintServiceLookup.getMultiDocServices(flavors, attributes);
        return list.toArray(new MultiDocPrintService[list.size()]);
    }

    public static final PrintService lookupDefaultPrintService() {
        Iterator psIterator = PrintServiceLookup.getAllLookupServices().iterator();
        while (psIterator.hasNext()) {
            try {
                PrintServiceLookup lus = (PrintServiceLookup)psIterator.next();
                PrintService service = lus.getDefaultPrintService();
                if (service == null) continue;
                return service;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerServiceProvider(PrintServiceLookup sp) {
        Class<PrintServiceLookup> clazz = PrintServiceLookup.class;
        synchronized (PrintServiceLookup.class) {
            Iterator psIterator = PrintServiceLookup.getAllLookupServices().iterator();
            while (psIterator.hasNext()) {
                try {
                    Object lus = psIterator.next();
                    if (lus.getClass() != sp.getClass()) continue;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
                catch (Exception exception) {
                }
            }
            PrintServiceLookup.getListOfLookupServices().add(sp);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerService(PrintService service) {
        Class<PrintServiceLookup> clazz = PrintServiceLookup.class;
        synchronized (PrintServiceLookup.class) {
            if (service instanceof StreamPrintService) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            ArrayList registeredServices = PrintServiceLookup.getRegisteredServices();
            if (registeredServices == null) {
                registeredServices = PrintServiceLookup.initRegisteredServices();
            } else if (registeredServices.contains(service)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            registeredServices.add(service);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }

    public abstract PrintService[] getPrintServices(DocFlavor var1, AttributeSet var2);

    public abstract PrintService[] getPrintServices();

    public abstract MultiDocPrintService[] getMultiDocPrintServices(DocFlavor[] var1, AttributeSet var2);

    public abstract PrintService getDefaultPrintService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList getAllLookupServices() {
        Class<PrintServiceLookup> clazz = PrintServiceLookup.class;
        synchronized (PrintServiceLookup.class) {
            ArrayList listOfLookupServices = PrintServiceLookup.getListOfLookupServices();
            if (listOfLookupServices != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return listOfLookupServices;
            }
            listOfLookupServices = PrintServiceLookup.initListOfLookupServices();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        Iterator<PrintServiceLookup> iterator = ServiceLoader.load(PrintServiceLookup.class).iterator();
                        ArrayList los = PrintServiceLookup.getListOfLookupServices();
                        while (iterator.hasNext()) {
                            try {
                                los.add(iterator.next());
                            }
                            catch (ServiceConfigurationError err) {
                                if (System.getSecurityManager() != null) {
                                    err.printStackTrace();
                                    continue;
                                }
                                throw err;
                            }
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
            return listOfLookupServices;
        }
    }

    private static ArrayList getServices(DocFlavor flavor, AttributeSet attributes) {
        PrintService[] services;
        ArrayList<PrintService> listOfServices = new ArrayList<PrintService>();
        Iterator psIterator = PrintServiceLookup.getAllLookupServices().iterator();
        while (psIterator.hasNext()) {
            try {
                PrintServiceLookup lus = (PrintServiceLookup)psIterator.next();
                services = null;
                if (flavor == null && attributes == null) {
                    try {
                        services = lus.getPrintServices();
                    }
                    catch (Throwable tr) {}
                } else {
                    services = lus.getPrintServices(flavor, attributes);
                }
                if (services == null) continue;
                for (int i = 0; i < services.length; ++i) {
                    listOfServices.add(services[i]);
                }
            }
            catch (Exception e) {
            }
        }
        ArrayList registeredServices = null;
        try {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkPrintJobAccess();
            }
            registeredServices = PrintServiceLookup.getRegisteredServices();
        }
        catch (SecurityException se) {
            // empty catch block
        }
        if (registeredServices != null) {
            services = registeredServices.toArray(new PrintService[registeredServices.size()]);
            for (int i = 0; i < services.length; ++i) {
                if (listOfServices.contains(services[i])) continue;
                if (flavor == null && attributes == null) {
                    listOfServices.add(services[i]);
                    continue;
                }
                if ((flavor == null || !services[i].isDocFlavorSupported(flavor)) && flavor != null || null != services[i].getUnsupportedAttributes(flavor, attributes)) continue;
                listOfServices.add(services[i]);
            }
        }
        return listOfServices;
    }

    private static ArrayList getMultiDocServices(DocFlavor[] flavors, AttributeSet attributes) {
        int i;
        PrintService[] services;
        ArrayList<PrintService> listOfServices = new ArrayList<PrintService>();
        Iterator psIterator = PrintServiceLookup.getAllLookupServices().iterator();
        while (psIterator.hasNext()) {
            try {
                PrintServiceLookup lus = (PrintServiceLookup)psIterator.next();
                services = lus.getMultiDocPrintServices(flavors, attributes);
                if (services == null) continue;
                for (i = 0; i < services.length; ++i) {
                    listOfServices.add(services[i]);
                }
            }
            catch (Exception e) {
            }
        }
        ArrayList registeredServices = null;
        try {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkPrintJobAccess();
            }
            registeredServices = PrintServiceLookup.getRegisteredServices();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (registeredServices != null) {
            services = registeredServices.toArray(new PrintService[registeredServices.size()]);
            for (i = 0; i < services.length; ++i) {
                if (!(services[i] instanceof MultiDocPrintService) || listOfServices.contains(services[i])) continue;
                if (flavors == null || flavors.length == 0) {
                    listOfServices.add(services[i]);
                    continue;
                }
                boolean supported = true;
                for (int f = 0; f < flavors.length; ++f) {
                    if (services[i].isDocFlavorSupported(flavors[f])) {
                        if (services[i].getUnsupportedAttributes(flavors[f], attributes) == null) continue;
                        supported = false;
                        break;
                    }
                    supported = false;
                    break;
                }
                if (!supported) continue;
                listOfServices.add(services[i]);
            }
        }
        return listOfServices;
    }

    static class Services {
        private ArrayList listOfLookupServices = null;
        private ArrayList registeredServices = null;

        Services() {
        }
    }
}

