/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.security.auth.kerberos.ServicePermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class KrbServicePermissionCollection
extends PermissionCollection
implements Serializable {
    private transient List<Permission> perms = new ArrayList<Permission>();
    private static final long serialVersionUID = -4118834211490102011L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", Vector.class)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof ServicePermission)) {
            return false;
        }
        ServicePermission np = (ServicePermission)permission;
        int desired = np.getMask();
        int effective = 0;
        int needed = desired;
        KrbServicePermissionCollection krbServicePermissionCollection = this;
        synchronized (krbServicePermissionCollection) {
            int len = this.perms.size();
            for (int i = 0; i < len; ++i) {
                ServicePermission x = (ServicePermission)this.perms.get(i);
                if ((needed & x.getMask()) == 0 || !x.impliesIgnoreMask(np)) continue;
                if (((effective |= x.getMask()) & desired) == desired) {
                    return true;
                }
                needed = desired ^ effective;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (!(permission instanceof ServicePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        KrbServicePermissionCollection krbServicePermissionCollection = this;
        synchronized (krbServicePermissionCollection) {
            this.perms.add(0, permission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<Permission> elements() {
        KrbServicePermissionCollection krbServicePermissionCollection = this;
        synchronized (krbServicePermissionCollection) {
            return Collections.enumeration(this.perms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        Vector<Permission> permissions = new Vector<Permission>(this.perms.size());
        KrbServicePermissionCollection krbServicePermissionCollection = this;
        synchronized (krbServicePermissionCollection) {
            permissions.addAll(this.perms);
        }
        ObjectOutputStream.PutField pfields = out.putFields();
        pfields.put("permissions", permissions);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gfields = in.readFields();
        Vector permissions = (Vector)gfields.get("permissions", null);
        this.perms = new ArrayList<Permission>(permissions.size());
        this.perms.addAll(permissions);
    }
}

