/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import com.sun.media.sound.JDK13Services;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import javax.sound.sampled.spi.AudioFileWriter;
import javax.sound.sampled.spi.FormatConversionProvider;
import javax.sound.sampled.spi.MixerProvider;

public class AudioSystem {
    public static final int NOT_SPECIFIED = -1;

    private AudioSystem() {
    }

    public static Mixer.Info[] getMixerInfo() {
        List infos = AudioSystem.getMixerInfoList();
        Mixer.Info[] allInfos = infos.toArray(new Mixer.Info[infos.size()]);
        return allInfos;
    }

    public static Mixer getMixer(Mixer.Info info) {
        int i;
        Object mixer = null;
        List providers = AudioSystem.getMixerProviders();
        for (i = 0; i < providers.size(); ++i) {
            try {
                return ((MixerProvider)providers.get(i)).getMixer(info);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        if (info == null) {
            for (i = 0; i < providers.size(); ++i) {
                try {
                    MixerProvider provider = (MixerProvider)providers.get(i);
                    Mixer.Info[] infos = provider.getMixerInfo();
                    for (int ii = 0; ii < infos.length; ++ii) {
                        try {
                            return provider.getMixer(infos[ii]);
                        }
                        catch (IllegalArgumentException e) {
                            continue;
                        }
                    }
                    continue;
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        throw new IllegalArgumentException("Mixer not supported: " + (info != null ? info.toString() : "null"));
    }

    public static Line.Info[] getSourceLineInfo(Line.Info info) {
        Vector<Line.Info> vector = new Vector<Line.Info>();
        Object fullInfo = null;
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            Mixer mixer = AudioSystem.getMixer(infoArray[i]);
            Line.Info[] currentInfoArray = mixer.getSourceLineInfo(info);
            for (int j = 0; j < currentInfoArray.length; ++j) {
                vector.addElement(currentInfoArray[j]);
            }
        }
        Line.Info[] returnedArray = new Line.Info[vector.size()];
        for (int i = 0; i < returnedArray.length; ++i) {
            returnedArray[i] = (Line.Info)vector.get(i);
        }
        return returnedArray;
    }

    public static Line.Info[] getTargetLineInfo(Line.Info info) {
        Vector<Line.Info> vector = new Vector<Line.Info>();
        Object fullInfo = null;
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            Mixer mixer = AudioSystem.getMixer(infoArray[i]);
            Line.Info[] currentInfoArray = mixer.getTargetLineInfo(info);
            for (int j = 0; j < currentInfoArray.length; ++j) {
                vector.addElement(currentInfoArray[j]);
            }
        }
        Line.Info[] returnedArray = new Line.Info[vector.size()];
        for (int i = 0; i < returnedArray.length; ++i) {
            returnedArray[i] = (Line.Info)vector.get(i);
        }
        return returnedArray;
    }

    public static boolean isLineSupported(Line.Info info) {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            Mixer mixer;
            if (infoArray[i] == null || !(mixer = AudioSystem.getMixer(infoArray[i])).isLineSupported(info)) continue;
            return true;
        }
        return false;
    }

    public static Line getLine(Line.Info info) throws LineUnavailableException {
        Mixer mixer;
        int j;
        Mixer.Info[] infos;
        MixerProvider provider;
        int i;
        LineUnavailableException lue = null;
        List providers = AudioSystem.getMixerProviders();
        try {
            Mixer mixer2 = AudioSystem.getDefaultMixer(providers, info);
            if (mixer2 != null && mixer2.isLineSupported(info)) {
                return mixer2.getLine(info);
            }
        }
        catch (LineUnavailableException e) {
            lue = e;
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        for (i = 0; i < providers.size(); ++i) {
            provider = (MixerProvider)providers.get(i);
            infos = provider.getMixerInfo();
            for (j = 0; j < infos.length; ++j) {
                try {
                    mixer = provider.getMixer(infos[j]);
                    if (!AudioSystem.isAppropriateMixer(mixer, info, true)) continue;
                    return mixer.getLine(info);
                }
                catch (LineUnavailableException e) {
                    lue = e;
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    // empty catch block
                }
            }
        }
        for (i = 0; i < providers.size(); ++i) {
            provider = (MixerProvider)providers.get(i);
            infos = provider.getMixerInfo();
            for (j = 0; j < infos.length; ++j) {
                try {
                    mixer = provider.getMixer(infos[j]);
                    if (!AudioSystem.isAppropriateMixer(mixer, info, false)) continue;
                    return mixer.getLine(info);
                }
                catch (LineUnavailableException e) {
                    lue = e;
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    // empty catch block
                }
            }
        }
        if (lue != null) {
            throw lue;
        }
        throw new IllegalArgumentException("No line matching " + info.toString() + " is supported.");
    }

    public static Clip getClip() throws LineUnavailableException {
        AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, true);
        DataLine.Info info = new DataLine.Info(Clip.class, format);
        return (Clip)AudioSystem.getLine(info);
    }

    public static Clip getClip(Mixer.Info mixerInfo) throws LineUnavailableException {
        AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, true);
        DataLine.Info info = new DataLine.Info(Clip.class, format);
        Mixer mixer = AudioSystem.getMixer(mixerInfo);
        return (Clip)mixer.getLine(info);
    }

    public static SourceDataLine getSourceDataLine(AudioFormat format) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        return (SourceDataLine)AudioSystem.getLine(info);
    }

    public static SourceDataLine getSourceDataLine(AudioFormat format, Mixer.Info mixerinfo) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        Mixer mixer = AudioSystem.getMixer(mixerinfo);
        return (SourceDataLine)mixer.getLine(info);
    }

    public static TargetDataLine getTargetDataLine(AudioFormat format) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
        return (TargetDataLine)AudioSystem.getLine(info);
    }

    public static TargetDataLine getTargetDataLine(AudioFormat format, Mixer.Info mixerinfo) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
        Mixer mixer = AudioSystem.getMixer(mixerinfo);
        return (TargetDataLine)mixer.getLine(info);
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat.Encoding sourceEncoding) {
        List codecs = AudioSystem.getFormatConversionProviders();
        Vector<AudioFormat.Encoding> encodings = new Vector<AudioFormat.Encoding>();
        AudioFormat.Encoding[] encs = null;
        for (int i = 0; i < codecs.size(); ++i) {
            FormatConversionProvider codec = (FormatConversionProvider)codecs.get(i);
            if (!codec.isSourceEncodingSupported(sourceEncoding)) continue;
            encs = codec.getTargetEncodings();
            for (int j = 0; j < encs.length; ++j) {
                encodings.addElement(encs[j]);
            }
        }
        AudioFormat.Encoding[] encs2 = encodings.toArray(new AudioFormat.Encoding[0]);
        return encs2;
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat sourceFormat) {
        List codecs = AudioSystem.getFormatConversionProviders();
        Vector<AudioFormat.Encoding[]> encodings = new Vector<AudioFormat.Encoding[]>();
        int size = 0;
        int index = 0;
        AudioFormat.Encoding[] encs = null;
        for (int i = 0; i < codecs.size(); ++i) {
            encs = ((FormatConversionProvider)codecs.get(i)).getTargetEncodings(sourceFormat);
            size += encs.length;
            encodings.addElement(encs);
        }
        AudioFormat.Encoding[] encs2 = new AudioFormat.Encoding[size];
        for (int i = 0; i < encodings.size(); ++i) {
            encs = (AudioFormat.Encoding[])encodings.get(i);
            for (int j = 0; j < encs.length; ++j) {
                encs2[index++] = encs[j];
            }
        }
        return encs2;
    }

    public static boolean isConversionSupported(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        List codecs = AudioSystem.getFormatConversionProviders();
        for (int i = 0; i < codecs.size(); ++i) {
            FormatConversionProvider codec = (FormatConversionProvider)codecs.get(i);
            if (!codec.isConversionSupported(targetEncoding, sourceFormat)) continue;
            return true;
        }
        return false;
    }

    public static AudioInputStream getAudioInputStream(AudioFormat.Encoding targetEncoding, AudioInputStream sourceStream) {
        List codecs = AudioSystem.getFormatConversionProviders();
        for (int i = 0; i < codecs.size(); ++i) {
            FormatConversionProvider codec = (FormatConversionProvider)codecs.get(i);
            if (!codec.isConversionSupported(targetEncoding, sourceStream.getFormat())) continue;
            return codec.getAudioInputStream(targetEncoding, sourceStream);
        }
        throw new IllegalArgumentException("Unsupported conversion: " + targetEncoding + " from " + sourceStream.getFormat());
    }

    public static AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        List codecs = AudioSystem.getFormatConversionProviders();
        Vector<AudioFormat[]> formats = new Vector<AudioFormat[]>();
        int size = 0;
        int index = 0;
        AudioFormat[] fmts = null;
        for (int i = 0; i < codecs.size(); ++i) {
            FormatConversionProvider codec = (FormatConversionProvider)codecs.get(i);
            fmts = codec.getTargetFormats(targetEncoding, sourceFormat);
            size += fmts.length;
            formats.addElement(fmts);
        }
        AudioFormat[] fmts2 = new AudioFormat[size];
        for (int i = 0; i < formats.size(); ++i) {
            fmts = (AudioFormat[])formats.get(i);
            for (int j = 0; j < fmts.length; ++j) {
                fmts2[index++] = fmts[j];
            }
        }
        return fmts2;
    }

    public static boolean isConversionSupported(AudioFormat targetFormat, AudioFormat sourceFormat) {
        List codecs = AudioSystem.getFormatConversionProviders();
        for (int i = 0; i < codecs.size(); ++i) {
            FormatConversionProvider codec = (FormatConversionProvider)codecs.get(i);
            if (!codec.isConversionSupported(targetFormat, sourceFormat)) continue;
            return true;
        }
        return false;
    }

    public static AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        if (sourceStream.getFormat().matches(targetFormat)) {
            return sourceStream;
        }
        List codecs = AudioSystem.getFormatConversionProviders();
        for (int i = 0; i < codecs.size(); ++i) {
            FormatConversionProvider codec = (FormatConversionProvider)codecs.get(i);
            if (!codec.isConversionSupported(targetFormat, sourceStream.getFormat())) continue;
            return codec.getAudioInputStream(targetFormat, sourceStream);
        }
        throw new IllegalArgumentException("Unsupported conversion: " + targetFormat + " from " + sourceStream.getFormat());
    }

    public static AudioFileFormat getAudioFileFormat(InputStream stream) throws UnsupportedAudioFileException, IOException {
        List providers = AudioSystem.getAudioFileReaders();
        AudioFileFormat format = null;
        for (int i = 0; i < providers.size(); ++i) {
            AudioFileReader reader = (AudioFileReader)providers.get(i);
            try {
                format = reader.getAudioFileFormat(stream);
                break;
            }
            catch (UnsupportedAudioFileException e) {
                continue;
            }
        }
        if (format == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return format;
    }

    public static AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        List providers = AudioSystem.getAudioFileReaders();
        AudioFileFormat format = null;
        for (int i = 0; i < providers.size(); ++i) {
            AudioFileReader reader = (AudioFileReader)providers.get(i);
            try {
                format = reader.getAudioFileFormat(url);
                break;
            }
            catch (UnsupportedAudioFileException e) {
                continue;
            }
        }
        if (format == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return format;
    }

    public static AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        List providers = AudioSystem.getAudioFileReaders();
        AudioFileFormat format = null;
        for (int i = 0; i < providers.size(); ++i) {
            AudioFileReader reader = (AudioFileReader)providers.get(i);
            try {
                format = reader.getAudioFileFormat(file);
                break;
            }
            catch (UnsupportedAudioFileException e) {
                continue;
            }
        }
        if (format == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return format;
    }

    public static AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        List providers = AudioSystem.getAudioFileReaders();
        AudioInputStream audioStream = null;
        for (int i = 0; i < providers.size(); ++i) {
            AudioFileReader reader = (AudioFileReader)providers.get(i);
            try {
                audioStream = reader.getAudioInputStream(stream);
                break;
            }
            catch (UnsupportedAudioFileException e) {
                continue;
            }
        }
        if (audioStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input stream");
        }
        return audioStream;
    }

    public static AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        List providers = AudioSystem.getAudioFileReaders();
        AudioInputStream audioStream = null;
        for (int i = 0; i < providers.size(); ++i) {
            AudioFileReader reader = (AudioFileReader)providers.get(i);
            try {
                audioStream = reader.getAudioInputStream(url);
                break;
            }
            catch (UnsupportedAudioFileException e) {
                continue;
            }
        }
        if (audioStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input URL");
        }
        return audioStream;
    }

    public static AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        List providers = AudioSystem.getAudioFileReaders();
        AudioInputStream audioStream = null;
        for (int i = 0; i < providers.size(); ++i) {
            AudioFileReader reader = (AudioFileReader)providers.get(i);
            try {
                audioStream = reader.getAudioInputStream(file);
                break;
            }
            catch (UnsupportedAudioFileException e) {
                continue;
            }
        }
        if (audioStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input file");
        }
        return audioStream;
    }

    public static AudioFileFormat.Type[] getAudioFileTypes() {
        List providers = AudioSystem.getAudioFileWriters();
        HashSet<AudioFileFormat.Type> returnTypesSet = new HashSet<AudioFileFormat.Type>();
        for (int i = 0; i < providers.size(); ++i) {
            AudioFileWriter writer = (AudioFileWriter)providers.get(i);
            AudioFileFormat.Type[] fileTypes = writer.getAudioFileTypes();
            for (int j = 0; j < fileTypes.length; ++j) {
                returnTypesSet.add(fileTypes[j]);
            }
        }
        AudioFileFormat.Type[] returnTypes = returnTypesSet.toArray(new AudioFileFormat.Type[0]);
        return returnTypes;
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type fileType) {
        List providers = AudioSystem.getAudioFileWriters();
        for (int i = 0; i < providers.size(); ++i) {
            AudioFileWriter writer = (AudioFileWriter)providers.get(i);
            if (!writer.isFileTypeSupported(fileType)) continue;
            return true;
        }
        return false;
    }

    public static AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream stream) {
        List providers = AudioSystem.getAudioFileWriters();
        HashSet<AudioFileFormat.Type> returnTypesSet = new HashSet<AudioFileFormat.Type>();
        for (int i = 0; i < providers.size(); ++i) {
            AudioFileWriter writer = (AudioFileWriter)providers.get(i);
            AudioFileFormat.Type[] fileTypes = writer.getAudioFileTypes(stream);
            for (int j = 0; j < fileTypes.length; ++j) {
                returnTypesSet.add(fileTypes[j]);
            }
        }
        AudioFileFormat.Type[] returnTypes = returnTypesSet.toArray(new AudioFileFormat.Type[0]);
        return returnTypes;
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type fileType, AudioInputStream stream) {
        List providers = AudioSystem.getAudioFileWriters();
        for (int i = 0; i < providers.size(); ++i) {
            AudioFileWriter writer = (AudioFileWriter)providers.get(i);
            if (!writer.isFileTypeSupported(fileType, stream)) continue;
            return true;
        }
        return false;
    }

    public static int write(AudioInputStream stream, AudioFileFormat.Type fileType, OutputStream out) throws IOException {
        List providers = AudioSystem.getAudioFileWriters();
        int bytesWritten = 0;
        boolean flag = false;
        for (int i = 0; i < providers.size(); ++i) {
            AudioFileWriter writer = (AudioFileWriter)providers.get(i);
            try {
                bytesWritten = writer.write(stream, fileType, out);
                flag = true;
                break;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
        }
        if (!flag) {
            throw new IllegalArgumentException("could not write audio file: file type not supported: " + fileType);
        }
        return bytesWritten;
    }

    public static int write(AudioInputStream stream, AudioFileFormat.Type fileType, File out) throws IOException {
        List providers = AudioSystem.getAudioFileWriters();
        int bytesWritten = 0;
        boolean flag = false;
        for (int i = 0; i < providers.size(); ++i) {
            AudioFileWriter writer = (AudioFileWriter)providers.get(i);
            try {
                bytesWritten = writer.write(stream, fileType, out);
                flag = true;
                break;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
        }
        if (!flag) {
            throw new IllegalArgumentException("could not write audio file: file type not supported: " + fileType);
        }
        return bytesWritten;
    }

    private static List getMixerProviders() {
        return AudioSystem.getProviders(MixerProvider.class);
    }

    private static List getFormatConversionProviders() {
        return AudioSystem.getProviders(FormatConversionProvider.class);
    }

    private static List getAudioFileReaders() {
        return AudioSystem.getProviders(AudioFileReader.class);
    }

    private static List getAudioFileWriters() {
        return AudioSystem.getProviders(AudioFileWriter.class);
    }

    private static Mixer getDefaultMixer(List providers, Line.Info info) {
        Mixer mixer;
        MixerProvider defaultProvider;
        Class<?> lineClass = info.getLineClass();
        String providerClassName = JDK13Services.getDefaultProviderClassName(lineClass);
        String instanceName = JDK13Services.getDefaultInstanceName(lineClass);
        if (providerClassName != null && (defaultProvider = AudioSystem.getNamedProvider(providerClassName, providers)) != null && (instanceName != null ? (mixer = AudioSystem.getNamedMixer(instanceName, defaultProvider, info)) != null : (mixer = AudioSystem.getFirstMixer(defaultProvider, info, false)) != null)) {
            return mixer;
        }
        if (instanceName != null && (mixer = AudioSystem.getNamedMixer(instanceName, providers, info)) != null) {
            return mixer;
        }
        return null;
    }

    private static MixerProvider getNamedProvider(String providerClassName, List providers) {
        for (int i = 0; i < providers.size(); ++i) {
            MixerProvider provider = (MixerProvider)providers.get(i);
            if (!provider.getClass().getName().equals(providerClassName)) continue;
            return provider;
        }
        return null;
    }

    private static Mixer getNamedMixer(String mixerName, MixerProvider provider, Line.Info info) {
        Mixer.Info[] infos = provider.getMixerInfo();
        for (int i = 0; i < infos.length; ++i) {
            Mixer mixer;
            if (!infos[i].getName().equals(mixerName) || !AudioSystem.isAppropriateMixer(mixer = provider.getMixer(infos[i]), info, false)) continue;
            return mixer;
        }
        return null;
    }

    private static Mixer getNamedMixer(String mixerName, List providers, Line.Info info) {
        for (int i = 0; i < providers.size(); ++i) {
            MixerProvider provider = (MixerProvider)providers.get(i);
            Mixer mixer = AudioSystem.getNamedMixer(mixerName, provider, info);
            if (mixer == null) continue;
            return mixer;
        }
        return null;
    }

    private static Mixer getFirstMixer(MixerProvider provider, Line.Info info, boolean isMixingRequired) {
        Mixer.Info[] infos = provider.getMixerInfo();
        for (int j = 0; j < infos.length; ++j) {
            Mixer mixer = provider.getMixer(infos[j]);
            if (!AudioSystem.isAppropriateMixer(mixer, info, isMixingRequired)) continue;
            return mixer;
        }
        return null;
    }

    private static boolean isAppropriateMixer(Mixer mixer, Line.Info lineInfo, boolean isMixingRequired) {
        if (!mixer.isLineSupported(lineInfo)) {
            return false;
        }
        Class<?> lineClass = lineInfo.getLineClass();
        if (isMixingRequired && (SourceDataLine.class.isAssignableFrom(lineClass) || Clip.class.isAssignableFrom(lineClass))) {
            int maxLines = mixer.getMaxLines(lineInfo);
            return maxLines == -1 || maxLines > 1;
        }
        return true;
    }

    private static List getMixerInfoList() {
        List providers = AudioSystem.getMixerProviders();
        return AudioSystem.getMixerInfoList(providers);
    }

    private static List getMixerInfoList(List providers) {
        ArrayList<Mixer.Info> infos = new ArrayList<Mixer.Info>();
        for (int i = 0; i < providers.size(); ++i) {
            Mixer.Info[] someInfos = ((MixerProvider)providers.get(i)).getMixerInfo();
            for (int j = 0; j < someInfos.length; ++j) {
                infos.add(someInfos[j]);
            }
        }
        return infos;
    }

    private static List getProviders(Class providerClass) {
        return JDK13Services.getProviders(providerClass);
    }
}

