/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.Spring;

public class SpringLayout
implements LayoutManager2 {
    private Map componentConstraints = new HashMap();
    private Spring cyclicReference = Spring.constant(Integer.MIN_VALUE);
    private Set cyclicSprings;
    private Set acyclicSprings;
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String HORIZONTAL_CENTER = "HorizontalCenter";
    public static final String VERTICAL_CENTER = "VerticalCenter";
    public static final String BASELINE = "Baseline";
    public static final String WIDTH = "Width";
    public static final String HEIGHT = "Height";
    private static String[] ALL_HORIZONTAL = new String[]{"West", "Width", "East", "HorizontalCenter"};
    private static String[] ALL_VERTICAL = new String[]{"North", "Height", "South", "VerticalCenter", "Baseline"};

    private void resetCyclicStatuses() {
        this.cyclicSprings = new HashSet();
        this.acyclicSprings = new HashSet();
    }

    private void setParent(Container p) {
        Spring height;
        this.resetCyclicStatuses();
        Constraints pc = this.getConstraints(p);
        pc.setX(Spring.constant(0));
        pc.setY(Spring.constant(0));
        Spring width = pc.getWidth();
        if (width instanceof Spring.WidthSpring && ((Spring.WidthSpring)width).c == p) {
            pc.setWidth(Spring.constant(0, 0, Integer.MAX_VALUE));
        }
        if ((height = pc.getHeight()) instanceof Spring.HeightSpring && ((Spring.HeightSpring)height).c == p) {
            pc.setHeight(Spring.constant(0, 0, Integer.MAX_VALUE));
        }
    }

    boolean isCyclic(Spring s) {
        if (s == null) {
            return false;
        }
        if (this.cyclicSprings.contains(s)) {
            return true;
        }
        if (this.acyclicSprings.contains(s)) {
            return false;
        }
        this.cyclicSprings.add(s);
        boolean result = s.isCyclic(this);
        if (!result) {
            this.acyclicSprings.add(s);
            this.cyclicSprings.remove(s);
        } else {
            System.err.println(s + " is cyclic. ");
        }
        return result;
    }

    private Spring abandonCycles(Spring s) {
        return this.isCyclic(s) ? this.cyclicReference : s;
    }

    @Override
    public void addLayoutComponent(String name, Component c) {
    }

    @Override
    public void removeLayoutComponent(Component c) {
        this.componentConstraints.remove(c);
    }

    private static Dimension addInsets(int width, int height, Container p) {
        Insets i = p.getInsets();
        return new Dimension(width + i.left + i.right, height + i.top + i.bottom);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        this.setParent(parent);
        Constraints pc = this.getConstraints(parent);
        return SpringLayout.addInsets(this.abandonCycles(pc.getWidth()).getMinimumValue(), this.abandonCycles(pc.getHeight()).getMinimumValue(), parent);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        this.setParent(parent);
        Constraints pc = this.getConstraints(parent);
        return SpringLayout.addInsets(this.abandonCycles(pc.getWidth()).getPreferredValue(), this.abandonCycles(pc.getHeight()).getPreferredValue(), parent);
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        this.setParent(parent);
        Constraints pc = this.getConstraints(parent);
        return SpringLayout.addInsets(this.abandonCycles(pc.getWidth()).getMaximumValue(), this.abandonCycles(pc.getHeight()).getMaximumValue(), parent);
    }

    @Override
    public void addLayoutComponent(Component component, Object constraints) {
        if (constraints instanceof Constraints) {
            this.putConstraints(component, (Constraints)constraints);
        }
    }

    @Override
    public float getLayoutAlignmentX(Container p) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container p) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container p) {
    }

    public void putConstraint(String e1, Component c1, int pad, String e2, Component c2) {
        this.putConstraint(e1, c1, Spring.constant(pad), e2, c2);
    }

    public void putConstraint(String e1, Component c1, Spring s, String e2, Component c2) {
        this.putConstraint(e1, c1, Spring.sum(s, this.getConstraint(e2, c2)));
    }

    private void putConstraint(String e, Component c, Spring s) {
        if (s != null) {
            this.getConstraints(c).setConstraint(e, s);
        }
    }

    private Constraints applyDefaults(Component c, Constraints constraints) {
        if (constraints == null) {
            constraints = new Constraints();
        }
        if (constraints.c == null) {
            constraints.c = c;
        }
        if (constraints.horizontalHistory.size() < 2) {
            this.applyDefaults(constraints, WEST, Spring.constant(0), WIDTH, Spring.width(c), constraints.horizontalHistory);
        }
        if (constraints.verticalHistory.size() < 2) {
            this.applyDefaults(constraints, NORTH, Spring.constant(0), HEIGHT, Spring.height(c), constraints.verticalHistory);
        }
        return constraints;
    }

    private void applyDefaults(Constraints constraints, String name1, Spring spring1, String name2, Spring spring2, List<String> history) {
        if (history.size() == 0) {
            constraints.setConstraint(name1, spring1);
            constraints.setConstraint(name2, spring2);
        } else {
            if (constraints.getConstraint(name2) == null) {
                constraints.setConstraint(name2, spring2);
            } else {
                constraints.setConstraint(name1, spring1);
            }
            Collections.rotate(history, 1);
        }
    }

    private void putConstraints(Component component, Constraints constraints) {
        this.componentConstraints.put(component, this.applyDefaults(component, constraints));
    }

    public Constraints getConstraints(Component c) {
        Constraints result = (Constraints)this.componentConstraints.get(c);
        if (result == null) {
            Object cp;
            if (c instanceof JComponent && (cp = ((JComponent)c).getClientProperty(SpringLayout.class)) instanceof Constraints) {
                return this.applyDefaults(c, (Constraints)cp);
            }
            result = new Constraints();
            this.putConstraints(c, result);
        }
        return result;
    }

    public Spring getConstraint(String edgeName, Component c) {
        edgeName = edgeName.intern();
        return new SpringProxy(edgeName, c, this);
    }

    @Override
    public void layoutContainer(Container parent) {
        this.setParent(parent);
        int n = parent.getComponentCount();
        this.getConstraints(parent).reset();
        for (int i = 0; i < n; ++i) {
            this.getConstraints(parent.getComponent(i)).reset();
        }
        Insets insets = parent.getInsets();
        Constraints pc = this.getConstraints(parent);
        this.abandonCycles(pc.getX()).setValue(0);
        this.abandonCycles(pc.getY()).setValue(0);
        this.abandonCycles(pc.getWidth()).setValue(parent.getWidth() - insets.left - insets.right);
        this.abandonCycles(pc.getHeight()).setValue(parent.getHeight() - insets.top - insets.bottom);
        for (int i = 0; i < n; ++i) {
            Component c = parent.getComponent(i);
            Constraints cc = this.getConstraints(c);
            int x = this.abandonCycles(cc.getX()).getValue();
            int y = this.abandonCycles(cc.getY()).getValue();
            int width = this.abandonCycles(cc.getWidth()).getValue();
            int height = this.abandonCycles(cc.getHeight()).getValue();
            c.setBounds(insets.left + x, insets.top + y, width, height);
        }
    }

    private static class SpringProxy
    extends Spring {
        private String edgeName;
        private Component c;
        private SpringLayout l;

        public SpringProxy(String edgeName, Component c, SpringLayout l) {
            this.edgeName = edgeName;
            this.c = c;
            this.l = l;
        }

        private Spring getConstraint() {
            return this.l.getConstraints(this.c).getConstraint(this.edgeName);
        }

        @Override
        public int getMinimumValue() {
            return this.getConstraint().getMinimumValue();
        }

        @Override
        public int getPreferredValue() {
            return this.getConstraint().getPreferredValue();
        }

        @Override
        public int getMaximumValue() {
            return this.getConstraint().getMaximumValue();
        }

        @Override
        public int getValue() {
            return this.getConstraint().getValue();
        }

        @Override
        public void setValue(int size) {
            this.getConstraint().setValue(size);
        }

        @Override
        boolean isCyclic(SpringLayout l) {
            return l.isCyclic(this.getConstraint());
        }

        public String toString() {
            return "SpringProxy for " + this.edgeName + " edge of " + this.c.getName() + ".";
        }
    }

    public static class Constraints {
        private Spring x;
        private Spring y;
        private Spring width;
        private Spring height;
        private Spring east;
        private Spring south;
        private Spring horizontalCenter;
        private Spring verticalCenter;
        private Spring baseline;
        private List<String> horizontalHistory = new ArrayList<String>(2);
        private List<String> verticalHistory = new ArrayList<String>(2);
        private Component c;

        public Constraints() {
        }

        public Constraints(Spring x, Spring y) {
            this.setX(x);
            this.setY(y);
        }

        public Constraints(Spring x, Spring y, Spring width, Spring height) {
            this.setX(x);
            this.setY(y);
            this.setWidth(width);
            this.setHeight(height);
        }

        public Constraints(Component c) {
            this.c = c;
            this.setX(Spring.constant(c.getX()));
            this.setY(Spring.constant(c.getY()));
            this.setWidth(Spring.width(c));
            this.setHeight(Spring.height(c));
        }

        private void pushConstraint(String name, Spring value, boolean horizontal) {
            List<String> history;
            boolean valid = true;
            List<String> list = history = horizontal ? this.horizontalHistory : this.verticalHistory;
            if (history.contains(name)) {
                history.remove(name);
                valid = false;
            } else if (history.size() == 2 && value != null) {
                history.remove(0);
                valid = false;
            }
            if (value != null) {
                history.add(name);
            }
            if (!valid) {
                String[] all = horizontal ? ALL_HORIZONTAL : ALL_VERTICAL;
                for (int i = 0; i < all.length; ++i) {
                    String s = all[i];
                    if (history.contains(s)) continue;
                    this.setConstraint(s, null);
                }
            }
        }

        private Spring sum(Spring s1, Spring s2) {
            return s1 == null || s2 == null ? null : Spring.sum(s1, s2);
        }

        private Spring difference(Spring s1, Spring s2) {
            return s1 == null || s2 == null ? null : Spring.difference(s1, s2);
        }

        private Spring scale(Spring s, float factor) {
            return s == null ? null : Spring.scale(s, factor);
        }

        private int getBaselineFromHeight(int height) {
            if (height < 0) {
                return -this.c.getBaseline(this.c.getPreferredSize().width, -height);
            }
            return this.c.getBaseline(this.c.getPreferredSize().width, height);
        }

        private int getHeightFromBaseLine(int baseline) {
            Dimension prefSize = this.c.getPreferredSize();
            int prefHeight = prefSize.height;
            int prefBaseline = this.c.getBaseline(prefSize.width, prefHeight);
            if (prefBaseline == baseline) {
                return prefHeight;
            }
            switch (this.c.getBaselineResizeBehavior()) {
                case CONSTANT_DESCENT: {
                    return prefHeight + (baseline - prefBaseline);
                }
                case CENTER_OFFSET: {
                    return prefHeight + 2 * (baseline - prefBaseline);
                }
            }
            return Integer.MIN_VALUE;
        }

        private Spring heightToRelativeBaseline(Spring s) {
            return new Spring.SpringMap(s){

                @Override
                protected int map(int i) {
                    return Constraints.this.getBaselineFromHeight(i);
                }

                @Override
                protected int inv(int i) {
                    return Constraints.this.getHeightFromBaseLine(i);
                }
            };
        }

        private Spring relativeBaselineToHeight(Spring s) {
            return new Spring.SpringMap(s){

                @Override
                protected int map(int i) {
                    return Constraints.this.getHeightFromBaseLine(i);
                }

                @Override
                protected int inv(int i) {
                    return Constraints.this.getBaselineFromHeight(i);
                }
            };
        }

        private boolean defined(List history, String s1, String s2) {
            return history.contains(s1) && history.contains(s2);
        }

        public void setX(Spring x) {
            this.x = x;
            this.pushConstraint(SpringLayout.WEST, x, true);
        }

        public Spring getX() {
            if (this.x == null) {
                if (this.defined(this.horizontalHistory, SpringLayout.EAST, SpringLayout.WIDTH)) {
                    this.x = this.difference(this.east, this.width);
                } else if (this.defined(this.horizontalHistory, SpringLayout.HORIZONTAL_CENTER, SpringLayout.WIDTH)) {
                    this.x = this.difference(this.horizontalCenter, this.scale(this.width, 0.5f));
                } else if (this.defined(this.horizontalHistory, SpringLayout.HORIZONTAL_CENTER, SpringLayout.EAST)) {
                    this.x = this.difference(this.scale(this.horizontalCenter, 2.0f), this.east);
                }
            }
            return this.x;
        }

        public void setY(Spring y) {
            this.y = y;
            this.pushConstraint(SpringLayout.NORTH, y, false);
        }

        public Spring getY() {
            if (this.y == null) {
                if (this.defined(this.verticalHistory, SpringLayout.SOUTH, SpringLayout.HEIGHT)) {
                    this.y = this.difference(this.south, this.height);
                } else if (this.defined(this.verticalHistory, SpringLayout.VERTICAL_CENTER, SpringLayout.HEIGHT)) {
                    this.y = this.difference(this.verticalCenter, this.scale(this.height, 0.5f));
                } else if (this.defined(this.verticalHistory, SpringLayout.VERTICAL_CENTER, SpringLayout.SOUTH)) {
                    this.y = this.difference(this.scale(this.verticalCenter, 2.0f), this.south);
                } else if (this.defined(this.verticalHistory, SpringLayout.BASELINE, SpringLayout.HEIGHT)) {
                    this.y = this.difference(this.baseline, this.heightToRelativeBaseline(this.height));
                } else if (this.defined(this.verticalHistory, SpringLayout.BASELINE, SpringLayout.SOUTH)) {
                    this.y = this.scale(this.difference(this.baseline, this.heightToRelativeBaseline(this.south)), 2.0f);
                }
            }
            return this.y;
        }

        public void setWidth(Spring width) {
            this.width = width;
            this.pushConstraint(SpringLayout.WIDTH, width, true);
        }

        public Spring getWidth() {
            if (this.width == null) {
                if (this.horizontalHistory.contains(SpringLayout.EAST)) {
                    this.width = this.difference(this.east, this.getX());
                } else if (this.horizontalHistory.contains(SpringLayout.HORIZONTAL_CENTER)) {
                    this.width = this.scale(this.difference(this.horizontalCenter, this.getX()), 2.0f);
                }
            }
            return this.width;
        }

        public void setHeight(Spring height) {
            this.height = height;
            this.pushConstraint(SpringLayout.HEIGHT, height, false);
        }

        public Spring getHeight() {
            if (this.height == null) {
                if (this.verticalHistory.contains(SpringLayout.SOUTH)) {
                    this.height = this.difference(this.south, this.getY());
                } else if (this.verticalHistory.contains(SpringLayout.VERTICAL_CENTER)) {
                    this.height = this.scale(this.difference(this.verticalCenter, this.getY()), 2.0f);
                } else if (this.verticalHistory.contains(SpringLayout.BASELINE)) {
                    this.height = this.relativeBaselineToHeight(this.difference(this.baseline, this.getY()));
                }
            }
            return this.height;
        }

        private void setEast(Spring east) {
            this.east = east;
            this.pushConstraint(SpringLayout.EAST, east, true);
        }

        private Spring getEast() {
            if (this.east == null) {
                this.east = this.sum(this.getX(), this.getWidth());
            }
            return this.east;
        }

        private void setSouth(Spring south) {
            this.south = south;
            this.pushConstraint(SpringLayout.SOUTH, south, false);
        }

        private Spring getSouth() {
            if (this.south == null) {
                this.south = this.sum(this.getY(), this.getHeight());
            }
            return this.south;
        }

        private Spring getHorizontalCenter() {
            if (this.horizontalCenter == null) {
                this.horizontalCenter = this.sum(this.getX(), this.scale(this.getWidth(), 0.5f));
            }
            return this.horizontalCenter;
        }

        private void setHorizontalCenter(Spring horizontalCenter) {
            this.horizontalCenter = horizontalCenter;
            this.pushConstraint(SpringLayout.HORIZONTAL_CENTER, horizontalCenter, true);
        }

        private Spring getVerticalCenter() {
            if (this.verticalCenter == null) {
                this.verticalCenter = this.sum(this.getY(), this.scale(this.getHeight(), 0.5f));
            }
            return this.verticalCenter;
        }

        private void setVerticalCenter(Spring verticalCenter) {
            this.verticalCenter = verticalCenter;
            this.pushConstraint(SpringLayout.VERTICAL_CENTER, verticalCenter, false);
        }

        private Spring getBaseline() {
            if (this.baseline == null) {
                this.baseline = this.sum(this.getY(), this.heightToRelativeBaseline(this.getHeight()));
            }
            return this.baseline;
        }

        private void setBaseline(Spring baseline) {
            this.baseline = baseline;
            this.pushConstraint(SpringLayout.BASELINE, baseline, false);
        }

        public void setConstraint(String edgeName, Spring s) {
            if ((edgeName = edgeName.intern()) == SpringLayout.WEST) {
                this.setX(s);
            } else if (edgeName == SpringLayout.NORTH) {
                this.setY(s);
            } else if (edgeName == SpringLayout.EAST) {
                this.setEast(s);
            } else if (edgeName == SpringLayout.SOUTH) {
                this.setSouth(s);
            } else if (edgeName == SpringLayout.HORIZONTAL_CENTER) {
                this.setHorizontalCenter(s);
            } else if (edgeName == SpringLayout.WIDTH) {
                this.setWidth(s);
            } else if (edgeName == SpringLayout.HEIGHT) {
                this.setHeight(s);
            } else if (edgeName == SpringLayout.VERTICAL_CENTER) {
                this.setVerticalCenter(s);
            } else if (edgeName == SpringLayout.BASELINE) {
                this.setBaseline(s);
            }
        }

        public Spring getConstraint(String edgeName) {
            return (edgeName = edgeName.intern()) == SpringLayout.WEST ? this.getX() : (edgeName == SpringLayout.NORTH ? this.getY() : (edgeName == SpringLayout.EAST ? this.getEast() : (edgeName == SpringLayout.SOUTH ? this.getSouth() : (edgeName == SpringLayout.WIDTH ? this.getWidth() : (edgeName == SpringLayout.HEIGHT ? this.getHeight() : (edgeName == SpringLayout.HORIZONTAL_CENTER ? this.getHorizontalCenter() : (edgeName == SpringLayout.VERTICAL_CENTER ? this.getVerticalCenter() : (edgeName == SpringLayout.BASELINE ? this.getBaseline() : null))))))));
        }

        void reset() {
            Spring[] allSprings = new Spring[]{this.x, this.y, this.width, this.height, this.east, this.south, this.horizontalCenter, this.verticalCenter, this.baseline};
            for (int i = 0; i < allSprings.length; ++i) {
                Spring s = allSprings[i];
                if (s == null) continue;
                s.setValue(Integer.MIN_VALUE);
            }
        }
    }
}

