/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractColorChooserPanel
extends JPanel {
    private JColorChooser chooser;
    private ChangeListener colorListener;
    private boolean dirty = true;

    public abstract void updateChooser();

    protected abstract void buildChooser();

    public abstract String getDisplayName();

    public int getMnemonic() {
        return 0;
    }

    public int getDisplayedMnemonicIndex() {
        return -1;
    }

    public abstract Icon getSmallDisplayIcon();

    public abstract Icon getLargeDisplayIcon();

    public void installChooserPanel(JColorChooser enclosingChooser) {
        if (this.chooser != null) {
            throw new RuntimeException("This chooser panel is already installed");
        }
        this.chooser = enclosingChooser;
        this.buildChooser();
        this.updateChooser();
        this.colorListener = new ModelListener();
        this.getColorSelectionModel().addChangeListener(this.colorListener);
    }

    public void uninstallChooserPanel(JColorChooser enclosingChooser) {
        this.getColorSelectionModel().removeChangeListener(this.colorListener);
        this.chooser = null;
    }

    public ColorSelectionModel getColorSelectionModel() {
        return this.chooser.getSelectionModel();
    }

    protected Color getColorFromModel() {
        return this.getColorSelectionModel().getSelectedColor();
    }

    @Override
    public void paint(Graphics g) {
        if (this.dirty) {
            this.updateChooser();
            this.dirty = false;
        }
        super.paint(g);
    }

    static int getInt(Object key, int defaultValue) {
        Object value = UIManager.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    class ModelListener
    implements ChangeListener,
    Serializable {
        ModelListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (AbstractColorChooserPanel.this.isShowing()) {
                AbstractColorChooserPanel.this.updateChooser();
                AbstractColorChooserPanel.this.dirty = false;
            } else {
                AbstractColorChooserPanel.this.dirty = true;
            }
        }
    }
}

