/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDesktopPaneUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthDesktopPaneUI
extends BasicDesktopPaneUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;
    private TaskBar taskBar;
    private DesktopManager oldDesktopManager;

    SynthDesktopPaneUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return new SynthDesktopPaneUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.desktop.addPropertyChangeListener(this);
        if (this.taskBar != null) {
            this.desktop.addComponentListener(this.taskBar);
            this.desktop.addContainerListener(this.taskBar);
        }
    }

    @Override
    protected void installDefaults() {
        this.updateStyle(this.desktop);
        if (UIManager.getBoolean("InternalFrame.useTaskBar")) {
            this.taskBar = new TaskBar();
            for (Component comp : this.desktop.getComponents()) {
                JInternalFrame.JDesktopIcon desktopIcon;
                if (comp instanceof JInternalFrame.JDesktopIcon) {
                    desktopIcon = (JInternalFrame.JDesktopIcon)comp;
                } else {
                    if (!(comp instanceof JInternalFrame)) continue;
                    desktopIcon = ((JInternalFrame)comp).getDesktopIcon();
                }
                if (desktopIcon.getParent() == this.desktop) {
                    this.desktop.remove(desktopIcon);
                }
                if (desktopIcon.getParent() == this.taskBar) continue;
                this.taskBar.add(desktopIcon);
                desktopIcon.getInternalFrame().addComponentListener(this.taskBar);
            }
            this.taskBar.setBackground(this.desktop.getBackground());
            this.desktop.add((Component)this.taskBar, new Integer(JLayeredPane.PALETTE_LAYER + 1));
            if (this.desktop.isShowing()) {
                this.taskBar.adjustSize();
            }
        }
    }

    private void updateStyle(JDesktopPane c) {
        SynthStyle oldStyle = this.style;
        SynthContext context = this.getContext(c, 1);
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (oldStyle != null) {
            this.uninstallKeyboardActions();
            this.installKeyboardActions();
        }
        context.dispose();
    }

    @Override
    protected void uninstallListeners() {
        if (this.taskBar != null) {
            this.desktop.removeComponentListener(this.taskBar);
            this.desktop.removeContainerListener(this.taskBar);
        }
        this.desktop.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    @Override
    protected void uninstallDefaults() {
        SynthContext context = this.getContext(this.desktop, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
        if (this.taskBar != null) {
            for (Component comp : this.taskBar.getComponents()) {
                JInternalFrame.JDesktopIcon desktopIcon = (JInternalFrame.JDesktopIcon)comp;
                this.taskBar.remove(desktopIcon);
                desktopIcon.setPreferredSize(null);
                JInternalFrame f = desktopIcon.getInternalFrame();
                if (f.isIcon()) {
                    this.desktop.add(desktopIcon);
                }
                f.removeComponentListener(this.taskBar);
            }
            this.desktop.remove(this.taskBar);
            this.taskBar = null;
        }
    }

    @Override
    protected void installDesktopManager() {
        if (UIManager.getBoolean("InternalFrame.useTaskBar")) {
            this.desktopManager = this.oldDesktopManager = this.desktop.getDesktopManager();
            if (!(this.desktopManager instanceof SynthDesktopManager)) {
                this.desktopManager = new SynthDesktopManager();
                this.desktop.setDesktopManager(this.desktopManager);
            }
        } else {
            super.installDesktopManager();
        }
    }

    @Override
    protected void uninstallDesktopManager() {
        if (this.oldDesktopManager != null && !(this.oldDesktopManager instanceof UIResource)) {
            this.desktopManager = this.desktop.getDesktopManager();
            if (this.desktopManager == null || this.desktopManager instanceof UIResource) {
                this.desktop.setDesktopManager(this.oldDesktopManager);
            }
        }
        this.oldDesktopManager = null;
        super.uninstallDesktopManager();
    }

    @Override
    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private Region getRegion(JComponent c) {
        return SynthLookAndFeel.getRegion(c);
    }

    private int getComponentState(JComponent c) {
        return SynthLookAndFeel.getComponentState(c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintDesktopPaneBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintDesktopPaneBorder(context, g, x, y, w, h);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (SynthLookAndFeel.shouldUpdateStyle(evt)) {
            this.updateStyle((JDesktopPane)evt.getSource());
        }
        if (evt.getPropertyName() == "ancestor" && this.taskBar != null) {
            this.taskBar.adjustSize();
        }
    }

    class SynthDesktopManager
    extends DefaultDesktopManager
    implements UIResource {
        SynthDesktopManager() {
        }

        @Override
        public void maximizeFrame(JInternalFrame f) {
            if (f.isIcon()) {
                try {
                    f.setIcon(false);
                }
                catch (PropertyVetoException e2) {}
            } else {
                f.setNormalBounds(f.getBounds());
                Container desktop = f.getParent();
                this.setBoundsForFrame(f, 0, 0, desktop.getWidth(), desktop.getHeight() - SynthDesktopPaneUI.this.taskBar.getHeight());
            }
            try {
                f.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        @Override
        public void iconifyFrame(JInternalFrame f) {
            Container c = f.getParent();
            JDesktopPane d = f.getDesktopPane();
            boolean findNext = f.isSelected();
            if (c == null) {
                return;
            }
            JInternalFrame.JDesktopIcon desktopIcon = f.getDesktopIcon();
            if (!f.isMaximum()) {
                f.setNormalBounds(f.getBounds());
            }
            c.remove(f);
            c.repaint(f.getX(), f.getY(), f.getWidth(), f.getHeight());
            try {
                f.setSelected(false);
            }
            catch (PropertyVetoException e2) {
                // empty catch block
            }
            if (findNext) {
                for (Component comp : c.getComponents()) {
                    if (!(comp instanceof JInternalFrame)) continue;
                    try {
                        ((JInternalFrame)comp).setSelected(true);
                    }
                    catch (PropertyVetoException e2) {
                        // empty catch block
                    }
                    ((JInternalFrame)comp).moveToFront();
                    return;
                }
            }
        }

        @Override
        public void deiconifyFrame(JInternalFrame f) {
            JInternalFrame.JDesktopIcon desktopIcon = f.getDesktopIcon();
            Container c = desktopIcon.getParent();
            if (c != null && (c = c.getParent()) != null) {
                c.add(f);
                if (f.isMaximum()) {
                    int w = c.getWidth();
                    int h = c.getHeight() - SynthDesktopPaneUI.this.taskBar.getHeight();
                    if (f.getWidth() != w || f.getHeight() != h) {
                        this.setBoundsForFrame(f, 0, 0, w, h);
                    }
                }
                if (f.isSelected()) {
                    f.moveToFront();
                } else {
                    try {
                        f.setSelected(true);
                    }
                    catch (PropertyVetoException e2) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        protected void removeIconFor(JInternalFrame f) {
            super.removeIconFor(f);
            SynthDesktopPaneUI.this.taskBar.validate();
        }

        @Override
        public void setBoundsForFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
            super.setBoundsForFrame(f, newX, newY, newWidth, newHeight);
            if (SynthDesktopPaneUI.this.taskBar != null && newY >= SynthDesktopPaneUI.this.taskBar.getY()) {
                f.setLocation(f.getX(), SynthDesktopPaneUI.this.taskBar.getY() - f.getInsets().top);
            }
        }
    }

    static class TaskBar
    extends JPanel
    implements ComponentListener,
    ContainerListener {
        TaskBar() {
            this.setOpaque(true);
            this.setLayout(new FlowLayout(0, 0, 0){

                @Override
                public void layoutContainer(Container target) {
                    Component[] comps = target.getComponents();
                    int n = comps.length;
                    if (n > 0) {
                        int prefWidth = 0;
                        for (Component c : comps) {
                            c.setPreferredSize(null);
                            Dimension prefSize = c.getPreferredSize();
                            if (prefSize.width <= prefWidth) continue;
                            prefWidth = prefSize.width;
                        }
                        Insets insets = target.getInsets();
                        int tw = target.getWidth() - insets.left - insets.right;
                        int w = Math.min(prefWidth, Math.max(10, tw / n));
                        for (Component c : comps) {
                            Dimension prefSize = c.getPreferredSize();
                            c.setPreferredSize(new Dimension(w, prefSize.height));
                        }
                    }
                    super.layoutContainer(target);
                }
            });
            this.setBorder(new BevelBorder(0){

                @Override
                protected void paintRaisedBevel(Component c, Graphics g, int x, int y, int w, int h) {
                    Color oldColor = g.getColor();
                    g.translate(x, y);
                    g.setColor(this.getHighlightOuterColor(c));
                    g.drawLine(0, 0, 0, h - 2);
                    g.drawLine(1, 0, w - 2, 0);
                    g.setColor(this.getShadowOuterColor(c));
                    g.drawLine(0, h - 1, w - 1, h - 1);
                    g.drawLine(w - 1, 0, w - 1, h - 2);
                    g.translate(-x, -y);
                    g.setColor(oldColor);
                }
            });
        }

        void adjustSize() {
            JDesktopPane desktop = (JDesktopPane)this.getParent();
            if (desktop != null) {
                int height = this.getPreferredSize().height;
                Insets insets = this.getInsets();
                if (height == insets.top + insets.bottom) {
                    height = this.getHeight() <= height ? (height += 21) : this.getHeight();
                }
                this.setBounds(0, desktop.getHeight() - height, desktop.getWidth(), height);
                this.revalidate();
                this.repaint();
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (e.getSource() instanceof JDesktopPane) {
                this.adjustSize();
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            if (e.getSource() instanceof JInternalFrame) {
                this.adjustSize();
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            if (e.getSource() instanceof JInternalFrame) {
                ((JInternalFrame)e.getSource()).getDesktopIcon().setVisible(false);
                this.revalidate();
            }
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            if (e.getChild() instanceof JInternalFrame) {
                JDesktopPane desktop = (JDesktopPane)e.getSource();
                JInternalFrame f = (JInternalFrame)e.getChild();
                JInternalFrame.JDesktopIcon desktopIcon = f.getDesktopIcon();
                for (Component comp : this.getComponents()) {
                    if (comp != desktopIcon) continue;
                    return;
                }
                this.add(desktopIcon);
                f.addComponentListener(this);
                if (this.getComponentCount() == 1) {
                    this.adjustSize();
                }
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            JInternalFrame f;
            if (e.getChild() instanceof JInternalFrame && !(f = (JInternalFrame)e.getChild()).isIcon()) {
                this.remove(f.getDesktopIcon());
                f.removeComponentListener(this);
                this.revalidate();
                this.repaint();
            }
        }
    }
}

