/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;

public class OrientableFlowLayout
extends FlowLayout {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int TOP = 0;
    public static final int BOTTOM = 2;
    int orientation;
    int vAlign;
    int vHGap;
    int vVGap;

    public OrientableFlowLayout() {
        this(0, 1, 1, 5, 5, 5, 5);
    }

    public OrientableFlowLayout(int orientation) {
        this(orientation, 1, 1, 5, 5, 5, 5);
    }

    public OrientableFlowLayout(int orientation, int hAlign, int vAlign) {
        this(orientation, hAlign, vAlign, 5, 5, 5, 5);
    }

    public OrientableFlowLayout(int orientation, int hAlign, int vAlign, int hHGap, int hVGap, int vHGap, int vVGap) {
        super(hAlign, hHGap, hVGap);
        this.orientation = orientation;
        this.vAlign = vAlign;
        this.vHGap = vHGap;
        this.vVGap = vVGap;
    }

    public synchronized void orientHorizontally() {
        this.orientation = 0;
    }

    public synchronized void orientVertically() {
        this.orientation = 1;
    }

    public Dimension preferredLayoutSize(Container target) {
        if (this.orientation == 0) {
            return super.preferredLayoutSize(target);
        }
        Dimension dim = new Dimension(0, 0);
        int n = target.countComponents();
        for (int i = 0; i < n; ++i) {
            Component c = target.getComponent(i);
            if (!c.isVisible()) continue;
            Dimension cDim = c.preferredSize();
            dim.width = Math.max(dim.width, cDim.width);
            if (i > 0) {
                dim.height += this.vVGap;
            }
            dim.height += cDim.height;
        }
        Insets insets = target.insets();
        dim.width += insets.left + insets.right + this.vHGap * 2;
        dim.height += insets.top + insets.bottom + this.vVGap * 2;
        return dim;
    }

    public Dimension minimumLayoutSize(Container target) {
        if (this.orientation == 0) {
            return super.minimumLayoutSize(target);
        }
        Dimension dim = new Dimension(0, 0);
        int n = target.countComponents();
        for (int i = 0; i < n; ++i) {
            Component c = target.getComponent(i);
            if (!c.isVisible()) continue;
            Dimension cDim = c.minimumSize();
            dim.width = Math.max(dim.width, cDim.width);
            if (i > 0) {
                dim.height += this.vVGap;
            }
            dim.height += cDim.height;
        }
        Insets insets = target.insets();
        dim.width += insets.left + insets.right + this.vHGap * 2;
        dim.height += insets.top + insets.bottom + this.vVGap * 2;
        return dim;
    }

    public void layoutContainer(Container target) {
        if (this.orientation == 0) {
            super.layoutContainer(target);
        } else {
            Insets insets = target.insets();
            Dimension targetDim = target.size();
            int maxHeight = targetDim.height - (insets.top + insets.bottom + this.vVGap * 2);
            int x = insets.left + this.vHGap;
            int y = 0;
            int colWidth = 0;
            int start = 0;
            int n = target.countComponents();
            for (int i = 0; i < n; ++i) {
                Component c = target.getComponent(i);
                if (!c.isVisible()) continue;
                Dimension cDim = c.preferredSize();
                c.resize(cDim.width, cDim.height);
                if (y == 0 || y + cDim.height <= maxHeight) {
                    if (y > 0) {
                        y += this.vVGap;
                    }
                    y += cDim.height;
                    colWidth = Math.max(colWidth, cDim.width);
                    continue;
                }
                this.moveComponents(target, x, insets.top + this.vVGap, colWidth, maxHeight - y, start, i);
                x += this.vHGap + colWidth;
                y = cDim.width;
                colWidth = cDim.width;
                start = i;
            }
            this.moveComponents(target, x, insets.top + this.vVGap, colWidth, maxHeight - y, start, n);
        }
    }

    private void moveComponents(Container target, int x, int y, int width, int height, int colStart, int colEnd) {
        switch (this.vAlign) {
            case 0: {
                break;
            }
            case 1: {
                y += height / 2;
                break;
            }
            case 2: {
                y += height;
            }
        }
        for (int i = colStart; i < colEnd; ++i) {
            Component c = target.getComponent(i);
            Dimension cDim = c.size();
            if (!c.isVisible()) continue;
            c.move(x + (width - cDim.width) / 2, y);
            y += this.vVGap + cDim.height;
        }
    }

    public String toString() {
        String str = "";
        switch (this.orientation) {
            case 0: {
                str = "orientation=horizontal, ";
                break;
            }
            case 1: {
                str = "orientation=vertical, ";
            }
        }
        return this.getClass().getName() + "[" + str + super.toString() + "]";
    }
}

