/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.ComponentAccessor;
import sun.awt.SunToolkit;
import sun.awt.X11.WindowDimensions;
import sun.awt.X11.XAtom;
import sun.awt.X11.XAtomList;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XConfigureEvent;
import sun.awt.X11.XContentWindow;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XEvent;
import sun.awt.X11.XFocusChangeEvent;
import sun.awt.X11.XFocusProxyWindow;
import sun.awt.X11.XIconInfo;
import sun.awt.X11.XIconWindow;
import sun.awt.X11.XKeyboardFocusManagerPeer;
import sun.awt.X11.XReparentEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWM;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XWindowAttributesData;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibUtil;
import sun.awt.X11.XlibWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class XDecoratedPeer
extends XWindowPeer {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XDecoratedPeer");
    private static final Logger insLog = Logger.getLogger("sun.awt.X11.insets.XDecoratedPeer");
    private static final Logger focusLog = Logger.getLogger("sun.awt.X11.focus.XDecoratedPeer");
    private static final Logger iconLog = Logger.getLogger("sun.awt.X11.icon.XDecoratedPeer");
    private static XAtom resize_request = new XAtom("_SUN_AWT_RESIZE_REQUEST", false);
    boolean configure_seen;
    boolean insets_corrected;
    XIconWindow iconWindow;
    WindowDimensions dimensions;
    XContentWindow content;
    Insets currentInsets;
    XFocusProxyWindow focusProxy;
    long reparent_serial = 0L;
    boolean no_reparent_artifacts = false;
    XWindowPeer actualFocusedWindow = null;

    XDecoratedPeer(Window target) {
        super(target);
    }

    XDecoratedPeer(XCreateWindowParams params) {
        super(params);
    }

    public long getShell() {
        return this.window;
    }

    @Override
    public long getContentWindow() {
        return this.content == null ? this.window : this.content.getWindow();
    }

    @Override
    void preInit(XCreateWindowParams params) {
        super.preInit(params);
        if (!resize_request.isInterned()) {
            resize_request.intern(false);
        }
        this.winAttr.initialFocus = true;
        this.currentInsets = new Insets(0, 0, 0, 0);
        this.applyGuessedInsets();
        Rectangle bounds = (Rectangle)params.get("bounds");
        this.dimensions = new WindowDimensions(bounds, this.getRealInsets(), false);
        params.put("bounds", this.dimensions.getClientRect());
        if (insLog.isLoggable(Level.FINE)) {
            insLog.log(Level.FINE, "Initial dimensions {0}", new Object[]{String.valueOf(this.dimensions)});
        }
        Long eventMask = (Long)params.get("event mask");
        params.add((Object)"event mask", eventMask & 0xFFFFFFFFFFDFFFFCL);
    }

    @Override
    void postInit(XCreateWindowParams params) {
        super.postInit(params);
        this.initResizability();
        this.updateSizeHints(this.dimensions);
        this.content = this.createContent(this.dimensions);
        this.content.initialize();
        if (this.warningWindow != null) {
            this.warningWindow.toFront();
        }
        this.focusProxy = this.createFocusProxy();
    }

    @Override
    void setIconHints(List<XIconInfo> icons) {
        if (!XWM.getWM().setNetWMIcon(this, icons) && icons.size() > 0) {
            if (this.iconWindow == null) {
                this.iconWindow = new XIconWindow(this);
            }
            this.iconWindow.setIconImages(icons);
        }
    }

    @Override
    public void updateMinimumSize() {
        super.updateMinimumSize();
        this.updateMinSizeHints();
    }

    private void updateMinSizeHints() {
        if (this.isResizable()) {
            Dimension minimumSize = this.getTargetMinimumSize();
            if (minimumSize != null) {
                Insets insets = this.getRealInsets();
                int minWidth = minimumSize.width - insets.left - insets.right;
                int minHeight = minimumSize.height - insets.top - insets.bottom;
                if (minWidth < 0) {
                    minWidth = 0;
                }
                if (minHeight < 0) {
                    minHeight = 0;
                }
                this.setSizeHints(0x10L | (this.isLocationByPlatform() ? 0L : 5L), this.getX(), this.getY(), minWidth, minHeight);
                if (this.isVisible()) {
                    int nh;
                    Rectangle bounds = this.getShellBounds();
                    int nw = bounds.width < minWidth ? minWidth : bounds.width;
                    int n = nh = bounds.height < minHeight ? minHeight : bounds.height;
                    if (nw != bounds.width || nh != bounds.height) {
                        this.setShellSize(new Rectangle(0, 0, nw, nh));
                    }
                }
            } else {
                boolean isMinSizeSet = this.isMinSizeSet();
                XWM.removeSizeHints(this, 16L);
                if (isMinSizeSet && this.isShowing() && XWM.needRemap(this)) {
                    this.xSetVisible(false);
                    XToolkit.XSync();
                    this.xSetVisible(true);
                }
            }
        }
    }

    XContentWindow createContent(WindowDimensions dims) {
        Rectangle rec = dims.getBounds();
        Insets ins = dims.getInsets();
        if (ins != null) {
            rec.x = -ins.left;
            rec.y = -ins.top;
        } else {
            rec.x = 0;
            rec.y = 0;
        }
        return new XContentWindow(this, rec);
    }

    XFocusProxyWindow createFocusProxy() {
        return new XFocusProxyWindow(this);
    }

    @Override
    protected XAtomList getWMProtocols() {
        XAtomList protocols = super.getWMProtocols();
        protocols.add(wm_delete_window);
        protocols.add(wm_take_focus);
        return protocols;
    }

    @Override
    public Graphics getGraphics() {
        return this.getGraphics(this.content.surfaceData, ComponentAccessor.getForeground(this.target), ComponentAccessor.getBackground(this.target), ComponentAccessor.getFont_NoClientCode(this.target));
    }

    public void setTitle(String title) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Title is " + title);
        }
        this.winAttr.title = title;
        this.updateWMName();
    }

    @Override
    protected String getWMName() {
        if (this.winAttr.title == null || this.winAttr.title.trim().equals("")) {
            return " ";
        }
        return this.winAttr.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateWMName() {
        super.updateWMName();
        String name = this.getWMName();
        XToolkit.awtLock();
        try {
            if (name == null || name.trim().equals("")) {
                name = "Java";
            }
            XAtom iconNameAtom = XAtom.get(37L);
            iconNameAtom.setProperty(this.getWindow(), name);
            XAtom netIconNameAtom = XAtom.get("_NET_WM_ICON_NAME");
            netIconNameAtom.setPropertyUTF8(this.getWindow(), name);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    @Override
    public void handleIconify() {
        this.postEvent(new WindowEvent((Window)this.target, 203));
    }

    @Override
    public void handleDeiconify() {
        this.postEvent(new WindowEvent((Window)this.target, 204));
    }

    @Override
    public void handleFocusEvent(XEvent xev) {
        super.handleFocusEvent(xev);
        XFocusChangeEvent xfe = xev.get_xfocus();
        focusLog.finer("Received focus event on shell: " + xfe);
    }

    @Override
    protected boolean isInitialReshape() {
        return false;
    }

    Insets difference(Insets i1, Insets i2) {
        return new Insets(i1.top - i2.top, i1.left - i2.left, i1.bottom - i2.bottom, i1.right - i2.right);
    }

    void add(Insets i1, Insets i2) {
        i1.left += i2.left;
        i1.top += i2.top;
        i1.right += i2.right;
        i1.bottom += i2.bottom;
    }

    boolean isNull(Insets i) {
        return i == null || (i.left | i.top | i.right | i.bottom) == 0;
    }

    Insets copy(Insets i) {
        return new Insets(i.top, i.left, i.bottom, i.right);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleReparentNotifyEvent(XEvent xev) {
        block17: {
            block18: {
                block16: {
                    XReparentEvent xe = xev.get_xreparent();
                    if (insLog.isLoggable(Level.FINE)) {
                        insLog.fine(xe.toString());
                    }
                    this.reparent_serial = xe.get_serial();
                    XToolkit.awtLock();
                    try {
                        long root = XlibWrapper.RootWindow(XToolkit.getDisplay(), this.getScreenNumber());
                        if (this.isEmbedded()) {
                            this.setReparented(true);
                            this.insets_corrected = true;
                            Object var9_4 = null;
                            break block16;
                        }
                        Component t = this.target;
                        if (this.getDecorations() == XWindowAttributesData.AWT_DECOR_NONE) {
                            this.setReparented(true);
                            this.insets_corrected = true;
                            this.reshape(this.dimensions, 2, false);
                            break block17;
                        }
                        if (xe.get_parent() == root) {
                            this.configure_seen = false;
                            this.insets_corrected = false;
                            if (this.isVisible()) {
                                XWM.getWM().unshadeKludge(this);
                                insLog.fine("- WM exited");
                                break block17;
                            } else {
                                insLog.fine(" - reparent due to hide");
                            }
                            break block17;
                        }
                        this.setReparented(true);
                        this.insets_corrected = false;
                        Insets correctWM = this.getWMSetInsets(null);
                        if (correctWM != null) {
                            Insets dimInsets;
                            if (insLog.isLoggable(Level.FINER)) {
                                insLog.log(Level.FINER, "wm-provided insets {0}", new Object[]{String.valueOf(correctWM)});
                            }
                            if (correctWM.equals(dimInsets = this.dimensions.getInsets())) {
                                insLog.finer("Insets are the same as estimated - no additional reshapes necessary");
                                this.no_reparent_artifacts = true;
                                this.insets_corrected = true;
                                this.applyGuessedInsets();
                                break block18;
                            }
                        } else {
                            correctWM = XWM.getWM().getInsets(this, xe.get_window(), xe.get_parent());
                            if (correctWM != null) {
                                if (insLog.isLoggable(Level.FINER)) {
                                    insLog.log(Level.FINER, "correctWM {0}", new Object[]{String.valueOf(correctWM)});
                                }
                            } else {
                                insLog.log(Level.FINER, "correctWM insets are not available, waiting for configureNotify");
                            }
                        }
                        if (correctWM != null) {
                            this.handleCorrectInsets(correctWM);
                        }
                        break block17;
                    }
                    catch (Throwable throwable) {
                        Object var9_7 = null;
                        XToolkit.awtUnlock();
                        throw throwable;
                    }
                }
                XToolkit.awtUnlock();
                return;
            }
            Object var9_5 = null;
            XToolkit.awtUnlock();
            return;
        }
        Object var9_6 = null;
        XToolkit.awtUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleCorrectInsets(Insets correctWM) {
        block9: {
            block8: {
                XToolkit.awtLock();
                try {
                    Insets correction = this.difference(correctWM, this.currentInsets);
                    if (insLog.isLoggable(Level.FINEST)) {
                        insLog.log(Level.FINEST, "Corrention {0}", new Object[]{String.valueOf(correction)});
                    }
                    if (!this.isNull(correction)) {
                        this.add(this.currentInsets, correction);
                        this.applyGuessedInsets();
                        this.updateMinSizeHints();
                    }
                    if (insLog.isLoggable(Level.FINER)) {
                        insLog.finer("Dimensions before reparent: " + this.dimensions);
                    }
                    this.dimensions.setInsets(this.getRealInsets());
                    this.insets_corrected = true;
                    if (this.isMaximized()) {
                        Object var4_3 = null;
                        break block8;
                    }
                    if ((this.getHints().get_flags() & 5L) != 0L) {
                        this.reshape(this.dimensions, 3, false);
                        break block9;
                    } else {
                        this.reshape(this.dimensions, 2, false);
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    XToolkit.awtUnlock();
                    throw throwable;
                }
            }
            XToolkit.awtUnlock();
            return;
        }
        Object var4_4 = null;
        XToolkit.awtUnlock();
    }

    public void handleMoved(WindowDimensions dims) {
        Point loc = dims.getLocation();
        ComponentAccessor.setX(this.target, loc.x);
        ComponentAccessor.setY(this.target, loc.y);
        this.postEvent(new ComponentEvent(this.target, 100));
    }

    protected Insets guessInsets() {
        if (this.isEmbedded()) {
            return new Insets(0, 0, 0, 0);
        }
        if (this.currentInsets.top > 0) {
            return this.copy(this.currentInsets);
        }
        Insets res = this.getWMSetInsets(null);
        if (res == null) {
            res = XWM.getWM().guessInsets(this);
        }
        return res;
    }

    private void applyGuessedInsets() {
        Insets guessed = this.guessInsets();
        this.currentInsets = this.copy(guessed);
        this.insets = this.copy(this.currentInsets);
    }

    public void revalidate() {
        XToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

            public void run() {
                XDecoratedPeer.this.target.invalidate();
                XDecoratedPeer.this.target.validate();
            }
        });
    }

    Insets getRealInsets() {
        if (this.isNull(this.insets)) {
            this.applyGuessedInsets();
        }
        return this.insets;
    }

    @Override
    public Insets getInsets() {
        Insets in = this.copy(this.getRealInsets());
        in.top += this.getMenuBarHeight();
        if (insLog.isLoggable(Level.FINEST)) {
            insLog.log(Level.FINEST, "Get insets returns {0}", new Object[]{String.valueOf(in)});
        }
        return in;
    }

    boolean gravityBug() {
        return XWM.configureGravityBuggy();
    }

    int getInputMethodHeight() {
        return 0;
    }

    void updateSizeHints(WindowDimensions dims) {
        Rectangle rec = dims.getClientRect();
        this.checkShellRect(rec);
        this.updateSizeHints(rec.x, rec.y, rec.width, rec.height);
    }

    @Override
    void updateSizeHints() {
        this.updateSizeHints(this.dimensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reshape(WindowDimensions newDimensions, int op, boolean userReshape) {
        block20: {
            block18: {
                if (insLog.isLoggable(Level.FINE)) {
                    insLog.fine("Reshaping " + this + " to " + newDimensions + " op " + op + " user reshape " + userReshape);
                }
                if (userReshape) {
                    Rectangle reqBounds = newDimensions.getBounds();
                    Rectangle newBounds = this.constrainBounds(reqBounds.x, reqBounds.y, reqBounds.width, reqBounds.height);
                    Insets insets = newDimensions.getInsets();
                    if (newDimensions.isClientSizeSet()) {
                        newBounds = new Rectangle(newBounds.x, newBounds.y, newBounds.width - insets.left - insets.right, newBounds.height - insets.top - insets.bottom);
                    }
                    newDimensions = new WindowDimensions(newBounds, insets, newDimensions.isClientSizeSet());
                }
                XToolkit.awtLock();
                try {
                    if (!this.isReparented() || !this.isVisible()) {
                        insLog.log(Level.FINE, "- not reparented({0}) or not visible({1}), default reshape", new Object[]{this.isReparented(), this.visible});
                        Point oldLocation = this.getLocation();
                        Point newLocation = new Point(ComponentAccessor.getX(this.target), ComponentAccessor.getY(this.target));
                        if (!newLocation.equals(oldLocation)) {
                            this.handleMoved(newDimensions);
                        }
                        this.dimensions = new WindowDimensions(newDimensions);
                        this.updateSizeHints(this.dimensions);
                        Rectangle client = this.dimensions.getClientRect();
                        this.checkShellRect(client);
                        this.setShellBounds(client);
                        if (this.content != null && !this.content.getSize().equals(newDimensions.getSize())) {
                            this.reconfigureContentWindow(newDimensions);
                        }
                        Object var8_8 = null;
                        break block18;
                    }
                    int wm = XWM.getWMID();
                    this.updateChildrenSizes();
                    this.applyGuessedInsets();
                    Rectangle shellRect = newDimensions.getClientRect();
                    if (this.gravityBug()) {
                        Insets in = newDimensions.getInsets();
                        shellRect.translate(in.left, in.top);
                    }
                    if ((op & 0x4000) == 0 && this.isEmbedded()) {
                        shellRect.setLocation(0, 0);
                    }
                    this.checkShellRectSize(shellRect);
                    if (!this.isEmbedded()) {
                        this.checkShellRectPos(shellRect);
                    }
                    if ((op &= 0xFFFFBFFF) == 1) {
                        this.setShellPosition(shellRect);
                    } else if (this.isResizable()) {
                        if (op == 3) {
                            this.setShellBounds(shellRect);
                        } else {
                            this.setShellSize(shellRect);
                        }
                    } else {
                        XWM.setShellNotResizable(this, newDimensions, shellRect, true);
                        if (op == 3) {
                            this.setShellPosition(shellRect);
                        }
                    }
                    this.reconfigureContentWindow(newDimensions);
                    break block20;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    XToolkit.awtUnlock();
                    throw throwable;
                }
            }
            XToolkit.awtUnlock();
            return;
        }
        Object var8_9 = null;
        XToolkit.awtUnlock();
    }

    private void reshape(int x, int y, int width, int height, int operation, boolean userReshape) {
        boolean setClient = false;
        WindowDimensions dims = new WindowDimensions(this.dimensions);
        switch (operation & 0xFFFFBFFF) {
            case 1: {
                dims.setLocation(x, y);
                break;
            }
            case 2: {
                dims.setSize(width, height);
                break;
            }
            case 4: {
                Insets in = this.currentInsets;
                dims.setClientSize(width -= in.left + in.right, height -= in.top + in.bottom);
                break;
            }
            default: {
                dims.setLocation(x, y);
                dims.setSize(width, height);
            }
        }
        if (insLog.isLoggable(Level.FINE)) {
            insLog.log(Level.FINE, "For the operation {0} new dimensions are {1}", new Object[]{XDecoratedPeer.operationToString(operation), String.valueOf(dims)});
        }
        this.reshape(dims, operation, userReshape);
    }

    abstract boolean isTargetUndecorated();

    @Override
    Rectangle constrainBounds(int x, int y, int width, int height) {
        if (!this.hasWarningWindow()) {
            return new Rectangle(x, y, width, height);
        }
        if (!this.isVisible() || this.isTargetUndecorated()) {
            return super.constrainBounds(x, y, width, height);
        }
        int newX = x;
        int newY = y;
        int newW = width;
        int newH = height;
        GraphicsConfiguration gc = ((Window)this.target).getGraphicsConfiguration();
        Rectangle sB = gc.getBounds();
        Insets sIn = ((Window)this.target).getToolkit().getScreenInsets(gc);
        Rectangle curBounds = this.getBounds();
        int maxW = Math.max(sB.width - sIn.left - sIn.right, curBounds.width);
        int maxH = Math.max(sB.height - sIn.top - sIn.bottom, curBounds.height);
        if (newW > maxW) {
            newW = maxW;
        }
        if (newH > maxH) {
            newH = maxH;
        }
        return new Rectangle(newX, newY, newW, newH);
    }

    @Override
    public void setBounds(int x, int y, int width, int height, int op) {
        this.reshape(x, y, width, height, op, true);
        this.validateSurface();
    }

    void reconfigureContentWindow(WindowDimensions dims) {
        if (this.content == null) {
            insLog.fine("WARNING: Content window is null");
            return;
        }
        this.content.setContentBounds(dims);
    }

    @Override
    public void handleConfigureNotifyEvent(XEvent xev) {
        assert (SunToolkit.isAWTLockHeldByCurrentThread());
        XConfigureEvent xe = xev.get_xconfigure();
        if (insLog.isLoggable(Level.FINE)) {
            insLog.log(Level.FINE, "Configure notify {0}", new Object[]{String.valueOf(xe)});
        }
        if (this.isReparented()) {
            this.configure_seen = true;
        }
        if (!(this.isMaximized() || xe.get_serial() != this.reparent_serial && xe.get_window() == this.getShell() || this.no_reparent_artifacts)) {
            insLog.fine("- reparent artifact, skipping");
            return;
        }
        this.no_reparent_artifacts = false;
        if (!this.isVisible() && XWM.getWMID() != 2) {
            insLog.fine(" - not visible, skipping");
            return;
        }
        int runningWM = XWM.getWMID();
        if (insLog.isLoggable(Level.FINE)) {
            insLog.log(Level.FINE, "reparented={0}, visible={1}, WM={2}, decorations={3}", new Object[]{this.isReparented(), this.isVisible(), runningWM, this.getDecorations()});
        }
        if (!this.isReparented() && this.isVisible() && runningWM != 2 && !XWM.isNonReparentingWM()) {
            if (this.getDecorations() != XWindowAttributesData.AWT_DECOR_NONE) {
                insLog.fine("- visible but not reparented, skipping");
                return;
            }
        }
        if (!this.insets_corrected) {
            if (this.getDecorations() != XWindowAttributesData.AWT_DECOR_NONE) {
                Insets correctWM;
                long parent = XlibUtil.getParentWindow(this.window);
                Insets insets = correctWM = parent != -1L ? XWM.getWM().getInsets(this, this.window, parent) : null;
                if (insLog.isLoggable(Level.FINER)) {
                    if (correctWM != null) {
                        insLog.finer("Configure notify - insets : " + correctWM);
                    } else {
                        insLog.finer("Configure notify - insets are still not available");
                    }
                }
                if (correctWM != null) {
                    this.handleCorrectInsets(correctWM);
                } else {
                    this.insets_corrected = true;
                }
            }
        }
        this.updateChildrenSizes();
        Rectangle targetBounds = new Rectangle(ComponentAccessor.getX(this.target), ComponentAccessor.getY(this.target), ComponentAccessor.getWidth(this.target), ComponentAccessor.getHeight(this.target));
        Point newLocation = targetBounds.getLocation();
        if (xe.get_send_event() || runningWM == 2 || XWM.isNonReparentingWM()) {
            newLocation = new Point(xe.get_x() - this.currentInsets.left, xe.get_y() - this.currentInsets.top);
        } else {
            switch (XWM.getWMID()) {
                case 5: 
                case 6: 
                case 9: 
                case 11: 
                case 14: {
                    Point xlocation = this.queryXLocation();
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "New X location: {0}", new Object[]{String.valueOf(xlocation)});
                    }
                    if (xlocation == null) break;
                    newLocation = xlocation;
                    break;
                }
            }
        }
        WindowDimensions newDimensions = new WindowDimensions(newLocation, new Dimension(xe.get_width(), xe.get_height()), this.copy(this.currentInsets), true);
        if (insLog.isLoggable(Level.FINER)) {
            insLog.log(Level.FINER, "Insets are {0}, new dimensions {1}", new Object[]{String.valueOf(this.currentInsets), String.valueOf(newDimensions)});
        }
        this.checkIfOnNewScreen(newDimensions.getBounds());
        Point oldLocation = this.getLocation();
        this.dimensions = newDimensions;
        if (!newLocation.equals(oldLocation)) {
            this.handleMoved(newDimensions);
        }
        this.reconfigureContentWindow(newDimensions);
        this.updateChildrenSizes();
        this.repositionSecurityWarning();
    }

    private void checkShellRectSize(Rectangle shellRect) {
        if (shellRect.width < 0) {
            shellRect.width = 1;
        }
        if (shellRect.height < 0) {
            shellRect.height = 1;
        }
    }

    private void checkShellRectPos(Rectangle shellRect) {
        int wm = XWM.getWMID();
        if ((wm == 5 || wm == 6) && shellRect.x == 0 && shellRect.y == 0) {
            shellRect.y = 1;
            shellRect.x = 1;
        }
    }

    private void checkShellRect(Rectangle shellRect) {
        this.checkShellRectSize(shellRect);
        this.checkShellRectPos(shellRect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShellBounds(Rectangle rec) {
        if (insLog.isLoggable(Level.FINE)) {
            insLog.fine("Setting shell bounds on " + this + " to " + rec);
        }
        XToolkit.awtLock();
        try {
            this.updateSizeHints(rec.x, rec.y, rec.width, rec.height);
            XlibWrapper.XResizeWindow(XToolkit.getDisplay(), this.getShell(), rec.width, rec.height);
            XlibWrapper.XMoveWindow(XToolkit.getDisplay(), this.getShell(), rec.x, rec.y);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShellSize(Rectangle rec) {
        if (insLog.isLoggable(Level.FINE)) {
            insLog.fine("Setting shell size on " + this + " to " + rec);
        }
        XToolkit.awtLock();
        try {
            this.updateSizeHints(rec.x, rec.y, rec.width, rec.height);
            XlibWrapper.XResizeWindow(XToolkit.getDisplay(), this.getShell(), rec.width, rec.height);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShellPosition(Rectangle rec) {
        if (insLog.isLoggable(Level.FINE)) {
            insLog.fine("Setting shell position on " + this + " to " + rec);
        }
        XToolkit.awtLock();
        try {
            this.updateSizeHints(rec.x, rec.y, rec.width, rec.height);
            XlibWrapper.XMoveWindow(XToolkit.getDisplay(), this.getShell(), rec.x, rec.y);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    void initResizability() {
        this.setResizable(this.winAttr.initialResizability);
    }

    public void setResizable(boolean resizable) {
        int fs = this.winAttr.functions;
        if (!this.isResizable() && resizable) {
            this.insets = this.currentInsets = new Insets(0, 0, 0, 0);
            this.resetWMSetInsets();
            if (!this.isEmbedded()) {
                this.setReparented(false);
            }
            this.winAttr.isResizable = resizable;
            fs = (fs & 1) != 0 ? (fs &= 0xFFFFFFED) : (fs |= 0x12);
            this.winAttr.functions = fs;
            XWM.setShellResizable(this);
        } else if (this.isResizable() && !resizable) {
            this.insets = this.currentInsets = new Insets(0, 0, 0, 0);
            this.resetWMSetInsets();
            if (!this.isEmbedded()) {
                this.setReparented(false);
            }
            this.winAttr.isResizable = resizable;
            fs = (fs & 1) != 0 ? (fs |= 0x12) : (fs &= 0xFFFFFFED);
            this.winAttr.functions = fs;
            XWM.setShellNotResizable(this, this.dimensions, this.dimensions.getScreenBounds(), false);
        }
    }

    Rectangle getShellBounds() {
        return this.dimensions.getClientRect();
    }

    @Override
    public Rectangle getBounds() {
        return this.dimensions.getBounds();
    }

    @Override
    public Dimension getSize() {
        return this.dimensions.getSize();
    }

    @Override
    public int getX() {
        return this.dimensions.getLocation().x;
    }

    @Override
    public int getY() {
        return this.dimensions.getLocation().y;
    }

    public Point getLocation() {
        return this.dimensions.getLocation();
    }

    @Override
    public int getAbsoluteX() {
        return this.dimensions.getScreenBounds().x;
    }

    @Override
    public int getAbsoluteY() {
        return this.dimensions.getScreenBounds().y;
    }

    @Override
    public int getWidth() {
        return this.getSize().width;
    }

    @Override
    public int getHeight() {
        return this.getSize().height;
    }

    public WindowDimensions getDimensions() {
        return this.dimensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point getLocationOnScreen() {
        block4: {
            Point point;
            XToolkit.awtLock();
            try {
                if (!this.configure_seen) break block4;
                point = this.toGlobal(0, 0);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            return point;
        }
        Point location = this.target.getLocation();
        if (insLog.isLoggable(Level.FINE)) {
            insLog.log(Level.FINE, "getLocationOnScreen {0} not reparented: {1} ", new Object[]{String.valueOf(this), String.valueOf(location)});
        }
        Point point = location;
        Object var4_4 = null;
        XToolkit.awtUnlock();
        return point;
    }

    @Override
    protected boolean isEventDisabled(XEvent e) {
        switch (e.get_type()) {
            case 22: {
                return true;
            }
            case 7: 
            case 8: {
                return true;
            }
        }
        return super.isEventDisabled(e);
    }

    int getDecorations() {
        return this.winAttr.decorations;
    }

    int getFunctions() {
        return this.winAttr.functions;
    }

    @Override
    public void setVisible(boolean vis) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Setting {0} to visible {1}", new Object[]{String.valueOf(this), vis});
        }
        if (vis && !this.isVisible()) {
            XWM.setShellDecor(this);
            super.setVisible(vis);
            if (this.winAttr.isResizable) {
                XWM.removeSizeHints(this, 32L);
                this.updateMinimumSize();
            }
        } else {
            super.setVisible(vis);
        }
    }

    @Override
    protected void suppressWmTakeFocus(boolean doSuppress) {
        XAtomList protocols = this.getWMProtocols();
        if (doSuppress) {
            protocols.remove(wm_take_focus);
        } else {
            protocols.add(wm_take_focus);
        }
        wm_protocols.setAtomListProperty((XBaseWindow)this, protocols);
    }

    @Override
    public void dispose() {
        if (this.content != null) {
            this.content.destroy();
        }
        this.focusProxy.destroy();
        if (this.iconWindow != null) {
            this.iconWindow.destroy();
        }
        super.dispose();
    }

    @Override
    public void handleClientMessage(XEvent xev) {
        super.handleClientMessage(xev);
        XClientMessageEvent cl = xev.get_xclient();
        if (wm_protocols != null && cl.get_message_type() == wm_protocols.getAtom()) {
            if (cl.get_data(0) == wm_delete_window.getAtom()) {
                this.handleQuit();
            } else if (cl.get_data(0) == wm_take_focus.getAtom()) {
                this.handleWmTakeFocus(cl);
            }
        } else if (cl.get_message_type() == resize_request.getAtom()) {
            this.reshape((int)cl.get_data(0), (int)cl.get_data(1), (int)cl.get_data(2), (int)cl.get_data(3), (int)cl.get_data(4), true);
        }
    }

    private void handleWmTakeFocus(XClientMessageEvent cl) {
        if (focusLog.isLoggable(Level.FINE)) {
            focusLog.log(Level.FINE, "WM_TAKE_FOCUS on {0}", new Object[]{String.valueOf(this)});
        }
        this.requestWindowFocus(cl.get_data(1), true);
    }

    @Override
    protected void requestXFocus(long time, boolean timeProvided) {
        if (this.focusProxy == null) {
            if (focusLog.isLoggable(Level.FINE)) {
                focusLog.warning("Focus proxy is null for " + this);
            }
        } else {
            if (focusLog.isLoggable(Level.FINE)) {
                focusLog.fine("Requesting focus to proxy: " + this.focusProxy);
            }
            if (timeProvided) {
                this.focusProxy.xRequestFocus(time);
            } else {
                this.focusProxy.xRequestFocus();
            }
        }
    }

    XFocusProxyWindow getFocusProxy() {
        return this.focusProxy;
    }

    public void handleQuit() {
        this.postEvent(new WindowEvent((Window)this.target, 201));
    }

    final void dumpMe() {
        System.err.println(">>> Peer: " + this.x + ", " + this.y + ", " + this.width + ", " + this.height);
    }

    final void dumpTarget() {
        int getWidth = ComponentAccessor.getWidth(this.target);
        int getHeight = ComponentAccessor.getHeight(this.target);
        int getTargetX = ComponentAccessor.getX(this.target);
        int getTargetY = ComponentAccessor.getY(this.target);
        System.err.println(">>> Target: " + getTargetX + ", " + getTargetY + ", " + getWidth + ", " + getHeight);
    }

    final void dumpShell() {
        this.dumpWindow("Shell", this.getShell());
    }

    final void dumpContent() {
        this.dumpWindow("Content", this.getContentWindow());
    }

    final void dumpParent() {
        long parent = XlibUtil.getParentWindow(this.getShell());
        if (parent != 0L) {
            this.dumpWindow("Parent", parent);
        } else {
            System.err.println(">>> NO PARENT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dumpWindow(String id, long window) {
        XWindowAttributes pattr = new XWindowAttributes();
        try {
            XToolkit.awtLock();
            try {
                int status = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), window, pattr.pData);
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            System.err.println(">>>> " + id + ": " + pattr.get_x() + ", " + pattr.get_y() + ", " + pattr.get_width() + ", " + pattr.get_height());
            Object var9_8 = null;
            pattr.dispose();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            pattr.dispose();
            throw throwable;
        }
    }

    final void dumpAll() {
        this.dumpTarget();
        this.dumpMe();
        this.dumpParent();
        this.dumpShell();
        this.dumpContent();
    }

    boolean isMaximized() {
        return false;
    }

    @Override
    boolean isOverrideRedirect() {
        return ((XToolkit)Toolkit.getDefaultToolkit()).isOverrideRedirect((Window)this.target);
    }

    @Override
    public boolean requestWindowFocus(long time, boolean timeProvided) {
        focusLog.fine("Request for decorated window focus");
        Window win = (Window)this.target;
        Window focusedWindow = XKeyboardFocusManagerPeer.getCurrentNativeFocusedWindow();
        Window activeWindow = XWindowPeer.getDecoratedOwner(focusedWindow);
        focusLog.log(Level.FINER, "Current window is: active={0}, focused={1}", new Object[]{win == activeWindow, win == focusedWindow});
        XWindowPeer toFocus = this;
        while (toFocus.nextTransientFor != null) {
            toFocus = toFocus.nextTransientFor;
        }
        if (this == toFocus) {
            if (this.focusAllowedFor()) {
                if (win == activeWindow && win != focusedWindow) {
                    focusLog.fine("Focus is on child window - transfering it back");
                    this.handleWindowFocusInSync(-1L);
                } else {
                    focusLog.fine("Requesting focus to this window");
                    if (timeProvided) {
                        this.requestXFocus(time);
                    } else {
                        this.requestXFocus();
                    }
                }
                return true;
            }
            return false;
        }
        if (toFocus.focusAllowedFor()) {
            focusLog.fine("Requesting focus to " + toFocus);
            if (timeProvided) {
                toFocus.requestXFocus(time);
            } else {
                toFocus.requestXFocus();
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setActualFocusedWindow(XWindowPeer actualFocusedWindow) {
        Object object = this.getStateLock();
        synchronized (object) {
            this.actualFocusedWindow = actualFocusedWindow;
        }
    }

    boolean requestWindowFocus(XWindowPeer actualFocusedWindow, long time, boolean timeProvided) {
        this.setActualFocusedWindow(actualFocusedWindow);
        return this.requestWindowFocus(time, timeProvided);
    }

    @Override
    public void handleWindowFocusIn(long serial) {
        if (null == this.actualFocusedWindow) {
            super.handleWindowFocusIn(serial);
        } else {
            this.postEvent(new InvocationEvent((Object)this.target, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    XWindowPeer fw = null;
                    Object object = XDecoratedPeer.this.getStateLock();
                    synchronized (object) {
                        fw = XDecoratedPeer.this.actualFocusedWindow;
                        XDecoratedPeer.this.actualFocusedWindow = null;
                        if (null == fw || !fw.isVisible() || !fw.isFocusableWindow()) {
                            fw = XDecoratedPeer.this;
                        }
                    }
                    fw.handleWindowFocusIn_Dispatch();
                }
            }));
        }
    }

    @Override
    public void handleWindowFocusOut(Window oppositeWindow, long serial) {
        Window owner;
        Window actualFocusedWindow = XKeyboardFocusManagerPeer.getCurrentNativeFocusedWindow();
        if (actualFocusedWindow != null && actualFocusedWindow != this.target && (owner = XWindowPeer.getDecoratedOwner(actualFocusedWindow)) != null && owner == this.target) {
            this.setActualFocusedWindow((XWindowPeer)ComponentAccessor.getPeer(actualFocusedWindow));
        }
        super.handleWindowFocusOut(oppositeWindow, serial);
    }

    private Point queryXLocation() {
        return XlibUtil.translateCoordinates(this.getContentWindow(), XlibWrapper.RootWindow(XToolkit.getDisplay(), this.getScreenNumber()), new Point(0, 0));
    }
}

