/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTKeyStroke;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.EmbeddedFrame;
import sun.awt.SunToolkit;
import sun.awt.X11.XConfigureEvent;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XEmbedClientHelper;
import sun.awt.X11.XEmbeddedFrame;
import sun.awt.X11.XEvent;
import sun.awt.X11.XFramePeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XlibUtil;
import sun.awt.X11.XlibWrapper;

public class XEmbeddedFramePeer
extends XFramePeer {
    private static final Logger xembedLog = Logger.getLogger("sun.awt.X11.xembed.XEmbeddedFramePeer");
    LinkedList<AWTKeyStroke> strokes;
    XEmbedClientHelper embedder;

    public XEmbeddedFramePeer(EmbeddedFrame target) {
        super(new XCreateWindowParams(new Object[]{"target", target, "visible", Boolean.TRUE, "embedded", Boolean.TRUE}));
    }

    public void preInit(XCreateWindowParams params) {
        super.preInit(params);
        this.strokes = new LinkedList();
        if (this.supportsXEmbed()) {
            this.embedder = new XEmbedClientHelper();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postInit(XCreateWindowParams params) {
        super.postInit(params);
        if (this.embedder != null) {
            this.embedder.install(this);
        } else if (this.getParentWindowHandle() != 0L) {
            XToolkit.awtLock();
            try {
                XlibWrapper.XReparentWindow(XToolkit.getDisplay(), this.getWindow(), this.getParentWindowHandle(), 0, 0);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            {
            }
        }
    }

    public void updateMinimumSize() {
    }

    protected String getWMName() {
        return "JavaEmbeddedFrame";
    }

    final long getParentWindowHandle() {
        return ((XEmbeddedFrame)this.target).handle;
    }

    boolean supportsXEmbed() {
        return ((EmbeddedFrame)this.target).supportsXEmbed();
    }

    public boolean requestWindowFocus(long time, boolean timeProvided) {
        if (this.embedder != null && this.embedder.isActive()) {
            xembedLog.fine("Requesting focus from embedding host");
            return this.embedder.requestFocus();
        }
        xembedLog.fine("Requesting focus from X");
        return super.requestWindowFocus(time, timeProvided);
    }

    protected void requestInitialFocus() {
        if (this.embedder != null && this.supportsXEmbed()) {
            this.embedder.requestFocus();
        } else {
            super.requestInitialFocus();
        }
    }

    protected boolean isEventDisabled(XEvent e) {
        if (this.embedder != null && this.embedder.isActive()) {
            switch (e.get_type()) {
                case 9: 
                case 10: {
                    return true;
                }
            }
        }
        return super.isEventDisabled(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConfigureNotifyEvent(XEvent xev) {
        assert (SunToolkit.isAWTLockHeldByCurrentThread());
        XConfigureEvent xe = xev.get_xconfigure();
        if (xembedLog.isLoggable(Level.FINE)) {
            xembedLog.fine(xe.toString());
        }
        this.checkIfOnNewScreen(this.toGlobal(new Rectangle(xe.get_x(), xe.get_y(), xe.get_width(), xe.get_height())));
        Rectangle oldBounds = this.getBounds();
        Object object = this.getStateLock();
        synchronized (object) {
            this.x = xe.get_x();
            this.y = xe.get_y();
            this.width = xe.get_width();
            this.height = xe.get_height();
            this.dimensions.setClientSize(this.width, this.height);
            this.dimensions.setLocation(this.x, this.y);
        }
        if (!this.getLocation().equals(oldBounds.getLocation())) {
            this.handleMoved(this.dimensions);
        }
        this.reconfigureContentWindow(this.dimensions);
    }

    protected void traverseOutForward() {
        if (this.embedder != null && this.embedder.isActive() && this.embedder.isApplicationActive()) {
            xembedLog.fine("Traversing out Forward");
            this.embedder.traverseOutForward();
        }
    }

    protected void traverseOutBackward() {
        if (this.embedder != null && this.embedder.isActive() && this.embedder.isApplicationActive()) {
            xembedLog.fine("Traversing out Backward");
            this.embedder.traverseOutBackward();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getLocationOnScreen() {
        Point point;
        XToolkit.awtLock();
        try {
            point = this.toGlobal(0, 0);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
        return point;
    }

    Rectangle constrainBounds(int x, int y, int width, int height) {
        return new Rectangle(x, y, width, height);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBoundsPrivate(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height, 16387);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBoundsPrivate() {
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        XWindowAttributes attr = new XWindowAttributes();
        XToolkit.awtLock();
        try {
            XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), this.getWindow(), attr.pData);
            x = attr.get_x();
            y = attr.get_y();
            w = attr.get_width();
            h = attr.get_height();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
        attr.dispose();
        return new Rectangle(x, y, w, h);
    }

    void registerAccelerator(AWTKeyStroke stroke) {
        if (stroke == null) {
            return;
        }
        this.strokes.add(stroke);
        if (this.embedder != null && this.embedder.isActive()) {
            this.embedder.registerAccelerator(stroke, this.strokes.size() - 1);
        }
    }

    void unregisterAccelerator(AWTKeyStroke stroke) {
        if (stroke == null) {
            return;
        }
        if (this.embedder != null && this.embedder.isActive()) {
            int index = this.strokes.indexOf(stroke);
            this.embedder.unregisterAccelerator(index);
        }
    }

    void notifyStarted() {
        if (this.embedder != null && this.embedder.isActive()) {
            int i = 0;
            Iterator iter = this.strokes.iterator();
            while (iter.hasNext()) {
                this.embedder.registerAccelerator((AWTKeyStroke)iter.next(), i++);
            }
        }
        this.updateDropTarget();
    }

    long getFocusTargetWindow() {
        return this.getWindow();
    }

    boolean isXEmbedActive() {
        return this.embedder != null && this.embedder.isActive();
    }

    public int getAbsoluteX() {
        Point absoluteLoc = XlibUtil.translateCoordinates(this.getWindow(), XToolkit.getDefaultRootWindow(), new Point(0, 0));
        return absoluteLoc.x;
    }

    public int getAbsoluteY() {
        Point absoluteLoc = XlibUtil.translateCoordinates(this.getWindow(), XToolkit.getDefaultRootWindow(), new Point(0, 0));
        return absoluteLoc.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void setModalBlocked(Dialog blocker, boolean blocked) {
        super.setModalBlocked(blocker, blocked);
        EmbeddedFrame frame = (EmbeddedFrame)this.target;
        frame.notifyModalBlocked(blocker, blocked);
    }
}

