/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.AwtGraphicsConfigData;
import sun.awt.X11.ColorData;
import sun.awt.X11.Native;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XIconInfo;
import sun.awt.X11.XIconSize;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XVisualInfo;
import sun.awt.X11.XWM;
import sun.awt.X11.XWMHints;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11.awtImageData;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.ToolkitImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XIconWindow
extends XBaseWindow {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XIconWindow");
    XDecoratedPeer parent;
    Dimension size;
    long iconPixmap = 0L;
    long iconMask = 0L;
    int iconWidth = 0;
    int iconHeight = 0;

    XIconWindow(XDecoratedPeer parent) {
        super(new XCreateWindowParams(new Object[]{"parent", parent, "delayed", Boolean.TRUE}));
    }

    @Override
    void instantPreInit(XCreateWindowParams params) {
        super.instantPreInit(params);
        this.parent = (XDecoratedPeer)params.get("parent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XIconSize[] getIconSizes() {
        XIconSize[] xIconSizeArray;
        block6: {
            long status;
            XToolkit.awtLock();
            AwtGraphicsConfigData adata = this.parent.getGraphicsConfigurationData();
            long screen = adata.get_awt_visInfo().get_screen();
            long display = XToolkit.getDisplay();
            if (log.isLoggable(Level.FINEST)) {
                log.finest(adata.toString());
            }
            if ((status = (long)XlibWrapper.XGetIconSizes(display, XToolkit.getDefaultRootWindow(), XlibWrapper.larg1, XlibWrapper.iarg1)) != 0L) break block6;
            XIconSize[] xIconSizeArray2 = null;
            Object var14_7 = null;
            XToolkit.awtUnlock();
            return xIconSizeArray2;
        }
        try {
            int count = Native.getInt(XlibWrapper.iarg1);
            long sizes_ptr = Native.getLong(XlibWrapper.larg1);
            log.log(Level.FINEST, "count = {1}, sizes_ptr = {0}", new Object[]{sizes_ptr, count});
            XIconSize[] res = new XIconSize[count];
            int i = 0;
            while (i < count) {
                res[i] = new XIconSize(sizes_ptr);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "sizes_ptr[{1}] = {0}", new Object[]{String.valueOf(res[i]), i});
                }
                ++i;
                sizes_ptr += (long)XIconSize.getSize();
            }
            xIconSizeArray = res;
            Object var14_8 = null;
        }
        catch (Throwable throwable) {
            Object var14_9 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
        return xIconSizeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension calcIconSize(int widthHint, int heightHint) {
        if (XWM.getWMID() == 10) {
            log.log(Level.FINEST, "Returning ICE_WM icon size: 16x16");
            return new Dimension(16, 16);
        }
        XIconSize[] sizeList = this.getIconSizes();
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Icon sizes: {0}", new Object[]{String.valueOf(sizeList)});
        }
        if (sizeList == null) {
            return new Dimension(16, 16);
        }
        boolean found = false;
        int dist = -1;
        int diff = 0;
        int saveWidth = 0;
        int saveHeight = 0;
        for (int i = 0; i < sizeList.length; ++i) {
            int closestHeight;
            if (widthHint < sizeList[i].get_min_width() || widthHint > sizeList[i].get_max_width() || heightHint < sizeList[i].get_min_height() || heightHint > sizeList[i].get_max_height()) continue;
            found = true;
            if ((widthHint - sizeList[i].get_min_width()) % sizeList[i].get_width_inc() == 0 && (heightHint - sizeList[i].get_min_height()) % sizeList[i].get_height_inc() == 0) {
                saveWidth = widthHint;
                saveHeight = heightHint;
                dist = 0;
                break;
            }
            diff = widthHint - sizeList[i].get_min_width();
            int closestWidth = diff == 0 ? widthHint : widthHint - (diff %= sizeList[i].get_width_inc());
            int newDist = closestWidth * closestWidth + (closestHeight = (diff = heightHint - sizeList[i].get_min_height()) == 0 ? heightHint : heightHint - (diff %= sizeList[i].get_height_inc())) * closestHeight;
            if (dist <= newDist) continue;
            saveWidth = closestWidth;
            saveHeight = closestHeight;
            dist = newDist;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("found=" + found);
        }
        if (!found) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("widthHint=" + widthHint + ", heightHint=" + heightHint + ", saveWidth=" + saveWidth + ", saveHeight=" + saveHeight + ", max_width=" + sizeList[0].get_max_width() + ", max_height=" + sizeList[0].get_max_height() + ", min_width=" + sizeList[0].get_min_width() + ", min_height=" + sizeList[0].get_min_height());
            }
            if (widthHint > sizeList[0].get_max_width() || heightHint > sizeList[0].get_max_height()) {
                int wdiff = widthHint - sizeList[0].get_max_width();
                int hdiff = heightHint - sizeList[0].get_max_height();
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("wdiff=" + wdiff + ", hdiff=" + hdiff);
                }
                if (wdiff >= hdiff) {
                    saveWidth = sizeList[0].get_max_width();
                    saveHeight = (int)((double)sizeList[0].get_max_width() / (double)widthHint * (double)heightHint);
                } else {
                    saveWidth = (int)((double)sizeList[0].get_max_height() / (double)heightHint * (double)widthHint);
                    saveHeight = sizeList[0].get_max_height();
                }
            } else if (widthHint < sizeList[0].get_min_width() || heightHint < sizeList[0].get_min_height()) {
                saveWidth = (sizeList[0].get_min_width() + sizeList[0].get_max_width()) / 2;
                saveHeight = (sizeList[0].get_min_height() + sizeList[0].get_max_height()) / 2;
            } else {
                saveWidth = widthHint;
                saveHeight = widthHint;
            }
        }
        XToolkit.awtLock();
        try {
            XlibWrapper.XFree(sizeList[0].pData);
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("return " + saveWidth + "x" + saveHeight);
        }
        return new Dimension(saveWidth, saveHeight);
    }

    Dimension getIconSize(int widthHint, int heightHint) {
        if (this.size == null) {
            this.size = this.calcIconSize(widthHint, heightHint);
        }
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void replaceImage(Image img) {
        block26: {
            block25: {
                block24: {
                    block23: {
                        block22: {
                            block21: {
                                if (this.parent == null) {
                                    return;
                                }
                                BufferedImage bi = null;
                                if (img != null && this.iconWidth != 0 && this.iconHeight != 0) {
                                    GraphicsConfiguration defaultGC = this.parent.getGraphicsConfiguration().getDevice().getDefaultConfiguration();
                                    ColorModel model = defaultGC.getColorModel();
                                    WritableRaster raster = model.createCompatibleWritableRaster(this.iconWidth, this.iconHeight);
                                    bi = new BufferedImage(model, raster, model.isAlphaPremultiplied(), null);
                                    Graphics g = bi.getGraphics();
                                    try {
                                        g.setColor(SystemColor.window);
                                        g.fillRect(0, 0, this.iconWidth, this.iconHeight);
                                        if (g instanceof Graphics2D) {
                                            ((Graphics2D)g).setComposite(AlphaComposite.Src);
                                        }
                                        g.drawImage(img, 0, 0, this.iconWidth, this.iconHeight, null);
                                        Object var8_8 = null;
                                        g.dispose();
                                    }
                                    catch (Throwable throwable) {
                                        Object var8_9 = null;
                                        g.dispose();
                                        throw throwable;
                                    }
                                }
                                XToolkit.awtLock();
                                try {
                                    block28: {
                                        block27: {
                                            if (this.iconPixmap != 0L) {
                                                XlibWrapper.XFreePixmap(XToolkit.getDisplay(), this.iconPixmap);
                                                this.iconPixmap = 0L;
                                                log.finest("Freed previous pixmap");
                                            }
                                            if (bi == null || this.iconWidth == 0) break block27;
                                            if (this.iconHeight != 0) break block28;
                                        }
                                        Object var19_11 = null;
                                        break block21;
                                    }
                                    AwtGraphicsConfigData adata = this.parent.getGraphicsConfigurationData();
                                    awtImageData awtImage = adata.get_awtImage(0);
                                    XVisualInfo visInfo = adata.get_awt_visInfo();
                                    this.iconPixmap = XlibWrapper.XCreatePixmap(XToolkit.getDisplay(), XlibWrapper.RootWindow(XToolkit.getDisplay(), visInfo.get_screen()), this.iconWidth, this.iconHeight, awtImage.get_Depth());
                                    if (this.iconPixmap == 0L) {
                                        log.finest("Can't create new pixmap for icon");
                                        break block22;
                                    }
                                    long bytes = 0L;
                                    DataBuffer srcBuf = bi.getData().getDataBuffer();
                                    if (srcBuf instanceof DataBufferByte) {
                                        byte[] buf = ((DataBufferByte)srcBuf).getData();
                                        ColorData cdata = adata.get_color_data(0);
                                        int num_colors = cdata.get_awt_numICMcolors();
                                        for (int i = 0; i < buf.length; ++i) {
                                            buf[i] = buf[i] >= num_colors ? (byte)0 : cdata.get_awt_icmLUT2Colors(buf[i]);
                                        }
                                        bytes = Native.toData(buf);
                                    } else if (srcBuf instanceof DataBufferInt) {
                                        bytes = Native.toData(((DataBufferInt)srcBuf).getData());
                                    } else {
                                        if (!(srcBuf instanceof DataBufferUShort)) throw new IllegalArgumentException("Unknown data buffer: " + srcBuf);
                                        bytes = Native.toData(((DataBufferUShort)srcBuf).getData());
                                    }
                                    int bpp = awtImage.get_wsImageFormat().get_bits_per_pixel();
                                    int slp = awtImage.get_wsImageFormat().get_scanline_pad();
                                    int bpsl = XIconWindow.paddedwidth(this.iconWidth * bpp, slp) >> 3;
                                    if ((bpsl << 3) / bpp < this.iconWidth) {
                                        log.finest("Image format doesn't fit to icon width");
                                        break block23;
                                    }
                                    long dst = XlibWrapper.XCreateImage(XToolkit.getDisplay(), visInfo.get_visual(), awtImage.get_Depth(), 2, 0, bytes, this.iconWidth, this.iconHeight, 32, bpsl);
                                    if (dst == 0L) {
                                        log.finest("Can't create XImage for icon");
                                        XlibWrapper.XFreePixmap(XToolkit.getDisplay(), this.iconPixmap);
                                        this.iconPixmap = 0L;
                                        break block24;
                                    }
                                    log.finest("Created XImage for icon");
                                    long gc = XlibWrapper.XCreateGC(XToolkit.getDisplay(), this.iconPixmap, 0L, 0L);
                                    if (gc == 0L) {
                                        log.finest("Can't create GC for pixmap");
                                        XlibWrapper.XFreePixmap(XToolkit.getDisplay(), this.iconPixmap);
                                        this.iconPixmap = 0L;
                                        break block25;
                                    }
                                    log.finest("Created GC for pixmap");
                                    try {
                                        XlibWrapper.XPutImage(XToolkit.getDisplay(), this.iconPixmap, gc, dst, 0, 0, 0, 0, this.iconWidth, this.iconHeight);
                                        Object var17_26 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var17_27 = null;
                                        XlibWrapper.XFreeGC(XToolkit.getDisplay(), gc);
                                        throw throwable;
                                    }
                                    XlibWrapper.XFreeGC(XToolkit.getDisplay(), gc);
                                    break block26;
                                }
                                catch (Throwable throwable) {
                                    Object var19_17 = null;
                                    XToolkit.awtUnlock();
                                    throw throwable;
                                }
                            }
                            XToolkit.awtUnlock();
                            return;
                        }
                        Object var19_12 = null;
                        XToolkit.awtUnlock();
                        return;
                    }
                    Object var19_13 = null;
                    XToolkit.awtUnlock();
                    return;
                }
                Object var19_14 = null;
                XToolkit.awtUnlock();
                return;
            }
            Object var19_15 = null;
            XToolkit.awtUnlock();
            return;
        }
        Object var19_16 = null;
        XToolkit.awtUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceMask(Image img) {
        if (this.parent == null) {
            return;
        }
        BufferedImage bi = null;
        if (img != null && this.iconWidth != 0 && this.iconHeight != 0) {
            bi = new BufferedImage(this.iconWidth, this.iconHeight, 2);
            Graphics g = bi.getGraphics();
            try {
                g.drawImage(img, 0, 0, this.iconWidth, this.iconHeight, null);
                Object var5_4 = null;
                g.dispose();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                g.dispose();
                throw throwable;
            }
        }
        XToolkit.awtLock();
        try {
            block14: {
                if (this.iconMask != 0L) {
                    XlibWrapper.XFreePixmap(XToolkit.getDisplay(), this.iconMask);
                    this.iconMask = 0L;
                    log.finest("Freed previous mask");
                }
                if (bi == null || this.iconWidth == 0) break block14;
                if (this.iconHeight != 0) break block15;
            }
            Object var17_8 = null;
        }
        catch (Throwable throwable) {
            Object var17_10 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
        {
            block15: {
                return;
            }
            AwtGraphicsConfigData adata = this.parent.getGraphicsConfigurationData();
            awtImageData awtImage = adata.get_awtImage(0);
            XVisualInfo visInfo = adata.get_awt_visInfo();
            ColorModel cm = bi.getColorModel();
            DataBuffer srcBuf = bi.getRaster().getDataBuffer();
            int sidx = 0;
            int bpl = this.iconWidth + 7 >> 3;
            byte[] destBuf = new byte[bpl * this.iconHeight];
            int didx = 0;
            for (int i = 0; i < this.iconHeight; ++i) {
                int dbit = 0;
                int cv = 0;
                for (int j = 0; j < this.iconWidth; ++j) {
                    if (cm.getAlpha(srcBuf.getElem(sidx)) != 0) {
                        cv += 1 << dbit;
                    }
                    if (++dbit == 8) {
                        destBuf[didx] = (byte)cv;
                        cv = 0;
                        dbit = 0;
                        ++didx;
                    }
                    ++sidx;
                }
            }
            this.iconMask = XlibWrapper.XCreateBitmapFromData(XToolkit.getDisplay(), XlibWrapper.RootWindow(XToolkit.getDisplay(), visInfo.get_screen()), Native.toData(destBuf), this.iconWidth, this.iconHeight);
        }
        Object var17_9 = null;
        XToolkit.awtUnlock();
    }

    void setIconImages(List<XIconInfo> icons) {
        if (icons == null || icons.size() == 0) {
            return;
        }
        int minDiff = Integer.MAX_VALUE;
        Image min = null;
        for (XIconInfo iconInfo : icons) {
            int heightDiff;
            if (!iconInfo.isValid()) continue;
            Image image = iconInfo.getImage();
            Dimension dim = this.calcIconSize(image.getWidth(null), image.getHeight(null));
            int widthDiff = Math.abs(dim.width - image.getWidth(null));
            if (minDiff < widthDiff + (heightDiff = Math.abs(image.getHeight(null) - dim.height))) continue;
            minDiff = widthDiff + heightDiff;
            min = image;
        }
        if (min != null) {
            log.log(Level.FINER, "Icon: {0}x{1}", new Object[]{min.getWidth(null), min.getHeight(null)});
            this.setIconImage(min);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIconImage(Image img) {
        if (img == null) {
            this.replaceImage(null);
            this.replaceMask(null);
        } else {
            int height;
            int width;
            if (img instanceof ToolkitImage) {
                ImageRepresentation ir = ((ToolkitImage)img).getImageRep();
                ir.reconstruct(32);
                width = ir.getWidth();
                height = ir.getHeight();
            } else {
                width = img.getWidth(null);
                height = img.getHeight(null);
            }
            Dimension iconSize = this.getIconSize(width, height);
            if (iconSize != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Icon size: {0}", String.valueOf(iconSize));
                }
                this.iconWidth = iconSize.width;
                this.iconHeight = iconSize.height;
            } else {
                log.finest("Error calculating image size");
                this.iconWidth = 0;
                this.iconHeight = 0;
            }
            this.replaceImage(img);
            this.replaceMask(img);
        }
        XToolkit.awtLock();
        try {
            AwtGraphicsConfigData adata = this.parent.getGraphicsConfigurationData();
            awtImageData awtImage = adata.get_awtImage(0);
            XVisualInfo visInfo = adata.get_awt_visInfo();
            XWMHints hints = this.parent.getWMHints();
            this.window = hints.get_icon_window();
            if (this.window == 0L) {
                log.finest("Icon window wasn't set");
                XCreateWindowParams params = this.getDelayedParams();
                params.add((Object)"border pixel", (Object)XToolkit.getAwtDefaultFg());
                params.add((Object)"pixmap", this.iconPixmap);
                params.add((Object)"color map", adata.get_awt_cmap());
                params.add((Object)"visual depth", awtImage.get_Depth());
                params.add((Object)"visual class", 1);
                params.add((Object)"visual", visInfo.get_visual());
                params.add((Object)"value mask", 8201L);
                params.add((Object)"parent window", XlibWrapper.RootWindow(XToolkit.getDisplay(), visInfo.get_screen()));
                params.add((Object)"bounds", new Rectangle(0, 0, this.iconWidth, this.iconHeight));
                params.remove("delayed");
                this.init(params);
                if (this.getWindow() == 0L) {
                    log.finest("Can't create new icon window");
                } else {
                    log.finest("Created new icon window");
                }
            }
            if (this.getWindow() != 0L) {
                XlibWrapper.XSetWindowBackgroundPixmap(XToolkit.getDisplay(), this.getWindow(), this.iconPixmap);
                XlibWrapper.XClearWindow(XToolkit.getDisplay(), this.getWindow());
            }
            long newFlags = hints.get_flags() | 4L | 0x20L;
            if (this.getWindow() != 0L) {
                newFlags |= 8L;
            }
            hints.set_flags(newFlags);
            hints.set_icon_pixmap(this.iconPixmap);
            hints.set_icon_mask(this.iconMask);
            hints.set_icon_window(this.getWindow());
            XlibWrapper.XSetWMHints(XToolkit.getDisplay(), this.parent.getShell(), hints.pData);
            log.finest("Set icon window hint");
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    static int paddedwidth(int number, int boundary) {
        return number + (boundary - 1) & ~(boundary - 1);
    }
}

